# Deployment Guide for NeonFS

## Overview

NeonFS is a single‑file, zero‑dependency PHP file manager. The recent updates introduce:

- **Navigation history** (Backspace / Shift + Backspace)
- **URL‑driven folder loading** (`?current_folder=...`)
- **Single‑click selection** with batch toolbar
- **Enhanced keyboard shortcuts** for navigation and actions

These features require no additional server configuration beyond the existing setup.

## Prerequisites

- PHP 7.4+ installed (`/lamp/php/bin/php`)
- Web server pointing to `/lamp/www/file_manager`
- Write permissions for the `file_manager` directory
- Optional: MySQL for other services (not required for NeonFS)

## Installation Steps

1. **Copy the project**

   ```bash
   cp -r /path/to/file_manager /lamp/www/
   ```

2. **Set file permissions**

   ```bash
   chmod 755 /lamp/www/file_manager
   chmod 644 /lamp/www/file_manager/index.php
   ```

3. **Configure constants** (edit the top of `index.php`)

   ```php
   define('NEONFS_REQUIRE_AUTH', false);   // set true to enable login
   define('NEONFS_PASSWORD', 'your_secure_password');
   define('NEONFS_ROOT_PATH', '/lamp/www'); // base directory for browsing
   define('NEONFS_MAX_UPLOAD_SIZE', 100);   // MB
   define('NEONFS_SAFE_MODE', false);      // true disables delete/chmod
   define('NEONFS_BLACKLIST', [
       '/etc/shadow',
       '/etc/passwd',
       '/root/.ssh'
   ]);
   ```

4. **Restart your web server** (if needed) to pick up any PHP changes.

## Accessing the Application

Open a browser and navigate to:

```
http://your-host/file_manager/
```

### Direct Folder Access

You can now open a specific folder instantly:

```
http://your-host/file_manager/?current_folder=/lamp/www/file_manager
```

The manager will load directly into that folder without a loading screen.

## Using the New Features

- **Backspace** – go back to the previous folder in history.
- **Shift + Backspace** – move forward in history.
- **Single‑click** on a file or folder toggles its selection state.
- **Batch toolbar** appears when items are selected, allowing copy, cut, delete, download, etc.
- Keyboard shortcuts have been extended to include the new navigation keys.

## Troubleshooting

- **Permissions errors** – ensure the web server user can read/write inside `NEONFS_ROOT_PATH`.
- **URL parameter ignored** – verify that `NEONFS_ROOT_PATH` allows the target folder and that the folder path starts with `/`.
- **Navigation history not working** – make sure JavaScript is not blocked by browser extensions.

## Updating the Application

When pulling new changes from the repository:

```bash
cd /lamp/www/file_manager
git pull origin main   # if using git
# or replace index.php with the latest version
```

After updating, clear your browser cache or perform a hard refresh (`Ctrl+F5`) to load the new script.

---

*NeonFS – the grid awaits you.*
