<?php
/**
 * ia_util.php
 * Utilerias
 * @version 2.1.2012.09.23
 * @package utilerias
 * pre-requisites: include config.php para array $gIAsql y $gIaTimeStart value,
 * 
 */


// ////////////////////// SQL  ////////////////////// 
    if(!array_key_exists('set_autocommit',$gIAsql)) $gIAsql['set_autocommit']=null;
    if(!array_key_exists('pconnect',$gIAsql)) $gIAsql['pconnect']=false;  
    if(!array_key_exists('trace',$gIAsql)) $gIAsql['trace']=false;
    if(!array_key_exists('sql_trace',$gIAsql)) $gIAsql['sql_trace']=array();
    if(!array_key_exists('link',$gIAsql)) $gIAsql['link']=null;
    if(!array_key_exists('err',$gIAsql)) $gIAsql['err']='';
    $gIAsql['affected_rows']=$gIAsql['begins']=$gIAsql['selected_rows']=0;
    
// ia_update y ia_insert en modo $inteligent_quotes=true no quotea lo siguiente:
$gIAsql['dont_quote']=array('NULL','CURDATE()','CURRENT_DATE()','CURRENT_DATE','CURRENT_TIME()','CURRENT_TIME','CURTIME()'
    ,'CURRENT_TIMESTAMP()','CURRENT_TIMESTAMP','NOW()','LOCALTIMESTAMP','LOCALTIMESTAMP()','SYSDATE()','UNIX_TIMESTAMP()'
    ,'UTC_DATE()','UTC_TIME()','UTC_TIMESTAMP()');
/**
 * ia_sqlErrors()
 * 
 * @return html <ul> con los errores
 */
function ia_sqlErrors() {
global $gIAsql;
    return $gIAsql['err']=='' ? '' : "<ul>$gIAsql[err]</ul>";
}

/**
 * ia_connect()
* Conecta a la base de datos de no estar conectado. 
* - Cambiar aqui host,user,pwd y db
* @param boolean $force en true forza reconectar, en false si ya esta conectado prosigue
* @return boolean TRUE on error, FALSE on valid active connection.
 */
function ia_connect($force=false) {
global $gIAsql;
	if(array_key_exists('link',$gIAsql) && ($gIAsql['link']!=null && $force===false))
		return FALSE;
    if(array_key_exists('link',$gIAsql) && $gIAsql['link']!=null)
        @mysql_close($gIAsql['link']);
    
    if($gIAsql['pconnect'])
	   $gIAsql['link'] = @mysql_connect($gIAsql['host'],$gIAsql['user'],$gIAsql['pwd'] );
    else
        $gIAsql['link'] = @mysql_connect($gIAsql['host'],$gIAsql['user'],$gIAsql['pwd'] );
        
	$errno=@mysql_errno();
	if($errno==2006 || $errno==2013 || $errno==1203 || $errno==1184  || $errno==1154  || $errno==1040 || $errno==1080  ) {
		usleep(30);
        if($gIAsql['pconnect'])
    	   $gIAsql['link'] = @mysql_connect($gIAsql['host'],$gIAsql['user'],$gIAsql['pwd'] );
        else
            $gIAsql['link'] = @mysql_pconnect($gIAsql['host'],$gIAsql['user'],$gIAsql['pwd'] );
	}
	
    if(@mysql_errno()!=0) {
		$gIAsql['err'].="<li>No me pude conectar al sql engine ".@mysql_error().' ('.@mysql_errno().') ';
		return TRUE;
	}
	
    @mysql_select_db($gIAsql['dbname']);
	if(@mysql_errno()!=0) {
		usleep(30);
		@mysql_select_db($gIAsql['dbname']);
	}
	
    if(@mysql_errno()!=0) {
		$gIAsql['err'].="<li>No pude abirir la base de datos ".@mysql_error().' ('.@mysql_errno().') ';
		return TRUE;
	}
	
    if(  array_key_exists('set_autocommit',$gIAsql) && $gIAsql['set_autocommit']!=null) {
        ia_query('SET SESSION AUTOCOMMIT='.$gIAsql['set_autocommit']); 
    }
    if( array_key_exists('init',$gIAsql) && !empty($gIAsql['init']) ) {
        if(is_array($gIAsql['init']))
            foreach($gIAsql['init'] as $d)
                ia_query($d);
        elseif($gIAsql['init']!='')
            ia_query($gIAsql['init']);
    }
	return FALSE;
}

/**
 * ia_transaction()
 * 
 * @param mixed $arr
 * @param string $cmnt
 * @param bool $findID
 * @return TRUE en error con rollback realiazado, FALSE all ok
 */
function ia_transaction($arr,$cmnt='trsct',$findID=true) {
global $gIAsql;
    $gIAsql['last_id']=0;
    if( !empty($arr ) ) {        
        if( ia_connect()) 
            return TRUE;                    
        if( ia_begin($cmnt) )
            return TRUE;                         
        $ok=false;
        $replaceId=false;
        if(!is_array($arr)) {              
            $ok=!ia_query($arr,true,false);
        }
        elseif(count($arr)>0)
            foreach($arr as $k=>$query) if( trim( $query )!='' ) {               
                if( $replaceId ) {
                    if( !array_key_exists($id,$d) || empty($id) || $id==0 )
                        echo "<li>No id id=$id replace: $query</li>";
                    $query=str_replace('<_id_>',$id,$query);
                }
                if(ia_query($query,true,false)) {                   
                    $ok=TRUE;                  
                    break;
                }
                if($findID && substr($k,0,5)=='getID') {
                    $id=@mysql_insert_id();             
                    if($gIAsql['trace']) $gIAsql['sql_trace'][]='SELECT LAST_ID()';      
                    if(mysql_errno()) {                          
                        $gIAsql['err'].='<li>'.@mysql_error().' ('.@mysql_errno().")<br/>$query";
                        $ok=TRUE;
                        break;                        
                    }
                    if($id==0) { // evitar tomar last id equivocada
                        $gIAsql['err'].="<li>Can't get id for $k<br/>$query";
                        $ok=TRUE;
                        break;                         
                    }
                    $gIAsql['last_id']=$id;
                    ia_query("SELECT last_insert_id(0)"); // set last insert id to 0!, evitar tomar last id equivocada
                    $replaceId=true;
                }
            }  
           
        if(!$ok) {            
            return ia_commit($cmnt);
            return FALSE;
        } else {
              
            ia_rollback($cmnt);
            return TRUE;
       }     
    }  
    return TRUE;    
}

/**
 * ia_nontransaction()
 * 
 * @param mixed $arr
 * @param bool $stopOnError
 * @param bool $findID
 * @return
 */
function ia_nontransaction($arr,$stopOnError=false,$findID=true) {
global $gIAsql;
    $gIAsql['last_id']=0;
    if( !empty($arr ) ) {        
        if( ia_connect()) 
            return TRUE;                                           
        $ok=false;
        $replaceId=false;
        if(!is_array($arr)) {
            return ia_query($arr,true,true);
        }
        elseif(count($arr)>0)
            foreach($arr as $k=>$query) if(!empty($query)) {
                if( $replaceId ) 
                    $query=str_replace('<_id_>',$id,$query);
                if(ia_query($query,true,true)) {                   
                    $ok=TRUE;
                    break;
                }
                if($findID && substr($k,0,5)=='getID') {
                    $id=@mysql_insert_id();
                    if($stopOnError &&  mysql_errno()) {                          
                        $gIAsql['err'].='<li>'.@mysql_error().' ('.@mysql_errno().")<br/>$query";
                        $ok=TRUE;
                        break;                        
                    }
                    if($id==0) { // evitar tomar last id equivocada
                        $gIAsql['err'].="<li>Can't get id for $k<br/>$query";
                        $ok=TRUE;
                        break;                         
                    }
                    $gIAsql['last_id']=$id;
                    ia_query("SELECT last_insert_id(0)"); // set last insert id to 0!, evitar tomar last id equivocada                    
                    $replaceId=true;
                }
            }  
        return $ok;    
    }
    return TRUE; 
}


/**
 * ia_begin()
 * 
* Inicia una transaccion. 
* - Incrementando $gIAsql['begins'] en 1. 
* - Conectandose de no estar conectado.
* @param boolean $setAutoCommit en TRUE pasando autocommit a 0. default TRUE
* @return boolean TRUE on error, FALSE on ok transaction started.
 */
function ia_begin($cmnt='strt',$setAutoCommit=TRUE) {
global $gIAsql;
    if( ia_connect()) 
            return TRUE; 
	if( $setAutoCommit ) {
		if( ia_query("SET  /* $cmnt */ SESSION AUTOCOMMIT=0"))
			return TRUE;    
	}    
	ia_query("begin  /* $cmnt */");
	if( @mysql_errno()==0) {	   
		$gIAsql['begins']++;       		
		return FALSE;
	}
	$gIAsql['err'].='<li>'.@mysql_error().' ('.@mysql_errno().")<br/>begin /* $cmnt */".debug_trace();  
	return TRUE;
}

/**
 * ia_commit()
* Hace commit de una transaccion.
* - Decrementando $gIAsql['begins'] en 1.
 * @param string $cmnt
 * @param bool $autocommit en true pasando autocommit a 1. default true
 * @return
 */
function ia_commit($cmnt='cmit',$autocommit=TRUE) {
global $gIAsql; 
	ia_query("commit  /* $cmnt */",true,false);
	if( @mysql_errno()==0) {	   
		$gIAsql['begins']--;
		if( $autocommit)
			ia_query("SET  /* $cmnt */ SESSION AUTOCOMMIT=1");           
		return FALSE;
	}
	$gIAsql['err'].='<li>'.@mysql_error().' ('.@mysql_errno().")<br/>commit /* $cmnt */".debug_trace();
	return TRUE;
}


/**
 * ia_rollback()
* Hace rollback de una transaccion
* - Decrementando $gIAsql['begins'] en 1. 
 * @param string $cmnt
 * @return boolean TRUE on error, FALSE all ok rollback done.
 * @return
 */
function ia_rollback($cmnt='rllbck',$autocommit=TRUE) {
global $gIAsql;

	ia_query("rollback /* $cmnt */",true,false);
	if( @mysql_errno()==0) { 	   
		$gIAsql['begins']--;
  		if( $autocommit)
			ia_query("SET  /* $cmnt */ SESSION AUTOCOMMIT=1");
		return FALSE;
	}
	$gIAsql['err'].='<li>'.@mysql_error().' ('.@mysql_errno().")<br/>rollback /* $cmnt */".debug_trace();
	return TRUE;
} 


/**
 * ia_query()
* Ejecuta query que no regresa datos 
* ie alter,delete,insert,update,replace,...  
* - Conectandose de no estar conectado.
* - En lock error reintenta.
* @param string $sql el sql string a ejecutar
* @param boolean $doAffectedRows si guardar affected rows en $gIAsql['affected_rows']. default TRUE
* @return boolean TRUE on error, FALSE on ok.
 */
function ia_query($sql,$doAffectedRows=TRUE,$doRetry=true) {
global $gIAsql;
    
    if($gIAsql['trace']) $gIAsql['sql_trace'][]=$sql;
	if( ia_connect() ) 
        return TRUE;
    
	@mysql_query($sql);        
	if( @mysql_errno()==0) {
		if($doAffectedRows)
			$gIAsql['affected_rows']=mysql_affected_rows();             
		return FALSE; 
	}
    
	if( $doRetry && ia_error_do_retry( @mysql_errno() ) )
		for($i=1;$i<=3;$i++) {
			if($gIAsql['trace']) $gIAsql['sql_trace'][]=$sql."/* retry $i err=".@mysql_errno()." */";
            @mysql_query($sql);
			if( @mysql_errno()==0) {
				if($doAffectedRows)
					$gIAsql['affected_rows']=mysql_affected_rows();
				return FALSE; 
			}
           
		}
    $gIAsql['err'].='<li>'.@mysql_error().' ('.@mysql_errno().')<pre>'.$sql.'<pre>'.debug_trace();
	$gIAsql['affected_rows']=0;
	return TRUE;
}

/**
 * ia_update()
 * regresa un update $table set $key='$values[$key]',... WHERE  $pkey='$primaryKey[$pkey]' AND 
 * @param string $table nombre de la tabla
 * @param array $values 'campo'=>value, rutina protege apostrofes
 * @param mixed $where  en array hace 'campo'=value  con AND, en string lo pone
 * @param string $after_clause despues del where.
 * @param string $before_clause entre update y table.
 * @param boolean $inteligent_quotes en true no quotea lo que este en $gIAsql['dont_quote']
 * @param boolean $dontQuote en true no pone quotes alrededor de los valores, default false no pone quotes
 * @return
 */
function ia_update($table,$values=array(),$where=array(),$after_clause='',$before_clause='',$inteligent_quotes=true,$dontQuote=false) {
global $gIAsql;
    $upd='';
    foreach($values as $k=>$v) {
        if( is_null($v) )
            $upd.=",$k=NULL";
        elseif( $dontQuote || ($inteligent_quotes && in_array(strtoupper(trim($v)),$gIAsql['dont_quote'])) )
            $upd.=",$k=$v";
        else
            $upd.=",$k=".strit($v);
    }
    if(is_array($where)) {
        $w='';
        foreach($where as $k=>$v)
            if( is_null($v) )
                $w.=" AND $k IS NULL";
            elseif( $dontQuote || ($inteligent_quotes && in_array(strtoupper(trim($v)),$gIAsql['dont_quote'])) )
                $w.=" AND $k=$v";
            else
                $w.=" AND $k=".strit($v);
        $w=substr($w,5);
    } else
        $w=$where;
    return "UPDATE $before_clause $table SET ".substr($upd,1)." WHERE $where ".$after_clause;
}

/**
 * ia_insert()
 * regresa un insert $before_clause into $table($keys) values($vals) $after_clause;
 * @param string $table nombre de la tabla
 * @param array $values 'campo'=>value
 * @param boolean $autoOnUpdate en true hace ON DUPLICATE UPDATE de no venir en after_clause
 * @param string $after_clause poner despues de values: on duplicate key...
 * @param string $before_clause entre insert y (campos) 
 * @param boolean $inteligent_quotes en true no quotea lo que este en $gIAsql['dont_quote']
 * @param boolean $dontQuote en true no pone quotes alrededor de los valores, default false no pone quotes
 * @return
 */
function ia_insert($table,$values=array(),$after_clause='',$autoOnUpdate=false,$before_clause='',$inteligent_quotes=true,$dontQuote=false) {
global $gIAsql;
    $ins='';
    $val='';
    $upd='';
  
    foreach($values as $k=>$v) {
        $ins.=",$k";
        if( is_null($v) )
            $val.=",NULL";
        elseif( $dontQuote || ($inteligent_quotes && in_array(strtoupper(trim($v)),$gIAsql['dont_quote'])) )
            $val.=",$v";
        else        
            $val.=','.strit($v);
        $upd.=",$k=VALUES($k)";
    }
    if($autoOnUpdate and stripos($after_clause,'on update')!==FALSE)
        $after_clause="ON DUPLICATE KEY UPDATE ".substr($upd,1);
    return "INSERT $before_clause INTO $table(".substr($ins,1).") VALUES(".substr($val,1).") $after_clause";
}

/**
 * ia_insert_update()
 * 
 * @param mixed $table
 * @param mixed $arr
 * @param string $upd
 * @param bool $execute
 * @return
 */
function ia_insert_update($table,$arr,$upd='',$execute=true) {
    $ins='';
    $values='';
    $upd='';
    foreach($arr as $k=>$v) {
        $ins.=",$k";
        $values.=','.strit($v);
        $upd.=",$k=VALUES($k)";
    }
    $sql="INSERT INTO $table(".substr($ins,1).") VALUES(".substr($values,1).") ON DUPLICATE KEY UPDATE ".substr($upd,1);
    if($execute)
        return ia_query($sql);
    return $sql;
}

/**
 * ia_insertIded()
* Ejecuta insert regresando el auto_increment id creado. 
*
* conectandose de no estar conectado.
* @param string $sql el sql string a ejecutar
* @return boolean FALSE on error, auto_increment id on Active.
 */
function ia_insertIded($sql) {
global $gIAsql;

    if($gIAsql['trace']) $gIAsql['sql_trace'][]=$sql;
	if( ia_connect()) return FALSE;
	@mysql_query($sql);
    
	if( @mysql_errno()==0)
		return @mysql_insert_id();
	if( ia_error_do_retry( @mysql_errno() ) )
		for($i=1;$i<=3;$i++) {
			if($gIAsql['trace']) $gIAsql['sql_trace'][]=$sql."/* retry $i err=".@mysql_errno()." */";
            @mysql_query($sql);
			if( @mysql_errno()==0)
				return @mysql_insert_id();			
		}
	$gIAsql['err'].='<li>'.@mysql_error().' ('.@mysql_errno().')<pre>'.$sql.'<pre>'.debug_trace();	
	return FALSE;
}

/**
 * ia_guid()
* returns universal uuid de mysql: sin - en base 36 (29 caracteres maximo) reversed para menos carga a indices. 

* @param string $cmnt
* @return string uuid
 */
function ia_guid($cmnt='guid') {    
    $a=explode('-',ia_singleread("SELECT SQL_NO_CACHE /* $cmnt */ UUID()",'',false,false));
    // aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee 
    // set @x=uuid(); select @x, substr(@x,1,8), substr(@x,10,4), substr(@x,15,4),substr(@x,20,4), substr(@x,25)
    // select @x,   CONCAT( substr(@x,25),substr(@x,20,4),substr(@x,15,4),substr(@x,10,4),substr(@x,1,8) ) 
    // create function ia_uuid() READS SQL
    //return ia_singleread( "SELECT UNHEX( HEX('".$a[4].$a[3].$a[2].$a[1].$a[0]."') ) " );
    return $a[4].$a[3].$a[2].$a[1].$a[0];
   // return ia_singleread("SELECT CONCAT( CONV('$a[4]',16,36),CONV('$a[3]',16,36),CONV('$a[2]',16,36),CONV('$a[1]',16,36),CONV('$a[0]',16,36)  ) ");
}


/**
 * ia_singleread()
* returns first select field (first row). 
* Llenando $gIAsql['selected_rows']. 
* conectandose de no estar conectado.
* @param string $sql el sql string a ejecutar
* @param variable $dflt='' resultado a regresar si el sql da not found. DEFAULT ''
* @param boolean $errResult=FALSE' resultado a regresar si el sql da error. DEFAULT FALSE
* @return mixed $errResult normalmente false on error, el resultado del query.
 */
function ia_singleread($sql,$dflt='',$errResult=FALSE,$getNumRows=true) {
global $gIAsql;
    $result=ia_result($sql);
    if($result===FALSE)
        return $errResult;
	$d=@mysql_fetch_array($result,MYSQL_NUM);
	if( @mysql_errno()!=0) {
		$gIAsql['err'].='<li>'.@mysql_error().' ('.@mysql_errno().')<pre>'.$sql.'<pre>'.debug_trace();
echo "ERROR SQL ERROR ";        
		$gIAsql['selected_rows']=0;
		@mysql_free_result($result);
		return $errResult;
	}
    if($getNumRows)
        $gIAsql['selected_rows']=ia_singleread("SELECT FOUND_ROWS()",0,0,false);
	   //$gIAsql['selected_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return ( isset($d[0]) ) ? $d[0] : $dflt;
}

/**
 * ia_singleton()
* returns all select fields in array (first row). 
*
* Llenando $gIAsql['selected_rows']. 
* conectandose de no estar conectado.
* @param string $sql el sql string a ejecutar
* @param enum $asoc=MYSQL_ASSOC como asociar el array MYSQL_ASSOC,MYSQL_NUM,MYSQL_BOTH Default MYSQL_ASSOC 
* @return boolean FALSE on error, el resultado del query en un array o null array en not found.
 */
function ia_singleton($sql,$asoc=MYSQL_ASSOC) { /* returns select fields in array (first row) */
global $gIAsql;
    $result=ia_result($sql);
    if($result===FALSE)
        return FALSE;
	$d=mysql_fetch_array($result,$asoc);
	if( @mysql_errno()!=0) {
		$gIAsql['err'].='<li>'.@mysql_error().' ('.@mysql_errno().')<pre>'.$sql.'<pre>'.debug_trace();
		$gIAsql['selected_rows']=0;
		@mysql_free_result($result);
		return FALSE;
	}
	$gIAsql['selected_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return empty($d) ? array() : $d;
}

/**
 * ia_singletonFull()
* returns all select fields in array (first row), incluyendo campos en null llenos con $enNull. 
* Llenando $gIAsql['selected_rows']. 
* Conectandose de no estar conectado.
* @param string $sql el sql string a ejecutar
* @param enum $asoc=MYSQL_ASSOC como asociar el array MYSQL_ASSOC,MYSQL_NUM,MYSQL_BOTH Default MYSQL_ASSOC
* @param variable $enNull='' que poner si el campo es null. Defaullt '-'
* @return boolean FALSE on error, el resultado del query en un array o null array en not found.
 */
function ia_singletonFull($sql,$enNull='',$asoc=MYSQL_ASSOC) {
global $gIAsql;
    $result=ia_result($sql);
    if($result===FALSE)
        return FALSE;
	$d=@mysql_fetch_array($result,$asoc);
	if( @mysql_errno()!=0) {
		$gIAsql['err'].='<li>'.@mysql_error().' ('.@mysql_errno().')<pre>'.$sql.'<pre>'.debug_trace();
		$gIAsql['selected_rows']=0;
		@mysql_free_result($result);
		return FALSE;
	}	
    if(!is_array($d))
        $d=array();
	$i = 0;  
	while ($i < mysql_num_fields($result)) {
		if( $asoc==MYSQL_NUM || $asoc==MYSQL_BOTH)
			if( !array_key_exists($i,$d) ) $d[$i]=$enNull;
		if( $asoc==MYSQL_ASSOC || $asoc==MYSQL_BOTH) {
			$meta = mysql_fetch_field($result, $i);       
			if($meta && !array_key_exists($meta->name,$d) ) 
                $d[$meta->name]=$enNull;
		}
		$i++; 
	}
	$gIAsql['selected_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return $d;
}
/**
 * ia_sqlmeta()
 * 
 * @param mixed $sql
 * @return
 */
function ia_sqlmeta($sql) {
    $result=ia_result($sql);
    if($result===FALSE)
        return FALSE;
    $meta=array();
    $i = 0;
    while ($i < mysql_num_fields($result)) {
        $m= mysql_fetch_field($result, $i);  
		if( $asoc==MYSQL_NUM || $asoc==MYSQL_BOTH)
            $meta[$m->name] = $meta;   
		if( $asoc==MYSQL_ASSOC || $asoc==MYSQL_BOTH) {
			$meta[$i] = $meta;
		}
		$i++; 
	}
    @mysql_free_result($result);
    return $meta;
}


/**
 * ia_result()
* returns result set de $sql. Mejor no Usarla!
* Llenando $gIAsql['selected_rows']. 
* conectandose de no estar conectado.
* @param string $sql el sql string a ejecutar
* @param bool $showError
* @return boolean FALSE on error, el $result set obtenido
*/
function ia_result($sql,$showError=true) {
global $gIAsql;
	if( ia_connect()) 
        return FALSE;
    if($gIAsql['trace']) 
        $gIAsql['sql_trace'][]=$sql;
        
	$result = mysql_query($sql);
    $i=4;
	if( ia_error_do_retry( @mysql_errno() ) ) {	   
		for($i=1;$i<=3;$i++) {
		    if($gIAsql['trace']) $gIAsql['sql_trace'][]=$sql."/* retry $i: error=".@mysql_errno()." */";
			@mysql_free_result($result);
			//$result = @mysql_query($sql);
			if( @mysql_errno()==0)
				break 1;
		}
		if($i>3) {
			if($showError)
                $gIAsql['err'].='<li style="color:red;">'.@mysql_error().' ('.@mysql_errno().')<pre>'.$sql.'<pre>'.debug_trace();
            $gIAsql['selected_rows']=0;
            //echo "<li>$sql = "; print_r($result);
			//if($result) @mysql_free_result($result);
			return FALSE;		
		}
	}
    if( @mysql_errno()==0 )
	   $gIAsql['selected_rows']=@mysql_num_rows($result);
    else {
        if($showError)
            $gIAsql['err'].='<li style="color:red;">'.@mysql_error().' ('.@mysql_errno().')<pre>'.$sql.'<pre>'.debug_trace();
        $gIAsql['selected_rows']=0;
	}
    return $result;	
}

/**
 * ia_sqlArray()
* returns 2 dim array con key $by del $sql con MYSQL_ASSOC. 
*
* Llenando $gIAsql['selected_rows']. 
* conectandose de no estar conectado.
* @param string $sql el sql string a ejecutar
 * @param string $by
 * @param mixed $asoc
 * @param bool $showErrors
 * @return boolean FALSE on error, el 2 dim array con key $by del query $sql. null array en not found
 */
function ia_sqlArray($sql,$by='id',$asoc=MYSQL_ASSOC,$showErrors=true) {
global $gIAsql;
    $result=ia_result($sql,$showErrors);
    if($result===FALSE)
        return FALSE;
	$x=array();
	while ($d = @mysql_fetch_array($result,$asoc))
		$x[$d[$by]]=$d;
	$gIAsql['found_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return $x;
} 

/**
 * ia_sqlVector()
 * 
 * @param mixed $sql
 * @return
 */
function ia_sqlVector($sql) {
global $gIAsql;
    $result=ia_result($sql);
    if($result===FALSE)
        return FALSE;
	$x=array();
	while ($d = @mysql_fetch_array($result,MYSQL_NUM))
		$x[]=$d[0];
	$gIAsql['found_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return $x;
}

/**
 * ia_sqlKeyValue()
 * returns 2 dim array con key $by del $sql con MYSQL_ASSOC. 
 *
 * Llenando $gIAsql['selected_rows']. 
 * conectandose de no estar conectado.
 * @param string $sql el sql string a ejecutar
 * @return boolean FALSE on error, el 2 dim array con key $by del query $sql. null array en not found
 */
function ia_sqlKeyValue($sql) {
global $gIAsql;
    $result=ia_result($sql);
    if($result===FALSE)
        return FALSE;
	$x=array();
	while ($d = @mysql_fetch_array($result,MYSQL_NUM))
		$x[$d[0]]=$d[1];
	$gIAsql['found_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return $x;
}

/**
 * ia_sqlKeyValueTriplet()
 * 
 * @param mixed $sql
 * @return
 */
function ia_sqlKeyValueTriplet($sql) {
global $gIAsql;
    $result=ia_result($sql);
    if($result===FALSE)
        return FALSE;
	$x=array();
	while ($d = @mysql_fetch_array($result,MYSQL_NUM))
		$x[$d[0]][$d[1]]=$d[2];
	$gIAsql['found_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return $x;
}

/**
 * ia_sqlArrayIndx()
 * returns 2 dim array con num row del $sql con MYSQL_ASSOC. 
 * Llenando $gIAsql['selected_rows']. 
 * conectandose de no estar conectado.
 * @param string $sql el sql string a ejecutar
 * @param mixed $asoc
 * @param bool $showError
 * @return boolean FALSE on error, el 2 dim array con key num row del query $sql. null array en not found
 */
function ia_sqlArrayIndx($sql,$asoc=MYSQL_ASSOC,$showError=true) {
global $gIAsql;
    $gIAsql['found_rows']=0;
    $result=ia_result($sql,$showError);
    if($result===FALSE)
        return FALSE;
	$x=array();
	while ($d = @mysql_fetch_array($result,$asoc))
		$x[]=$d;
	$gIAsql['found_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return $x;
}

/**
 * ia_echoSqlOptions()
 * Hace un echo de options de un select donde col 1 es el value, col 2 el texto del sql, selected trae el value (col 1) se marca como selected
 * Llenando $gIAsql['selected_rows']. 
 * conectandose de no estar conectado.
 * falta quote protect $d[0]
 * @param string $sql el sql string a ejecutar col 1 es el value del option, col 2 se el texto entre options
 * @param string $selected
 * @param string $optionTag
 * @return boolean FALSE on error, TRUE ok
 */
function ia_echoSqlOptions($sql,$selected='',$optionTag='') {
global $gIAsql;
    $result=ia_result($sql);
    if($result===FALSE)
        return FALSE;
	while ($d = @mysql_fetch_array($result,MYSQL_NUM)) {
		if(is_array($selected)) {
			echo "\r\n<option value='$d[0]'".(array_key_exists($d[0],$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d[1])."</option>";
		} else {
			echo "\r\n<option value='$d[0]'".(strcmp($selected,$d[0]) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d[1])."</option>";
		}
	}
	$gIAsql['found_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return TRUE;
}

/**
 * ia_SqlOptions()
 * 
 * @param mixed $sql
 * @param string $selected
 * @param mixed $extra
 * @param string $optionTag
 * @return
 */
function ia_SqlOptions($sql,$selected='',$extra=array(),$optionTag='') {
global $gIAsql;

    $result=ia_result($sql);
    if($result===FALSE)
        return FALSE;
    $ret='';
    if($extra) foreach($extra as $k=>$v)
		if(is_array($selected)) {
			$ret.= "\r\n<option value='$k'".(array_key_exists($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($v)."</option>";
		} else {
			$ret.= "\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($v)."</option>";
		}    
	while ($d = @mysql_fetch_array($result,MYSQL_NUM)) {
		if(is_array($selected)) {
			$ret.= "\r\n<option value='$d[0]'".(array_key_exists($d[0],$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d[1])."</option>";
		} else {
			$ret.= "\r\n<option value='$d[0]'".(strcmp($selected,$d[0]) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d[1])."</option>";
		}
	}
	$gIAsql['found_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return $ret;
}

/**
 * ia_SqlOptionsSetDataData()
 * 
 * @param mixed $sql
 * @param string $selected
 * @param mixed $extra
 * @param string $optionTag
 * @return
 */
function ia_SqlOptionsSetDataData($sql,$selected='',$extra=array(),$optionTag='') {
global $gIAsql;

    $result=ia_result($sql);
    if($result===FALSE)
        return FALSE;
    $ret='';
    if($extra) foreach($extra as $k=>$v)
		if(is_array($selected)) {
			$ret.= "\r\n<option value='$k'".(array_key_exists($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($v)."</option>";
		} else {
			$ret.= "\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($v)."</option>";
		}    
	while ($d = @mysql_fetch_array($result,MYSQL_NUM)) {
		if(is_array($selected)) {
			$ret.= "\r\n<option data-data='$d[2]' value='$d[0]'".(array_key_exists($d[0],$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d[1])."</option>";
		} else {
			$ret.= "\r\n<option data-data='$d[2]' value='$d[0]'".(strcmp($selected,$d[0]) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d[1])."</option>";
		}
	}
	$gIAsql['found_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return $ret;
}

/**
 * ia_arrayOptions()
 * 
 * @param mixed $array
 * @param string $selected
 * @param mixed $extra
 * @param string $optionTag
 * @return
 */
function ia_arrayOptions($array,$selected='',$extra=array(),$optionTag='') {
global $gIAsql;

    $ret='';
    if($extra) foreach($extra as $k=>$v)
		if(is_array($selected)) {
			$ret.= "\r\n<option value='$k'".(array_key_exists($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($v)."</option>";
		} else {
			$ret.= "\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($v)."</option>";
		}    
	if($array) foreach($array as $k=>$d)
		if(is_array($selected)) {
			$ret.= "\r\n<option value='$d[0]'".(array_key_exists($d[0],$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d[1])."</option>";
		} else {
			$ret.= "\r\n<option value='$d[0]'".(strcmp($selected,$d[0]) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d[1])."</option>";
		}


	return $ret;
}


/**
 * ia_echoSqlOptionsTitle()
* Hace un echo de options de un select donde col 1 es el value, col 2 el texto del sql, col 3 el globito, 
* selected trae el value (col 1) se marca como selected
* Llenando $gIAsql['selected_rows']. 
* conectandose de no estar conectado.
* falta quote protect $d[0]
* @param string $sql el sql string a ejecutar value=>options value, display=>display option otro es class=la_clase (la pone entre '),
 * @param string $selected
 * @param string $optionTag
 * @return boolean FALSE on error, TRUE ok
 */
function ia_echoSqlOptionsTitle($sql,$selected='',$optionTag='') {
global $gIAsql;
    $result=ia_result($sql);
    if($result===FALSE)
        return FALSE;
	while ($d = @mysql_fetch_array($result,MYSQL_ASSOC)) {
	   $tag='';
	    foreach($d as $k=>$v) if($k!='display' )
            $tag.=" $k='$v'";
		if(is_array($selected)) {
			echo "\r\n<option value='$d[0]'".(in_array($d['value'],$selected) ? " SELECTED='selected' " : "").">".ia_htmlentities($d['display'])."</option>";
		} else {
			echo "\r\n<option value='$d[0]'".(strcmp($selected,$d['value']) ? "" : " SELECTED='selected' ").">".ia_htmlentities($d['display'])."</option>";
		}
	}
	$gIAsql['found_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return TRUE;
}

/**
 * ia_OptionsKey_echo()
 * 
 * @param mixed $array
 * @param string $selected
 * @param string $optionTag
 * @return
 */
function ia_OptionsKey_echo($array,$selected='',$optionTag='') {
global $gIAsql;
	if($array) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			echo "\r\n<option value='$k'".(in_array($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($k)."</option>";
		} else {
			echo "\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($k)."</option>";
		}
	}
}

/**
 * ia_OptionsValue()
 * 
 * @param mixed $array
 * @param string $selected
 * @param string $optionTag
 * @return
 */
function ia_OptionsValue($array,$selected='',$optionTag='') {
    $ret='';
	if($array) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			$ret.= "\r\n<option value='$d'".(in_array($d,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d)."</option>";
		} else {
			$ret.= "\r\n<option value='$d'".(strcmp($selected,$d) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d)."</option>";
		}
	}
    return $ret;
}

/**
 * ia_OptionsValue_echo()
 * 
 * @param mixed $array
 * @param string $selected
 * @param string $optionTag
 * @return
 */
function ia_OptionsValue_echo($array,$selected='',$optionTag='') {
	if($array) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			echo "\r\n<option value='$d'".(in_array($d,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d)."</option>";
		} else {
			echo "\r\n<option value='$d'".(strcmp($selected,$d) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d)."</option>";
		}
	}
}

/**
 * ia_SqlOptionsClass()
 * 
 * @param mixed $sql
 * @param string $selected
 * @param string $optionTag
 * @return
 */
function ia_SqlOptionsClass($sql,$selected='',$optionTag='') {
global $gIAsql;
    $result=ia_result($sql);
    if($result===FALSE)
        return FALSE;
    $ret='';
	while ($d = @mysql_fetch_array($result,MYSQL_NUM)) {
		if(is_array($selected)) {
			$ret.= "\r\n<option ".(isset($d[2]) && $d[2]!='' ? "class='".ia_htmlentities($d[2])."'" : '')." value='$d[0]'".(in_array($d[0],$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d[1])."</option>";
		} else {
			$ret.= "\r\n<option ".(isset($d[2]) && $d[2]!='' ? "class='".ia_htmlentities($d[2])."'" : '')." value='$d[0]'".(strcmp($selected,$d[0]) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d[1])."</option>";
		}
	}
	$gIAsql['found_rows']=@mysql_num_rows($result);
	@mysql_free_result($result);
	return $ret;
}
///////////////////////
/**
 * ia_Options_KeyDisplay()
 * pone options de un <select>
 * 
 * @param $array            [value]=display
 * @param $selected         value seleccionado actualmente
 * @param $optionAttr        opcional, atriubtos a agreagar a cada option
 * @return
 */
function ia_Options_KeyDisplay($array,$selected='',$optionAttr='') {
    $ret='';
	if($array) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			$ret.="\r\n<option value='$k'".(in_array($k,$selected) ? " SELECTED='selected' " : "")."$optionAttr>".ia_htmlentities($d)."</option>";
		} else {
			$ret.="\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionAttr>".ia_htmlentities($d)."</option>";
		}
	}
    return $ret;
}

/**
 * ia_Options_KeyDisplay
 * pone options de un <select>
 * 
 * @param $array            [value]=display
 * @param $selected         value seleccionado actualmente
 * @param $optionAttr        opcional, atriubtos a agreagar a cada option
 * 
 * @use ia_Options_KeyDisplay(ia_sqlKeyValue("SELECT id,nombre FROM tabla ORDER BY 2")  ,$id);
 * 
 */
function ia_Options_KeyValueDisplay($array,$selected='',$optionAttr='') {
    $ret='';
	if($array) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			$ret.="\r\n<option value='$k'".(in_array($k,$selected) ? " SELECTED='selected' " : "")."$optionAttr>".ia_htmlentities($d)."</option>";
		} else {
			$ret.="\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionAttr>".ia_htmlentities($d)."</option>";
		}
	}
    return $ret;
}

/**
 * ia_radioButtonsKeyValue()
 * 
 * @param mixed $name
 * @param mixed $array
 * @param string $selected
 * @param string $tag
 * @return
 */
function ia_radioButtonsKeyValue($name,$array,$selected='',$tag='') {
    $ret='';
	if($array) foreach($array as $k=>$d) {
	   $ret.= "<input type=radio name='$name' id='$name' value='".ia_htmlentities($k)."'".(strcmp($selected,$k) ? "" : " checked='checked' ")."$tag />".ia_htmlentities($d);
	}
    return $ret;
}

/**
 * ia_radioButtons()
 * 
 * @param mixed $name
 * @param mixed $array
 * @param string $selected
 * @param string $tag
 * @return
 */
function ia_radioButtons($name,$array,$selected='',$tag='') {
    $ret='';
	if($array) foreach($array as $k=>$d) {
	   $ret.= "<input type=radio name='$name' id='$name' value='".ia_htmlentities($d)."'".(strcmp($selected,$d) ? "" : " checked='checked' ")."$tag />".ia_htmlentities($d);
	}
    return $ret;
}


/**
* Dado error de sql reintentar el query
* @param int $errno el error de mysql para ver si hacer retry o no
* @return boolean TRUE retry query, FALSE no retry
*/
function ia_error_do_retry($errno) {
	if($errno==0) 
		return FALSE;
        
	if($errno==1205 || $errno==1206  || $errno==1213) {
		usleep(25);
		return TRUE;
	}
    return FALSE;
//return TRUE;
	if($errno==2006 || $errno==2013 || $errno==1203 || $errno==1184  || $errno==1154  || $errno==1040 || $errno==1080  ) {
		@mysql_close();
		usleep(50);
		return ia_connect();
	}
	return FALSE;
}

/**
 * dateit()
 * 
 * @param mixed $s
 * @return
 */
function dateit($s)  { if($s=='') return 'null';  return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."'"; }
/**
 * dateitc()
 * 
 * @param mixed $s
 * @return
 */
function dateitc($s) { if($s=='') return 'null'; return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."',"; }
/**
* Portege un string o fecha de caracteres extra para el sql query
* @param string $s el string a proteger
* @return string el string $s protegido 
*/
function strit($s)  {  return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."'"; }
/**
 * stritN()
 * 
 * @param mixed $s
 * @return
 */
function stritN($s)  { if($s=='') return 'null';  return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."'"; }
/**
* Portege un string o fecha de caracteres extra para el sql query
* @param string $s el string a proteger
* @return string el string $s protegido terminado con una coma
*/
function stritc($s) {  return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."',"; }
/**
 * stritNc()
 * 
 * @param mixed $s
 * @return
 */
function stritNc($s) {  return stritN($s)."',"; }

/**
 * comillea()
 * 
 * @param mixed $s
 * @return
 */
function comillea($s)  { if($s===null) return '""';  return '"'.str_replace('"',"'", $s).'"'; }
/**
 * jsit()
 * 
 * @param mixed $s
 * @return
 */
function jsit($s) { return '"'.str_replace( array("\\","\""),array("\\\\","\\\""),$s).'"'; }

/**
 * Portege un numero caracteres extraÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢óÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€šÃ‚Â ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¾Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â óÃƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¾ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢óÃƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â¦ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Â¦Ãƒâ€šÃ‚Â¡óÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â±os para el sql query, de no ser numerico pone 0
 * @param number $n el numero a proteger
 * @return string el numero $n protegido
 */
function numit($s)  { if( $s=='' ) return "0"; if( is_numeric($s) ) return strit($s); else return "0"; }
/**
 * numitN()
 * 
 * @param mixed $s
 * @return
 */
function numitN($s)  { if( $s=='' ) return "null"; if( is_numeric($s) ) return strit($s); else return "0"; }
/**
* Portege un numero caracteres extraÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢óÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€šÃ‚Â ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¾Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â óÃƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¾ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢óÃƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â¦ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Â¦Ãƒâ€šÃ‚Â¡óÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â±os para el sql query, de no ser numerico pone 0
* @param number $n el numero a proteger
* @return string el numero $n protegido terminado con una coma
*/
function numitc($s) { return numit($s).","; }
/**
 * numitNc()
 * 
 * @param mixed $s
 * @return
 */
function numitNc($s) { return numitN($s).","; }
/////////////////////////////////// params ////////////////////////////////////////////////////

/**
* regresa el parametro llamado $name en post en string o array, si no existe busca en get, de no estar regresa $dflt
* @param string $nombre nombre del parametro a regresar
* @param variable $dflt='' el valor a regresar de no existir el parametro. default ''
* @return string el parametro llamado $name en post o get array si es array, de no estar regresa $dflt
*/
function param($name,$dflt='')      { return param_post($name, param_get($name,$dflt) ); }

/**
* regresa el parametro llamado $name en get en string o array, de no estar regresa $dflt
* @param string $nombre nombre del parametro a regresar
* @param variable $dflt='' el valor a regresar de no existir el parametro. default ''
* @return string el parametro llamado $name en get, de no estar regresa $dflt
*/
function param_get($name,$dflt='')  {
	if(  array_key_exists($name,$_GET)  && !is_array($_GET[$name]) )
		return trim(urldecode($_GET[$name]));
	if( !array_key_exists($name,$_GET)) 
		return $dflt;
	$arr=$_GET[$name];
    array_walk_recursive($arr,'arrayWalk_param_post_encode');
    return $arr;
}
/**
* regresa el parametro llamado $name en post en string o array, de no estar regresa $dflt
* @param string $nombre nombre del parametro a regresar
* @param variable $dflt='' el valor a regresar de no existir el parametro. default ''
* @return string el parametro llamado $name en post, de no estar regresa $dflt
*/
function param_post($name,$dflt='') {
	if( array_key_exists($name,$_POST) && !is_array($_POST[$name]) )
		return trim(html_entity_decode($_POST[$name],ENT_QUOTES));
	if( !array_key_exists($name,$_POST) )
		return $dflt;
	$arr=$_POST[$name];
    array_walk_recursive($arr,'arrayWalk_param_post_encode');
    return $arr;
}


/**
 * arrayWalk_param_post_encode()
 * 
 * @param mixed $item
 * @param mixed $key
 * @return
 */
function arrayWalk_param_post_encode(&$item,$key) {
    $item=trim(html_entity_decode($item,ENT_QUOTES));
}
////////////////////////////////// emails ////////////////////////////////////////////////////

/**
* Valida un email este bien escrito por regexp
* @param string email a revisar
* @return boolean true email a validar 
*/
function ia_emailValidRegExp($email) { 
    return filter_var($email, FILTER_VALIDATE_EMAIL); 
}

/**
 * ia_email()
 * 
 * @param mixed $to
 * @param mixed $subject
 * @param mixed $body
 * @param mixed $from
 * @param string $headerExtra
 * @return
 */
function ia_email($to,$subject,$body,$from,$headerExtra='') {
    $headers  = "MIME-Version: 1.0\r\n";
    $headers .= "From: $from\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";	
    $headers=$headers.$header;
    return @mail($to,$subject,$body,$headers); 
}
  
//////////////////// formas ///////////////////////////////
  /**
   * input_value()
   * 
   * @param mixed $name
   * @param string $dflt
   * @return
   */
  function input_value($name,$dflt='') { return ' value="'.ia_htmlentities( param($name,$dflt) ).'" '; }
  /**
   * select_value()
   * 
   * @param mixed $name
   * @param mixed $valor
   * @param bool $forza
   * @return
   */
  function select_value($name,$valor,$forza=false) {
   return ' value="'.ia_htmlentities($valor).'"'.( ( param($name) == html_entity_decode($valor,ENT_QUOTES) || $forza) ? ' SELECTED ' : '' );
  }
  /**
   * radio_checked()
   * 
   * @param mixed $name
   * @param mixed $valor
   * @param bool $forza
   * @return
   */
  function radio_checked($name,$valor,$forza=false) {
   return ' value="'.ia_htmlentities($valor).'"'.( ( param($name) == html_entity_decode($valor,ENT_QUOTES) || $forza ) ? ' CHECKED ' : '' );
  }
  /**
   * array_options()
   * 
   * @param mixed $arr
   * @param mixed $selected
   * @param string $tag
   * @param string $optionTag
   * @return
   */
  function array_options($arr,$selected,$tag='',$optionTag='') {
  	foreach($arr as $k=>$d) {
		if(is_array($selected))
			echo "\r\n<option value='$k'".(in_array($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d)."</option>";
		else
			echo "\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d)."</option>";	
	}
  }
// doble submitted
  /**
   * ia_limite_add()
   * 
   * @return
   */
  function ia_limite_add() { 
    if(  !array_key_exists('limite',$_SESSION) )
      $_SESSION['limite']=1;
    else
      $_SESSION['limite']++;
 }

// file uploads

/**
 * uploadErrorStr()
 * 
 * @param mixed $indx
 * @return
 */
function uploadErrorStr($indx) {
    if( $_FILES[$indx]['error']==0)
	   return '';
   elseif( $_FILES[$indx]['error']==1)
	      return 'El archivo es demasiado grande';
   elseif( $_FILES[$indx]['error']==2)
	      return 'El archivo es demasiado grande';
   elseif( $_FILES[$indx]['error']==3)
	      return 'Solo subio parte del archivo';
   elseif( $_FILES[$indx]['error']==4)
	      return 'No subio el archivo';
   elseif( $_FILES[$indx]['error']==6)
	      return 'No subio el archivo a tmp';
   elseif( $_FILES[$indx]['error']==7)
	      return 'Error al escribir el archivo';
   elseif( $_FILES[$indx]['error']==8)
	      return 'Tipo de archivo invalido';
   else
    return 'Error al subir el archivo';
}

/////////////////////////////////////// ip //////////////////////////////////////////
/**
 * ip_extract()
 * 
 * @param mixed $ip
 * @return
 */
function ip_extract(&$ip) {
    $array=array();
	if (@preg_match("/^([0-9]{1,3}\.){3,3}[0-9]{1,3}/", $ip, $array))
		return $array;
	else
		return false;
}
/**
 * ip_server_set()
 * 
 * @param mixed $cual
 * @return
 */
function ip_server_set($cual) {
  if(  !array_key_exists($cual,$_SERVER) ) 
     return false;
  return   ( strcasecmp($_SERVER[$cual],'unknown')!=0 && $_SERVER[$cual]!='' );
}
/**
 * ip_get()
 * 
 * @return
 */
function ip_get() {
	if(ip_server_set('HTTP_X_FORWARDED_FOR')) { // case 1.A: proxy && HTTP_X_FORWARDED_FOR is defined
		$array = ip_extract($_SERVER['HTTP_X_FORWARDED_FOR']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}
	if(ip_server_set('HTTP_X_FORWARDED')) { // case 1.B: proxy && HTTP_X_FORWARDED is defined
		$array = ip_extract($_SERVER['HTTP_X_FORWARDED']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}
	if(ip_server_set('HTTP_FORWARDED_FOR')) { // case 1.C: proxy && HTTP_FORWARDED_FOR is defined
		$array = ip_extract($_SERVER['HTTP_FORWARDED_FOR']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}
	if(ip_server_set('HTTP_FORWARDED')) { // case 1.D: proxy && HTTP_FORWARDED is defined
		$array = ip_extract($_SERVER['HTTP_FORWARDED']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}
	if(ip_server_set('HTTP_CLIENT_IP')) { // case 1.E: proxy && HTTP_CLIENT_IP is defined
		$array = ip_extract($_SERVER['HTTP_CLIENT_IP']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}
	
	if(ip_server_set('HTTP_VIA')) {
	// case 2: 
	// proxy && HTTP_(X_) FORWARDED (_FOR) not defined && HTTP_VIA defined
	// other exotic variables may be defined 
	return ( $_SERVER['HTTP_VIA']. 
	  (  array_key_exists('HTTP_X_COMING_FROM',$_SERVER)   ?  '_' . $_SERVER['HTTP_X_COMING_FROM'] : '').
	  (   array_key_exists('HTTP_COMING_FROM',$_SERVER)   ?  '_' . $_SERVER['HTTP_COMING_FROM'] : '')
	  ) ;
	}
	if(ip_server_set('HTTP_X_COMING_FROM') || ip_server_set('HTTP_COMING_FROM') ) {
	// case 3: proxy && only exotic variables defined
	// the exotic variables are not enough, we add the REMOTE_ADDR of the proxy
	return ( $_SERVER['REMOTE_ADDR'] . 
	  (  array_key_exists('HTTP_X_COMING_FROM',$_SERVER)   ?  '_' . $_SERVER['HTTP_X_COMING_FROM'] : '').
	  (  array_key_exists('HTTP_COMING_FROM',$_SERVER)   ?  '_' . $_SERVER['HTTP_COMING_FROM'] : '')
	  ) ;
	}
	
	// case 4: no proxy (or tricky case: proxy+refresh)
	if(ip_server_set('REMOTE_HOST')) {
		$array = ip_extract($_SERVER['REMOTE_HOST']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}
	return $_SERVER['REMOTE_ADDR'];
}
/**
 * ip_getFull()
 * 
 * @return
 */
function ip_getFull() {
	//optimizar
	$ip='';
	if(ip_server_set('HTTP_X_FORWARDED_FOR')) { // case 1.A: proxy && HTTP_X_FORWARDED_FOR is defined
		$ip.=',HTTP_X_FORWARDED_FOR,'.$_SERVER['HTTP_X_FORWARDED_FOR'];
	}
	if(ip_server_set('HTTP_X_FORWARDED')) { // case 1.B: proxy && HTTP_X_FORWARDED is defined
		$ip.=',HTTP_X_FORWARDED,'.$_SERVER['HTTP_X_FORWARDED'];
	}
	if(ip_server_set('HTTP_FORWARDED_FOR')) { // case 1.C: proxy && HTTP_FORWARDED_FOR is defined
		$ip.=',HTTP_FORWARDED_FOR,'.$_SERVER['HTTP_FORWARDED_FOR'];
	}
	if(ip_server_set('HTTP_FORWARDED')) { // case 1.D: proxy && HTTP_FORWARDED is defined
		$ip.=',HTTP_FORWARDED,'.$_SERVER['HTTP_FORWARDED'];
	}
	if(ip_server_set('HTTP_CLIENT_IP')) { // case 1.E: proxy && HTTP_CLIENT_IP is defined
		$ip.=',HTTP_CLIENT_IP,'.$_SERVER['HTTP_CLIENT_IP'];
	}
	
	if(ip_server_set('HTTP_VIA')) {
	   $ip.=',HTTP_VIA,'. $_SERVER['HTTP_VIA'];
	}
	if(ip_server_set('HTTP_COMING_FROM') ) {
	  $ip.=',HTTP_X_COMING_FROM,' . $_SERVER['HTTP_X_COMING_FROM'];
	}
	if(ip_server_set('HTTP_X_COMING_FROM') ) {
	  $ip.=',HTTP_X_COMING_FROM,' . $_SERVER['HTTP_X_COMING_FROM'];
	}
		
	// case 4: no proxy (or tricky case: proxy+refresh)
	if(ip_server_set('REMOTE_HOST')) {
		$ip.=',REMOTE_HOST,'.$_SERVER['REMOTE_HOST'];
	}
	if(ip_server_set('REMOTE_ADDR')) {
		$ip.=',REMOTE_ADDR,'.$_SERVER['REMOTE_ADDR'];
	}	
	return $ip;
}
 
////////////////////// HTML //////////////////////////////////////////////////////////////////////////
if ( !function_exists('ia_htmlentities')) {    
  /**
   * ia_htmlentities()
   * 
   * @param mixed $s
   * @param bool $forza
   * @param bool $hardblank
   * @return
   */
  function ia_htmlentities($s,$forza=false,$hardblank=false) { if($hardblank && ($s==null || $s=='') ) return '&nbsp;'; return htmlentities($s); }
}

  /**
   * redirect()
   * 
   * @param mixed $url
   * @return
   */
  function redirect($url) {
   $requestProtocol = array_key_exists('SERVER_PROTOCOL',$_SERVER)  ? $_SERVER["SERVER_PROTOCOL"] : 'HTTP/1.0';  
   $protocolArr = explode("/",$requestProtocol); 
   $protocolName = isset($protocolArr[1]) ? trim($protocolArr[0]) : 'HTTP/1.0'; 
   $protocolVersion = isset($protocolArr[1]) ? trim($protocolArr[1]): ''; 
   if (stristr($protocolName,"HTTP") && strtolower($protocolVersion) > "1.0" ) { 
     $httpStatusCode = 307; 
   } else { 
      $httpStatusCode = 302; 
   } 
   $httpStatusLine = "$requestProtocol $httpStatusCode Temporary Redirect"; 
   @header($httpStatusLine, TRUE, $httpStatusCode); 
   @header("Location: $url");    
  }

  /**
   * refreshTo()
   * 
   * @param mixed $url
   * @return
   */
  function refreshTo($url) {
   echo "<html><head><meta http-equiv='refresh' content='0;url='$url'/></head><body><a href='$url'>$url</a></body></html>";   
  }

/**
 * post_to_get()
 * 
 * @param integer $maxLen
 * @return
 */
function post_to_get($maxLen=4096) {
	$ret='?';
	if( isset($_POST) && sizeof($_POST)>0) 
	reset($_POST);
	while (list($k, $d) = each($_POST))
	// pasara a array exclude param
	if($k!='password' && $k!='pwd' && $k!='entrar' && $k!='email' && $k!='guarda' && $k!='causa_cancela' && $k!='confirma' && $k!='Foto'  )
		if($ret=='?')
			$ret.="$k=".urlencode($v);
		else
			$ret.="&$k=".urlencode($v);
	if( strlen($ret)>$maxLen)
		return substr($ret,0,$maxLen);	
	return $ret;
}
 
 /**
  * ia_md5_salted()
  * 
  * @param mixed $s
  * @return
  */
 function ia_md5_salted($s) { return md5("[Ga7ubeLa>$s"."KLZ*"); }
//
/**
 * ia_convertBytes()
 * 
 * @param mixed $bytes
 * @return
 */
function ia_convertBytes($bytes) {
    if($bytes=='' || !is_numeric($bytes))
        return $bytes;
    if($bytes<0) {
        $singo='-';
        $bytes*=-1;
    } else
        $signo='';
    if($bytes<=1024) {
        $decs=0;
        $punto='';
    } else {
        $decs=2;
        $punto='.';
    }
    $unit=array('b','Kb','Mb','Gb','Tb','Pb');
    return $signo.@number_format($bytes/@pow(1024,($i=floor(log($bytes,1024)))),$decs,$punto,',').' '.$unit[$i];
}

/**
 * ia_errores_a_dime()
 * 
 * @param string $msg
 * @param string $usuario
 * @param string $script
 * @return
 */
function ia_errores_a_dime($msg='',$usuario='',$script='') {
global $gIAsql;
        $tmp=error_last();
        $json= function_exists('json_last_error()') ? json_last_error() : 0;
        if($json) {
            if($json==JSON_ERROR_DEPTH)
                $tmp.="\r\nJSON ERROR: The maximum stack depth has been exceeded";
            elseif($json==JSON_ERROR_STATE_MISMATCH)
                $tmp.="\r\nJSON ERROR: Invalid or malformed JSON";  
            elseif($json==JSON_ERROR_CTRL_CHAR)
                $tmp.="\r\nJSON ERROR: Control character error, possibly incorrectly encoded"; 
            elseif($json==JSON_ERROR_SYNTAX)
                $tmp.="\r\nJSON ERROR: Syntax error"; 
            elseif($json==JSON_ERROR_UTF8)
                $tmp.="\r\nJSON ERROR: Malformed UTF-8 characters, possibly incorrectly encoded"; 
            else
                $tmp.="\r\nJSON ERROR: $json";                                                                             
        }
        if($tmp!='' || $gIAsql['err']!='' || $msg!='') {
            if($tmp!='')
                $tmp.="\r\n";
            if($gIAsql['err']!='')
                $tmp.=$gIAsql['err']."\r\n";
            if($msg!='')
                $tmp=$msg."\r\n".$tmp;                
            $usuario = $usuario=='' && array_key_exists('usuario',$_SESSION) ? $_SESSION['usuario'] : $usuario;
            if($script=='')
                $script=$_SERVER['SCRIPT_NAME'];
            ia_query("INSERT INTO dime(usuario,script,dime) VALUES(".stritc($usuario).stritc($script).strit($tmp).")");
        }
}


/**
 * ia_report_status_collapsable()
 * 
 * @param bool $scriptTime
 * @param bool $rusage
 * @param bool $ram
 * @param bool $sqlErrors
 * @param bool $sqlTrace
 * @param bool $phpErr
 * @return
 */
function ia_report_status_collapsable($scriptTime=true,$rusage=true,$ram=true,$sqlErrors=true,$sqlTrace=true,$phpErr=true) {
global $gIAsql, $gIaTimeStart;
    $tmp=error_last();
    $color= empty($gIAsql['err']) && empty($tmp) ? 'color:silver;' : 'color:red;' ;
    $ret=ia_report_status($scriptTime,$rusage,$ram,$sqlErrors,$sqlTrace,$phpErr);
    return "<div style='padding-top:16px;'><span style='cursor:pointer;font-style:italic;font-weight:lighter;$color;' onClick='ia_toggleSibling(this,\"Page stats\");'>&#8594; Page stats</span><div style='display:none;padding-left:16px;'>$ret</div></div>";
}

/**
 * ia_report_status()
 * 
 * @param bool $scriptTime
 * @param bool $rusage
 * @param bool $ram
 * @param bool $sqlErrors
 * @param bool $sqlTrace
 * @param bool $phpErr
 * @return
 */
function ia_report_status($scriptTime=true,$rusage=true,$ram=true,$sqlErrors=true,$sqlTrace=true,$phpErr=true) {
global $gIAsql, $gIaTimeStart;

    $finalT=microtime(true); 
    $ret= PHP_EOL."<table class=tabla >";
    if($phpErr) {
        $tmp=error_last(); //phperr
        if($tmp!='') 
            $ret.= PHP_EOL."<tr><td><table>
                <th style='color:red;'><a name='phperr'></a>Last php error<tr><td WRAP style='color:red;white-space:normal;'>".ia_htmlentities($tmp)
                ."</table>";
    }
    
    $ramDoTable=true;
    $timeRam='';
    if($scriptTime ) {
        $ramDoTable=false;
        $timeRam.= PHP_EOL."<tr><td>
        <table class=tabla><tr><th>Script Time
            <table class=tabla>";
        if( array_key_exists('REQUEST_TIME',$_SERVER) ) {
            $lapsed=abs($finalT-$_SERVER['REQUEST_TIME']);
            $milli=round($lapsed-floor($lapsed),3)*1000;
            $timeRam.=PHP_EOL."\t\t\t\t<tr><th class='nowrap'>Request time<td NOWRAP class='der nowrap' style='width:20px;'>".str_replace(
                 array('0 h','00 min','00 sec',' 01',' 02',' 03',' 04',' 05',' 06',' 07',' 08',' 09')
                 ,array('','',''               ,' 1',' 2',' 3',' 4',' 5',' 6',' 7',' 8',' 9')
                ,gmDate(' G \h i \m\i\n s \s\e\c '.$milli.' \m\s',floor($lapsed) ) );
        }    
        if(isset($gIaTimeStart) && $gIaTimeStart!='' && is_numeric( $gIaTimeStart) ) {
            $lapsed=abs($finalT-$gIaTimeStart);
            $milli=round($lapsed-floor($lapsed),3)*1000;
            $timeRam.=PHP_EOL. "\t\t\t\t<tr><th class='nowrap'>Script time<td NOWRAP class='der nowrap'>".str_replace(
                 array('0 h','00 min','00 sec',' 01',' 02',' 03',' 04',' 05',' 06',' 07',' 08',' 09')
                 ,array('','',''               ,' 1',' 2',' 3',' 4',' 5',' 6',' 7',' 8',' 9')
                ,gmDate(' G \h i \m\i\n s \s\e\c '.$milli.' \m\s',floor($lapsed) ) );
        }
        if(isset($gIaTimeStart) && $gIaTimeStart!='' && is_numeric( $gIaTimeStart) && array_key_exists('REQUEST_TIME',$_SERVER) ) {
            $lapsed=abs( $_SERVER['REQUEST_TIME']-$gIaTimeStart );
            $milli=round($lapsed-floor($lapsed),3)*1000;        
            $timeRam.= PHP_EOL."\t\t\t\t<tr><th class='nowrap'>Apache time<td NOWRAP class='der nowrap'>".str_replace(
                 array('0 h','00 min','00 sec',' 01',' 02',' 03',' 04',' 05',' 06',' 07',' 08',' 09')
                 ,array('','',''               ,' 1',' 2',' 3',' 4',' 5',' 6',' 7',' 8',' 9')
                ,gmDate(' G \h i \m\i\n s \s\e\c '.$milli.' \m\s',floor($lapsed) ) );        
        }
        $timeRam.= PHP_EOL."\t\t\t</table>".PHP_EOL;
    }
        
    if($ram && function_exists('memory_get_usage') && function_exists('memory_get_peak_usage') ) {
        if($ramDoTable)
            $timeRam.=PHP_EOL.PHP_EOL."<tr><td>
            <table class=tabla><tr>";
        $ramDoTable=false;
        $timeRam.= PHP_EOL."\t\t\t<th>RAM
            <table class=tabla>
                  <tr><th class='achica'>Usage<th class='achica'>Usage malloc<th class='achica'>Peak<th class='achica'>Peak malloc
                  <tr><td class='der achica'>".ia_convertBytes( memory_get_usage() )."<td class='der achica'>" . ia_convertBytes( memory_get_usage(true) )
                     ."<td class='der achica'>".ia_convertBytes( memory_get_peak_usage() )."<td class='der achica'>".ia_convertBytes( memory_get_peak_usage(true) )
            .PHP_EOL."\t\t\t</table>";
    }
    
    if($timeRam!='')
        $ret.=$timeRam.PHP_EOL.PHP_EOL."\t\t</table>".PHP_EOL;
        
    if( $rusage && function_exists('getrusage')) {
        $tit['ru_utime.tv_sec']='CPU user time secs.';
        $tit['ru_utime.tv_usec']='CPU user time microseconds.';
        $tit['ru_stime.tv_sec']='CPU system time secs.';
        $tit['ru_stime.tv_usec']='CPU system time microseconds.';   
        $tit['ru_maxrss']='Maximum resident size in Kb.';
        $tit['ru_ixrss']='Integer, amount of memory used by the text segment that was also shared among other processes in kb * ticks-of-execution';
        $tit['ru_idrss']='Integer, amount of unshared memory residing in the data segment of a process in kb * ticks-of-execution';
        $tit['ru_isrss']='Integer, amount of unshared memory residing in the stack segment of a process in kb * ticks-of-execution';
        $tit['ru_minflt']='Number of page faults serviced without any I/O activity';
        $tit['ru_majflt']='Number of page faults serviced that required I/O activity';
        $tit['ru_nswap']='Number of times a process was swapped out of main memory';
        $tit['ru_inblock']='Number of times the file system had to perform input';
        $tit['ru_oublock']='Number of times the file system had to perform output';
        $tit['ru_msgsnd']='Number of IPC messages sent';    
        $tit['ru_msgrcv']='Number of IPC messages received';
        $tit['ru_nsignals']='Number of signals delivered';
        $tit['ru_nvcsw']='Number of voluntary context switches';
        $tit['ru_nivcsw']='Number of context switches due to higher priority or time slice exceeded'; 

        $uni['ru_stime.tv_sec']=$uni['ru_utime.tv_sec']='secs.';
        $uni['ru_stime.tv_usec']=$uni['ru_utime.tv_usec']='microseconds';   
        $uni['ru_maxrss']='Kb.';
        $uni['ru_isrss']=$uni['ru_idrss']=$uni['ru_ixrss']='kb * ticks-of-execution';
        $uni['ru_majflt']=$uni['ru_minflt']='pages';
        $uni['ru_inblock']=$uni['ru_oublock']=$uni['ru_nswap']='# veces';
        
        $uni['ru_msgrcv']=$uni['ru_msgsnd']='# IPC messages';    
        $uni['ru_nsignals']='# se&ntilde;ales';
        $uni['ru_nivcsw']=$uni['ru_nvcsw']='# context switches';
                
        $tmp=getrusage();
        //$tmp2=getrusage(1);
        $ret.= PHP_EOL."<tr><th class='izq nowrap'>R Usage<tr><td>
            <table class=tabla>
                  <tr><th class='achica'>Item<th class='achica'>Value<th class='achica'>Units";
        foreach( $tmp as $k=>$v) {
            $ret.=PHP_EOL."<tr><th><span".(array_key_exists($k,$tit) ? " title='$tit[$k]'" : '').">$k</span>
                    <td NOWRAP class='der nowrap'>".number_format($v,0,'',',')
                
                ."<td>".(array_key_exists($k,$uni) ? $uni[$k] : '');
                //."<td NOWRAP class='der nowrap'>".number_format( array_key_exists($k,$tmp2) ? $tmp2[$k]:0  ,0,'',',')
        }
        $ret.="</table>";          
    }
    
    if($sqlErrors) {
        if($gIAsql['begins']!=0)
            $ret.=PHP_EOL."<tr><th class='izq nowrap' style='color:red;'>Hanging begins: $gIAsql[begins]";
        if($sqlErrors && !empty($gIAsql['err'])) {
            $ret.=PHP_EOL."<tr><th class='izq nowrap' style='color:red;'><a name=sqlerr></a>Sql Errors<tr><td style='white-space:pre;style='color:red;'><ol style='style='color:red;'>$gIAsql[err]</ol>";
        }
    }

    if($sqlTrace && $gIAsql['trace']) {
        $ret.="<tr><th class='izq nowrap'>Sql trace<table class=tabla><tr><td><pre><ol>"; 
        foreach( $gIAsql['sql_trace'] as $v)
            $ret.="<li>".ia_htmlentities($v); 
        $ret.="</ol></pre></table>";
    }
    return $ret.PHP_EOL."</table>".PHP_EOL;    
}

/**
 * ia_array2js()
 * 
 * @param mixed $nombre
 * @param mixed $arr
 * @return
 */
function ia_array2js($nombre,$arr) {
    echo PHP_EOL."$var={";
    if($arr) {
        
    }
    echo '};'.PHP_EOL;
}

// files
/**
 * file_size_formatted()
 * 
 * @param mixed $size
 * @return
 */
function file_size_formatted($size) {
    if($size<1024)
        return $size.'b';
    if($size<1024*1024)
        return round($size/1024.00,0).'Kb';
    if($size<1024*1024*1024)
        return round($size/(1024.00*1024.00),1).'Mb';  
    return round($size/(1024.00*1024.00*1024.00),1).'Gb';      
}
/**
 * file_is_image()
 * 
 * @param mixed $fileName
 * @return
 */
function file_is_image($fileName) {
    $dot=strrpos($fileName,'.');
    if($dot===FALSE)
        return false;
    $ext=substr($fileName,$dot+1);
    return (strcasecmp($ext,'jpg')==0 || strcasecmp($ext,'jpeg')==0 || strcasecmp($ext,'gif')==0 || strcasecmp($ext,'png')==0 );
}
/**
 * file_icon()
 * 
 * @param mixed $fileName
 * @return
 */
function file_icon($fileName) {
global $gIApath;
    
    $dot=strrpos($fileName,'.');
    if($dot===FALSE)
        return false;
    $ext=substr($fileName,$dot+1);
    if(strcasecmp($ext,'jpg')==0 || strcasecmp($ext,'jpeg')==0 || strcasecmp($ext,'gif')==0 || strcasecmp($ext,'png')==0 || strcasecmp($ext,'bmp')==0 || strcasecmp($ext,'ico')==0 )
        return "$gIApath[WebPath]img/ext/jpg.gif";
    if(strcasecmp($ext,'avi')==0 || strcasecmp($ext,'mpeg')==0 || strcasecmp($ext,'rm')==0 || strcasecmp($ext,'wmp')==0 )
        return "$gIApath[WebPath]img/ext/video.gif";        
    $gifs=array('csv','doc','docx','gif','htm','html','jpeg','jpg','pdf','png','pps','ppsx','ppt','pptx','video','wav','xls','xlsx');
    if(in_array($ext,$gifs))
        return "$gIApath[WebPath]img/ext/$ext.gif";
    return "$gIApath[WebPath]img/ext/clip.gif";
}
// IMAGES
/**
 * ia_image_tag_size()
 * 
 * @param mixed $imageFile
 * @return
 */
function ia_image_tag_size($imageFile) {
try {
    if(!file_exists($imageFile) )
        return '';
    $size=filesize($imageFile);
    if($size===FALSE)
        $size='';
    else
        $size=file_size_formatted($size);
    if(file_is_image($imageFile)) {
        $arr=getimagesize($imageFile); // 0=width, 1=height, 3=height, width tag  
        if($arr===FALSE || !is_array($arr) || sizeof($arr)<4) return $size;
        return "w: $arr[0]px h:$arr[1]px $size";
    }
    return $size;
} catch(Exception $e) { return ''; } 
}

/**
 * ia_image_tagsize_fitmax()
 * 
 * @param mixed $imageFile
 * @param mixed $max_width
 * @param mixed $max_height
 * @param bool $cssFormat
 * @param bool $enLarge
 * @return
 */
function ia_image_tagsize_fitmax($imageFile,$max_width,$max_height,$cssFormat=true,$enLarge=false) {
try {
    $arr=@getimagesize($imageFile); // 0=width, 1=height, 3=height, width tag
    if($arr===FALSE || !is_array($arr) || sizeof($arr)<4) return '';
    
    if($arr[0]==$max_width && $arr[1]==$max_height)
        if($cssFormat)
            return "width:$arr[0]px;height:$arr[1]px;";
        else
            return $arr[3];
                
    if($arr[0]<=$max_width && $arr[1]<=$max_height)
        if( !$enLarge )
            if($cssFormat)
                return "width:$arr[0]px;height:$arr[1]px;";
            else
                return $arr[3];
        else {
            if($max_width>=$max_height) 
                if($cssFormat)
                    return "width:$max_width"."px;height:".round( $max_width/$arr[0]*$arr[1],0).'px;';       
                else
                    return "width='$max_width' height='".round( $max_width/$arr[0]*$arr[1],0)."'";        
            else
                if($cssFormat)
                    return 'width:'.round($max_height/$arr[1]*$arr[0])."px;height:$max_height"."px;";       
                else
                    return "height='$max_height' width='".round($max_height/$arr[1]*$arr[0])."'";
        }
        
    if( ($arr[0]>$max_width && $arr[1]<=$max_height) || ( $arr[0]>$max_width && $arr[0]>=$arr[1] && round( $max_width/$arr[0]*$arr[1],0)<=$max_height )   )
        if($cssFormat)
            return "width:$max_width"."px;height:".round( $max_width/$arr[0]*$arr[1],0).'px;';       
        else
            return "width='$max_width'";

    if( ($arr[1]>$max_height && $arr[0]<=$max_width) || ( $arr[1]>$max_height && $arr[1]>=$arr[0] && round( $max_height/$arr[1]*$arr[0],0)<=$max_width )  )
        if($cssFormat)
            return 'width:'.round($max_height/$arr[1]*$arr[0])."px;height:$max_height"."px;";       
        else
            return "height='$max_height'";    
    
    if($max_width>=$max_height) 
        if($cssFormat)
            return "width:$max_width"."px;height:".round( $max_width/$arr[0]*$arr[1],0).'px;';       
        else
            return "width='$max_width' height='".round( $max_width/$arr[0]*$arr[1],0)."'";        
    else
        if($cssFormat)
            return 'width:'.round($max_height/$arr[1]*$arr[0])."px;height:$max_height"."px;";       
        else
            return "height='$max_height' width='".round($max_height/$arr[1]*$arr[0])."'";
} catch(Exception $e) { return ''; } 
}

/**
 * ia_image_escribe()
 * 
 * @param mixed $imageFile
 * @param mixed $escribe
 * @return
 */
function ia_image_escribe($imageFile,$escribe) {
try {
    $ext=substr($imageFile,-3);
    if( strcasecmp($ext,'png')==0 )
        $image = imagecreatefrompng($img);
    elseif( strcasecmp($ext,'gif')==0 )
        $image = imagecreatefromgif($img);
    elseif( strcasecmp($ext,'jpg')==0 || strcasecmp(substr($imageFile,-4),'jpeg')==0 )
        $image = imagecreatefromjpeg($img);
    elseif( strcasecmp($ext,'bmp')==0 )
        $image = imagecreatefromwbmp($img);
    else
        return FALSE;
        
    if($image===FALSE)
        return FALSE;
    $color = imagecolorallocate($image, 0, 0, 0);
    $x=10;
    $y=10;
    foreach($escribe as $k=>$v) {
        $font= array_key_exists('font',$v) ? $v['font'] : './arial.ttf';
        $font_size= array_key_exists('font_size',$v) ? $v['font_size'] : 9;
        $text=array_key_exists('texto',$v) ? $v['texto'] : ' ';
        if( array_key_exists('color_rgb',$v) ) {
            if(is_array($v['color_rgb']) && sizeof($v['color_rgb'])>=3)
                $color = imagecolorallocate($image, $v['color_rgb'][0], $v['color_rgb'][1], $v['color_rgb'][2]);
        }
        if( array_key_exists('utf8_encode',$v) && $v['utf8_encode'] )
            $text=utf8_encode($text);
            
        $arr=imagettfbbox($font_size,0,$font,$text);
        $x= array_key_exists('x',$v) ? $v['x'] : $x;
        $y= array_key_exists('y',$v) ? $v['y'] : $y;
        ImageTTFText($image, $font_size, 0, $x, $y, $color, $font, $text);
        $y+=10;
    }
    return $image;
} catch(Exception $e) { return FALSE; } 
}

/**
 * Convert an RGB array to HEX
 *
 * @param array $colors array('r' => 255, 'g' => 125, 'b' => 0)
 * @return string 
 */
/**
 * rgb_to_hex()
 * 
 * @param mixed $colors
 * @return
 */
function rgb_to_hex($colors = array()) {
        /* Won't accept black, so we make an exception (thanks Arantor) */
        if ($colors['r'] === '0' && $colors['g'] === '0' && $colors['b'] === '0')
                return '000000';
        /* If it's an empty array, or missing a color, it's invalid! */
        if (empty($colors['r']) && empty($colors['g']) & empty($colors['b']))
                return false;

        return strtoupper(dechex($colors['r']).dechex($colors['g']).dechex($colors['b']));
}
/**
 * imagesharpen()
 * 
 * @param mixed $image
 * @return
 */
function imagesharpen( $image) {
    
        $matrix = array(
            array(-1, -1, -1),
            array(-1, 16, -1),
            array(-1, -1, -1),
        );
    
        $divisor = array_sum(array_map('array_sum', $matrix));
        $offset = 0; 
        imageconvolution($image, $matrix, $divisor, $offset);
        
        return $image;
    }
    
/**
 * Convert a HEX color string to an RGB array
 *
 * @param string $hex HEX string to convert
 * @param bool $returnstring Return as string or array
 * @return array
 */
/**
 * hex_to_rgb()
 * 
 * @param mixed $hex
 * @param bool $returnstring
 * @return
 */
function hex_to_rgb($hex, $returnstring = false) {
        $hex = preg_replace('~[^0-9A-Fa-f]~', '', $hex);
        $rgb = array();

        if (strlen($hex) == 6) {
                $color = hexdec($hex);
                $rgb['r'] = 0xFF & ($color >> 0x10);
                $rgb['g'] = 0xFF & ($color >> 0x8);
                $rgb['b'] = 0xFF & $color;
        } elseif (strlen($hex) == 3) {
                $rgb['r'] = hexdec(str_repeat(substr($hex, 0, 1), 2));
                $rgb['g'] = hexdec(str_repeat(substr($hex, 1, 1), 2));
                $rgb['b'] = hexdec(str_repeat(substr($hex, 2, 1), 2));
        } else
                return false;

        return $returnstring == true ? implode(',', $rgb) : $rgb;
}

/**
 * saniteze_string()
 * 
 * @param mixed $s
 * @return
 */
function saniteze_string($s) {
    $letras['%01']='';
        $letras['%02']='';
        $letras['%03']='';
        $letras['%04']='';
        $letras['%05']='';
        $letras['%06']='';
        $letras['%07']='';
        $letras['%08']='';
        $letras['%09']='';
        $letras['%0A']='';
        $letras['%0B']='';
        $letras['%0C']='';
        $letras['%0D']='';
        $letras['%0E']='';
        $letras['%0F']='';
        $letras['%10']='';
        $letras['%11']='';
        $letras['%12']='';
        $letras['%13']='';
        $letras['%14']='';
        $letras['%15']='';
        $letras['%16']='';
        $letras['%17']='';
        $letras['%18']='';
        $letras['%19']='';
        $letras['%1A']='';
        $letras['%1B']='';
        $letras['%1C']='';
        $letras['%1D']='';
        $letras['%1E']='';
        $letras['%1F']='';
        $letras['%20']='_';
        $letras['%21']="_";
        $letras['%22']='_';
        $letras['%23']="_";
        $letras['%24']="_";
        $letras['%25']="_";
        $letras['%26']="_";
        $letras['%27']="_";
        $letras['%28']="_";
        $letras['%29']="_";
        $letras['%2A']="_";
        $letras['%2B']="_";
        $letras['%2C']="_";
        $letras['%2D']="-";
        $letras['%2E']=".";
        $letras['%2F']="_";
        $letras['%30']="0";
        $letras['%31']="1";
        $letras['%32']="2";
        $letras['%33']="3";
        $letras['%34']="4";
        $letras['%35']="5";
        $letras['%36']="6";
        $letras['%37']="7";
        $letras['%38']="8";
        $letras['%39']="9";
        $letras['%3A']="_";
        $letras['%3B']="_";
        $letras['%3C']="_";
        $letras['%3D']="_";
        $letras['%3E']="_";
        $letras['%3F']="_";
        $letras['%40']="_";
        $letras['%41']="A";
        $letras['%42']="B";
        $letras['%43']="C";
        $letras['%44']="D";
        $letras['%45']="E";
        $letras['%46']="F";
        $letras['%47']="G";
        $letras['%48']="H";
        $letras['%49']="I";
        $letras['%4A']="J";
        $letras['%4B']="K";
        $letras['%4C']="L";
        $letras['%4D']="M";
        $letras['%4E']="N";
        $letras['%4F']="O";
        $letras['%50']="P";
        $letras['%51']="Q";
        $letras['%52']="R";
        $letras['%53']="S";
        $letras['%54']="T";
        $letras['%55']="U";
        $letras['%56']="V";
        $letras['%57']="W";
        $letras['%58']="X";
        $letras['%59']="Y";
        $letras['%5A']="Z";
        $letras['%5B']="_";
        $letras['%5C']='_';
        $letras['%5D']="_";
        $letras['%5E']="_";
        $letras['%5F']="_";
        $letras['%60']="_";
        $letras['%61']="a";
        $letras['%62']="b";
        $letras['%63']="c";
        $letras['%64']="d";
        $letras['%65']="e";
        $letras['%66']="f";
        $letras['%67']="g";
        $letras['%68']="h";
        $letras['%69']="i";
        $letras['%6A']="j";
        $letras['%6B']="k";
        $letras['%6C']="l";
        $letras['%6D']="m";
        $letras['%6E']="n";
        $letras['%6F']="o";
        $letras['%70']="p";
        $letras['%71']="q";
        $letras['%72']="r";
        $letras['%73']="s";
        $letras['%74']="t";
        $letras['%75']="u";
        $letras['%76']="v";
        $letras['%77']="w";
        $letras['%78']="x";
        $letras['%79']="y";
        $letras['%7A']="z";
        $letras['%7B']="_";
        $letras['%7C']="_";
        $letras['%7D']="_";
        $letras['%7E']="_";
        $letras['%7F']='_';
        $letras['%80']="E";
        $letras['%81']='_';
        $letras['%82']="_";
        $letras['%83']="f";
        $letras['%84']='_';
        $letras['%85']=".";
        $letras['%86']="_";
        $letras['%87']="_";
        $letras['%88']="_";
        $letras['%89']="_";
        $letras['%8A']="_";
        $letras['%8B']="_";
        $letras['%8C']="C";
        $letras['%8D']="a";
        $letras['%8E']="Z";
        $letras['%8F']="a";
        $letras['%90']="a";
        $letras['%91']="_";
        $letras['%92']="_";
        $letras['%93']='_';
        $letras['%94']='_';
        $letras['%95']=".";
        $letras['%96']="ae";
        $letras['%97']="a";
        $letras['%98']="a";
        $letras['%99']="T";
        $letras['%9A']="s";
        $letras['%9B']="_";
        $letras['%9C']="o";
        $letras['%9D']='_';
        $letras['%9E']="z";
        $letras['%9F']="Y";
        $letras['%A0']='_';
        $letras['%A1']="_";
        $letras['%A2']="c";
        $letras['%A3']="L";
        $letras['%A4']="o";
        $letras['%A5']="y";
        $letras['%A6']="_";
        $letras['%A7']="s";
        $letras['%A8']=".";
        $letras['%A9']="c";
        $letras['%AA']="a";
        $letras['%AB']="_";
        $letras['%AC']="_";
        $letras['%AD']='_';
        $letras['%AE']="R";
        $letras['%AF']="-";
        $letras['%B0']="_";
        $letras['%B1']="_";
        $letras['%B2']="2";
        $letras['%B3']="3";
        $letras['%B4']="_";
        $letras['%B5']="u";
        $letras['%B6']="p";
        $letras['%B7']=".";
        $letras['%B8']="_";
        $letras['%B9']="1";
        $letras['%BA']="o";
        $letras['%BB']="_";
        $letras['%BC']="1";
        $letras['%BD']="1";
        $letras['%BE']="1";
        $letras['%BF']="_";
        $letras['%C0']="A";
        $letras['%C1']="a";
        $letras['%C2']="A";
        $letras['%C3']="A";
        $letras['%C4']="A";
        $letras['%C5']="A";
        $letras['%C6']="A";
        $letras['%C7']="C";
        $letras['%C8']="E";
        $letras['%C9']="E";
        $letras['%CA']="E";
        $letras['%CB']="E";
        $letras['%CC']="I";
        $letras['%CD']="I";
        $letras['%CE']="I";
        $letras['%CF']="I";
        $letras['%D0']="D";
        $letras['%D1']="N";
        $letras['%D2']="O";
        $letras['%D3']="O";
        $letras['%D4']="O";
        $letras['%D5']="O";
        $letras['%D6']="O";
        $letras['%D7']="x";
        $letras['%D8']="O";
        $letras['%D9']="U";
        $letras['%DA']="U";
        $letras['%DB']="U";
        $letras['%DC']="U";
        $letras['%DD']="y";
        $letras['%DE']="b";
        $letras['%DF']="s";
        $letras['%E0']="a";
        $letras['%E1']="a";
        $letras['%E2']="a";
        $letras['%E3']="a";
        $letras['%E4']="a";
        $letras['%E5']="a";
        $letras['%E6']="a";
        $letras['%E7']="c";
        $letras['%E8']="e";
        $letras['%E9']="e";
        $letras['%EA']="e";
        $letras['%EB']="e";
        $letras['%EC']="i";
        $letras['%ED']="i";
        $letras['%EE']="i";
        $letras['%EF']="i";
        $letras['%F0']="d";
        $letras['%F1']="n";
        $letras['%F2']="o";
        $letras['%F3']="o";
        $letras['%F4']="o";
        $letras['%F5']="o";
        $letras['%F6']="o";
        $letras['%F7']="_";
        $letras['%F8']="o";
        $letras['%F9']="u";
        $letras['%FA']="u";
        $letras['%FB']="u";
        $letras['%FC']="u";
        $letras['%FD']="y";
        $letras['%FE']="b";
        $letras['%FF']="y";
      
      return strtr( urlencode($s),$letras);
}

/**
 * Unaccent a string 
 *
 * @author http://www.evaisse.net/2008/php-translit-remove-accent-unaccent-21001
 * @param $str input string
 * @param $utf8 if null, function will detect input string encoding
 * @return string input string without accent
 */
/**
 * removeAccents()
 * 
 * @param mixed $str
 * @param bool $utf8
 * @return
 */
function removeAccents($str, $utf8 = true) {
    $str = (string) $str;
    if (is_null($utf8)) {
        if (!function_exists('mb_detect_encoding')) {
            $utf8 = (strtolower(mb_detect_encoding($str)) == 'utf-8');
        } else {
            $length = strlen($str);
            $utf8 = true;
            
            for ($i = 0; $i < $length; $i++) {
                $c = ord($str[$i]);
                
                if ($c < 0x80) $n = 0; // 0bbbbbbb
                elseif (($c & 0xE0) == 0xC0) $n = 1; // 110bbbbb
                elseif (($c & 0xF0) == 0xE0) $n = 2; // 1110bbbb
                elseif (($c & 0xF8) == 0xF0) $n = 3; // 11110bbb
                elseif (($c & 0xFC) == 0xF8) $n = 4; // 111110bb
                elseif (($c & 0xFE) == 0xFC) $n = 5; // 1111110b
                else return false; // Does not match any model
                
                for ($j = 0; $j < $n; $j++) { // n bytes matching 10bbbbbb follow ?
                    if ((++$i == $length) || ((ord($str[$i]) & 0xC0) != 0x80)) {
                        $utf8 = false;
                        break;
                    }
                }
            }
        }
    }
    
    if (!$utf8) {
        $str = utf8_encode($str);
    }
    
    $transliteration = array(
        'Ĳ' => 'I', 'Ö' => 'O', 'Œ' => 'O', 'Ü' => 'U', 'ä' => 'a', 'æ' => 'a',
        'ĳ' => 'i', 'ö' => 'o', 'œ' => 'o', 'ü' => 'u', 'ß' => 's', 'ſ' => 's',
        'À' => 'A', 'Á' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'A', 'Å' => 'A',
        'Æ' => 'A', 'Ā' => 'A', 'Ą' => 'A', 'Ă' => 'A', 'Ç' => 'C', 'Ć' => 'C',
        'Č' => 'C', 'Ĉ' => 'C', 'Ċ' => 'C', 'Ď' => 'D', 'Đ' => 'D', 'È' => 'E',
        'É' => 'E', 'Ê' => 'E', 'Ë' => 'E', 'Ē' => 'E', 'Ę' => 'E', 'Ě' => 'E',
        'Ĕ' => 'E', 'Ė' => 'E', 'Ĝ' => 'G', 'Ğ' => 'G', 'Ġ' => 'G', 'Ģ' => 'G',
        'Ĥ' => 'H', 'Ħ' => 'H', 'Ì' => 'I', 'Í' => 'I', 'Î' => 'I', 'Ï' => 'I',
        'Ī' => 'I', 'Ĩ' => 'I', 'Ĭ' => 'I', 'Į' => 'I', 'İ' => 'I', 'Ĵ' => 'J',
        'Ķ' => 'K', 'Ľ' => 'K', 'Ĺ' => 'K', 'Ļ' => 'K', 'Ŀ' => 'K', 'Ł' => 'L',
        'Ñ' => 'N', 'Ń' => 'N', 'Ň' => 'N', 'Ņ' => 'N', 'Ŋ' => 'N', 'Ò' => 'O',
        'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ø' => 'O', 'Ō' => 'O', 'Ő' => 'O',
        'Ŏ' => 'O', 'Ŕ' => 'R', 'Ř' => 'R', 'Ŗ' => 'R', 'Ś' => 'S', 'Ş' => 'S',
        'Ŝ' => 'S', 'Ș' => 'S', 'Š' => 'S', 'Ť' => 'T', 'Ţ' => 'T', 'Ŧ' => 'T',
        'Ț' => 'T', 'Ù' => 'U', 'Ú' => 'U', 'Û' => 'U', 'Ū' => 'U', 'Ů' => 'U',
        'Ű' => 'U', 'Ŭ' => 'U', 'Ũ' => 'U', 'Ų' => 'U', 'Ŵ' => 'W', 'Ŷ' => 'Y',
        'Ÿ' => 'Y', 'Ý' => 'Y', 'Ź' => 'Z', 'Ż' => 'Z', 'Ž' => 'Z', 'à' => 'a',
        'á' => 'a', 'â' => 'a', 'ã' => 'a', 'ā' => 'a', 'ą' => 'a', 'ă' => 'a',
        'å' => 'a', 'ç' => 'c', 'ć' => 'c', 'č' => 'c', 'ĉ' => 'c', 'ċ' => 'c',
        'ď' => 'd', 'đ' => 'd', 'è' => 'e', 'é' => 'e', 'ê' => 'e', 'ë' => 'e',
        'ē' => 'e', 'ę' => 'e', 'ě' => 'e', 'ĕ' => 'e', 'ė' => 'e', 'ƒ' => 'f',
        'ĝ' => 'g', 'ğ' => 'g', 'ġ' => 'g', 'ģ' => 'g', 'ĥ' => 'h', 'ħ' => 'h',
        'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i', 'ī' => 'i', 'ĩ' => 'i',
        'ĭ' => 'i', 'į' => 'i', 'ı' => 'i', 'ĵ' => 'j', 'ķ' => 'k', 'ĸ' => 'k',
        'ł' => 'l', 'ľ' => 'l', 'ĺ' => 'l', 'ļ' => 'l', 'ŀ' => 'l', 'ñ' => 'n',
        'ń' => 'n', 'ň' => 'n', 'ņ' => 'n', 'ŉ' => 'n', 'ŋ' => 'n', 'ò' => 'o',
        'ó' => 'o', 'ô' => 'o', 'õ' => 'o', 'ø' => 'o', 'ō' => 'o', 'ő' => 'o',
        'ŏ' => 'o', 'ŕ' => 'r', 'ř' => 'r', 'ŗ' => 'r', 'ś' => 's', 'š' => 's',
        'ť' => 't', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ū' => 'u', 'ů' => 'u',
        'ű' => 'u', 'ŭ' => 'u', 'ũ' => 'u', 'ų' => 'u', 'ŵ' => 'w', 'ÿ' => 'y',
        'ý' => 'y', 'ŷ' => 'y', 'ż' => 'z', 'ź' => 'z', 'ž' => 'z', 'Α' => 'A',
        'Ά' => 'A', 'Ἀ' => 'A', 'Ἁ' => 'A', 'Ἂ' => 'A', 'Ἃ' => 'A', 'Ἄ' => 'A',
        'Ἅ' => 'A', 'Ἆ' => 'A', 'Ἇ' => 'A', 'ᾈ' => 'A', 'ᾉ' => 'A', 'ᾊ' => 'A',
        'ᾋ' => 'A', 'ᾌ' => 'A', 'ᾍ' => 'A', 'ᾎ' => 'A', 'ᾏ' => 'A', 'Ᾰ' => 'A',
        'Ᾱ' => 'A', 'Ὰ' => 'A', 'ᾼ' => 'A', 'Β' => 'B', 'Γ' => 'G', 'Δ' => 'D',
        'Ε' => 'E', 'Έ' => 'E', 'Ἐ' => 'E', 'Ἑ' => 'E', 'Ἒ' => 'E', 'Ἓ' => 'E',
        'Ἔ' => 'E', 'Ἕ' => 'E', 'Ὲ' => 'E', 'Ζ' => 'Z', 'Η' => 'I', 'Ή' => 'I',
        'Ἠ' => 'I', 'Ἡ' => 'I', 'Ἢ' => 'I', 'Ἣ' => 'I', 'Ἤ' => 'I', 'Ἥ' => 'I',
        'Ἦ' => 'I', 'Ἧ' => 'I', 'ᾘ' => 'I', 'ᾙ' => 'I', 'ᾚ' => 'I', 'ᾛ' => 'I',
        'ᾜ' => 'I', 'ᾝ' => 'I', 'ᾞ' => 'I', 'ᾟ' => 'I', 'Ὴ' => 'I', 'ῌ' => 'I',
        'Θ' => 'T', 'Ι' => 'I', 'Ί' => 'I', 'Ϊ' => 'I', 'Ἰ' => 'I', 'Ἱ' => 'I',
        'Ἲ' => 'I', 'Ἳ' => 'I', 'Ἴ' => 'I', 'Ἵ' => 'I', 'Ἶ' => 'I', 'Ἷ' => 'I',
        'Ῐ' => 'I', 'Ῑ' => 'I', 'Ὶ' => 'I', 'Κ' => 'K', 'Λ' => 'L', 'Μ' => 'M',
        'Ν' => 'N', 'Ξ' => 'K', 'Ο' => 'O', 'Ό' => 'O', 'Ὀ' => 'O', 'Ὁ' => 'O',
        'Ὂ' => 'O', 'Ὃ' => 'O', 'Ὄ' => 'O', 'Ὅ' => 'O', 'Ὸ' => 'O', 'Π' => 'P',
        'Ρ' => 'R', 'Ῥ' => 'R', 'Σ' => 'S', 'Τ' => 'T', 'Υ' => 'Y', 'Ύ' => 'Y',
        'Ϋ' => 'Y', 'Ὑ' => 'Y', 'Ὓ' => 'Y', 'Ὕ' => 'Y', 'Ὗ' => 'Y', 'Ῠ' => 'Y',
        'Ῡ' => 'Y', 'Ὺ' => 'Y', 'Φ' => 'F', 'Χ' => 'X', 'Ψ' => 'P', 'Ω' => 'O',
        'Ώ' => 'O', 'Ὠ' => 'O', 'Ὡ' => 'O', 'Ὢ' => 'O', 'Ὣ' => 'O', 'Ὤ' => 'O',
        'Ὥ' => 'O', 'Ὦ' => 'O', 'Ὧ' => 'O', 'ᾨ' => 'O', 'ᾩ' => 'O', 'ᾪ' => 'O',
        'ᾫ' => 'O', 'ᾬ' => 'O', 'ᾭ' => 'O', 'ᾮ' => 'O', 'ᾯ' => 'O', 'Ὼ' => 'O',
        'ῼ' => 'O', 'α' => 'a', 'ά' => 'a', 'ἀ' => 'a', 'ἁ' => 'a', 'ἂ' => 'a',
        'ἃ' => 'a', 'ἄ' => 'a', 'ἅ' => 'a', 'ἆ' => 'a', 'ἇ' => 'a', 'ᾀ' => 'a',
        'ᾁ' => 'a', 'ᾂ' => 'a', 'ᾃ' => 'a', 'ᾄ' => 'a', 'ᾅ' => 'a', 'ᾆ' => 'a',
        'ᾇ' => 'a', 'ὰ' => 'a', 'ᾰ' => 'a', 'ᾱ' => 'a', 'ᾲ' => 'a', 'ᾳ' => 'a',
        'ᾴ' => 'a', 'ᾶ' => 'a', 'ᾷ' => 'a', 'β' => 'b', 'γ' => 'g', 'δ' => 'd',
        'ε' => 'e', 'έ' => 'e', 'ἐ' => 'e', 'ἑ' => 'e', 'ἒ' => 'e', 'ἓ' => 'e',
        'ἔ' => 'e', 'ἕ' => 'e', 'ὲ' => 'e', 'ζ' => 'z', 'η' => 'i', 'ή' => 'i',
        'ἠ' => 'i', 'ἡ' => 'i', 'ἢ' => 'i', 'ἣ' => 'i', 'ἤ' => 'i', 'ἥ' => 'i',
        'ἦ' => 'i', 'ἧ' => 'i', 'ᾐ' => 'i', 'ᾑ' => 'i', 'ᾒ' => 'i', 'ᾓ' => 'i',
        'ᾔ' => 'i', 'ᾕ' => 'i', 'ᾖ' => 'i', 'ᾗ' => 'i', 'ὴ' => 'i', 'ῂ' => 'i',
        'ῃ' => 'i', 'ῄ' => 'i', 'ῆ' => 'i', 'ῇ' => 'i', 'θ' => 't', 'ι' => 'i',
        'ί' => 'i', 'ϊ' => 'i', 'ΐ' => 'i', 'ἰ' => 'i', 'ἱ' => 'i', 'ἲ' => 'i',
        'ἳ' => 'i', 'ἴ' => 'i', 'ἵ' => 'i', 'ἶ' => 'i', 'ἷ' => 'i', 'ὶ' => 'i',
        'ῐ' => 'i', 'ῑ' => 'i', 'ῒ' => 'i', 'ῖ' => 'i', 'ῗ' => 'i', 'κ' => 'k',
        'λ' => 'l', 'μ' => 'm', 'ν' => 'n', 'ξ' => 'k', 'ο' => 'o', 'ό' => 'o',
        'ὀ' => 'o', 'ὁ' => 'o', 'ὂ' => 'o', 'ὃ' => 'o', 'ὄ' => 'o', 'ὅ' => 'o',
        'ὸ' => 'o', 'π' => 'p', 'ρ' => 'r', 'ῤ' => 'r', 'ῥ' => 'r', 'σ' => 's',
        'ς' => 's', 'τ' => 't', 'υ' => 'y', 'ύ' => 'y', 'ϋ' => 'y', 'ΰ' => 'y',
        'ὐ' => 'y', 'ὑ' => 'y', 'ὒ' => 'y', 'ὓ' => 'y', 'ὔ' => 'y', 'ὕ' => 'y',
        'ὖ' => 'y', 'ὗ' => 'y', 'ὺ' => 'y', 'ῠ' => 'y', 'ῡ' => 'y', 'ῢ' => 'y',
        'ῦ' => 'y', 'ῧ' => 'y', 'φ' => 'f', 'χ' => 'x', 'ψ' => 'p', 'ω' => 'o',
        'ώ' => 'o', 'ὠ' => 'o', 'ὡ' => 'o', 'ὢ' => 'o', 'ὣ' => 'o', 'ὤ' => 'o',
        'ὥ' => 'o', 'ὦ' => 'o', 'ὧ' => 'o', 'ᾠ' => 'o', 'ᾡ' => 'o', 'ᾢ' => 'o',
        'ᾣ' => 'o', 'ᾤ' => 'o', 'ᾥ' => 'o', 'ᾦ' => 'o', 'ᾧ' => 'o', 'ὼ' => 'o',
        'ῲ' => 'o', 'ῳ' => 'o', 'ῴ' => 'o', 'ῶ' => 'o', 'ῷ' => 'o', 'А' => 'A',
        'Б' => 'B', 'В' => 'V', 'Г' => 'G', 'Д' => 'D', 'Е' => 'E', 'Ё' => 'E',
        'Ж' => 'Z', 'З' => 'Z', 'И' => 'I', 'Й' => 'I', 'К' => 'K', 'Л' => 'L',
        'М' => 'M', 'Н' => 'N', 'О' => 'O', 'П' => 'P', 'Р' => 'R', 'С' => 'S',
        'Т' => 'T', 'У' => 'U', 'Ф' => 'F', 'Х' => 'K', 'Ц' => 'T', 'Ч' => 'C',
        'Ш' => 'S', 'Щ' => 'S', 'Ы' => 'Y', 'Э' => 'E', 'Ю' => 'Y', 'Я' => 'Y',
        'а' => 'A', 'б' => 'B', 'в' => 'V', 'г' => 'G', 'д' => 'D', 'е' => 'E',
        'ё' => 'E', 'ж' => 'Z', 'з' => 'Z', 'и' => 'I', 'й' => 'I', 'к' => 'K',
        'л' => 'L', 'м' => 'M', 'н' => 'N', 'о' => 'O', 'п' => 'P', 'р' => 'R',
        'с' => 'S', 'т' => 'T', 'у' => 'U', 'ф' => 'F', 'х' => 'K', 'ц' => 'T',
        'ч' => 'C', 'ш' => 'S', 'щ' => 'S', 'ы' => 'Y', 'э' => 'E', 'ю' => 'Y',
        'я' => 'Y', 'ð' => 'd', 'Ð' => 'D', 'þ' => 't', 'Þ' => 'T', 'ა' => 'a',
        'ბ' => 'b', 'გ' => 'g', 'დ' => 'd', 'ე' => 'e', 'ვ' => 'v', 'ზ' => 'z',
        'თ' => 't', 'ი' => 'i', 'კ' => 'k', 'ლ' => 'l', 'მ' => 'm', 'ნ' => 'n',
        'ო' => 'o', 'პ' => 'p', 'ჟ' => 'z', 'რ' => 'r', 'ს' => 's', 'ტ' => 't',
        'უ' => 'u', 'ფ' => 'p', 'ქ' => 'k', 'ღ' => 'g', 'ყ' => 'q', 'შ' => 's',
        'ჩ' => 'c', 'ც' => 't', 'ძ' => 'd', 'წ' => 't', 'ჭ' => 'c', 'ხ' => 'k',
        'ჯ' => 'j', 'ჰ' => 'h',
    );
    
    return str_replace(array_keys($transliteration), array_values($transliteration), $str);
}

/**
 * filename_safe()
 * 
 * @param mixed $fileName
 * @return
 */
function filename_safe($fileName) {
    if(substr($fileName,0,1)=='.')
        $fileName='_'.substr($fileName,1);
    return str_replace(array(' ','(',')','-','*','?','!'),'_',removeAccents($fileName));
}
/**
 * filename_extension()
 * 
 * @param mixed $fileName
 * @return
 */
function filename_extension($fileName) {
    $pos=strrchr($fileName,'.');
    if($pos===FALSE || $pos==$fileName)
        return '';
    return substr($pos,1);
}
/**
 * filename_extension_icon()
 * 
 * @param mixed $fileName
 * @return
 */
function filename_extension_icon($fileName) {
global $gIApath;
    return  "$gIApath[WebPath]img/ext/". strtolower( filename_extension($fileName) ).".gif";
}

/**
 * error_last()
 * 
 * @return
 */
function error_last() {
    if ( !function_exists('error_get_last'))
        return '';
    $tmp=error_get_last();
    if($tmp)
        return "Error: $tmp[message] at $tmp[file] line $tmp[line]";
    else
        return '';
}
/**
 * debug_trace()
 * 
 * @param string $start
 * @param string $sep
 * @param string $end
 * @return
 */
function debug_trace($start='<ol>',$sep='<li>',$end='</ol>') {
    if ( !function_exists('debug_backtrace'))
        return '';
    $tmp=  debug_backtrace();
    $ret=$start;
    if($tmp) foreach($tmp as $d)
        if($d['function']!='debug_trace')
            $ret.="$sep$d[function] ($d[line])";
    return $ret.$end;
}

/// ia_case specific
    global $gAppRelate;
    /**
     * gAppRelate_set()
     * 
     * @return
     */
    function gAppRelate_set() {
    global $gAppRelate;
        if( !isset($gAppRelate) || empty($gAppRelate) )
            $gAppRelate=new appRelate();
    }
    /**
     * vale_where()
     * 
     * @return
     */
    function vale_where() {
        
    }
    
    /**
     * form_doublepsot_is()
     * 
     * @return
     */
    function form_doublepsot_is() {
        $timecode=param('iatimecode');      
        if($timecode=='')
            return false;
        return ia_singleread("SELECT ya FROM iacase_doublesumbit WHERE timecode=".strit($timecode)." LIMIT 1")==1;
    }

    /**
     * form_doublepsot_set()
     * 
     * @return
     */
    function form_doublepsot_set() {
        $timecode=param('iatimecode');
        if($timecode=='')
            return;
        ia_query("UPDATE iacase_doublesumbit SET ya=1 WHERE timecode=".strit($timecode)." LIMIT 1");
    }
    /**
     * array_key_set()
     * 
     * @param mixed $atribute
     * @param mixed $value
     * @param mixed $arr
     * @param bool $append
     * @param string $separator
     * @return
     */
    function array_key_set($atribute,$value,&$arr,$append=false,$separator=' ') {
            if(!$append || !array_key_exists($atribute,$arr) )
                $arr[$atribute]=$value;
            else
                $arr[$atribute].=$separator.value;
    }
    
    /**
     * array_key_existsArr()
     * 
     * @param mixed $keys
     * @param mixed $arr
     * @param bool $primerCall
     * @return
     */
    function array_key_existsArr($keys,$arr,$primerCall=true) {
        if(!is_array($arr))
            if($primerCall)
                echo "<li>array_key_existsArr arr not array</li>";
            else
                return false;
        if(!is_array($keys))
            return array_key_exists($keys,$arr);
        $key=array_shift($keys);
        if($key===NULL)
            return true;
        if(!array_key_exists($key,$arr))
            return false;
        if(empty($keys))
            return true;            
        return array_key_existsArr($keys,$arr[$key],false);
    }
    
    /**
     * array_key_existsN()
     * 
     * @return
     */
    function array_key_existsN() {
        $find=func_get_args();
        $len=sizeof($find);
//echo "<li>len=$len";        
        if($len<=1)
            return "kaput";
        $arr=array_pop($find);
//        echo "<li>keys=".print_r($find,true)." arr=".print_r($arr,true)."</li>";
        return array_key_existsArr($find,$arr); 
    }
    
    /**
     * date_limit()
     * 
     * @param mixed $lim
     * @param mixed $base_date
     * @param bool $incluye_dom
     * @param bool $incluye_sab
     * @param bool $forzaInicioAno
     * @return
     */
    function date_limit($lim,$base_date=null,$incluye_dom=true,$incluye_sab=true,$forzaInicioAno=false) {
        if(empty($lim))
            return '';
        if( preg_match('/^[0-9]{4}\-(0[1-9]|1[0-2])\-(0[1-9]|[1-2][0-9]|3[0-1])$/', $lim)  )
            return $lim;        
        $c1=substr($lim,0,1);
        if( is_numeric($c1) )
            return "$lim-01-01";    
        // si es mysqldate regresalra
        
        if(empty($base_date))
           $base_date=Date('Y-m-d');  
         $base_year=substr($base_date,0,4);  


        $anos=$meses=$semanas=$dias=0;
        $tmp=explode(' ',$lim);
        if($tmp) foreach($tmp as $d) {
            $d=trim($d);
            if(strpos($d,'y')!==FALSE) 
                $anos+=str_ireplace('y','',$d);
            elseif(strpos($d,'m')!==FALSE) 
                $meses+=str_ireplace('m','',$d);            
            elseif(strpos($d,'w')!==FALSE) 
                $semanas+=str_ireplace('w','',$d);    
            elseif(strpos($d,'d')!==FALSE) 
                $dias+=str_ireplace('d','',$d);
            else
                $dias+=$d;                   
        }    
        if(!is_numeric($anos))
            $anos=0;
        if(!is_numeric($meses))
            $meses=0;
        if(!is_numeric($semanas))
            $semanas=0;
        if(!is_numeric($dias))
            $diasem=0;
                                         
        $fecha=mktime(0,0,0,Date('n')+$meses,Date('j')+$dias+$semanas*7,$base_year+$anos);
        
        $incluye_dom=$incluye_sab=true;
        if(!$incluye_dom || !$incluye_sab) {
            $hoy=mktime(0,0,0,Date('n'),Date('j'),Date('Y'));
            if($hoy>$fecha)
                $days = round( ($fecha - $hoy) / 86400 ) + 1;
            else
                $days = round( ($hoy - $fecha) / 86400 ) + 1;
            $finsemana= (!$incluye_dom && !$incluye_sab) ? 2 : 1;
            $mas = floor($days / 7)*$finsemana;
            //if($days>=7)
            //    $mas += fmod($days, 7)*$finsemana;
            $diasem = date("w", $fecha);        
            if($diasem==6 && !$incluye_sab)
                $mas++;
            if($diasem==6 && !$incluye_dom)
                $mas++;
            if($diasem==0 && !$incluye_dom)
                $mas++;                 
            $diasem = date("w", $hoy);
            if($diasem==6 && !$incluye_sab)
                $mas++;
            if($diasem==6 && !$incluye_dom)
                $mas++;
            if($diasem==0 && !$incluye_dom)
                $mas++;  ;          
            $fecha=mktime(0,0,0,Date('n')+$meses,Date('j')+$dias+$semanas*7+$mas,$base_year+$anos);  
        }
              
        if($forzaInicioAno)
            return Date('Y-01-01',$fecha);
        return Date('Y-m-d',$fecha);
    }    

    /**
     * to_plural()
     * 
     * @param mixed $word
     * @param bool $esMasculino
     * @return
     */
    function to_plural($word,$esMasculino=true) {
        $w=substr($word,-1);
        if(    strcasecmp('a',$w)==0 || strcasecmp('e',$w)==0  || strcasecmp('i',$w)==0  || strcasecmp('o',$w)==0  || strcasecmp('u',$w)==0  
            || strcasecmp('á',$w)==0 || strcasecmp('é',$w)==0  || strcasecmp('í',$w)==0  || strcasecmp('ó',$w)==0  || strcasecmp('Ú',$w)==0 
            || strcasecmp('y',$w)==0 || strcasecmp('w',$w)==0 )
            return $word.'s';
        if(strcasecmp('z',$w)==0)
            return substr($word,0,-1).'ces';
        $w2=substr($word,-2,1);
        if(strcasecmp('s',$w)==0 && ( strcasecmp('e',$w2)==0 || strcasecmp('u',$w2) ))
            return $word;
        if($esMasculino)
            return $word.'es';
        else
            return $word.'as';
    }
        
	/**
	 * to_label()
	 * 
	 * @param mixed $fieldName
	 * @param bool $capWords
	 * @param bool $htmlentities
	 * @return
	 */
	function to_label( $fieldName,$capWords=true,$htmlentities=false ) {
        $ret=preg_replace(
            array('/\baccion\b/i','/\baleman\b/i','/\balmacen\b/i','/\bano\b/i','/\banos\b/i','/\barea\b/i','/\bareas\b/i','/\barticulo\b/i','/\barticulos\b/i'
                    ,'/\bbitacora\b/i','/\bbitacoras\b/i'
                    ,'/\bcalculo\b/i','/\bcaracter\b/i','/\bcatalogo\b/i','/\bcatalogos\b/i','/\bcomentario\b/i','/\bcompania\b/i','/\bcompanias\b/i','/\bcp\b/i'
                    ,'/\bdepostio\b/i','/\bdepostios\b/i','/\bdia\b/i','/\bdias\b/i','/\bdigito\b/i','/\bdigitos\b/i','/\bdolar\b/i','/\bdolares\b/i'
                    ,'/\beconomia\b/i','/\belectronica\b/i','/\belectronico\b/i','/\belectronicos\b/i','/\bespanol\b/i'
                    ,'/\binteres\b/i','/\bimagenes\b/i','/\bindice\b/i','/\bindices\b/i','/\bingles\b/i'
                    ,'/\bfabrica\b/i','/\bfrances\b/i','/\bfotografica\b/i'
                    ,'/\bgrafica\b/i'
                    ,'/\bhuesped\b/i'
                    ,'/\bmaquina\b/i','/\bmaquinas\b/i','/\bmaximo\b/i','/\bmaximos\b/i','/\bmecancia\b/i','/\bmedico\b/i','/\bmexico\b/i','/\bmiercoles\b/i','/\bminimo\b/i','/\bminimos\b/i','/\bmusica\b/i'
                    ,'/\bnumero\b/i','/\bnumeros\b/i'
                    ,'/\bpagina\b/i','/\bpaginas\b/i','/\bpais\b/i','/\bpaises\b/i','/\bparticula\b/i','/\bpelicula\b/i','/\bpie\b/i','/\bpolitica\b/i','/\bportuges\b/i','/\bpublico\b/i'
                    ,'/\brazon\b/i','/\bresumen\b/i'
                    ,'/\bsabado\b/i'
                    ,'/\btecnica\b/i','/\btelefono\b/i','/\btelefono\b/i','/\btio\b/i','/\btitulo\b/i','/\btitulos\b/i','/\btunel\b/i'
                    ,'/\bunica\b/i','/\bunico\b/i','/\bultimo\b/i','/\bultimos\b/i','/\bultima\b/i','/\bultimas\b/i'
                    ,'/\busuario\b/i'
                    ,'/ion\b/i','/ia\b/i','/ie\b/i'
                   )
            ,array('acción','alemán','almacén','año','años','área','áreas','artículo','artículos'
                ,'bitácora','bitácoras'
                ,'cálculo','caractér','catálogo','catálogos','comentario','compañía','compañias','C.P.'
                ,'depósito','depósitos','día','días','dígito','dígitos','dólar','dólares'
                ,'economía','electrónica','electrónico','electrónicos','español'
                ,'interés','imágenes','índice','índices','inglés'                
                ,'fábrica','fránces','fotográfica'
                ,'gráfica'
                ,'huésped'
                ,'máquina','máquinas','máximo','máximos','mecánica','médico','México','miércoles','mínimo','mínimos','música'
                ,'número','números'
               ,'página','páginas','país','paises','partícula','película','pié','política','portugués','público'
               ,'razon','resúmen'
               ,'sábado'
               ,'tecnica','teléfono','teléfonos','tio','título','títulos','túnel'
               ,'Única','Único','Último','Últimos','Última','Últimas'
               ,'usuario'
               ,'ión','ía','ie'
            )
            ,preg_replace(
                array('/^idioma_/','/^kv_/','/^iac_/','/_id$/','/_/')
                ,array('','','','',' ')
                ,$fieldName
            )
        );
        if($ret=='usuarió')
            $ret='usuario';
        if($ret=='comentarió')
            $ret='comentario'; 
        if($ret=='rfc' || $ret=='curp' || $ret=='imss' || $ret=='cp')
            return strtoupper($ret);           
        if($capWords)
            $ret=ucwords($ret);
        if($htmlentities)
            return ia_htmlentities( str_replace( array(' De ',' A ',' Del ',' Al ',' El ',' La ',' Las ',' Los '), array(' de ',' a ',' del ', ' al ', ' el ',' la ',' las ',' los '),$ret ) );
        else
            return str_replace( array(' De ',' A ',' Del ',' Al ',' El ',' La ',' Las ',' Los '), array(' de ',' a ',' del ', ' al ', ' el ',' la ',' las ',' los '),$ret );
}

/**
 * comb()
 * genera todas las combinaciones de los elementos del array
 * nota ya no se usa pues no soporta una tabla tan grande el eviews
 * @param array $a
 * @return
 */
function comb($a) {
    $len  = count($a);
    $list = array();
    $k=1;
    $iLim=pow(2,$len);
    for($i = 1; $i < $iLim; $i++) {       
        $c = '';
        for($j = 0; $j < $len; $j++) {
            //if($i & (1 << $j))
            if($i & pow(2,$j)) 
                $c .= $a[$j];
        }
        $list[] = $c;
    }
    return $list;
}
?>