<?php
/**
 * ia_util.php
 * Utilerias
 * @version 2.1.2012.09.23
 * @package utilerias
 * pre-requisites: include config.php para array $gIAsql y $gIaTimeStart value,
 *
 */


// ////////////////////// SQL  //////////////////////
    if(!array_key_exists('set_autocommit',$gIAsql)) $gIAsql['set_autocommit']=null;
    if(!array_key_exists('pconnect',$gIAsql)) $gIAsql['pconnect']=false;
    if(!array_key_exists('trace',$gIAsql)) $gIAsql['trace']=false;
    if(!array_key_exists('sql_trace',$gIAsql)) $gIAsql['sql_trace']=array();
    if(!array_key_exists('link',$gIAsql)) $gIAsql['link']=null;
    if(!array_key_exists('err',$gIAsql)) $gIAsql['err']='';
    $gIAsql['affected_rows']=$gIAsql['begins']=$gIAsql['selected_rows']=0;

// ia_update y ia_insert en modo $inteligent_quotes=true no quotea lo siguiente: FALTA ia_seq y functions
$gIAsql['dont_quote']=array('NULL','CURDATE()','CURRENT_DATE()','CURRENT_DATE','CURRENT_DATETIME','CURRENT_TIME()','CURRENT_TIME','CURTIME()'
    ,'CURRENT_TIMESTAMP()','CURRENT_TIMESTAMP','NOW()','LOCALTIMESTAMP','LOCALTIMESTAMP()','SYSDATE()','UNIX_TIMESTAMP()'
    ,'UTC_DATE()','UTC_TIME()','UTC_TIMESTAMP()');

include_once(__DIR__.'/sqlConverter.php');
/**
 * ia_sqlErrors()
 *
 * @return html <ul> con los errores
 */
function ia_sqlErrors() {
global $gIAsql;
    return $gIAsql['err']=='' ? '' : "<ul>$gIAsql[err]</ul>";
}

/**
 * ia_update()
 * regresa un update $table set $key='$values[$key]',... WHERE  $pkey='$primaryKey[$pkey]' AND
 * @param string $table nombre de la tabla
 * @param array $values 'campo'=>value, rutina protege apostrofes
 * @param mixed $where  en array hace 'campo'=value  con AND, en string lo pone
 * @param string $after_clause despues del where.
 * @param string $before_clause entre update y table.
 * @param boolean $inteligent_quotes en true no quotea lo que este en $gIAsql['dont_quote']
 * @param boolean $dontQuote en true no pone quotes alrededor de los valores, default false no pone quotes
 * @return
 */
function ia_update($table,$values=array(),$where=array(),$excludeQuote=array(),$after_clause='',$before_clause='',$inteligent_quotes=true,$dontQuote=false) {
global $gIAsql;
    $upd='';
    foreach($values as $fieldName=>$v) {
        if( is_null($v) )
            $upd.=",$fieldName=NULL";
        elseif( $dontQuote || ($inteligent_quotes && in_array(strtoupper(trim($v)),$gIAsql['dont_quote'])) || in_array($fieldName,$excludeQuote) || ia_dontQuote($v) )
            $upd.=",$fieldName=$v";
        else
            $upd.=",$fieldName=".strit($v);
    }
    if(is_array($where)) {
        $w='';
        foreach($where as $fieldName=>$v)
            if( is_null($v) )
                $w.=" AND $fieldName IS NULL";
            elseif( $dontQuote || ($inteligent_quotes && in_array(strtoupper(trim($v)),$gIAsql['dont_quote'])) )
                $w.=" AND $fieldName=$v";
            else
                $w.=" AND $fieldName=".strit($v);
        $w=substr($w,5);
    } else
        $w=$where;
    return "UPDATE $before_clause $table SET ".substr($upd,1)." WHERE $w ".$after_clause;
}
function ia_dontQuote($v) {
    //$v = trim($v);
    $paren = strpos($v,'(');

    if($paren === FALSE)
        return false;
    $close = strpos($v,')',$paren);

    if($close === FALSE  || $close < $paren)
        return false;
    $blank = strpos($v,' ');
    if($blank === FALSE || $paren < $blank && substr($v,-1==')') && substr_count ($v,'(') == substr_count ($v,')')  ) {
        $functions = array('DATE_ADD(','DATE_SUB(');
        foreach($functions as $f)
            if(stripos($v,$f) === 0)
                return true;
    }
    return false;
}

/**
 * ia_insert()
 * regresa un insert $before_clause into $table($keys) values($vals) $after_clause;
 * @param string $table nombre de la tabla
 * @param array $values 'campo'=>value
 * @param boolean $autoOnUpdate en true hace ON DUPLICATE UPDATE de no venir en after_clause
 * @param string $after_clause poner despues de values: on duplicate key...
 * @param string $before_clause entre insert y (campos)
 * @param boolean $inteligent_quotes en true no quotea lo que este en $gIAsql['dont_quote']
 * @param boolean $dontQuote en true no pone quotes alrededor de los valores, default false no pone quotes
 * @return
 */
function ia_insert($table,$values=array(),$excludeQuote=array(),$after_clause='',$autoOnUpdate=false,$before_clause='',$inteligent_quotes=true,$dontQuote=false) {
global $gIAsql;
    $ins='';
    $val='';
    $upd='';

    foreach($values as $fieldName=>$v) {
        $ins.=",$fieldName";
        if( is_null($v) )
            $val.=",NULL";
        elseif(is_array($v)) {
            $val.=','.strit( implode(',',$v));
        } elseif( $dontQuote || ($inteligent_quotes && in_array(strtoupper(trim($v)),$gIAsql['dont_quote'])) || in_array($fieldName,$excludeQuote) || ia_dontQuote($v) )
            $val.=",$v";
        else
            $val.=','.strit($v);
        $upd.=",$fieldName=VALUES($fieldName)";
    }
    if($autoOnUpdate)
        $after_clause="ON DUPLICATE KEY UPDATE ".substr($upd,1);
    return "INSERT $before_clause INTO $table(".substr($ins,1).") VALUES(".substr($val,1).") $after_clause";
}

/**
 * ia_insert_update()
 *
 * @param mixed $table
 * @param mixed $arr
 * @param string $upd
 * @param bool $execute
 * @return
 */
function ia_insert_update($table,$arr,$execute=true) {
    $sql=ia_insert($table,$arr,array(),'',true);
    if($execute)
        return ia_query($sql);
    return $sql;
}


/**
 * ia_guid()
* returns universal uuid de mysql: sin - en base 36 (29 caracteres maximo) reversed para menos carga a indices.

* @param string $cmnt
* @return string uuid
 */
function ia_guid($cmnt='guid') {
    $a=explode('-',ia_singleread("SELECT SQL_NO_CACHE /* $cmnt */ UUID()",'',false,false));
    // aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee
    // set @x=uuid(); select @x, substr(@x,1,8), substr(@x,10,4), substr(@x,15,4),substr(@x,20,4), substr(@x,25)
    // select @x,   CONCAT( substr(@x,25),substr(@x,20,4),substr(@x,15,4),substr(@x,10,4),substr(@x,1,8) )
    // create function ia_uuid() READS SQL
    //return ia_singleread( "SELECT UNHEX( HEX('".$a[4].$a[3].$a[2].$a[1].$a[0]."') ) " );
    return $a[4].$a[3].$a[2].$a[1].$a[0];
   // return ia_singleread("SELECT CONCAT( CONV('$a[4]',16,36),CONV('$a[3]',16,36),CONV('$a[2]',16,36),CONV('$a[1]',16,36),CONV('$a[0]',16,36)  ) ");
}

///// <options> nuvas
    /**
     * ia_options_sql()
     * De uns select haceF
     * @param string $sql SELECT value,text,html_atribute,....
     * @param mixed $selected string selected value, array of selected values
     * @param mixed $extraOptions [value]=array(''=>value,''=>text,'html atribute'=>'',...) options no el sql result
     * @param string $optionTag html atributes a poner en todos los options
     * @return string <option ..>text</option>..
     */
    function ia_options_sql($sql,$selected='',$extraOptions=array(),$optionTag='') {
        return ia_options(ia_sqlArray($sql,null),$selected,$extraOption,$optionTag);
    }

    /**
     * ia_options()
     * De un array hace <option> para un <select>
     * @param array $arr [value]=array(''=>value,''=>text,'html atribute'=>'',...)
     * @param mixed $selected string selected value, array of selected values
     * @param array $extraOptions [value]=array(''=>value,''=>text,'html atribute'=>'',...) options no en array
     * @param string $optionTag html atributes a poner en todos los options
     * @return string <option ..>text</option>...
     */
    function ia_options($arr,$selected='',$extraOptions=array(),$optionTag='') {
        $getEs=true;
        $ret='';
        $isArraySelected=is_array($selected);
        if(!empty($extraOptions))
            $arr=array_merge($extraOptions,$arr);
        if($arr) foreach($arr as $k=>$v) {
            if($getEs) {
                $getEs=true;
                $es=ia_options_atributes($v);
                $doTag=sizeof($es)>2;
                $value=$es['value'];
                $text=$es['text'];
            }
            if($doTag) {
                $tag='';
                foreach($es as $tag=>$val) if($tag!='text')
                    $tag.=" $tag='".$v[$val]."'";
            } else {
                $tag=" value='".$v[$value]."'";
            }
            if($isArraySelected)
                $ret.="<option $tag ".(array_key_exists($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($v[$text])."</option>";
            else
                $ret.="<option $tag ".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($v[$text])."</option>";
        }
        return $ret;
    }

    /**
     * ia_options_sql_echo()
     * De uns select hace
     * @param string $sql SELECT value,text,html_atribute,....
     * @param mixed $selected string selected value, array of selected values
     * @param mixed $extraOptions [value]=array(''=>value,''=>text,'html atribute'=>'',...) options no el sql result
     * @param string $optionTag html atributes a poner en todos los options
     * @return string <option ..>text</option>..
     */
    function ia_options_sql_echo($sql,$selected='',$extraOptions=array(),$optionTag='') {
        return ia_options_echo(ia_sqlArray($sql,null),$selected,$extraOption,$optionTag);
    }

    /**
     * ia_options_echo()
     * De un array hace <option> para un <select>
     * @param array $arr [value]=array(''=>value,''=>text,'html atribute'=>'',...)
     * @param mixed $selected string selected value, array of selected values
     * @param array $extraOptions [value]=array(''=>value,''=>text,'html atribute'=>'',...) options no en array
     * @param string $optionTag html atributes a poner en todos los options
     * @return string <option ..>text</option>...
     */
    function ia_options_echo($arr,$selected='',$extraOptions=array(),$optionTag='') {
        $getEs=true;
        $isArraySelected=is_array($selected);
        if(!empty($extraOptions))
            $arr=array_merge($extraOptions,$arr);
        if($arr) foreach($arr as $k=>$v) {
            if($getEs  ) {
                $getEs=false;

                    $es=ia_options_atributes($v);
                    $doTag=sizeof($es)>2;
                    $value=$es['value'];
                    $text=$es['text'];
                    $tipo=1;
            }
            if($doTag) {
                $tag='';
                foreach($es as $tag=>$val) if($tag!='text')
                    $tag.=" $tag='".$v[$val]."'";
            } else {
                $tag=" value='".$v[$value]."'";
            }
            if($isArraySelected)
                echo "<option $tag ".(array_key_exists($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($v[$text])."</option>";
            else
                echo "<option $tag ".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($v[$text])."</option>";
        }
    }


    /**
     * ia_options_atributes()
     * Interna usada por ia_Options_*, regresa array con html_atribute=>array_key
     * @param array $d
     * @return array
     */
    function ia_options_atributes($d) {
        $pon=array('class','style','title');
        $es=array();
        $i=1;
        foreach($d as $k=>$v) {
            if($i==1)
                $es['value']=$k;
            elseif($i==2)
                $es['text']=$k;
            elseif( in_array($k,$pon) )
                $es['class']=$k;
            else
                $es["data-$k"]=$k;
            $i++;
        }
        return $es;
    }

/**
 * ia_SqlOptionsSetDataData()
 *
 * @param array $arr
 * @param string $selected
 * @param mixed $extra
 * @param string $optionTag
 * @return
 */
function ia_OptionsSetData($arr,$selected='',$extra=array(),$optionTag='') {
global $gIAsql;

    $ret='';
    if($extra) foreach($extra as $k=>$v)
		if(is_array($selected)) {
			$ret.= PHP_EOL."<option value='$k'".(array_key_exists($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($v)."</option>";
		} else {
			$ret.= PHP_EOL."<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($v)."</option>";
		}
    foreach($arr as $k=>$v) {
        if(is_array($selected))
            $ret.= PHP_EOL."<option value='$k'".(array_key_exists($k,$selected) ? " SELECTED='selected' " : "");
         else
            $ret.= PHP_EOL."<option data-data='$k' value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ");
         $i=0; $label='';
        if(is_array($v))
            foreach($v as $attr=>$val) {
                if($i==1)
                    $label=$val;
                elseif($i>1)
                    $ret.=" $attr='$val'";
                $i++;
            }
        else
            $label=$v;

         $ret.=" $optionTag>".ia_htmlentities($label)."</option>";
    }
	return $ret;
}

/**
 * ia_arrayOptions()
 *
 * @param array $array
 * @param string $selected
 * @param mixed $extra
 * @param string $optionTag
 * @return
 */
function ia_arrayOptions($array,$selected='',$extra=array(),$optionTag='') {
global $gIAsql;

    $ret='';
    if( !empty( $extra) ) foreach($extra as $k=>$v) {
		if(is_array($selected)) {
			$ret.= "\r\n<option value='$k'".(array_key_exists($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($v)."</option>";
		} else {
			$ret.= "\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($v)."</option>";
		}
	}
    if( !empty( $array) ) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			$ret.= "\r\n<option value='$d[0]'".(array_key_exists($d[0],$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d[1])."</option>";
		} else {
			$ret.= "\r\n<option value='$d[0]'".(strcmp($selected,$d[0]) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d[1])."</option>";
		}
    }

	return $ret;
}
function ia_array_2_option($arr) {

}



/**
 * ia_OptionsKey_echo()
 *
 * @param array $array
 * @param string $selected
 * @param string $optionTag
 * @return
 */
function ia_OptionsKey_echo($array,$selected='',$optionTag='') {
global $gIAsql;
	if( !empty( $array) ) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			echo "\r\n<option value='$k'".(in_array($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($k)."</option>";
		} else {
			echo "\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($k)."</option>";
		}
	}
}

/**
 * ia_OptionsKeyValue()
 *
 * @param array $array
 * @param string $selected
 * @param string $optionTag
 * @return
 */
function ia_OptionsKeyValue($array,$selected='',$optionTag='') {
global $gIAsql;
    $ret='';

	if( !empty( $array) ) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			$ret.= "\r\n<option value='$k'".(in_array($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d)."</option>";
		} else {
			$ret.= "\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d)."</option>";
		}
	}
    return $ret;
}

/**
 * ia_OptionsValue()
 *
 * @param array $array
 * @param string $selected
 * @param string $optionTag
 * @return
 */
function ia_OptionsValue($array,$selected='',$optionTag='') {
    $ret='';
	if( !empty( $array) ) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			$ret.= "\r\n<option value='$d'".(in_array($d,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d)."</option>";
		} else {
			$ret.= "\r\n<option value='$d'".(strcmp($selected,$d) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d)."</option>";
		}
	}
    return $ret;
}

/**
 * ia_OptionsValue_echo()
 *
 * @param array $array
 * @param string $selected
 * @param string $optionTag
 * @return
 */
function ia_OptionsValue_echo($array,$selected='',$optionTag='') {
	if( !empty( $array) ) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			echo "\r\n<option value='$d'".(in_array($d,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d)."</option>";
		} else {
			echo "\r\n<option value='$d'".(strcmp($selected,$d) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d)."</option>";
		}
	}
}


///////////////////////
/**
 * ia_Options_array()
 * pone options de un <select>
 *
 * @param array $array      [value]=display o value=array(value,display,'html-tag'=>tag_value,,'html-tag'=>tag_value,...)
 * @param $selected         value seleccionado actualmente
 * @param $optionAttr        opcional, atriubtos a agreagar a cada option
 * @return
 */
function ia_Options_array($array,$selected='',$optionAttr='') {
    $pon=array('class','style','title');
    $ret='';
	if( !empty( $array) ) foreach($array as $k=>$d) {
        $opts='';
        $id='';
        $text='';
        if(is_array($d)) {
            $i=0;
            foreach($d as $k=>$v) {
                $i++;
                if($i==1)
                    $id=$v;
                if($i==2)
                    $text=$v;
                elseif($i>2) {
                    if(in_array($k,$pon))
                        $opts.=" $k='".ia_htmlentities($v)."'";
                    else
                        $opts.=" data-$k='".ia_htmlentities($v)."'";
                }
            }
        } else {
            $text=$d;
            $id=$k;
        }

        if(is_array($selected)) {
			$ret.="\r\n<option value='$id'".(in_array($id,$selected) ? " SELECTED='selected' " : "")."$optionAttr$opts>".ia_htmlentities($text)."</option>";
		} else {
			$ret.="\r\n<option value='$id'".(strcmp($selected,$id) ? "" : " SELECTED='selected' ")."$optionAttr$opts>".ia_htmlentities($text)."</option>";
		}
	}
    return $ret;
}

/**
 * ia_Options_KeyDisplay()
 * pone options de un <select>
 *
 * @param $array            [value]=display
 * @param $selected         value seleccionado actualmente
 * @param $optionAttr        opcional, atriubtos a agreagar a cada option
 * @return
 */
function ia_Options_KeyDisplay($array,$selected='',$optionAttr='') {
    $ret='';
	if( !empty( $array) ) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			$ret.="\r\n<option value='$k'".(in_array($k,$selected) ? " SELECTED='selected' " : "")."$optionAttr>".ia_htmlentities($d)."</option>";
		} else {
			$ret.="\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionAttr>".ia_htmlentities($d)."</option>";
		}
	}
    return $ret;
}

/**
 * ia_Options_KeyDisplay
 * pone options de un <select>
 *
 * @param $array            [value]=display
 * @param $selected         value seleccionado actualmente
 * @param $optionAttr        opcional, atriubtos a agreagar a cada option
 *
 * @use ia_Options_KeyDisplay(ia_sqlKeyValue("SELECT id,nombre FROM tabla ORDER BY 2")  ,$id);
 *
 */
function ia_Options_KeyValueDisplay($array,$selected='',$optionAttr='') {
    $ret='';
	if( !empty( $array) ) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			$ret.="\r\n<option value='$k'".(in_array($k,$selected) ? " SELECTED='selected' " : "")."$optionAttr>".ia_htmlentities($d)."</option>";
		} else {
			$ret.="\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionAttr>".ia_htmlentities($d)."</option>";
		}
	}
    return $ret;
}

/**
 * ia_radioButtonsKeyValue()
 *
 * @param mixed $name
 * @param array $array
 * @param string $selected
 * @param string $tag
 * @return
 */
function ia_radioButtonsKeyValue($name,$array,$selected='',$tag='') {
    $ret='';
	if( !empty( $array) ) foreach($array as $k=>$d) {
	   $ret.= "<input type=radio name='$name' id='$name' value='".ia_htmlentities($k)."'".(strcmp($selected,$k) ? "" : " checked='checked' ")."$tag />".ia_htmlentities($d);
	}
    return $ret;
}

/**
 * ia_radioButtons()
 *
 * @param mixed $name
 * @param array $array
 * @param string $selected
 * @param string $tag
 * @return
 */
function ia_radioButtons($name,$array,$selected='',$tag='') {
    $ret='';
	if( !empty( $array) ) foreach($array as $k=>$d) {
	   $ret.= "<input type=radio name='$name' id='$name' value='".ia_htmlentities($d)."'".(strcmp($selected,$d) ? "" : " checked='checked' ")."$tag />".ia_htmlentities($d);
	}
    return $ret;
}

/**
 * dateit()
 *
 * @param string $s
 * @return
 */
function dateit($s)  { if($s=='') return 'null';  return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."'"; }
/**
 * dateitc()
 *
 * @param string $s
 * @return
 */
function dateitc($s) { if($s=='') return 'null'; return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."',"; }
/**
* Portege un string o fecha de caracteres extra para el sql query
* @param string $s el string a proteger
* @return string el string $s protegido
*/
function strit($s)  {  return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."'"; }
/**
 * strit()
 *
 * @param string $s
 * @return
 */
function stritN($s)  { if($s=='') return 'null';  return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."'"; }
/**
* Portege un string o fecha de caracteres extra para el sql query
* @param string $s el string a proteger
* @return string el string $s protegido terminado con una coma
*/
function stritc($s) {  return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."',"; }
/**
 * stritNc()
 *
 * @param string $s
 * @return
 */
function stritNc($s) {  return stritN($s)."',"; }

/**
 * comillea()
 *
 * @param string $s
 * @return
 */
function comillea($s)  { if($s===null) return '""';  return '"'.str_replace('"',"'", $s).'"'; }
/**
 * jsit()
 *
 * @param string $s
 * @return
 */
function jsit($s) { return '"'.str_replace( array("\\","\"","\'"),array("\\\\","\\\"","\\\'"),$s).'"'; }

/**
* Portege un string de javascript entre $entre apostrofes ' o comillas
* @param string $s el string a proteger
* @param string $entre ' o " El string sera puesto entre ' o "
* @return string el string $s protegido
*/
function javait($s,$entre="'")  {  return $entre.str_replace ($entre, "\\'",str_replace("\\", "\\\\", $s)).$entre; }
/**
 * stritN()
 *
 * @param mixed $s
 * @return
 */


/**
 * Portege un numero caracteres extra para el sql query, de no ser numerico pone 0
 * @param number $n el numero a proteger
 * @return string el numero $n protegido
 */
function numit($s)  { if( $s=='' ) return "0"; if( is_numeric($s) ) return strit($s); else return "0"; }
/**
 * numitN()
 *
 * @param string $s
 * @return
 */
function numitN($s)  { if( $s=='' ) return "null"; if( is_numeric($s) ) return strit($s); else return "0"; }
/**
* Portege un numero caracteres extraÃƒÆ’para el sql query, de no ser numerico pone 0
* @param number $n el numero a proteger
* @return string el numero $n protegido terminado con una coma
*/
function numitc($s) { return numit($s).","; }
/**
 * numitNc()
 *
 * @param string $s
 * @return
 */
function numitNc($s) { return numitN($s).","; }
/////////////////////////////////// params ////////////////////////////////////////////////////
function param_index($name,$index,$dflt='') {
    $arr=param($name,$dflt);
    if(is_array($arr) )
        if(array_key_exists($index,$arr) )
            return $arr[$index];
        else
            return $dflt;
    return $arr;
}
/**
* regresa el parametro llamado $name en post en string o array, si no existe busca en get, de no estar regresa $dflt
* @param string $nombre nombre del parametro a regresar
* @param variable $dflt='' el valor a regresar de no existir el parametro. default ''
* @return string el parametro llamado $name en post o get array si es array, de no estar regresa $dflt
*/
function param($name,$dflt='')      { return param_post($name, param_get($name,$dflt) ); }

/**
* regresa el parametro llamado $name en get en string o array, de no estar regresa $dflt
* @param string $nombre nombre del parametro a regresar
* @param variable $dflt='' el valor a regresar de no existir el parametro. default ''
* @return string el parametro llamado $name en get, de no estar regresa $dflt
*/
function param_get($name,$dflt='')  {
	if(  array_key_exists($name,$_GET)  && !is_array($_GET[$name]) )
		return trim(urldecode($_GET[$name]));
	if( !array_key_exists($name,$_GET))
		return $dflt;
	$arr=$_GET[$name];
    array_walk_recursive($arr,'arrayWalk_param_post_encode');
    return $arr;
}
/**
* regresa el parametro llamado $name en post en string o array, de no estar regresa $dflt
* @param string $nombre nombre del parametro a regresar
* @param variable $dflt='' el valor a regresar de no existir el parametro. default ''
* @return string el parametro llamado $name en post, de no estar regresa $dflt
*/
function param_post($name,$dflt='') {
	if( array_key_exists($name,$_POST) && !is_array($_POST[$name]) )
		return trim(html_entity_decode($_POST[$name],ENT_QUOTES));
	if( !array_key_exists($name,$_POST) )
		return $dflt;
	$arr=$_POST[$name];
    array_walk_recursive($arr,'arrayWalk_param_post_encode');
    return $arr;
}


/**
 * arrayWalk_param_post_encode()
 *
 * @param mixed $item
 * @param mixed $key
 * @return
 */
function arrayWalk_param_post_encode(&$item,$key) {
    $item=trim(html_entity_decode($item,ENT_QUOTES));
}
////////////////////////////////// emails ////////////////////////////////////////////////////

/**
* Valida un email este bien escrito por regexp
* @param string email a revisar
* @return boolean true email a validar
*/
function ia_emailValidRegExp($email) {
    if(function_exists('fiter_var'))
        return filter_var($email, FILTER_VALIDATE_EMAIL);
    else
        return validEmail($email);
}

function ia_emailValid($email) {
        return filter_var($email, FILTER_VALIDATE_EMAIL);
}

/**
Validate an email address.
Provide email address (raw input)
Returns true if the email address has the email
address format and the domain exists.
*/
function validEmail($email)
{
   $isValid = true;
   $atIndex = strrpos($email, "@");
   if (is_bool($atIndex) && !$atIndex)
   {
      $isValid = false;
   }
   else
   {
      $domain = substr($email, $atIndex+1);
      $local = substr($email, 0, $atIndex);
      $localLen = strlen($local);
      $domainLen = strlen($domain);
      if ($localLen < 1 || $localLen > 64)
      {
         // local part length exceeded
         $isValid = false;
      }
      else if ($domainLen < 1 || $domainLen > 255)
      {
         // domain part length exceeded
         $isValid = false;
      }
      else if ($local[0] == '.' || $local[$localLen-1] == '.')
      {
         // local part starts or ends with '.'
         $isValid = false;
      }
      else if (preg_match('/\\.\\./', $local))
      {
         // local part has two consecutive dots
         $isValid = false;
      }
      else if (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain))
      {
         // character not valid in domain part
         $isValid = false;
      }
      else if (preg_match('/\\.\\./', $domain))
      {
         // domain part has two consecutive dots
         $isValid = false;
      }
      else if(!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/',str_replace("\\\\","",$local)))
      {
         // character not valid in local part unless
         // local part is quoted
         if (!preg_match('/^"(\\\\"|[^"])+"$/',
             str_replace("\\\\","",$local)))
         {
            $isValid = false;
         }
      }
      if ($isValid && !(checkdnsrr($domain,"MX") || checkdnsrr($domain,"A")))
      {
         // domain not found in DNS
         $isValid = false;
      }
   }
   return $isValid;
}

/**
 * ia_email()
 *
 * @param mixed $to
 * @param string $subject
 * @param mixed $body
 * @param mixed $from
 * @param string $headerExtra
 * @return
 */
function ia_email($to,$subject,$body,$from,$headerExtra='') {
    $headers  = "MIME-Version: 1.0\r\n";
    $headers .= "From: $from\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";
    $headers=$headers.$header;
    return @mail($to,$subject,$body,$headers);
}

//////////////////// formas ///////////////////////////////
  /**
   * input_value()
   *
   * @param mixed $name
   * @param string $dflt
   * @return
   */
  function input_value($name,$dflt='') { return ' value="'.ia_htmlentities( param($name,$dflt) ).'" '; }
  /**
   * select_value()
   *
   * @param mixed $name
   * @param mixed $valor
   * @param bool $forza
   * @return
   */
  function select_value($name,$valor,$forza=false) {
   return ' value="'.ia_htmlentities($valor).'"'.( ( param($name) == html_entity_decode($valor,ENT_QUOTES) || $forza) ? ' SELECTED ' : '' );
  }
  /**
   * radio_checked()
   *
   * @param mixed $name
   * @param mixed $valor
   * @param bool $forza
   * @return
   */
  function radio_checked($name,$valor,$forza=false) {
   return ' value="'.ia_htmlentities($valor).'"'.( ( param($name) == html_entity_decode($valor,ENT_QUOTES) || $forza ) ? ' CHECKED ' : '' );
  }
  /**
   * array_options()
   *
   * @param mixed $arr
   * @param string $selected
   * @param string $tag
   * @param string $optionTag
   * @return
   */
  function array_options($arr,$selected,$tag='',$optionTag='') {
  	foreach($arr as $k=>$d) {
		if(is_array($selected))
			echo "\r\n<option value='$k'".(in_array($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d)."</option>";
		else
			echo "\r\n<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d)."</option>";
	}
  }
// doble submitted
  /**
   * ia_limite_add()
   *
   * @return
   */
  function ia_limite_add() {
    if(  !array_key_exists('limite',$_SESSION) )
      $_SESSION['limite']=1;
    else
      $_SESSION['limite']++;
 }

// file uploads
    function file_upload_standarize() {
        $subir=array();
        foreach($_FILES as $fieldName=>$f) {
            if( array_key_exists('name',$f) ) {
                if(is_array($f['name']) ) {
                    if($f['name']) foreach($f['name'] as $i=>$d) {
                        $name= array_key_exists($i,$f['name'])  ?  $f['name'][$i] : '';
                        $type= array_key_exists($i,$f['type'])  ?  $f['type'][$i] : '';
                        $tmp_name= array_key_exists($i,$f['tmp_name'])  ?  $f['tmp_name'][$i] : '';
                        $error= array_key_exists($i,$f['error'])  ?  $f['error'][$i] : 9;
                        $size= array_key_exists($i,$f['size'])  ?  $f['size'][$i] : 0;
                        if($name!='')
                            $subir[$fieldName][] = array('name'=>$name ,'type'=>$type,'tmp_name'=>$tmp_name,'error'=>$error,'size'=>$size);

                    }
                } else {
                        $name= array_key_exists('name',$f)  ?  $f['name'] : '';
                        $type= array_key_exists('type',$f)  ?  $f['type'] : '';
                        $tmp_name= array_key_exists('tmp_name',$f)  ?  $f['tmp_name'] : '';
                        $error= array_key_exists('error',$f)  ?  $f['error'] : 9;
                        $size= array_key_exists('size',$f)  ?  $f['size'] : 0;
                        if($name!='')
                            $subir[$fieldName][] = array('name'=>$name ,'type'=>$type,'tmp_name'=>$tmp_name,'error'=>$error,'size'=>$size);
                }
            }
        }
        return $subir;
    }
    function file_upload($file,$webPath,$extensions=array('jpg','jpeg','gif','png'),$maxBytes=0) {
    global $gIApath;
        $fullName='';
        $ok = false;

        $name= array_key_exists('name',$f)  ?  $f['name'] : '';
        $name_safe = filename_safe($name);
        $type= array_key_exists('type',$f)  ?  $f['type'] : '';
        $tmp_name= array_key_exists('tmp_name',$f)  ?  $f['tmp_name'] : '';
        $error= array_key_exists('error',$f)  ?  $f['error'] : 9;
        $size= array_key_exists('size',$f)  ?  $f['size'] : 0;

        $a = array('name'=>$name,'name_safe'=>$name_safe ,'type'=>$type,'tmp_name'=>$tmp_name,'error'=>$error,'size'=>$size);
        $ext = strtolower( filename_extension($name) );
        $msg_err='';
        if( $a['error'] ) {
            $msg_err .='<li>Error al subir '.ia_htmlentities($a['name']).': '.file_upload_error($a['error']);
        } elseif($maxBytes>0 && $a['size']>$maxBytes) {
            $msg_err .='<li>'.ia_htmlentities($a['name']).' mide '.file_size_formatted($a['size']).' m&aacute;ximo: '.file_size_formatted($maxBytes);
        } elseif( !in_array($ext,$extensions) ) {
            $msg_err .='<li>'.ia_htmlentities($a['name']).' tipo de archivo invÃ¡lido';
        } elseif( !file_upload_valid( $a['name'] ) ) {
           $msg_err .='<li>'.ia_htmlentities($a['name']).' nombre de archivo inv&aacute;lido! '.$fieldName;
        } else {
            //if( substr($webPath,0,-1)!='/' )
            //    $webPath.='/';
            $fullName = $webPath.$a['name_safe'];
            if( substr($gIApath['DOCUMENT_ROOT'],0,-1)!='/' )
                $uploaded_path = $gIApath['DOCUMENT_ROOT'].'/'.$fullName;
            else
                $uploaded_path = $gIApath['DOCUMENT_ROOT'].$fullName;

            if( move_uploaded_file($a['tmp_name'],$uploaded_path) ) {
                $ok=true;
            } elseif(copy($a['tmp_name'],$uploaded_path) ) {
                $ok=true;
            } else {
                $msg_err .= "<li>Error al copiar el archivo";
                $ok=false;
            }
            if($ok)
                @chmod($uploaded_path,0666);
            $a['uploaded_path'] = $uploaded_path;
        }
        $a['ok']=$ok;
        $a['msg_err'] = $msg_err;
        $a['fullName'] = $fullName;
        return  $a;
    }

    function file_upload_valid($file) {

        if( empty($file) || $file=='.htaccess' || $file=='.' || $file=='..' || $file=='./' || $file=='../' || $file=='/'
            || $file==DIRECTORY_SEPARATOR || $file=='.'.DIRECTORY_SEPARATOR  || $file=='..'.DIRECTORY_SEPARATOR  )
            return false;

        $invalid=array('../', '*','./',"\\",'?','...','//','~','$','"',"'","Ã‚Â´","`","!","@","|","%","&","(",")","[","]","{","}",">","<"," ");

        foreach($invalid as $d)
            if( !(strpos($file, $d )===FALSE) ) {
                return FALSE;
            }

        if( $file=='*' || $file=='' || substr($file,0,1)=='.' )
            return FALSE;
        if( substr($file,0,1)=='/' || substr($file,0,1)=='\\'  || substr($file,0,1)==DIRECTORY_SEPARATOR  )
            return FALSE;
        for($i=0;$i<strlen($file);++$i)
            if( ord($file[$i]) <=32 )
                return FALSE;

        $ext=filename_extension($file);
        if($ext=='' || $ext=='php' )
            return FALSE;
        return TRUE;
    }

function file_upload_error($err) {
    if( $err==0)
	   return '';
   elseif( $err==1)
	      return 'El archivo es demasiado grande';
   elseif( $err==2)
	      return 'El archivo es demasiado grande';
   elseif($err==3)
	      return 'Solo subio parte del archivo';
   elseif( $err==4)
	      return 'No subio el archivo';
   elseif( $err==6)
	      return 'No subio el archivo a tmp';
   elseif( $err==7)
	      return 'Error al escribir el archivo';
   elseif( $err==8)
	      return 'Tipo de archivo invalido';
   else
    return 'Error al subir el archivo';
}
/**
 * uploadErrorStr()
 *
 * @param mixed $indx
 * @return
 */
function uploadErrorStr($indx) {
    if( $_FILES[$indx]['error']==0)
	   return '';
   elseif( $_FILES[$indx]['error']==1)
	      return 'El archivo es demasiado grande';
   elseif( $_FILES[$indx]['error']==2)
	      return 'El archivo es demasiado grande';
   elseif( $_FILES[$indx]['error']==3)
	      return 'Solo subio parte del archivo';
   elseif( $_FILES[$indx]['error']==4)
	      return 'No subio el archivo';
   elseif( $_FILES[$indx]['error']==6)
	      return 'No subio el archivo a tmp';
   elseif( $_FILES[$indx]['error']==7)
	      return 'Error al escribir el archivo';
   elseif( $_FILES[$indx]['error']==8)
	      return 'Tipo de archivo invalido';
   else
    return 'Error al subir el archivo';
}

/////////////////////////////////////// ip //////////////////////////////////////////
/**
 * ip_extract()
 *
 * @param mixed $ip
 * @return
 */
function ip_extract(&$ip) {
    $array=array();
	if (@preg_match("/^([0-9]{1,3}\.){3,3}[0-9]{1,3}/", $ip, $array))
		return $array;
	else
		return false;
}
/**
 * ip_server_set()
 *
 * @param mixed $cual
 * @return
 */
function ip_server_set($cual) {
  if(  !array_key_exists($cual,$_SERVER) )
     return false;
  return   ( strcasecmp($_SERVER[$cual],'unknown')!=0 && $_SERVER[$cual]!='' );
}
/**
 * ip_get()
 *
 * @return
 */
function ip_get() {
	if(ip_server_set('HTTP_X_FORWARDED_FOR')) { // case 1.A: proxy && HTTP_X_FORWARDED_FOR is defined
		$array = ip_extract($_SERVER['HTTP_X_FORWARDED_FOR']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}
	if(ip_server_set('HTTP_X_FORWARDED')) { // case 1.B: proxy && HTTP_X_FORWARDED is defined
		$array = ip_extract($_SERVER['HTTP_X_FORWARDED']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}
	if(ip_server_set('HTTP_FORWARDED_FOR')) { // case 1.C: proxy && HTTP_FORWARDED_FOR is defined
		$array = ip_extract($_SERVER['HTTP_FORWARDED_FOR']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}
	if(ip_server_set('HTTP_FORWARDED')) { // case 1.D: proxy && HTTP_FORWARDED is defined
		$array = ip_extract($_SERVER['HTTP_FORWARDED']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}
	if(ip_server_set('HTTP_CLIENT_IP')) { // case 1.E: proxy && HTTP_CLIENT_IP is defined
		$array = ip_extract($_SERVER['HTTP_CLIENT_IP']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}

	if(ip_server_set('HTTP_VIA')) {
	// case 2:
	// proxy && HTTP_(X_) FORWARDED (_FOR) not defined && HTTP_VIA defined
	// other exotic variables may be defined
	return ( $_SERVER['HTTP_VIA'].
	  (  array_key_exists('HTTP_X_COMING_FROM',$_SERVER)   ?  '_' . $_SERVER['HTTP_X_COMING_FROM'] : '').
	  (   array_key_exists('HTTP_COMING_FROM',$_SERVER)   ?  '_' . $_SERVER['HTTP_COMING_FROM'] : '')
	  ) ;
	}
	if(ip_server_set('HTTP_X_COMING_FROM') || ip_server_set('HTTP_COMING_FROM') ) {
	// case 3: proxy && only exotic variables defined
	// the exotic variables are not enough, we add the REMOTE_ADDR of the proxy
	return ( $_SERVER['REMOTE_ADDR'] .
	  (  array_key_exists('HTTP_X_COMING_FROM',$_SERVER)   ?  '_' . $_SERVER['HTTP_X_COMING_FROM'] : '').
	  (  array_key_exists('HTTP_COMING_FROM',$_SERVER)   ?  '_' . $_SERVER['HTTP_COMING_FROM'] : '')
	  ) ;
	}

	// case 4: no proxy (or tricky case: proxy+refresh)
	if(ip_server_set('REMOTE_HOST')) {
		$array = ip_extract($_SERVER['REMOTE_HOST']);
		if ($array && count($array) >= 1) {
			return $array[0]; // first IP in the list
		}
	}
	return $_SERVER['REMOTE_ADDR'];
}
/**
 * ip_getFull()
 *
 * @return
 */
function ip_getFull() {
	//optimizar
	$ip='';
	if(ip_server_set('HTTP_X_FORWARDED_FOR')) { // case 1.A: proxy && HTTP_X_FORWARDED_FOR is defined
		$ip.=',HTTP_X_FORWARDED_FOR,'.$_SERVER['HTTP_X_FORWARDED_FOR'];
	}
	if(ip_server_set('HTTP_X_FORWARDED')) { // case 1.B: proxy && HTTP_X_FORWARDED is defined
		$ip.=',HTTP_X_FORWARDED,'.$_SERVER['HTTP_X_FORWARDED'];
	}
	if(ip_server_set('HTTP_FORWARDED_FOR')) { // case 1.C: proxy && HTTP_FORWARDED_FOR is defined
		$ip.=',HTTP_FORWARDED_FOR,'.$_SERVER['HTTP_FORWARDED_FOR'];
	}
	if(ip_server_set('HTTP_FORWARDED')) { // case 1.D: proxy && HTTP_FORWARDED is defined
		$ip.=',HTTP_FORWARDED,'.$_SERVER['HTTP_FORWARDED'];
	}
	if(ip_server_set('HTTP_CLIENT_IP')) { // case 1.E: proxy && HTTP_CLIENT_IP is defined
		$ip.=',HTTP_CLIENT_IP,'.$_SERVER['HTTP_CLIENT_IP'];
	}

	if(ip_server_set('HTTP_VIA')) {
	   $ip.=',HTTP_VIA,'. $_SERVER['HTTP_VIA'];
	}
	if(ip_server_set('HTTP_COMING_FROM') ) {
	  $ip.=',HTTP_X_COMING_FROM,' . $_SERVER['HTTP_X_COMING_FROM'];
	}
	if(ip_server_set('HTTP_X_COMING_FROM') ) {
	  $ip.=',HTTP_X_COMING_FROM,' . $_SERVER['HTTP_X_COMING_FROM'];
	}

	// case 4: no proxy (or tricky case: proxy+refresh)
	if(ip_server_set('REMOTE_HOST')) {
		$ip.=',REMOTE_HOST,'.$_SERVER['REMOTE_HOST'];
	}
	if(ip_server_set('REMOTE_ADDR')) {
		$ip.=',REMOTE_ADDR,'.$_SERVER['REMOTE_ADDR'];
	}
	return $ip;
}

////////////////////// HTML //////////////////////////////////////////////////////////////////////////
if ( !function_exists('ia_htmlentities')) {
  /**
   * ia_htmlentities()
   *
   * @param string $s
   * @param bool $forza
   * @param bool $hardblank
   * @return
   */
  function ia_htmlentities($s,$forza=false,$hardblank=false) { if($hardblank && ($s==null || $s=='') ) return '&nbsp;'; return htmlentities($s); }
}

  /**
   * redirect()
   *
   * @param mixed $url
   * @return
   */
  function redirect($url) {
   $requestProtocol = array_key_exists('SERVER_PROTOCOL',$_SERVER)  ? $_SERVER["SERVER_PROTOCOL"] : 'HTTP/1.0';
   $protocolArr = explode("/",$requestProtocol);
   $protocolName = isset($protocolArr[1]) ? trim($protocolArr[0]) : 'HTTP/1.0';
   $protocolVersion = isset($protocolArr[1]) ? trim($protocolArr[1]): '';
   if (stristr($protocolName,"HTTP") && strtolower($protocolVersion) > "1.0" ) {
     $httpStatusCode = 307;
   } else {
      $httpStatusCode = 302;
   }
   $httpStatusLine = "$requestProtocol $httpStatusCode Temporary Redirect";
   @header($httpStatusLine, TRUE, $httpStatusCode);
   @header("Location: $url");
  }

  /**
   * refreshTo()
   *
   * @param mixed $url
   * @return
   */
  function refreshTo($url) {
   echo "<html><head><meta http-equiv='refresh' content='0;url='$url'/></head><body><a href='$url'>$url</a></body></html>";
  }

/**
 * post_to_get()
 *
 * @param integer $maxLen
 * @return
 */
function post_to_get($maxLen=4096) {
	$ret='?';
	if( isset($_POST) && sizeof($_POST)>0)
	reset($_POST);
	while (list($k, $d) = each($_POST))
	// pasara a array exclude param
	if($k!='password' && $k!='pwd' && $k!='entrar' && $k!='email' && $k!='guarda' && $k!='causa_cancela' && $k!='confirma' && $k!='Foto'  )
		if($ret=='?')
			$ret.="$k=".urlencode($v);
		else
			$ret.="&$k=".urlencode($v);
	if( strlen($ret)>$maxLen)
		return substr($ret,0,$maxLen);
	return $ret;
}

 /**
  * ia_md5_salted()
  *
  * @param string $s
  * @return
  */
 function ia_md5_salted($s) { return md5("[Ga7ubeLa>$s"."KLZ*"); }
//
/**
 * ia_convertBytes()
 *
 * @param mixed $bytes
 * @return
 */
function ia_convertBytes($bytes) {
    if(empty($bytes) || !is_numeric($bytes))
        return $bytes;
    if($bytes<0) {
        $singo='-';
        $bytes*=-1;
    } else
        $signo='';
    if($bytes<=1024) {
        $decs=0;
        $punto='';
    } else {
        $decs=2;
        $punto='.';
    }
    $unit=array('b','Kb','Mb','Gb','Tb','Pb');

    return $signo.@number_format($bytes/@pow(1024,($i=floor(log($bytes,1024)))),$decs,$punto,',').' '.$unit[$i];
}

/**
 * ia_errores_a_dime()
 *
 * @param string $msg
 * @param string $usuario
 * @param string $script
 * @return
 */
function ia_errores_a_dime($msg='',$usuario='',$script='',$showSqlTrace=false) {
global $gIAsql;

        $err = error_get_last();
		if(empty($err))
			$err = array('line'=>1,'type'=>'?','file'=>$_SERVER['SCRIPT_NAME']);
		$tmp = array_val('message',$err,'');

        $json= function_exists('json_last_error()') ? json_last_error() : 0;
        if($json) {
            $err['type']='json';
            if($json==JSON_ERROR_DEPTH)
                $tmp.="\r\nJSON ERROR: The maximum stack depth has been exceeded";
            elseif($json==JSON_ERROR_STATE_MISMATCH)
                $tmp.="\r\nJSON ERROR: Invalid or malformed JSON";
            elseif($json==JSON_ERROR_CTRL_CHAR)
                $tmp.="\r\nJSON ERROR: Control character error, possibly incorrectly encoded";
            elseif($json==JSON_ERROR_SYNTAX)
                $tmp.="\r\nJSON ERROR: Syntax error";
            elseif($json==JSON_ERROR_UTF8)
                $tmp.="\r\nJSON ERROR: Malformed UTF-8 characters, possibly incorrectly encoded";
            else
                $tmp.="\r\nJSON ERROR: $json";
        }
        if($showSqlTrace &&  $gIAsql['trace'] && array_key_exists('sql_trace',$gIAsql) && !empty($gIAsql['sql_trace'])  ) {
            $tmptracer = sql_trace_get();
            $tmp.="\r\n".print_r($tmptracer,true);
            $tmp.="\r\n".print_r($gIAsql['sql_trace'],true);

        }

        $explain = ''; //  iasql_explain_trace(false);
        if(!empty($explain))
            $tmp.=$explain;
        if($tmp!='' || $gIAsql['err']!='' || $msg!='') {
            if($tmp!='')
                $tmp.="\r\n";
            if($gIAsql['err']!='') {
                if($err['type']=='?')
                    $err['type']='sql';
                $tmp.=$gIAsql['err']."\r\n";
            }
            if($msg!='')
                $tmp="msg: ".$msg."\r\n".$tmp;

			$usuario = $usuario=='' && array_key_exists('usuario',$_SESSION) ? $_SESSION['usuario'] : $usuario;
            if(empty($script))
                $script= array_val('file',$err,$_SERVER['SCRIPT_NAME']);

			ia_query("INSERT INTO dime(primera_fecha,fecha,usuario,script,dime,linea,tipo)
			VALUES(NOW(),NOW(),".stritc($usuario).stritc($script).stritc($tmp)
				.stritc($err['line']).strit($err['type']).") ON DUPLICATE KEY UPDATE fecha=NOW(),dime=VALUES(dime),usuario=VALUES(usuario)");
        }
}
/**
 * ia_errores_a_dime_ori()
 *
 * @param string $msg
 * @param string $usuario
 * @param string $script
 * @return
 */
function ia_errores_a_dime_ori($msg='',$usuario='',$script='',$showSqlTrace=false) {
global $gIAsql;
        $tmp=error_last();
        $json= function_exists('json_last_error()') ? json_last_error() : 0;
        if($json) {
            if($json==JSON_ERROR_DEPTH)
                $tmp.="\r\nJSON ERROR: The maximum stack depth has been exceeded";
            elseif($json==JSON_ERROR_STATE_MISMATCH)
                $tmp.="\r\nJSON ERROR: Invalid or malformed JSON";
            elseif($json==JSON_ERROR_CTRL_CHAR)
                $tmp.="\r\nJSON ERROR: Control character error, possibly incorrectly encoded";
            elseif($json==JSON_ERROR_SYNTAX)
                $tmp.="\r\nJSON ERROR: Syntax error";
            elseif($json==JSON_ERROR_UTF8)
                $tmp.="\r\nJSON ERROR: Malformed UTF-8 characters, possibly incorrectly encoded";
            else
                $tmp.="\r\nJSON ERROR: $json";
        }
        if($showSqlTrace &&  $gIAsql['trace'] && array_key_exists('sql_trace',$gIAsql) && !empty($gIAsql['sql_trace'])  )
            $tmp.="\r\n".print_r($gIAsql['sql_trace'],true);
        $explain = ''; //  iasql_explain_trace(false);
        if(!empty($explain))
            $tmp.=$explain;
        if($tmp!='' || $gIAsql['err']!='' || $msg!='') {
            if($tmp!='')
                $tmp.="\r\n";
            if($gIAsql['err']!='')
                $tmp.=$gIAsql['err']."\r\n";
            if($msg!='')
                $tmp=$msg."\r\n".$tmp;
            $usuario = $usuario=='' && array_key_exists('usuario',$_SESSION) ? $_SESSION['usuario'] : $usuario;
            if($script=='')
                $script=$_SERVER['SCRIPT_NAME'];
            ia_query("INSERT INTO dime(usuario,script,dime) VALUES(".stritc($usuario).stritc($script).strit($tmp).")");
        }
}


/**
 * ia_report_status_collapsable()
 *
 * @param bool $scriptTime
 * @param bool $rusage
 * @param bool $ram
 * @param bool $sqlErrors
 * @param bool $sqlTrace
 * @param bool $phpErr
 * @return
 */
function ia_report_status_collapsable($scriptTime=true,$rusage=true,$ram=true,$sqlErrors=true,$sqlTrace=true,$phpErr=true) {
global $gIAsql, $gIaTimeStart;
    $tmp=error_last();
    $color= empty($gIAsql['err']) && empty($tmp) ? 'color:silver;' : 'color:red;' ;
    $ret=ia_report_status($scriptTime,$rusage,$ram,$sqlErrors,$sqlTrace,$phpErr);
    return "<div style='padding-top:16px;'><span style='cursor:pointer;font-style:italic;font-weight:lighter;$color;' onClick='ia_toggleSibling(this,\"Page stats\");'>&#8594; Page stats</span><div style='display:none;padding-left:16px;'>$ret</div></div>";
}

/**
 * ia_report_status()
 *
 * @param bool $scriptTime
 * @param bool $rusage
 * @param bool $ram
 * @param bool $sqlErrors
 * @param bool $sqlTrace
 * @param bool $phpErr
 * @return
 */
function ia_report_status($scriptTime=true,$rusage=true,$ram=true,$sqlErrors=true,$sqlTrace=true,$phpErr=true) {
global $gIAsql, $gIaTimeStart;

    $finalT=microtime(true);
    $ret= PHP_EOL."<table class=tabla >";
    if($phpErr) {
        $tmp=error_last(); //phperr
        if($tmp!='')
            $ret.= PHP_EOL."<tr><td><table>
                <th style='color:red;'><a name='phperr'></a>Last php error<tr><td WRAP style='color:red;white-space:normal;'>".ia_htmlentities($tmp)
                ."</table>";
    }

    $ramDoTable=true;
    $timeRam='';
    if($scriptTime ) {
        $ramDoTable=false;
        $timeRam.= PHP_EOL."<tr><td>
        <table class=tabla><tr><th>Script Time
            <table class=tabla>";
        if( array_key_exists('REQUEST_TIME',$_SERVER) ) {
            $lapsed=abs($finalT-$_SERVER['REQUEST_TIME']);
            $milli=round($lapsed-floor($lapsed),3)*1000;
            $timeRam.=PHP_EOL."\t\t\t\t<tr><th class='nowrap'>Request time<td NOWRAP class='der nowrap' style='width:20px;'>".str_replace(
                 array('0 h','00 min','00 sec',' 01',' 02',' 03',' 04',' 05',' 06',' 07',' 08',' 09')
                 ,array('','',''               ,' 1',' 2',' 3',' 4',' 5',' 6',' 7',' 8',' 9')
                ,gmDate(' G \h i \m\i\n s \s\e\c '.$milli.' \m\s',floor($lapsed) ) );
        }
        if(isset($gIaTimeStart) && $gIaTimeStart!='' && is_numeric( $gIaTimeStart) ) {
            $lapsed=abs($finalT-$gIaTimeStart);
            $milli=round($lapsed-floor($lapsed),3)*1000;
            $timeRam.=PHP_EOL. "\t\t\t\t<tr><th class='nowrap'>Script time<td NOWRAP class='der nowrap'>".str_replace(
                 array('0 h','00 min','00 sec',' 01',' 02',' 03',' 04',' 05',' 06',' 07',' 08',' 09')
                 ,array('','',''               ,' 1',' 2',' 3',' 4',' 5',' 6',' 7',' 8',' 9')
                ,gmDate(' G \h i \m\i\n s \s\e\c '.$milli.' \m\s',floor($lapsed) ) );
        }
        if(isset($gIaTimeStart) && $gIaTimeStart!='' && is_numeric( $gIaTimeStart) && array_key_exists('REQUEST_TIME',$_SERVER) ) {
            $lapsed=abs( $_SERVER['REQUEST_TIME']-$gIaTimeStart );
            $milli=round($lapsed-floor($lapsed),3)*1000;
            $timeRam.= PHP_EOL."\t\t\t\t<tr><th class='nowrap'>Apache time<td NOWRAP class='der nowrap'>".str_replace(
                 array('0 h','00 min','00 sec',' 01',' 02',' 03',' 04',' 05',' 06',' 07',' 08',' 09')
                 ,array('','',''               ,' 1',' 2',' 3',' 4',' 5',' 6',' 7',' 8',' 9')
                ,gmDate(' G \h i \m\i\n s \s\e\c '.$milli.' \m\s',floor($lapsed) ) );
        }
        $timeRam.= PHP_EOL."\t\t\t</table>".PHP_EOL;
    }

    if($ram && function_exists('memory_get_usage') && function_exists('memory_get_peak_usage') ) {
        if($ramDoTable)
            $timeRam.=PHP_EOL.PHP_EOL."<tr><td>
            <table class=tabla><tr>";
        $ramDoTable=false;
        $timeRam.= PHP_EOL."\t\t\t<th>RAM
            <table class=tabla>
                  <tr><th class='achica'>Usage<th class='achica'>Usage malloc<th class='achica'>Peak<th class='achica'>Peak malloc
                  <tr><td class='der achica'>".ia_convertBytes( memory_get_usage() )."<td class='der achica'>" . ia_convertBytes( memory_get_usage(true) )
                     ."<td class='der achica'>".ia_convertBytes( memory_get_peak_usage() )."<td class='der achica'>".ia_convertBytes( memory_get_peak_usage(true) )
            .PHP_EOL."\t\t\t</table>";
    }

    if($timeRam!='')
        $ret.=$timeRam.PHP_EOL.PHP_EOL."\t\t</table>".PHP_EOL;

    if( $rusage && function_exists('getrusage')) {
        $tit['ru_utime.tv_sec']='CPU user time secs.';
        $tit['ru_utime.tv_usec']='CPU user time microseconds.';
        $tit['ru_stime.tv_sec']='CPU system time secs.';
        $tit['ru_stime.tv_usec']='CPU system time microseconds.';
        $tit['ru_maxrss']='Maximum resident size in Kb.';
        $tit['ru_ixrss']='Integer, amount of memory used by the text segment that was also shared among other processes in kb * ticks-of-execution';
        $tit['ru_idrss']='Integer, amount of unshared memory residing in the data segment of a process in kb * ticks-of-execution';
        $tit['ru_isrss']='Integer, amount of unshared memory residing in the stack segment of a process in kb * ticks-of-execution';
        $tit['ru_minflt']='Number of page faults serviced without any I/O activity';
        $tit['ru_majflt']='Number of page faults serviced that required I/O activity';
        $tit['ru_nswap']='Number of times a process was swapped out of main memory';
        $tit['ru_inblock']='Number of times the file system had to perform input';
        $tit['ru_oublock']='Number of times the file system had to perform output';
        $tit['ru_msgsnd']='Number of IPC messages sent';
        $tit['ru_msgrcv']='Number of IPC messages received';
        $tit['ru_nsignals']='Number of signals delivered';
        $tit['ru_nvcsw']='Number of voluntary context switches';
        $tit['ru_nivcsw']='Number of context switches due to higher priority or time slice exceeded';

        $uni['ru_stime.tv_sec']=$uni['ru_utime.tv_sec']='secs.';
        $uni['ru_stime.tv_usec']=$uni['ru_utime.tv_usec']='microseconds';
        $uni['ru_maxrss']='Kb.';
        $uni['ru_isrss']=$uni['ru_idrss']=$uni['ru_ixrss']='kb * ticks-of-execution';
        $uni['ru_majflt']=$uni['ru_minflt']='pages';
        $uni['ru_inblock']=$uni['ru_oublock']=$uni['ru_nswap']='# veces';

        $uni['ru_msgrcv']=$uni['ru_msgsnd']='# IPC messages';
        $uni['ru_nsignals']='# se&ntilde;ales';
        $uni['ru_nivcsw']=$uni['ru_nvcsw']='# context switches';

        $tmp=getrusage();
        //$tmp2=getrusage(1);
        $ret.= PHP_EOL."<tr><th class='izq nowrap'>R Usage<tr><td>
            <table class=tabla>
                  <tr><th class='achica'>Item<th class='achica'>Value<th class='achica'>Units";

        foreach( $tmp as $k=>$v) {
            $ret.=PHP_EOL."<tr><th><span".(array_key_exists($k,$tit) ? " title='$tit[$k]'" : '').">$k</span>
                    <td NOWRAP class='der nowrap'>".number_format($v,0,'',',')

                ."<td>".(array_key_exists($k,$uni) ? $uni[$k] : '');
                //."<td NOWRAP class='der nowrap'>".number_format( array_key_exists($k,$tmp2) ? $tmp2[$k]:0  ,0,'',',')
        }
        $ret.="</table>";
    }

    if($sqlErrors) {
        if($gIAsql['begins']!=0)
            $ret.=PHP_EOL."<tr><th class='izq nowrap' style='color:red;'>Hanging begins: $gIAsql[begins]";
        if($sqlErrors && !empty($gIAsql['err'])) {
            $ret.=PHP_EOL."<tr><th class='izq nowrap' style='color:red;'><a name=sqlerr></a>Sql Errors<tr><td style='white-space:pre;style='color:red;'><ol style='style='color:red;'>$gIAsql[err]</ol>";
        }
    }

    if($sqlTrace) {
        $ret.="<tr><th class='izq nowrap'>Sql trace<table class=tabla><tr><td><pre><ol>";
        foreach( $gIAsql['sql_trace'] as $v)
            if(is_array($v))
                $ret.="<li>".print_r($v,true);
            else
                $ret.="<li>".ia_htmlentities($v);

        foreach( sql_trace_get() as $v)
            if(is_array($v))
                $ret.="<li>".print_r($v,true);
            else
                $ret.="<li>".ia_htmlentities($v);

        $ret.="</ol></pre></table>";
    }
    return $ret.PHP_EOL."</table>".PHP_EOL;
}

/**
 * ia_array2js()
 *
 * @param mixed $nombre
 * @param mixed $arr
 * @return
 */
function ia_array2js($nombre,$arr) {
    echo PHP_EOL."$var={";
    if($arr) {

    }
    echo '};'.PHP_EOL;
}

// files
/**
 * file_size_formatted()
 *
 * @param string $size
 * @return
 */
function file_size_formatted($size) {
    if($size<1024)
        return $size.'b';
    if($size<1024*1024)
        return round($size/1024.00,0).'Kb';
    if($size<1024*1024*1024)
        return round($size/(1024.00*1024.00),1).'Mb';
    return round($size/(1024.00*1024.00*1024.00),1).'Gb';
}
/**
 * file_is_image()
 *
 * @param mixed $fileName
 * @return
 */
function file_is_image($fileName) {
    $dot=strrpos($fileName,'.');
    if($dot===FALSE)
        return false;
    $ext=substr($fileName,$dot+1);
    return (strcasecmp($ext,'jpg')==0 || strcasecmp($ext,'jpeg')==0 || strcasecmp($ext,'gif')==0 || strcasecmp($ext,'png')==0 );
}
/**
 * file_icon()
 *
 * @param mixed $fileName
 * @return
 */
function file_icon($fileName) {
global $gIApath;

    $dot=strrpos($fileName,'.');
    if($dot===FALSE)
        return false;
    $ext=substr($fileName,$dot+1);
    if(strcasecmp($ext,'jpg')==0 || strcasecmp($ext,'jpeg')==0 || strcasecmp($ext,'gif')==0 || strcasecmp($ext,'png')==0 || strcasecmp($ext,'bmp')==0 || strcasecmp($ext,'ico')==0 )
        return "$gIApath[WebPath]img/ext/jpg.gif";
    if(strcasecmp($ext,'avi')==0 || strcasecmp($ext,'mpeg')==0 || strcasecmp($ext,'rm')==0 || strcasecmp($ext,'wmp')==0 )
        return "$gIApath[WebPath]img/ext/video.gif";
    $gifs=array('csv','doc','docx','gif','htm','html','jpeg','jpg','pdf','png','pps','ppsx','ppt','pptx','video','wav','xls','xlsx');
    if(in_array($ext,$gifs))
        return "$gIApath[WebPath]img/ext/$ext.gif";
    return "$gIApath[WebPath]img/ext/clip.gif";
}
// IMAGES
/**
 * ia_image_tag_size()
 *
 * @param mixed $imageFile
 * @return
 */
function ia_image_tag_size($imageFile) {
try {
    if(!file_exists($imageFile) )
        return '';
    $size=filesize($imageFile);
    if($size===FALSE)
        $size='';
    else
        $size=file_size_formatted($size);
    if(file_is_image($imageFile)) {
        $arr=@getimagesize($imageFile); // 0=width, 1=height, 3=height, width tag
        if($arr===FALSE || !is_array($arr) || sizeof($arr)<4) return $size;
        return "w: $arr[0]px h:$arr[1]px $size";
    }
    return $size;
} catch(Exception $e) { return ''; }
}

function ia_img_format($w,$h,$cssFormat) { if($cssFormat) return "width: $w"."px; height: $h".'px'; return "width='$w' height='$h'"; }

/**
 * ia_image_tagsize_fitmax()
 * ajusta imagen al tamaÃ±o
 * @param mixed $imageFile path fisico a imagen o array(0=>w,1=>h)
 * @param int $max_width maximo width deseado, 0 cualsea
 * @param int $max_height maximo height deseado, 0 cualsea
 * @param bool $cssFormat true regresa css flase
 * @param bool $enLarge
 * @return en $cssFormat true width:npx; height:xpx en false width='xpx' height='ypx'
 */
function ia_image_tagsize_fitmax($imageFile,$max_width,$max_height,$cssFormat=true,$enLarge=false) {
try {
    if(is_array($imageFile))
        $arr=$imageFile;
    else {
        $arr=@getimagesize($imageFile); // 0=width, 1=height, 3=height, width tag
        if($arr===FALSE || !is_array($arr) || sizeof($arr)<4) return '';
    }
    $w=$arr[0];
    $h=$arr[1];

    if(!empty($max_width) && !empty($max_height) ) {

        if($w==$max_width && $h==$max_height)
            return ia_img_format($w,$h,$cssFormat);
        if(!$enLarge && $w<=$max_width && $h<=$max_height)
            return ia_img_format($w,$h,$cssFormat);
        if($w==0 || $h==0)
           return ia_img_format($max_width,$max_height,$cssFormat);
        if($enLarge && $w <= $max_width && $h <= $max_height) {
            if($w>$h)
                return ia_img_format($max_width,round($max_width*$h/$w,0),$cssFormat);
            else
                return ia_img_format(round($max_height*$w/$h,0),$max_height,$cssFormat);
        }
        if( $w>$max_width && $h<=$max_height)
            return ia_img_format($max_width,round($max_width*$h/$w,0),$cssFormat);
        if( $w<=$max_width && $h>$max_height)
            return ia_img_format(round($max_height*$w/$h,0),$max_height,$cssFormat);
        // ambas mayores
        if($w>=$h)
            return ia_img_format($max_width,round($max_width*$h/$w,0),$cssFormat);
        else
            return ia_img_format(round($max_height*$w/$h,0),$max_height,$cssFormat);
    }
    if(empty($max_height)) {

        if($w==$max_width)
            return ia_img_format($w,$h,$cssFormat);
        if( $w <= $max_width) {
            if( $enLarge )
                return ia_img_format($max_width,round($max_width*$h/$w,0),$cssFormat);
            else
                return ia_img_format($w,$h,$cssFormat);
        }
        return ia_img_format($max_width,round($max_width*$h/$w,0),$cssFormat);
    }
    if(empty($max_width)) {

        if($h == $max_height)
            return ia_img_format($w,$h,$cssFormat);
        if($h <= $max_height) {
            if( $enLarge ) {
                return ia_img_format(round($max_height*$w/$h,0),$max_height, $cssFormat);
            } else {
                return ia_img_format($w,$h,$cssFormat);
            }
        }
        return ia_img_format(round($max_height*$w/$h,0),$max_height,$cssFormat);
    }
    return ia_img_format($w,$h,$cssFormat );
} catch(Exception $e) { return ''; }
}

/**
 * ia_image_escribe()
 *
 * @param mixed $imageFile
 * @param mixed $escribe
 * @return
 */
function ia_image_escribe($imageFile,$escribe) {
try {
    $ext=substr($imageFile,-3);
    if( strcasecmp($ext,'png')==0 )
        $image = imagecreatefrompng($img);
    elseif( strcasecmp($ext,'gif')==0 )
        $image = imagecreatefromgif($img);
    elseif( strcasecmp($ext,'jpg')==0 || strcasecmp(substr($imageFile,-4),'jpeg')==0 )
        $image = imagecreatefromjpeg($img);
    elseif( strcasecmp($ext,'bmp')==0 )
        $image = imagecreatefromwbmp($img);
    else
        return FALSE;

    if($image===FALSE)
        return FALSE;
    $color = imagecolorallocate($image, 0, 0, 0);
    $x=10;
    $y=10;
    foreach($escribe as $k=>$v) {
        $font= array_key_exists('font',$v) ? $v['font'] : './arial.ttf';
        $font_size= array_key_exists('font_size',$v) ? $v['font_size'] : 9;
        $text=array_key_exists('texto',$v) ? $v['texto'] : ' ';
        if( array_key_exists('color_rgb',$v) ) {
            if(is_array($v['color_rgb']) && sizeof($v['color_rgb'])>=3)
                $color = imagecolorallocate($image, $v['color_rgb'][0], $v['color_rgb'][1], $v['color_rgb'][2]);
        }
        if( array_key_exists('utf8_encode',$v) && $v['utf8_encode'] )
            $text=utf8_encode($text);

        $arr=imagettfbbox($font_size,0,$font,$text);
        $x= array_key_exists('x',$v) ? $v['x'] : $x;
        $y= array_key_exists('y',$v) ? $v['y'] : $y;
        ImageTTFText($image, $font_size, 0, $x, $y, $color, $font, $text);
        $y+=10;
    }
    return $image;
} catch(Exception $e) { return FALSE; }
}

/**
 * Convert an RGB array to HEX
 *
 * @param array $colors array('r' => 255, 'g' => 125, 'b' => 0)
 * @return string
 */
/**
 * rgb_to_hex()
 *
 * @param mixed $colors
 * @return
 */
function rgb_to_hex($colors = array()) {
        /* Won't accept black, so we make an exception (thanks Arantor) */
        if ($colors['r'] === '0' && $colors['g'] === '0' && $colors['b'] === '0')
                return '000000';
        /* If it's an empty array, or missing a color, it's invalid! */
        if (empty($colors['r']) && empty($colors['g']) & empty($colors['b']))
                return false;

        return strtoupper(dechex($colors['r']).dechex($colors['g']).dechex($colors['b']));
}
/**
 * imagesharpen()
 *
 * @param mixed $image
 * @return
 */
function imagesharpen( $image) {

        $matrix = array(
            array(-1, -1, -1),
            array(-1, 16, -1),
            array(-1, -1, -1),
        );

        $divisor = array_sum(array_map('array_sum', $matrix));
        $offset = 0;
        imageconvolution($image, $matrix, $divisor, $offset);

        return $image;
    }

/**
 * Convert a HEX color string to an RGB array
 *
 * @param string $hex HEX string to convert
 * @param bool $returnstring Return as string or array
 * @return array
 */
/**
 * hex_to_rgb()
 *
 * @param mixed $hex
 * @param bool $returnstring
 * @return
 */
function hex_to_rgb($hex, $returnstring = false) {
        $hex = preg_replace('~[^0-9A-Fa-f]~', '', $hex);
        $rgb = array();

        if (strlen($hex) == 6) {
                $color = hexdec($hex);
                $rgb['r'] = 0xFF & ($color >> 0x10);
                $rgb['g'] = 0xFF & ($color >> 0x8);
                $rgb['b'] = 0xFF & $color;
        } elseif (strlen($hex) == 3) {
                $rgb['r'] = hexdec(str_repeat(substr($hex, 0, 1), 2));
                $rgb['g'] = hexdec(str_repeat(substr($hex, 1, 1), 2));
                $rgb['b'] = hexdec(str_repeat(substr($hex, 2, 1), 2));
        } else
                return false;

        return $returnstring == true ? implode(',', $rgb) : $rgb;
}

/**
 * saniteze_string()
 *
 * @param string $s
 * @return
 */
function saniteze_string($s) {
    $letras['%01']='';
        $letras['%02']='';
        $letras['%03']='';
        $letras['%04']='';
        $letras['%05']='';
        $letras['%06']='';
        $letras['%07']='';
        $letras['%08']='';
        $letras['%09']='';
        $letras['%0A']='';
        $letras['%0B']='';
        $letras['%0C']='';
        $letras['%0D']='';
        $letras['%0E']='';
        $letras['%0F']='';
        $letras['%10']='';
        $letras['%11']='';
        $letras['%12']='';
        $letras['%13']='';
        $letras['%14']='';
        $letras['%15']='';
        $letras['%16']='';
        $letras['%17']='';
        $letras['%18']='';
        $letras['%19']='';
        $letras['%1A']='';
        $letras['%1B']='';
        $letras['%1C']='';
        $letras['%1D']='';
        $letras['%1E']='';
        $letras['%1F']='';
        $letras['%20']='_';
        $letras['%21']="_";
        $letras['%22']='_';
        $letras['%23']="_";
        $letras['%24']="_";
        $letras['%25']="_";
        $letras['%26']="_";
        $letras['%27']="_";
        $letras['%28']="_";
        $letras['%29']="_";
        $letras['%2A']="_";
        $letras['%2B']="_";
        $letras['%2C']="_";
        $letras['%2D']="-";
        $letras['%2E']=".";
        $letras['%2F']="_";
        $letras['%30']="0";
        $letras['%31']="1";
        $letras['%32']="2";
        $letras['%33']="3";
        $letras['%34']="4";
        $letras['%35']="5";
        $letras['%36']="6";
        $letras['%37']="7";
        $letras['%38']="8";
        $letras['%39']="9";
        $letras['%3A']="_";
        $letras['%3B']="_";
        $letras['%3C']="_";
        $letras['%3D']="_";
        $letras['%3E']="_";
        $letras['%3F']="_";
        $letras['%40']="_";
        $letras['%41']="A";
        $letras['%42']="B";
        $letras['%43']="C";
        $letras['%44']="D";
        $letras['%45']="E";
        $letras['%46']="F";
        $letras['%47']="G";
        $letras['%48']="H";
        $letras['%49']="I";
        $letras['%4A']="J";
        $letras['%4B']="K";
        $letras['%4C']="L";
        $letras['%4D']="M";
        $letras['%4E']="N";
        $letras['%4F']="O";
        $letras['%50']="P";
        $letras['%51']="Q";
        $letras['%52']="R";
        $letras['%53']="S";
        $letras['%54']="T";
        $letras['%55']="U";
        $letras['%56']="V";
        $letras['%57']="W";
        $letras['%58']="X";
        $letras['%59']="Y";
        $letras['%5A']="Z";
        $letras['%5B']="_";
        $letras['%5C']='_';
        $letras['%5D']="_";
        $letras['%5E']="_";
        $letras['%5F']="_";
        $letras['%60']="_";
        $letras['%61']="a";
        $letras['%62']="b";
        $letras['%63']="c";
        $letras['%64']="d";
        $letras['%65']="e";
        $letras['%66']="f";
        $letras['%67']="g";
        $letras['%68']="h";
        $letras['%69']="i";
        $letras['%6A']="j";
        $letras['%6B']="k";
        $letras['%6C']="l";
        $letras['%6D']="m";
        $letras['%6E']="n";
        $letras['%6F']="o";
        $letras['%70']="p";
        $letras['%71']="q";
        $letras['%72']="r";
        $letras['%73']="s";
        $letras['%74']="t";
        $letras['%75']="u";
        $letras['%76']="v";
        $letras['%77']="w";
        $letras['%78']="x";
        $letras['%79']="y";
        $letras['%7A']="z";
        $letras['%7B']="_";
        $letras['%7C']="_";
        $letras['%7D']="_";
        $letras['%7E']="_";
        $letras['%7F']='_';
        $letras['%80']="E";
        $letras['%81']='_';
        $letras['%82']="_";
        $letras['%83']="f";
        $letras['%84']='_';
        $letras['%85']=".";
        $letras['%86']="_";
        $letras['%87']="_";
        $letras['%88']="_";
        $letras['%89']="_";
        $letras['%8A']="_";
        $letras['%8B']="_";
        $letras['%8C']="C";
        $letras['%8D']="a";
        $letras['%8E']="Z";
        $letras['%8F']="a";
        $letras['%90']="a";
        $letras['%91']="_";
        $letras['%92']="_";
        $letras['%93']='_';
        $letras['%94']='_';
        $letras['%95']=".";
        $letras['%96']="ae";
        $letras['%97']="a";
        $letras['%98']="a";
        $letras['%99']="T";
        $letras['%9A']="s";
        $letras['%9B']="_";
        $letras['%9C']="o";
        $letras['%9D']='_';
        $letras['%9E']="z";
        $letras['%9F']="Y";
        $letras['%A0']='_';
        $letras['%A1']="_";
        $letras['%A2']="c";
        $letras['%A3']="L";
        $letras['%A4']="o";
        $letras['%A5']="y";
        $letras['%A6']="_";
        $letras['%A7']="s";
        $letras['%A8']=".";
        $letras['%A9']="c";
        $letras['%AA']="a";
        $letras['%AB']="_";
        $letras['%AC']="_";
        $letras['%AD']='_';
        $letras['%AE']="R";
        $letras['%AF']="-";
        $letras['%B0']="_";
        $letras['%B1']="_";
        $letras['%B2']="2";
        $letras['%B3']="3";
        $letras['%B4']="_";
        $letras['%B5']="u";
        $letras['%B6']="p";
        $letras['%B7']=".";
        $letras['%B8']="_";
        $letras['%B9']="1";
        $letras['%BA']="o";
        $letras['%BB']="_";
        $letras['%BC']="1";
        $letras['%BD']="1";
        $letras['%BE']="1";
        $letras['%BF']="_";
        $letras['%C0']="A";
        $letras['%C1']="a";
        $letras['%C2']="A";
        $letras['%C3']="A";
        $letras['%C4']="A";
        $letras['%C5']="A";
        $letras['%C6']="A";
        $letras['%C7']="C";
        $letras['%C8']="E";
        $letras['%C9']="E";
        $letras['%CA']="E";
        $letras['%CB']="E";
        $letras['%CC']="I";
        $letras['%CD']="I";
        $letras['%CE']="I";
        $letras['%CF']="I";
        $letras['%D0']="D";
        $letras['%D1']="N";
        $letras['%D2']="O";
        $letras['%D3']="O";
        $letras['%D4']="O";
        $letras['%D5']="O";
        $letras['%D6']="O";
        $letras['%D7']="x";
        $letras['%D8']="O";
        $letras['%D9']="U";
        $letras['%DA']="U";
        $letras['%DB']="U";
        $letras['%DC']="U";
        $letras['%DD']="y";
        $letras['%DE']="b";
        $letras['%DF']="s";
        $letras['%E0']="a";
        $letras['%E1']="a";
        $letras['%E2']="a";
        $letras['%E3']="a";
        $letras['%E4']="a";
        $letras['%E5']="a";
        $letras['%E6']="a";
        $letras['%E7']="c";
        $letras['%E8']="e";
        $letras['%E9']="e";
        $letras['%EA']="e";
        $letras['%EB']="e";
        $letras['%EC']="i";
        $letras['%ED']="i";
        $letras['%EE']="i";
        $letras['%EF']="i";
        $letras['%F0']="d";
        $letras['%F1']="n";
        $letras['%F2']="o";
        $letras['%F3']="o";
        $letras['%F4']="o";
        $letras['%F5']="o";
        $letras['%F6']="o";
        $letras['%F7']="_";
        $letras['%F8']="o";
        $letras['%F9']="u";
        $letras['%FA']="u";
        $letras['%FB']="u";
        $letras['%FC']="u";
        $letras['%FD']="y";
        $letras['%FE']="b";
        $letras['%FF']="y";

      return strtr( urlencode($s),$letras);
}

/**
 * Unaccent a string
 *
 * @author http://www.evaisse.net/2008/php-translit-remove-accent-unaccent-21001
 * @param $str input string
 * @param $utf8 if null, function will detect input string encoding
 * @return string input string without accent
 */
/**
 * removeAccents()
 *
 * @param string $str
 * @param bool $utf8
 * @return
 */
function removeAccents($str, $utf8 = true) {
    $str = (string) $str;
    if (is_null($utf8)) {
        if (!function_exists('mb_detect_encoding')) {
            $utf8 = (strtolower(mb_detect_encoding($str)) == 'utf-8');
        } else {
            $length = strlen($str);
            $utf8 = true;

            for ($i = 0; $i < $length; $i++) {
                $c = ord($str[$i]);

                if ($c < 0x80) $n = 0; // 0bbbbbbb
                elseif (($c & 0xE0) == 0xC0) $n = 1; // 110bbbbb
                elseif (($c & 0xF0) == 0xE0) $n = 2; // 1110bbbb
                elseif (($c & 0xF8) == 0xF0) $n = 3; // 11110bbb
                elseif (($c & 0xFC) == 0xF8) $n = 4; // 111110bb
                elseif (($c & 0xFE) == 0xFC) $n = 5; // 1111110b
                else return false; // Does not match any model

                for ($j = 0; $j < $n; $j++) { // n bytes matching 10bbbbbb follow ?
                    if ((++$i == $length) || ((ord($str[$i]) & 0xC0) != 0x80)) {
                        $utf8 = false;
                        break;
                    }
                }
            }
        }
    }

    if (!$utf8) {
        $str = utf8_encode($str);
    }

    $transliteration = array(
        'Ã„Â²' => 'I', 'Ãƒâ€“' => 'O', 'Ã…â€™' => 'O', 'ÃƒÅ“' => 'U', 'ÃƒÂ¤' => 'a', 'ÃƒÂ¦' => 'a',
        'Ã„Â³' => 'i', 'ÃƒÂ¶' => 'o', 'Ã…â€œ' => 'o', 'ÃƒÂ¼' => 'u', 'ÃƒÅ¸' => 's', 'Ã…Â¿' => 's',
        'Ãƒâ‚¬' => 'A', 'ÃƒÂ' => 'A', 'Ãƒâ€š' => 'A', 'ÃƒÆ’' => 'A', 'Ãƒâ€ž' => 'A', 'Ãƒâ€¦' => 'A',
        'Ãƒâ€ ' => 'A', 'Ã„â‚¬' => 'A', 'Ã„â€ž' => 'A', 'Ã„â€š' => 'A', 'Ãƒâ€¡' => 'C', 'Ã„â€ ' => 'C',
        'Ã„Å’' => 'C', 'Ã„Ë†' => 'C', 'Ã„Å ' => 'C', 'Ã„Å½' => 'D', 'Ã„Â' => 'D', 'ÃƒË†' => 'E',
        'Ãƒâ€°' => 'E', 'Ãš' => 'E', 'Ãƒâ€¹' => 'E', 'Ã„â€™' => 'E', 'Ã„Ëœ' => 'E', 'Ã„Å¡' => 'E',
        'Ã„â€' => 'E', 'Ã„â€“' => 'E', 'Ã„Å“' => 'G', 'Ã„Å¾' => 'G', 'Ã„Â ' => 'G', 'Ã„Â¢' => 'G',
        'Ã„Â¤' => 'H', 'Ã„Â¦' => 'H', 'ÃƒÅ’' => 'I', 'ÃƒÂ' => 'I', 'ÃƒÅ½' => 'I', 'ÃƒÂ' => 'I',
        'Ã„Âª' => 'I', 'Ã„Â¨' => 'I', 'Ã„Â¬' => 'I', 'Ã„Â®' => 'I', 'Ã„Â°' => 'I', 'Ã„Â´' => 'J',
        'Ã„Â¶' => 'K', 'Ã„Â½' => 'K', 'Ã„Â¹' => 'K', 'Ã„Â»' => 'K', 'Ã„Â¿' => 'K', 'Ã…Â' => 'L',
        'Ãƒâ€˜' => 'N', 'Ã…Æ’' => 'N', 'Ã…â€¡' => 'N', 'Ã…â€¦' => 'N', 'Ã…Å ' => 'N', 'Ãƒâ€™' => 'O',
        'Ãƒâ€œ' => 'O', 'Ãƒâ€' => 'O', 'Ãƒâ€¢' => 'O', 'ÃƒËœ' => 'O', 'Ã…Å’' => 'O', 'Ã…Â' => 'O',
        'Ã…Å½' => 'O', 'Ã…â€' => 'R', 'Ã…Ëœ' => 'R', 'Ã…â€“' => 'R', 'Ã…Å¡' => 'S', 'Ã…Å¾' => 'S',
        'Ã…Å“' => 'S', 'ÃˆËœ' => 'S', 'Ã…Â ' => 'S', 'Ã…Â¤' => 'T', 'Ã…Â¢' => 'T', 'Ã…Â¦' => 'T',
        'ÃˆÅ¡' => 'T', 'Ãƒâ„¢' => 'U', 'Ãš' => 'U', 'Ãƒâ€º' => 'U', 'Ã…Âª' => 'U', 'Ã…Â®' => 'U',
        'Ã…Â°' => 'U', 'Ã…Â¬' => 'U', 'Ã…Â¨' => 'U', 'Ã…Â²' => 'U', 'Ã…Â´' => 'W', 'Ã…Â¶' => 'Y',
        'Ã…Â¸' => 'Y', 'ÃƒÂ' => 'Y', 'Ã…Â¹' => 'Z', 'Ã…Â»' => 'Z', 'Ã…Â½' => 'Z', 'ÃƒÂ ' => 'a',
        'Ã¡' => 'a', 'ÃƒÂ¢' => 'a', 'ÃƒÂ£' => 'a', 'Ã„Â' => 'a', 'Ã„â€¦' => 'a', 'Ã„Æ’' => 'a',
        'ÃƒÂ¥' => 'a', 'ÃƒÂ§' => 'c', 'Ã„â€¡' => 'c', 'Ã„Â' => 'c', 'Ã„â€°' => 'c', 'Ã„â€¹' => 'c',
        'Ã„Â' => 'd', 'Ã„â€˜' => 'd', 'ÃƒÂ¨' => 'e', 'Ã©' => 'e', 'ÃƒÂª' => 'e', 'ÃƒÂ«' => 'e',
        'Ã„â€œ' => 'e', 'Ã„â„¢' => 'e', 'Ã„â€º' => 'e', 'Ã„â€¢' => 'e', 'Ã„â€”' => 'e', 'Ã†â€™' => 'f',
        'Ã„Â' => 'g', 'Ã„Å¸' => 'g', 'Ã„Â¡' => 'g', 'Ã„Â£' => 'g', 'Ã„Â¥' => 'h', 'Ã„Â§' => 'h',
        'ÃƒÂ¬' => 'i', 'Ã­' => 'i', 'ÃƒÂ®' => 'i', 'ÃƒÂ¯' => 'i', 'Ã„Â«' => 'i', 'Ã„Â©' => 'i',
        'Ã„Â­' => 'i', 'Ã„Â¯' => 'i', 'Ã„Â±' => 'i', 'Ã„Âµ' => 'j', 'Ã„Â·' => 'k', 'Ã„Â¸' => 'k',
        'Ã…â€š' => 'l', 'Ã„Â¾' => 'l', 'Ã„Âº' => 'l', 'Ã„Â¼' => 'l', 'Ã…â‚¬' => 'l', 'Ã±' => 'n',
        'Ã…â€ž' => 'n', 'Ã…Ë†' => 'n', 'Ã…â€ ' => 'n', 'Ã…â€°' => 'n', 'Ã…â€¹' => 'n', 'ÃƒÂ²' => 'o',
        'Ã³' => 'o', 'ÃƒÂ´' => 'o', 'ÃƒÂµ' => 'o', 'ÃƒÂ¸' => 'o', 'Ã…Â' => 'o', 'Ã…â€˜' => 'o',
        'Ã…Â' => 'o', 'Ã…â€¢' => 'r', 'Ã…â„¢' => 'r', 'Ã…â€”' => 'r', 'Ã…â€º' => 's', 'Ã…Â¡' => 's',
        'Ã…Â¥' => 't', 'ÃƒÂ¹' => 'u', 'Ãº' => 'u', 'ÃƒÂ»' => 'u', 'Ã…Â«' => 'u', 'Ã…Â¯' => 'u',
        'Ã…Â±' => 'u', 'Ã…Â­' => 'u', 'Ã…Â©' => 'u', 'Ã…Â³' => 'u', 'Ã…Âµ' => 'w', 'ÃƒÂ¿' => 'y',
        'ÃƒÂ½' => 'y', 'Ã…Â·' => 'y', 'Ã…Â¼' => 'z', 'Ã…Âº' => 'z', 'Ã…Â¾' => 'z', 'ÃŽâ€˜' => 'A',
        'ÃŽâ€ ' => 'A', 'Ã¡Â¼Ë†' => 'A', 'Ã¡Â¼â€°' => 'A', 'Ã¡Â¼Å ' => 'A', 'Ã¡Â¼â€¹' => 'A', 'Ã¡Â¼Å’' => 'A',
        'Ã¡Â¼Â' => 'A', 'Ã¡Â¼Å½' => 'A', 'Ã¡Â¼Â' => 'A', 'Ã¡Â¾Ë†' => 'A', 'Ã¡Â¾â€°' => 'A', 'Ã¡Â¾Å ' => 'A',
        'Ã¡Â¾â€¹' => 'A', 'Ã¡Â¾Å’' => 'A', 'Ã¡Â¾Â' => 'A', 'Ã¡Â¾Å½' => 'A', 'Ã¡Â¾Â' => 'A', 'Ã¡Â¾Â¸' => 'A',
        'Ã¡Â¾Â¹' => 'A', 'Ã¡Â¾Âº' => 'A', 'Ã¡Â¾Â¼' => 'A', 'ÃŽâ€™' => 'B', 'ÃŽâ€œ' => 'G', 'ÃŽâ€' => 'D',
        'ÃŽâ€¢' => 'E', 'ÃŽË†' => 'E', 'Ã¡Â¼Ëœ' => 'E', 'Ã¡Â¼â„¢' => 'E', 'Ã¡Â¼Å¡' => 'E', 'Ã¡Â¼â€º' => 'E',
        'Ã¡Â¼Å“' => 'E', 'Ã¡Â¼Â' => 'E', 'Ã¡Â¿Ë†' => 'E', 'ÃŽâ€“' => 'Z', 'ÃŽâ€”' => 'I', 'ÃŽâ€°' => 'I',
        'Ã¡Â¼Â¨' => 'I', 'Ã¡Â¼Â©' => 'I', 'Ã¡Â¼Âª' => 'I', 'Ã¡Â¼Â«' => 'I', 'Ã¡Â¼Â¬' => 'I', 'Ã¡Â¼Â­' => 'I',
        'Ã¡Â¼Â®' => 'I', 'Ã¡Â¼Â¯' => 'I', 'Ã¡Â¾Ëœ' => 'I', 'Ã¡Â¾â„¢' => 'I', 'Ã¡Â¾Å¡' => 'I', 'Ã¡Â¾â€º' => 'I',
        'Ã¡Â¾Å“' => 'I', 'Ã¡Â¾Â' => 'I', 'Ã¡Â¾Å¾' => 'I', 'Ã¡Â¾Å¸' => 'I', 'Ã¡Â¿Å ' => 'I', 'Ã¡Â¿Å’' => 'I',
        'ÃŽËœ' => 'T', 'ÃŽâ„¢' => 'I', 'ÃŽÅ ' => 'I', 'ÃŽÂª' => 'I', 'Ã¡Â¼Â¸' => 'I', 'Ã¡Â¼Â¹' => 'I',
        'Ã¡Â¼Âº' => 'I', 'Ã¡Â¼Â»' => 'I', 'Ã¡Â¼Â¼' => 'I', 'Ã¡Â¼Â½' => 'I', 'Ã¡Â¼Â¾' => 'I', 'Ã¡Â¼Â¿' => 'I',
        'Ã¡Â¿Ëœ' => 'I', 'Ã¡Â¿â„¢' => 'I', 'Ã¡Â¿Å¡' => 'I', 'ÃŽÅ¡' => 'K', 'ÃŽâ€º' => 'L', 'ÃŽÅ“' => 'M',
        'ÃŽÂ' => 'N', 'ÃŽÅ¾' => 'K', 'ÃŽÅ¸' => 'O', 'ÃŽÅ’' => 'O', 'Ã¡Â½Ë†' => 'O', 'Ã¡Â½â€°' => 'O',
        'Ã¡Â½Å ' => 'O', 'Ã¡Â½â€¹' => 'O', 'Ã¡Â½Å’' => 'O', 'Ã¡Â½Â' => 'O', 'Ã¡Â¿Â¸' => 'O', 'ÃŽÂ ' => 'P',
        'ÃŽÂ¡' => 'R', 'Ã¡Â¿Â¬' => 'R', 'ÃŽÂ£' => 'S', 'ÃŽÂ¤' => 'T', 'ÃŽÂ¥' => 'Y', 'ÃŽÅ½' => 'Y',
        'ÃŽÂ«' => 'Y', 'Ã¡Â½â„¢' => 'Y', 'Ã¡Â½â€º' => 'Y', 'Ã¡Â½Â' => 'Y', 'Ã¡Â½Å¸' => 'Y', 'Ã¡Â¿Â¨' => 'Y',
        'Ã¡Â¿Â©' => 'Y', 'Ã¡Â¿Âª' => 'Y', 'ÃŽÂ¦' => 'F', 'ÃŽÂ§' => 'X', 'ÃŽÂ¨' => 'P', 'ÃŽÂ©' => 'O',
        'ÃŽÂ' => 'O', 'Ã¡Â½Â¨' => 'O', 'Ã¡Â½Â©' => 'O', 'Ã¡Â½Âª' => 'O', 'Ã¡Â½Â«' => 'O', 'Ã¡Â½Â¬' => 'O',
        'Ã¡Â½Â­' => 'O', 'Ã¡Â½Â®' => 'O', 'Ã¡Â½Â¯' => 'O', 'Ã¡Â¾Â¨' => 'O', 'Ã¡Â¾Â©' => 'O', 'Ã¡Â¾Âª' => 'O',
        'Ã¡Â¾Â«' => 'O', 'Ã¡Â¾Â¬' => 'O', 'Ã¡Â¾Â­' => 'O', 'Ã¡Â¾Â®' => 'O', 'Ã¡Â¾Â¯' => 'O', 'Ã¡Â¿Âº' => 'O',
        'Ã¡Â¿Â¼' => 'O', 'ÃŽÂ±' => 'a', 'ÃŽÂ¬' => 'a', 'Ã¡Â¼â‚¬' => 'a', 'Ã¡Â¼Â' => 'a', 'Ã¡Â¼â€š' => 'a',
        'Ã¡Â¼Æ’' => 'a', 'Ã¡Â¼â€ž' => 'a', 'Ã¡Â¼â€¦' => 'a', 'Ã¡Â¼â€ ' => 'a', 'Ã¡Â¼â€¡' => 'a', 'Ã¡Â¾â‚¬' => 'a',
        'Ã¡Â¾Â' => 'a', 'Ã¡Â¾â€š' => 'a', 'Ã¡Â¾Æ’' => 'a', 'Ã¡Â¾â€ž' => 'a', 'Ã¡Â¾â€¦' => 'a', 'Ã¡Â¾â€ ' => 'a',
        'Ã¡Â¾â€¡' => 'a', 'Ã¡Â½Â°' => 'a', 'Ã¡Â¾Â°' => 'a', 'Ã¡Â¾Â±' => 'a', 'Ã¡Â¾Â²' => 'a', 'Ã¡Â¾Â³' => 'a',
        'Ã¡Â¾Â´' => 'a', 'Ã¡Â¾Â¶' => 'a', 'Ã¡Â¾Â·' => 'a', 'ÃŽÂ²' => 'b', 'ÃŽÂ³' => 'g', 'ÃŽÂ´' => 'd',
        'ÃŽÂµ' => 'e', 'ÃŽÂ­' => 'e', 'Ã¡Â¼Â' => 'e', 'Ã¡Â¼â€˜' => 'e', 'Ã¡Â¼â€™' => 'e', 'Ã¡Â¼â€œ' => 'e',
        'Ã¡Â¼â€' => 'e', 'Ã¡Â¼â€¢' => 'e', 'Ã¡Â½Â²' => 'e', 'ÃŽÂ¶' => 'z', 'ÃŽÂ·' => 'i', 'ÃŽÂ®' => 'i',
        'Ã¡Â¼Â ' => 'i', 'Ã¡Â¼Â¡' => 'i', 'Ã¡Â¼Â¢' => 'i', 'Ã¡Â¼Â£' => 'i', 'Ã¡Â¼Â¤' => 'i', 'Ã¡Â¼Â¥' => 'i',
        'Ã¡Â¼Â¦' => 'i', 'Ã¡Â¼Â§' => 'i', 'Ã¡Â¾Â' => 'i', 'Ã¡Â¾â€˜' => 'i', 'Ã¡Â¾â€™' => 'i', 'Ã¡Â¾â€œ' => 'i',
        'Ã¡Â¾â€' => 'i', 'Ã¡Â¾â€¢' => 'i', 'Ã¡Â¾â€“' => 'i', 'Ã¡Â¾â€”' => 'i', 'Ã¡Â½Â´' => 'i', 'Ã¡Â¿â€š' => 'i',
        'Ã¡Â¿Æ’' => 'i', 'Ã¡Â¿â€ž' => 'i', 'Ã¡Â¿â€ ' => 'i', 'Ã¡Â¿â€¡' => 'i', 'ÃŽÂ¸' => 't', 'ÃŽÂ¹' => 'i',
        'ÃŽÂ¯' => 'i', 'ÃÅ ' => 'i', 'ÃŽÂ' => 'i', 'Ã¡Â¼Â°' => 'i', 'Ã¡Â¼Â±' => 'i', 'Ã¡Â¼Â²' => 'i',
        'Ã¡Â¼Â³' => 'i', 'Ã¡Â¼Â´' => 'i', 'Ã¡Â¼Âµ' => 'i', 'Ã¡Â¼Â¶' => 'i', 'Ã¡Â¼Â·' => 'i', 'Ã¡Â½Â¶' => 'i',
        'Ã¡Â¿Â' => 'i', 'Ã¡Â¿â€˜' => 'i', 'Ã¡Â¿â€™' => 'i', 'Ã¡Â¿â€“' => 'i', 'Ã¡Â¿â€”' => 'i', 'ÃŽÂº' => 'k',
        'ÃŽÂ»' => 'l', 'ÃŽÂ¼' => 'm', 'ÃŽÂ½' => 'n', 'ÃŽÂ¾' => 'k', 'ÃŽÂ¿' => 'o', 'ÃÅ’' => 'o',
        'Ã¡Â½â‚¬' => 'o', 'Ã¡Â½Â' => 'o', 'Ã¡Â½â€š' => 'o', 'Ã¡Â½Æ’' => 'o', 'Ã¡Â½â€ž' => 'o', 'Ã¡Â½â€¦' => 'o',
        'Ã¡Â½Â¸' => 'o', 'Ãâ‚¬' => 'p', 'ÃÂ' => 'r', 'Ã¡Â¿Â¤' => 'r', 'Ã¡Â¿Â¥' => 'r', 'ÃÆ’' => 's',
        'Ãâ€š' => 's', 'Ãâ€ž' => 't', 'Ãâ€¦' => 'y', 'ÃÂ' => 'y', 'Ãâ€¹' => 'y', 'ÃŽÂ°' => 'y',
        'Ã¡Â½Â' => 'y', 'Ã¡Â½â€˜' => 'y', 'Ã¡Â½â€™' => 'y', 'Ã¡Â½â€œ' => 'y', 'Ã¡Â½â€' => 'y', 'Ã¡Â½â€¢' => 'y',
        'Ã¡Â½â€“' => 'y', 'Ã¡Â½â€”' => 'y', 'Ã¡Â½Âº' => 'y', 'Ã¡Â¿Â ' => 'y', 'Ã¡Â¿Â¡' => 'y', 'Ã¡Â¿Â¢' => 'y',
        'Ã¡Â¿Â¦' => 'y', 'Ã¡Â¿Â§' => 'y', 'Ãâ€ ' => 'f', 'Ãâ€¡' => 'x', 'ÃË†' => 'p', 'Ãâ€°' => 'o',
        'ÃÅ½' => 'o', 'Ã¡Â½Â ' => 'o', 'Ã¡Â½Â¡' => 'o', 'Ã¡Â½Â¢' => 'o', 'Ã¡Â½Â£' => 'o', 'Ã¡Â½Â¤' => 'o',
        'Ã¡Â½Â¥' => 'o', 'Ã¡Â½Â¦' => 'o', 'Ã¡Â½Â§' => 'o', 'Ã¡Â¾Â ' => 'o', 'Ã¡Â¾Â¡' => 'o', 'Ã¡Â¾Â¢' => 'o',
        'Ã¡Â¾Â£' => 'o', 'Ã¡Â¾Â¤' => 'o', 'Ã¡Â¾Â¥' => 'o', 'Ã¡Â¾Â¦' => 'o', 'Ã¡Â¾Â§' => 'o', 'Ã¡Â½Â¼' => 'o',
        'Ã¡Â¿Â²' => 'o', 'Ã¡Â¿Â³' => 'o', 'Ã¡Â¿Â´' => 'o', 'Ã¡Â¿Â¶' => 'o', 'Ã¡Â¿Â·' => 'o', 'ÃÂ' => 'A',
        'Ãâ€˜' => 'B', 'Ãâ€™' => 'V', 'Ãâ€œ' => 'G', 'Ãâ€' => 'D', 'Ãâ€¢' => 'E', 'ÃÂ' => 'E',
        'Ãâ€“' => 'Z', 'Ãâ€”' => 'Z', 'ÃËœ' => 'I', 'Ãâ„¢' => 'I', 'ÃÅ¡' => 'K', 'Ãâ€º' => 'L',
        'ÃÅ“' => 'M', 'ÃÂ' => 'N', 'ÃÅ¾' => 'O', 'ÃÅ¸' => 'P', 'ÃÂ ' => 'R', 'ÃÂ¡' => 'S',
        'ÃÂ¢' => 'T', 'ÃÂ£' => 'U', 'ÃÂ¤' => 'F', 'ÃÂ¥' => 'K', 'ÃÂ¦' => 'T', 'ÃÂ§' => 'C',
        'ÃÂ¨' => 'S', 'ÃÂ©' => 'S', 'ÃÂ«' => 'Y', 'ÃÂ­' => 'E', 'ÃÂ®' => 'Y', 'ÃÂ¯' => 'Y',
        'ÃÂ°' => 'A', 'ÃÂ±' => 'B', 'ÃÂ²' => 'V', 'ÃÂ³' => 'G', 'ÃÂ´' => 'D', 'ÃÂµ' => 'E',
        'Ã‘â€˜' => 'E', 'ÃÂ¶' => 'Z', 'ÃÂ·' => 'Z', 'ÃÂ¸' => 'I', 'ÃÂ¹' => 'I', 'ÃÂº' => 'K',
        'ÃÂ»' => 'L', 'ÃÂ¼' => 'M', 'ÃÂ½' => 'N', 'ÃÂ¾' => 'O', 'ÃÂ¿' => 'P', 'Ã‘â‚¬' => 'R',
        'Ã‘Â' => 'S', 'Ã‘â€š' => 'T', 'Ã‘Æ’' => 'U', 'Ã‘â€ž' => 'F', 'Ã‘â€¦' => 'K', 'Ã‘â€ ' => 'T',
        'Ã‘â€¡' => 'C', 'Ã‘Ë†' => 'S', 'Ã‘â€°' => 'S', 'Ã‘â€¹' => 'Y', 'Ã‘Â' => 'E', 'Ã‘Å½' => 'Y',
        'Ã‘Â' => 'Y', 'ÃƒÂ°' => 'd', 'ÃƒÂ' => 'D', 'ÃƒÂ¾' => 't', 'ÃƒÅ¾' => 'T', 'Ã¡Æ’Â' => 'a',
        'Ã¡Æ’â€˜' => 'b', 'Ã¡Æ’â€™' => 'g', 'Ã¡Æ’â€œ' => 'd', 'Ã¡Æ’â€' => 'e', 'Ã¡Æ’â€¢' => 'v', 'Ã¡Æ’â€“' => 'z',
        'Ã¡Æ’â€”' => 't', 'Ã¡Æ’Ëœ' => 'i', 'Ã¡Æ’â„¢' => 'k', 'Ã¡Æ’Å¡' => 'l', 'Ã¡Æ’â€º' => 'm', 'Ã¡Æ’Å“' => 'n',
        'Ã¡Æ’Â' => 'o', 'Ã¡Æ’Å¾' => 'p', 'Ã¡Æ’Å¸' => 'z', 'Ã¡Æ’Â ' => 'r', 'Ã¡Æ’Â¡' => 's', 'Ã¡Æ’Â¢' => 't',
        'Ã¡Æ’Â£' => 'u', 'Ã¡Æ’Â¤' => 'p', 'Ã¡Æ’Â¥' => 'k', 'Ã¡Æ’Â¦' => 'g', 'Ã¡Æ’Â§' => 'q', 'Ã¡Æ’Â¨' => 's',
        'Ã¡Æ’Â©' => 'c', 'Ã¡Æ’Âª' => 't', 'Ã¡Æ’Â«' => 'd', 'Ã¡Æ’Â¬' => 't', 'Ã¡Æ’Â­' => 'c', 'Ã¡Æ’Â®' => 'k',
        'Ã¡Æ’Â¯' => 'j', 'Ã¡Æ’Â°' => 'h',
    );

    return str_replace(array_keys($transliteration), array_values($transliteration), $str);
}

/**
 * filename_safe()
 *
 * @param string $fileName
 * @return string
 */
function filename_safe($fileName) {
    if(substr($fileName,0,1)=='.')
        $fileName='_'.substr($fileName,1);
    return str_replace(array(' ','(',')','-','*','?','!','|','`'.'Ã‚Â´','"',"'".'..'.DIRECTORY_SEPARATOR,DIRECTORY_SEPARATOR,"\\","/",'[',']','{','}')
        ,'_',removeAccents($fileName));
}
/**
 * filename_extension()
 *
 * @param mixed $fileName
 * @return
 */
function filename_extension($fileName) {
    $pos=strrchr($fileName,'.');
    if($pos===FALSE || $pos==$fileName)
        return '';
    return substr($pos,1);
}
/**
 * filename_extension_icon()
 *
 * @param string $fileName
 * @return string extension.gif
 */
function filename_extension_icon($fileName) {
global $gIApath;
    return  "$gIApath[WebPath]img/ext/". strtolower( filename_extension($fileName) ).".gif";
}

/**
 * error_last()
 *
 * @return
 */
function error_last() {
    if ( !function_exists('error_get_last'))
        return '';
    $tmp=error_get_last();
    if($tmp)
        return "Error($tmp[type]): $tmp[message] at $tmp[file] line $tmp[line]";
    else
        return '';
}
/**
 * debug_trace()
 *
 * @param string $start
 * @param string $sep
 * @param string $end
 * @return
 */
function debug_trace($start='<ol>',$sep='<li>',$end='</ol>') {
    if ( !function_exists('debug_backtrace'))
        return '';
    $tmp=  debug_backtrace();
    $ret=$start;
    if($tmp) foreach($tmp as $d)
        if($d['function']!='debug_trace')
            $ret.="$sep$d[function] ($d[line])";
    return $ret.$end;
}

/// ia_case specific
    global $gAppRelate;
    /**
     * gAppRelate_set()
     *
     * @return
     */
    function gAppRelate_set() {
    global $gAppRelate;
        if( !isset($gAppRelate) || empty($gAppRelate) )
            $gAppRelate=new appRelate();
    }
    /**
     * vale_where()
     *
     * @return
     */
    function vale_where() {

    }

    /**
     * form_doublepsot_is()
     *
     * @return
     */
    function form_doublepsot_is() {
        $timecode=param('iatimecode');
        if($timecode=='')
            return false;
        return ia_singleread("SELECT ya FROM iacase_doublesumbit WHERE timecode=".strit($timecode)." LIMIT 1")==1;
    }

    /**
     * form_doublepsot_set()
     *
     * @return
     */
    function form_doublepsot_set() {
        $timecode=param('iatimecode');
        if($timecode=='')
            return;
        ia_query("UPDATE iacase_doublesumbit SET ya=1 WHERE timecode=".strit($timecode)." LIMIT 1");
    }

    /**
     * array_val()
     * Regresa el valor de key en el array o default de no existir
     * @param string $key
     * @param array $array
     * @param mixed $default
     * @return mixed valor de $key en el array o $default de no existir
     */
    function array_val($key,$array,$default=false) {
        if(array_key_exists($key,$array))
            return $array[$key];
        return $default;
    }
    /**
     * array_key_set()
     *
     * @param mixed $atribute
     * @param mixed $value
     * @param mixed $arr
     * @param bool $append
     * @param string $separator
     * @return
     */
    function array_key_set($atribute,$value,&$arr,$append=false,$separator=' ') {
            if(!$append || !array_key_exists($atribute,$arr) )
                $arr[$atribute]=$value;
            else
                $arr[$atribute].=$separator.value;
    }

    /**
     * array_key_existsArr()
     *
     * @param mixed $keys
     * @param mixed $arr
     * @param bool $primerCall
     * @return
     */
    function array_key_existsArr($keys,$arr,$primerCall=true) {
        if(!is_array($arr))
            if($primerCall)
                echo "<li>array_key_existsArr arr not array</li>";
            else
                return false;
        if(!is_array($keys))
            return array_key_exists($keys,$arr);
        $key=array_shift($keys);
        if($key===NULL)
            return true;
        if(!array_key_exists($key,$arr))
            return false;
        if(empty($keys))
            return true;
        return array_key_existsArr($keys,$arr[$key],false);
    }

    /**
     * array_key_existsN()
     *
     * @return
     */
    function array_key_existsN() {
        $find=func_get_args();
        $len=sizeof($find);
//echo "<li>len=$len";
        if($len<=1)
            return "kaput";
        $arr=array_pop($find);
//        echo "<li>keys=".print_r($find,true)." arr=".print_r($arr,true)."</li>";
        return array_key_existsArr($find,$arr);
    }

    /**
     * date_limit()
     *
     * @param mixed $lim
     * @param mixed $base_date
     * @param bool $incluye_dom
     * @param bool $incluye_sab
     * @param bool $forzaInicioAno
     * @return
     */
    function date_limit($lim,$base_date=null,$incluye_dom=true,$incluye_sab=true,$forzaInicioAno=false) {
        if(empty($lim))
            return '';
        if( preg_match('/^[0-9]{4}\-(0[1-9]|1[0-2])\-(0[1-9]|[1-2][0-9]|3[0-1])$/', $lim)  )
            return $lim;
        $c1=substr($lim,0,1);
        if( is_numeric($c1) )
            return "$lim-01-01";
        // si es mysqldate regresalra

        if(empty($base_date))
           $base_date=Date('Y-m-d');
         $base_year=substr($base_date,0,4);


        $anos=$meses=$semanas=$dias=0;
        $tmp=explode(' ',$lim);
        if($tmp) foreach($tmp as $d) {
            $d=trim($d);
            if(strpos($d,'y')!==FALSE)
                $anos+=str_ireplace('y','',$d);
            elseif(strpos($d,'m')!==FALSE)
                $meses+=str_ireplace('m','',$d);
            elseif(strpos($d,'w')!==FALSE)
                $semanas+=str_ireplace('w','',$d);
            elseif(strpos($d,'d')!==FALSE)
                $dias+=str_ireplace('d','',$d);
            else
                $dias+=$d;
        }
        if(!is_numeric($anos))
            $anos=0;
        if(!is_numeric($meses))
            $meses=0;
        if(!is_numeric($semanas))
            $semanas=0;
        if(!is_numeric($dias))
            $diasem=0;

        $fecha=mktime(0,0,0,Date('n')+$meses,Date('j')+$dias+$semanas*7,$base_year+$anos);

        $incluye_dom=$incluye_sab=true;
        if(!$incluye_dom || !$incluye_sab) {
            $hoy=mktime(0,0,0,Date('n'),Date('j'),Date('Y'));
            if($hoy>$fecha)
                $days = round( ($fecha - $hoy) / 86400 ) + 1;
            else
                $days = round( ($hoy - $fecha) / 86400 ) + 1;
            $finsemana= (!$incluye_dom && !$incluye_sab) ? 2 : 1;
            $mas = floor($days / 7)*$finsemana;
            //if($days>=7)
            //    $mas += fmod($days, 7)*$finsemana;
            $diasem = date("w", $fecha);
            if($diasem==6 && !$incluye_sab)
                $mas++;
            if($diasem==6 && !$incluye_dom)
                $mas++;
            if($diasem==0 && !$incluye_dom)
                $mas++;
            $diasem = date("w", $hoy);
            if($diasem==6 && !$incluye_sab)
                $mas++;
            if($diasem==6 && !$incluye_dom)
                $mas++;
            if($diasem==0 && !$incluye_dom)
                $mas++;  ;
            $fecha=mktime(0,0,0,Date('n')+$meses,Date('j')+$dias+$semanas*7+$mas,$base_year+$anos);
        }

        if($forzaInicioAno)
            return Date('Y-01-01',$fecha);
        return Date('Y-m-d',$fecha);
    }

    /**
     * to_plural()
     *
     * @param mixed $word
     * @param bool $esMasculino
     * @return
     */
    function to_plural($word,$esMasculino=true) {
        $w=substr($word,-1);

        if(strcasecmp('.',$w)==0) //VCA
            return $word;

        if(    strcasecmp('a',$w)==0 || strcasecmp('e',$w)==0  || strcasecmp('i',$w)==0  || strcasecmp('o',$w)==0  || strcasecmp('u',$w)==0
            || strcasecmp('Ã¡',$w)==0 || strcasecmp('Ã©',$w)==0  || strcasecmp('Ã­',$w)==0  || strcasecmp('Ã³',$w)==0  || strcasecmp('Ãš',$w)==0
            || strcasecmp('y',$w)==0 || strcasecmp('w',$w)==0 )
            return $word.'s';
        if(strcasecmp('z',$w)==0)
            return substr($word,0,-1).'ces';
        $w2=substr($word,-2,1);
        if(strcasecmp('s',$w)==0 && ( strcasecmp('e',$w2)==0 || strcasecmp('u',$w2) ))
            return $word;
        if($esMasculino)
            return $word.'es';
        else
            return $word.'as';
    }

	/**
	 * to_label()
	 *
	 * @param mixed $fieldName
	 * @param bool $capWords
	 * @param bool $htmlentities
	 * @return
	 */
	function to_label( $fieldName,$capWords=true,$htmlentities=false ) {
        $ret=preg_replace(
            array('/\baccion\b/i','/\baleman\b/i','/\balmacen\b/i','/\bano\b/i','/\banos\b/i','/\barea\b/i','/\bareas\b/i','/\barticulo\b/i','/\barticulos\b/i'
                    ,'/\bbitacora\b/i','/\bbitacoras\b/i'
                    ,'/\bcalculo\b/i','/\bcaracter\b/i','/\bcatalogo\b/i','/\bcatalogos\b/i','/\bcodigo\b/i','/\bcomentario\b/i','/\bcompania\b/i','/\bcompanias\b/i','/\bcp\b/i'
                    ,'/\bdepostio\b/i','/\bdepostios\b/i','/\bdia\b/i','/\bdias\b/i','/\bdigito\b/i','/\bdigitos\b/i','/\bdolar\b/i','/\bdolares\b/i'
                    ,'/\beconomia\b/i','/\belectronica\b/i','/\belectronico\b/i','/\belectronicos\b/i','/\bespanol\b/i'
                    ,'/\binteres\b/i','/\bimagenes\b/i','/\bindice\b/i','/\bindices\b/i','/\bingles\b/i'
                    ,'/\bfabrica\b/i','/\bfrances\b/i','/\bfotografica\b/i'
                    ,'/\bgrafica\b/i'
                    ,'/\bhuesped\b/i'
                    ,'/\blimite\b/i'
                    ,'/\bmaquina\b/i','/\bmaquinas\b/i','/\bmaximo\b/i','/\bmaximos\b/i','/\bmecancia\b/i','/\bmedico\b/i','/\bmexico\b/i','/\bmiercoles\b/i','/\bminimo\b/i','/\bminimos\b/i','/\bmusica\b/i'
                    ,'/\bnumero\b/i','/\bnumeros\b/i'
                    ,'/\bpagina\b/i','/\bpaginas\b/i','/\bpais\b/i','/\bpaises\b/i','/\bparticula\b/i','/\bpelicula\b/i','/\bpie\b/i','/\bpolitica\b/i','/\bportuges\b/i','/\bpublico\b/i'
                    ,'/\brazon\b/i','/\bresumen\b/i'
                    ,'/\bsabado\b/i'
                    ,'/\btecnica\b/i','/\btelefono\b/i','/\btelefonos\b/i','/\btio\b/i','/\btitulo\b/i','/\btitulos\b/i','/\btunel\b/i'
                    ,'/\bunica\b/i','/\bunico\b/i','/\bultimo\b/i','/\bultimos\b/i','/\bultima\b/i','/\bultimas\b/i'
                    ,'/\busuario\b/i'
                    ,'/ion\b/i'
                   )
            ,array('acciÃ³n','alemÃ¡n','almacÃ©n','aÃ±o','aÃ±os','Ã¡rea','Ã¡reas','artÃ­culo','artÃ­culos'
                ,'bitÃ¡cora','bitÃ¡coras'
                ,'cÃ¡lculo','caractÃ©r','catÃ¡logo','catÃ¡logos','cÃ³digo','comentario','compaÃ±Ã­a','compaÃ±ias','C.P.'
                ,'depÃ³sito','depÃ³sitos','dÃ­a','dÃ­as','dÃ­gito','dÃ­gitos','dÃ³lar','dÃ³lares'
                ,'economÃ­a','electrÃ³nica','electrÃ³nico','electrÃ³nicos','espaÃ±ol'
                ,'interÃ©s','imÃ¡genes','Ã­ndice','Ã­ndices','inglÃ©s'
                ,'fÃ¡brica','frÃ¡nces','fotogrÃ¡fica'
                ,'grÃ¡fica'
                ,'huÃ©sped'
                ,'lÃ­mite'
                ,'mÃ¡quina','mÃ¡quinas','mÃ¡ximo','mÃ¡ximos','mecÃ¡nica','mÃ©dico','MÃ©xico','miÃ©rcoles','mÃ­nimo','mÃ­nimos','mÃºsica'
                ,'nÃºmero','nÃºmeros'
               ,'pÃ¡gina','pÃ¡ginas','paÃ­s','paises','partÃ­cula','pelÃ­cula','piÃ©','polÃ­tica','portuguÃ©s','pÃºblico'
               ,'razon','resumen'
               ,'sÃ¡bado'
               ,'tecnica','telÃ©fono','telÃ©fonos','tio','tÃ­tulo','tÃ­tulos','tÃºnel'
               ,'Ãšnica','Ãšnico','Ãšltimo','Ãšltimos','Ãšltima','Ãšltimas'
               ,'usuario'
               ,'iÃ³n'
            )
            ,preg_replace(
                array('/^idioma_/','/^kv_/','/^iac_/','/_id$/','/_/')
                ,array('','','','',' ')
                ,$fieldName
            )
        );
        if($ret=='usuariÃ³')
            $ret='usuario';
        if($ret=='comentariÃ³')
            $ret='comentario';
        if($ret=='rfc' || $ret=='curp' || $ret=='imss' || $ret=='cp')
            return strtoupper($ret);
        if($capWords)
            $ret=ucwords($ret);
        if($htmlentities)
            return ia_htmlentities( str_replace( array(' De ',' A ',' Del ',' Al ',' El ',' La ',' Las ',' Los '), array(' de ',' a ',' del ', ' al ', ' el ',' la ',' las ',' los '),$ret ) );
        else
            return str_replace( array(' De ',' A ',' Del ',' Al ',' El ',' La ',' Las ',' Los '), array(' de ',' a ',' del ', ' al ', ' el ',' la ',' las ',' los '),$ret );
}

/**
 * comb()
 * genera todas las combinaciones de los elementos del array
 * nota ya no se usa pues no soporta una tabla tan grande el eviews
 * @param array $a
 * @return
 */
function comb($a) {
    $len  = count($a);
    $list = array();
    $k=1;
    $iLim=pow(2,$len);
    for($i = 1; $i < $iLim; $i++) {
        $c = '';
        for($j = 0; $j < $len; $j++) {
            //if($i & (1 << $j))
            if($i & pow(2,$j))
                $c .= $a[$j];
        }
        $list[] = $c;
    }
    return $list;
}

if (!function_exists('mysqlDate2display')) {
    function mysqlDate2display($date) {
    global $gIAData;
        if(empty($date) || $date=='0000-00-00' )
            return '';
        if(strlen($date)==19)
            return mysqlDateTime2display($date);
        try { return substr($date,8,2).'/'.$gIAData['monthShort'][substr($date,5,2)+0].'/'.substr($date,2,2); } catch(Exception $e) { return $date; }
    }
}
if (!function_exists('mysqlDateTime2display')) {
    function mysqlDateTime2display($date) {
    global $gIAData;
        if(empty($date) || $date=='0000-00-00 00:00:00')
            return '';
        if(strlen($date)==19)
            try { return substr($date,8,2).'/'.$gIAData['monthShort'][substr($date,5,2)+0].'/'.substr($date,2,2).' '.substr($date,10,6); } catch(Exception $e) { return $date; }
         return $date;
    }
}


    function ia_mktime_day($month,$day,$year) {
        $t=mktime(0,0,0,$month,$day,$year);
        if(Date('H:i:s',$t)=='00:00:00')
            return $t;
        $z=date('Z',$t);
        return $t+$z;
    }

if (!function_exists('mysqlDateToTimeStamp')) {
    function mysqlDateToTimeStamp($fecha) {
        if(is_numeric($fecha))
            return $fecha;
        return ia_mktime_day(substr($fecha,5,2),substr($fecha,8,2),substr($fecha,0,4));
    }
}

function ia_capitalize($s) {
    $pattern = array( '\.'=>'. ', '\,'=>', '  ,';'=>'; ', ':'=>': ', '"'=>'" ', "'"=>"' ", '\-'=>' - ','/'=>' / '  );
    foreach($pattern as $f=>$r)
        $s = ia_mb_ereg_replace($f, $r, $s);
    $s=mb_convert_case($s, MB_CASE_TITLE);
    $no_capitilize=array('de','del','la','las','los','el','Ã©l','en','y','e','o','mas','mÃ¡s');
    foreach($no_capitilize as $f)
        $s = preg_replace('/\s+'.$f.'([\s\.])/i', " $f$1 ", $s);
    $s=ia_mb_ereg_replace('\s+',' ',$s);
    return $s;
}
function ia_mb_ereg_replace($pattern,$replace,$string) {
    $tmp=mb_ereg_replace($pattern,$replace,$string);
    if($tmp===FALSE)
        return $string;
    return $tmp;
}
function ia_mb_eregi_replace($pattern,$replace,$string) {
    $tmp=mb_eregi_replace($pattern,$replace,$string);
    if($tmp===FALSE)
        return $string;
    return $tmp;
}

function trim_line($s) {
    return preg_replace("/[\s\t\r\n][\s\t\r\n]*/",' ',trim($s));
}


/**
     * This file is part of the array_column library
     *
     * For the full copyright and license information, please view the LICENSE
     * file that was distributed with this source code.
     *
     * @copyright Copyright (c) 2013 Ben Ramsey <http://benramsey.com>
     * @license http://opensource.org/licenses/MIT MIT
     */

    if (!function_exists('array_column')) {

        /**
         * Returns the values from a single column of the input array, identified by
         * the $columnKey.
         *
         * Optionally, you may provide an $indexKey to index the values in the returned
         * array by the values from the $indexKey column in the input array.
         *
         * @param array $input A multi-dimensional array (record set) from which to pull
         *                     a column of values.
         * @param mixed $columnKey The column of values to return. This value may be the
         *                         integer key of the column you wish to retrieve, or it
         *                         may be the string key name for an associative array.
         * @param mixed $indexKey (Optional.) The column to use as the index/keys for
         *                        the returned array. This value may be the integer key
         *                        of the column, or it may be the string key name.
         * @return array
         */
        function array_column($input = null, $columnKey = null, $indexKey = null)
        {
            // Using func_get_args() in order to check for proper number of
            // parameters and trigger errors exactly as the built-in array_column()
            // does in PHP 5.5.
            $argc = func_num_args();
            $params = func_get_args();

            if ($argc < 2) {
                trigger_error("array_column() expects at least 2 parameters, {$argc} given", E_USER_WARNING);
                return null;
            }

            if (!is_array($params[0])) {
                trigger_error('array_column() expects parameter 1 to be array, ' . gettype($params[0]) . ' given', E_USER_WARNING);
                return null;
            }

            if (!is_int($params[1])
                && !is_float($params[1])
                && !is_string($params[1])
                && $params[1] !== null
                && !(is_object($params[1]) && method_exists($params[1], '__toString'))
            ) {
                trigger_error('array_column(): The column key should be either a string or an integer', E_USER_WARNING);
                return false;
            }

            if (isset($params[2])
                && !is_int($params[2])
                && !is_float($params[2])
                && !is_string($params[2])
                && !(is_object($params[2]) && method_exists($params[2], '__toString'))
            ) {
                trigger_error('array_column(): The index key should be either a string or an integer', E_USER_WARNING);
                return false;
            }

            $paramsInput = $params[0];
            $paramsColumnKey = ($params[1] !== null) ? (string) $params[1] : null;

            $paramsIndexKey = null;
            if (isset($params[2])) {
                if (is_float($params[2]) || is_int($params[2])) {
                    $paramsIndexKey = (int) $params[2];
                } else {
                    $paramsIndexKey = (string) $params[2];
                }
            }

            $resultArray = array();

            foreach ($paramsInput as $row) {

                $key = $value = null;
                $keySet = $valueSet = false;

                if ($paramsIndexKey !== null && array_key_exists($paramsIndexKey, $row)) {
                    $keySet = true;
                    $key = (string) $row[$paramsIndexKey];
                }

                if ($paramsColumnKey === null) {
                    $valueSet = true;
                    $value = $row;
                } elseif (is_array($row) && array_key_exists($paramsColumnKey, $row)) {
                    $valueSet = true;
                    $value = $row[$paramsColumnKey];
                }

                if ($valueSet) {
                    if ($keySet) {
                        $resultArray[$key] = $value;
                    } else {
                        $resultArray[] = $value;
                    }
                }

            }

            return $resultArray;
        }

    }
function close_session() {
    // close_session();
    // session_write_close();
}

?>