<?php
/**
 * @author Informatica Asociada
 * @copyright 2013
 * @version 1.2013.3.0
 * 
 * FALTA
 *    
 *      crear workflow en worfklow termina en ....
 *      list workflows por crear y su accion
 *      conectar a borrar
 */

class iaworkflow {
    protected $para=null; // array con tables tienen workflow
    protected $sabado_feriado=true; // true 
    protected $domingo_feriado=true;
    public $feriados=array();
    public $control=array();
    public $semana_santa=array(); // guarda año=>viernes, se llena con $this->semana_santa_llena(año) agregando a $this->feriados;
    
    function __construct() { }
    
////////////////
// Detecta si dispara
/////////////// 
    public function trigger_paso_termina($paso,$status) {     
        $table=ia_singleread("SELECT paso FROM workflow_paso WHERE workflow_paso_id=".strit( $paso->enDB['worfklow_para_id']));
        if(!$this->tiene($table))          
            return false;
        $triggers=$this->triggers_read($table);
        $iacase=null;
        $ret=false;
        foreach($triggers as $trigger_id=>$t)
            if( strcasecmp( $t['disparador'],$status)==0 ) {
                if($iacase===null) {
                    $tmp="app_$table";
                    $iacase=new $tmp();
                    $iacase->h='r';
                    $iacase->id=$paso->enDB['iac_document_id'];
                    $iacase->read_sql();                    
                }
                $ret|=$this->workflow_crea_triggered($iacase,$iacase->enDB['alta_por'],$t,true);
            }
        return $ret;
    }
    
    public function trigger_document_alta($iacase,$values_changed) {        
        $table=$iacase->table;
       
        if(!$this->tiene($table))          
            return false;
        $triggers=$this->triggers_read($table);
        if(empty($triggers))
            return false;                    
        $tabla=$iacase->table;
        $creador_doc=$iacase->array_val('alta_por',$iacase->values, $_SESSION[USER]);
        $log='';

        $ret=false;
       
        foreach($triggers as $trigger_id=>$t)
            if( strcasecmp( $t['disparador'],'Alta')==0 ) {                 
                $ret|=$this->workflow_crea_triggered($iacase,$creador_doc,$t,true);  
            } elseif(strcasecmp( $t['disparador'],'Alta con: Dato - Valor')==0 && $this->dato_dispara($iacase,$t,$values_changed) ) {
                $ret|=$this->workflow_crea_triggered($iacase,$creador_doc,$t,true);
            }
        if(!empty($log))
            $iacase->log('workflow',$log);
        return $ret;
    }

    public function trigger_document_guarda($iacase,$values_changed) {        
        $table=$iacase->table;
        if(!$this->tiene($table))          
            return false;
        $triggers=$this->triggers_read($table);
        if(empty($triggers))
            return false;                    
        $tabla=$iacase->table;
        $creador_doc=$iacase->array_val('alta_por',$iacase->values, $_SESSION[USER]);
        $log='';

        $ret=false;
        foreach($triggers as $trigger_id=>$t)
            if(strcasecmp( $t['disparador'],'Guarda con: Dato - Valor')==0 && $this->dato_dispara($iacase,$t,$values_changed) ) {
                $ret|=$this->workflow_crea_triggered($iacase,$creador_doc,$t,true);
            }
        if(!empty($log))
            $iacase->log('workflow',$log);
        return $ret;
    }
    
    function dato_dispara($iacase,$trigger,$values_changed) {
        $dato=$trigger['dato'];
        if(!array_key_exists($dato,$values_changed))
            return false;
        
        if(!array_key_exists($dato,$iacase->campos)) {
            $iacase->msg_err.='<li>'.to_label($dato).' inválido, ya no existe en el documento, arregle el workflow trigger: '.ia_htmlentities($trigger['nombre']);
            return false;
        }
        $cond=$trigger['condicion'];
        if($cond=='entre') 
            return $trigger['valor'] <= $dato && $dato >= $trigger['valor_hasta'];
        if($cond=='fuera del rango') 
            return $trigger['valor'] >= $dato || $dato <= $trigger['valor_hasta'];
        if($cond=='=')
            return $trigger['valor'] == $dato;    
        if($cond=='<')
            return $trigger['valor'] < $dato;
        if($cond=='<=')
            return $trigger['valor'] <= $dato;
        if($cond=='>')
            return $trigger['valor'] > $dato;
        if($cond=='>=')
            return $trigger['valor'] >= $dato;
        if($cond=='<>')
            return $trigger['valor'] != $dato;                                                                  
        return false;
    }
    
////////////////
// Crea el workflow
///////////////
    
    public function workflow_crea_triggered($iacase,$creador,$trigger,$do_avisa_a) {
     
        $pasos=ia_sqlArray("SELECT * FROM workflow_template WHERE workflow_id=".strit($trigger['workflow_id'])." ORDER BY inicia desc, duracion",'workflow_template_id');
        if(empty($pasos)) {
            $iacase->msg_err.="<li>No se pudo crear el workflow ".ia_htmlentities($trigger['workflow'])." pues no tiene pasos definidos en su plantilla";
            return false;
        }
        
        $gerente=$trigger['iac_usr_gerente_id'];
        if(empty($creador))
            $creador=$_SESSION[USER_ID];
        if(!is_numeric($creador))
            $creador=ia_singleread("SELECT iac_usr_id FROM iac_usr WHERE vale='Active' AND nick=".strit($creador),$gerente);
                    
        if($do_avisa_a && $trigger['al_disparar']=='Avisa') {
            $avisa_a=$this->encargado($trigger['avisa_crear_a'],$trigger['iac_usr_avisa_id'],$gerente,$creador);
            return $this->workflow_avisa_crear($iacase,$creador,$trigger,$avisa_a);    
        }
        $this->feriados_llena();
        $log='';
        $corrida=ia_singleread("SELECT MAX(corrida) FROM workflow_paso WHERE workflow_id=".strit($trigger['workflow_id'])." AND iac_document_id=".strit($iacase->id),0 );
        $corrida++;

        $now=$this->pasa_a_habil( mysqlDateToTimeStamp(Date('Y-m-d')) );
        $sql=array();
        $arr=array();
        $arr['corrida']=$corrida;
        $arr['workflow_para_id']=$trigger['workflow_para_id'];
        $arr['iac_document_id']=$iacase->id;
        $arr['alta_db']='NOW()';
        $arr['alta_por']=$_SESSION[USER];
        $arr['ultimo_cambio']='NOW()';
        $arr['ultimo_cambio_por']=$_SESSION[USER];
        $arr['iac_last_edit_ip']=ip_get();
        $arr['workflow_id']=$trigger['workflow_id'];
        
        //$exclude_copy=array_merge( array_keys($arr),array('workflow_template_id','iac_usr_responsable_id','fecha_inico_programada','fecha_programada_fin') );
                    
        foreach($pasos as $k=>$p) { 
            $arr['actividad']=$p['actividad'];
            $arr['actividad_detalle']=$p['actividad_detalle'];
            $arr['adelanta_siguientes']=$p['adelanta_siguientes'];
            $arr['retrasa_siguientes']=$p['retrasa_siguientes'];
            $arr['termina_mal_finaliza_el_worfklow']=$p['termina_mal_finaliza_el_worfklow'];
            $arr['termina_ok_finaliza_el_worfklow']=$p['termina_ok_finaliza_el_worfklow'];
                        
            $arr['workflow_template_id']=$k;
            $arr['iac_usr_responsable_id']=$this->encargado($p['encarga_a'],$p['iac_usr_responsable_id'],$gerente,$creador);
            $arr['fecha_inicio_programada']=date('Y-m-d',$this->habil_mas_dias($now,$p['inicia']) );
            $arr['fecha_fin_programada']=date('Y-m-d',$this->habil_mas_dias($now,$p['inicia']+$p['duracion']) );
                        
            $sql[]=ia_insert('workflow_paso',$arr);
        }
        $ret= ia_transaction($sql);
        if(array_key_exists('msg',$trigger))
            $tmp="Proceso '".ia_htmlentities($trigger['workflow'])."' ".$trigger['msg']."' para ".$iacase->label_record();
        else
            $tmp="Proceso '".ia_htmlentities($trigger['workflow'])."' por trigger "."'".ia_htmlentities($trigger['nombre'])."' para ".$iacase->label_record();
        if($ret) {
            $log.="<li style='color:red'>No se pudo crear $tmp</li>";
            $iacase->msg_err.="<li style='color:red'>No se pudo crear $tmp</li>";
        } else {
            $log.="<li>Se crea $tmp";
            $iacase->msg_aviso.="<li>Se crea $tmp";
         }          
        if(!empty($log))
            $iacase->log('workflow',$log);        
        return $ret;
    }
    
    public function workflow_avisa_crear($iacase,$creador,$trigger,$avisa_a) {
        $avisa= array('iac_usr_responsable_id'=>$avisa_a,'workflow_id'=>$trigger['workflow_id'],'workflow_trigger_id'=>$trigger['workflow_trigger_id'],
            'workflow_para_id'=>$trigger['workflow_para_id'],'iac_document_id'=>$iacase->id,'causa'=>'','causado_por'=>$creador);
        $ret=ia_query( ia_insert('workflow_por_crear',$avisa) );
        if(array_key_exists('msg',$trigger))
            $tmp="Proceso '".ia_htmlentities($trigger['workflow'])."' ".$trigger['msg']."' para ".$iacase->label_record();
        else
            $tmp="Proceso '".ia_htmlentities($trigger['workflow'])."' por trigger "."'".ia_htmlentities($trigger['nombre'])."' para ".$iacase->label_record();
        if($ret) {
            $log.="<li style='color:red'>No se pudo avisar a ".ia_htmlentities($avisa_a)." que genere el $tmp</li>";
            $iacase->msg_err.="<li style='color:red'>No se pudo avisar a ".ia_htmlentities($avisa_a)." que genere el $tmp</li>";
        } else {
            $log.="<li>Se solicita a ".ia_htmlentities($avisa_a)." crear el $tmp";
            $iacase->msg_aviso.="<li>Se crea $tmp";
         }          
        if(!empty($log))
            $iacase->log('workflow',$log);        
        return $ret;        
    }
    
    public function encargado($encarga_a,$seleccionado,$gerente,$creador) {
        if(empty($seleccionado))
            $seleccionador=$_SESSION[USER_ID];
        if($encarga_a=='Seleccionar')
            return $seleccionado;
        if($encarga_a=='Gerente del workflow')
            return $gerente;
        if(empty($creador))
            $creador=$_SESSION[USER_ID];
        if(!is_numeric($creador))
            $creador=ia_singleread("SELECT iac_usr_id FROM iac_usr WHERE vale='Active' AND nick=".strit($creador),$gerente);
        if($encarga_a=='Jefe del creador del documento')
            return ia_singleread("SELECT iac_usr_idiac_usr_jefe_id FROM iac_usr WHERE vale='Active' AND iac_usr_id=".strit($creador),$gerente);   
        return $creador;
    }


////////////////
// Calculos fechas
///////////////    
    function habil_mas_dias($fecha,$dias) {
        $timestamp=$this->pasa_a_habil($fecha,($dias>=0));
        if($dias>=0)
            for($i=1;$i<=$dias;$i++)
                $timestamp=$this->pasa_a_habil( $timestamp + 86400,true );
        else
            for($i=$dias;$i<0;$i--)
                $timestamp=$this->pasa_a_habil( $timestamp - 86400,false );      
        return $timestamp;
    }
    
    function diff_dias_habiles($fecha1,$fecha2) {
        $f1=mysqlDateToTimeStamp($fecha1);
        $f2=mysqlDateToTimeStamp($fecha2);
        if($f1==$f2)
            return 0;
        $inc = $f1 < $f2 ? -1 : 1;
        if($f1>$f2) {
            $tmp=$f1;
            $f1=$f2;
            $f2=$tmp;
        }
        $dias=0;
        while($f1<$f2 || $dias>10000) {
            $dias++;
            $f1=$this->habil_mas_dias($f1,1);
        }
        return $inc*$dias;
    }

    function diff_dias_calendario($fecha1,$fecha2) {
        return floor((  mysqlDateToTimeStamp($fecha1) - mysqlDateToTimeStamp($fecha2) )/86400);
    }
        
    function pasa_a_habil($fecha,$adelante=true) {
        $tmp=$timestamp=mysqlDateToTimeStamp($fecha);
        $i=0;
        if($adelante) {
            while($tmp==$timestamp && $i++<300) {
                $tmp=$timestamp;
                if( $this->es_feriado($timestamp)  )
                    $timestamp += 86400;
            }               
        } else {
            while($tmp==$timestamp && $i++<300) {
                $tmp=$timestamp;
                if( $this->es_feriado($timestamp)  )
                    $timestamp -= 86400;
            }                               
        }
        return $timestamp;      
    }
        
    function es_feriado($fecha) {
        $timestamp=mysqlDateToTimeStamp($fecha);
        $iWeekday=Date('w',$timestamp); //0 (for Sunday) through 6 (for Saturday
        if($iWeekday==6 && $this->sabado_feriado)
            return true;
        if($iWeekday==0 && $this->domingo_feriado)
            return true;        
        $this->feriados_llena();
        $this->semana_santa_llena(Date('Y',$timestamp));
        if( empty ($this->feriados) )
            return false;
        foreach($this->feriados as $f=>$d) {
            if($d['es']=='Cada ano')
                $feriado=mysqlDateToTimeStamp(Date('Y',$timestamp).'-'.str_pad($d['mes'],2,'0',STR_PAD_LEFT).'-'.str_pad($d['mes'],2,'0',STR_PAD_LEFT));
            else
                $feriado=$d['timestamp'];
            if($d['es']=='Lunes mas cercano')
                $feriado=$this->lunes_mas_cercano($timestamp);
            if($timestamp==$feriado )               
                return true;
        }
        return false;
    }
    
    function lunes_mas_cercano($fecha) {
        $timestamp=mysqlDateToTimeStamp($fecha);
        $iWeekday=Date('w',$timestamp);
        if($iWeekday==1)
            return $timestamp;
        if($iWeekday==0)
            $iWeekday=7;
        if($iWeekday>=5)
            return $timestamp + (8-$iWeekday)*86400;
        return $timestamp - ($iWeekday-1)*86400;
    }

    public function dias_habiles($sabado_feriado=true,$domingo_feriado=true) {
        $this->sabado_feriado=$sabado_feriado;
        $this->domingo_feriado=$domingo_feriado;    
    }

    public function feriados_llena() {
        if(!$this->feriados==null)
            return;
        $this->feriados=ia_sqlArray("SELECT iac_feriado_id,ano,mes,dia,es,cuando FROM iac_feriado ORDER BY mes,dia",'iac_feriado_id');
        if($this->feriados) foreach($this->feriados as $k=>$d)
            if($d['es']!='Cada ano') {
                $this->feriados[$k]['fecha']=$d['ano'].'-'.str_pad($d['mes'],2,'0',STR_PAD_LEFT).'-'.str_pad($d['mes'],2,'0',STR_PAD_LEFT);
                $this->feriados[$k]['timestamp']=mysqlDateToTimeStamp($this->feriados[$k]['fecha']);
            }
        $this->control_llena();
        $this->semana_santa_llena(date('Y'));
    }   
     
    public function control_llena() {
        if(! empty($this->control))
            return;
        $this->control=ia_singleton("SELECT ".SQL_CACHE." * FROM iac_control WHERE iac_control_id=1");
    }
          
    function semana_santa_domingo($year) { return ia_mktime_day(3,21,$year) + easter_days($year)*86400; }
    
    function semana_santa_llena($year) {
        if(array_key_exists($year,$this->semana_santa))
            return;
        $this->control_llena();
            
        $this->semana_santa[$year]=$vie=$this->semana_santa_domingo($year)-2*86400;
        if($this->control['viernes_santo_feraido']=='Feriado') 
            $this->feriados[]=array('cuando'=>'Mismo Dia','es'=>'Mismo Dia','fecha'=>Date('Y-m-d',$vie),'timestamp'=>$vie,'motivo'=>'Viernes Santo' );
        $vie-=86400;
        if($this->control['jueves_santo_feraido']=='Feriado') 
            $this->feriados[]=array('cuando'=>'Mismo Dia','es'=>'Mismo Dia','fecha'=>Date('Y-m-d',$vie),'timestamp'=>$vie,'motivo'=>'Jueves Santo' );
        if($this->control['semana_santa_lu_a_mie']=='Feriado') {
            $vie-=86400;
            $this->feriados[]=array('cuando'=>'Mismo Dia','es'=>'Mismo Dia','fecha'=>Date('Y-m-d',$vie),'timestamp'=>$vie,'motivo'=>'Miércoles Semana Santa' );
            $vie-=86400;
            $this->feriados[]=array('cuando'=>'Mismo Dia','es'=>'Mismo Dia','fecha'=>Date('Y-m-d',$vie),'timestamp'=>$vie,'motivo'=>'Martes Semana Santa' );
            $vie-=86400;
            $this->feriados[]=array('cuando'=>'Mismo Dia','es'=>'Mismo Dia','fecha'=>Date('Y-m-d',$vie),'timestamp'=>$vie,'motivo'=>'Lunes Semana Santa' );
        }
    }
////////////////
// Auxliares
///////////////    
    public function triggers_read($table,$trigger_id=null) {
        $where= empty($trigger_id) ? '' : ' AND t.workflow_trigger_id='.strit($trigger_id); 
        return ia_sqlArray("SELECT ".SQL_CACHE." t.workflow_trigger_id,t.workflow_para_id,t.nombre,t.disparador,t.al_disparar,t.dato,t.condicion,t.valor,t.valor_hasta,t.avisa_crear_a,t.iac_usr_avisa_id
                ,w.workflow_id,w.workflow,w.iac_usr_gerente_id,w.responsable_proceso,w.iac_usr_responsable_id 
            FROM workflow_para p 
                JOIN workflow_trigger t ON p.workflow_para_id=t.workflow_para_id
                JOIN workflow_triggered u ON u.workflow_trigger_id=t.workflow_trigger_id 
                JOIN workflow w ON w.workflow_id=u.workflow_id  
            WHERE p.para=".strit($table),'workflow_trigger_id').$where;   
    }
    
    public function tiene($table) {
        $this->para_llena();    
        return array_key_exists($table,$this->para);
    }
    
    public function para() { 
        para_llena(); 
        return $this->para; 
    }
    
    protected function para_llena() {
        if($this->para==null)
            $this->para=ia_sqlArray("SELECT para FROM workflow_para",'para');
    }
    

}

?>