
function init_app() {
    init_coloriza();
}

function init_coloriza() {
try {      
   $('input[type=checkbox]').change( function() {coloriza()});
   $('input[type=radio]').change( function() {coloriza()});
   $("select").change( function() {coloriza()});
   coloriza();
} catch(er) { console.log('app_iacase.js: init_coloriza',er);}
}

function coloriza() {
try {    
    if( $('#divDataTable').length ) {
        $("#divDataTable").css('background-color','white');    
        if( $("#paid").is(':checked')  )
            $("#divDataTable").css('background-color','red');
        else if( $("#atrasado").is(':checked')  )
            $("#divDataTable").css('background-color','blue');
    }
    
    if($("#divData").length) {
        $("#divData").css('background-color','');
        if($("#moneda_id").val()==2 || $("#moneda_id").val()=='USD')
            $("#divData").css('background-color','green');
    }
    
    if($("#acT_moneda").length) {
        if($("#acT_moneda").val()==2 || $("#acT_moneda").val()=='USD')
            $("#acT_form").css('background-color','green');
        else
            $("#acT_form").css('background-color','');
    }
} catch(er) { console.log('app_iacase.js: coloriza',er);}
}
    
    //Valor predeterminado del IDE y Comisin TC.
    var ideValorPred = '3.00';
    var comTCValorPred = '5.00';
    
    // Funciones que ocupan los acuentas: ac.php, acd.php y vales
    function moneda(mon,tc) {
        en_moneda=$("#moneda_id").val();
        var cTC = $('#'+mon+' :selected').attr('tc');
        
        if(en_moneda=='' || en_moneda==undefined)
            en_moneda='MXP';
            
        if(en_moneda=='MXP')
            en_moneda=1;
        else
            en_moneda=2;
        paga_moneda=$("#"+mon).val();
        
        if(paga_moneda==en_moneda && _app != 'vale')
        {
            $('#'+tc).val(cTC).hide();
            $("label[for='"+tc+"']").hide();
        } 
        else
        {
            tipoCambio = cTC;
            $('#'+tc).val(tipoCambio).show();
            $("label[for='"+tc+"']").show();
        }
        if(paga_moneda==1)
            $("#acT_form").css('background-color','');
        else
            $("#acT_form").css('background-color','green');

        $('#'+lb_tipo_cambio).focus().select();
        calculaImporteAfecta('NO');
    }
    
    function banco_mov_tipo_do(mov,ide,bc)
    {
        if(ide!=null)
            if( $('#' + mov + ' :selected').attr('data-lleva_ide')=='Si' )
            {
                $('#'+ide).val(ideValorPred).show().focus().select(); //Valor por default del IDE al da 10-01-13
                $("label[for='"+ide+"']").show();
                //Monto IDE
                $('#'+lb_ide_monto).val('0.00').show();
                $("label[for='"+lb_ide_monto+"']").show();
            }
            else
            {
                $('#'+ide).val('0.00').hide();
                $("label[for='"+ide+"']").hide();
                //Monto IDE
                $('#'+lb_ide_monto).val('0.00').hide();
                $("label[for='"+lb_ide_monto+"']").hide();
            }
        if(bc!=null)
        {
            if( $('#' + mov + ' :selected').attr('data-solicita_link_bancario')=='Si' )
            {
                $('#'+bc).val('0.00').show();
                $("label[for='"+bc+"']").show();
                //Monto deposito
                $('#'+lb_monto_deposito).val($('#'+lb_quantity).val()).show();
                $("label[for='"+lb_monto_deposito+"']").show();
            }
            else
            {
                //Cuenta bancaria
                $('#'+bc).val('0.00').hide();
                $("label[for='"+bc+"']").hide();
                //Monto deposito
                $('#'+lb_monto_deposito).val('0.00').hide();
                $("label[for='"+lb_monto_deposito+"']").hide();
            }
            
            if( $('#' + mov + ' :selected').attr('data-especial')=='MIXTO' )
            {
                //Muestra los inputs de Cash, Desposit
                $('#'+lb_cash).val($('#'+lb_quantity).val()).show().focus().select();
                $("label[for='"+lb_cash+"']").show();
                $('#'+lb_deposit).val('0.00').show();
                $("label[for='"+lb_deposit+"']").show();

                //Pongo el quantity en readonly para que escriban los montos en cash y deposit
                $('#'+lb_quantity).addClass("readonly").prop("readonly");
            }
            else
            {
                //Oculta los inputs de Cash, Desposit
                $('#'+lb_cash).val('0.00').hide();
                $("label[for='"+lb_cash+"']").hide();
                $('#'+lb_deposit).val('0.00').hide();
                $("label[for='"+lb_deposit+"']").hide();
                
                if($('#' + mov + ' :selected').attr('data-lleva_ide')=='Si')
                {
                    $('#'+ide).val(ideValorPred);
                    $('#'+lb_ide_monto).val('0.00');
                }
                
                $('#'+lb_quantity).removeClass("readonly").removeProp("readonly");
            }
            
            if( $('#' + mov + ' :selected').attr('data-especial')=='TARJCRED' )
            {
                //Muestra los inputs de Comision por pago con TC
                $('#'+lb_tarjeta_percent).val(comTCValorPred).show().focus().select();
                $("label[for='"+lb_tarjeta_percent+"']").show();
                $('#'+lb_tarjeta_amount).val('0.00').show();
                $("label[for='"+lb_tarjeta_amount+"']").show();
            }
            else
            {
                //Oculta los inputs de Comision por pago con TC
                $('#'+lb_tarjeta_percent).val('0.00').hide();
                $("label[for='"+lb_tarjeta_percent+"']").hide();
                $('#'+lb_tarjeta_amount).val('0.00').hide();
                $("label[for='"+lb_tarjeta_amount+"']").hide();
            }
        }
        calculaIDE();
        calculaComisionTC();
        calculaImporteAfecta('NO');
    }
    
    
    function obtenOnHandCuentaT(CuentaTID)
    {
        if(CuentaTID == '')
            return;
            
        $.ajax({
            type: "POST",
            cache: false,
            async: false,
            url: "ajax/deudas_acciones.php",
            data: "accion=onHandCuentaT&cuentaT_id=" + CuentaTID,
            dataType: "json",
            success: function(data, textStatus, jqXHR)
            {
                if(data.Status == 'OK')
                {
                    cT_on_hand_mx = data.CuentaT.on_hand_mx;
                    cT_on_hand_usd = data.CuentaT.on_hand_usd;
                    
                    cT_on_hand_mx = 1 * cT_on_hand_mx;
                    cT_on_hand_usd = 1 * cT_on_hand_usd;
                }
                else
                {
                    vx_alert(divIDInfo, data.Error, "Cuenta T.");
                }             
            },
            error: function(jqXHR, textStatus, errorThrown) {
                alert(textStatus);
                console.log("Cuenta T.",jqXHR);
            }                
        });
        
        return;
    }
    
    function permiteSolicitarLinkBancario()
    {
        
    }
    
    function guardaDocumentoPadre()
    {
        try {  $(".ui-dialog-buttonpane button:first").css('background','');  } catch(er) {}
        //Tratamos de guardar al documento padre.
        try
        {
            if(iac_modo == 'cardex' || iac_modo == 'cardex_window')
            {
                iaFormDirty=false;
                document.getElementById(iac_form_id).submit();
            }
            else if(iac_modo=='jqgrid_iacform')
            {
                iaFormDirty=false;
                $(".ui-button-text:contains('Guardar')").click();
            }
        } catch(er) {console.log("backoffice/ac.php set_form_unmodified:",er);}
        
        return true;
    }
    
    function calculaIDE(origen)
    {
        if(!origen)
            var origen = lb_quantity;

        if(!$('#'+lb_ide).is(":visible"))
        {
            //$('#'+lb_quantity_afecta).val($('#'+lb_quantity).val()).show();
            calculaImporteAfecta('NO');
            return;
        }
           
        switch (origen)
        {
            case lb_quantity:
                var qtyTotal = $('#'+lb_quantity).val();
                var qtyAfecta = 0.00;
                var idePercent = $('#'+lb_ide).val();
                var ideQty = 0.00;
                                
                qtyTotal = (qtyTotal == '') ? 0.00 : qtyTotal.replace(/\,/g,'');
                idePercent = (idePercent == '') ? 0.00 : idePercent.replace(/\,/g,'');
                                
                qtyTotal = 1 * qtyTotal;
                idePercent = 1 * idePercent;
                
                ideQty = qtyTotal * idePercent / 100;
                qtyAfecta = qtyTotal - ideQty;
                                
                $('#'+lb_quantity).val(CommaFormatted(qtyTotal));
                $('#'+lb_quantity_afecta).val(CommaFormatted(qtyAfecta));
                $('#'+lb_ide_monto).val(CommaFormatted(ideQty));
                $('#'+lb_ide).val(CommaFormatted(idePercent));
                //alert('calculaIDE case acT_quantity');
            break;
            
            case lb_ide:
                var qtyTotal = $('#'+lb_quantity).val();
                var qtyAfecta = 0.00;
                var idePercent = $('#'+lb_ide).val();
                var ideQty = 0.00;
                
                if($('#'+lb_cash).is(":visible"))
                {
                    var qtyCash = $('#'+lb_cash).val();
                    var qtyDeposit = $('#'+lb_deposit).val();
                    
                    qtyCash = (qtyCash == '') ? 0.00 : qtyCash.replace(/\,/g,'');
                    qtyDeposit = (qtyDeposit == '') ? 0.00 : qtyDeposit.replace(/\,/g,'');
                    
                    qtyCash = 1 * qtyCash;
                    qtyDeposit = 1 * qtyDeposit;
                    
                    ideQty = qtyCash * idePercent / 100;
                    qtyAfecta = qtyCash + qtyDeposit - ideQty;
                    qtyTotal = qtyCash + qtyDeposit;
                    
                    $('#'+lb_cash).val(CommaFormatted(qtyCash));
                    $('#'+lb_deposit).val(CommaFormatted(qtyDeposit));
                }
                else
                {
                    qtyTotal = (qtyTotal == '') ? 0.00 : qtyTotal.replace(/\,/g,'');
                    idePercent = (idePercent == '') ? 0.00 : idePercent.replace(/\,/g,'');
                                    
                    qtyTotal = 1 * qtyTotal;
                    idePercent = 1 * idePercent;
                    
                    ideQty = qtyTotal * idePercent / 100;
                    qtyAfecta = qtyTotal - ideQty;
                }

                $('#'+lb_quantity).val(CommaFormatted(qtyTotal));
                $('#'+lb_quantity_afecta).val(CommaFormatted(qtyAfecta));
                $('#'+lb_ide_monto).val(CommaFormatted(ideQty));
                $('#'+lb_ide).val(CommaFormatted(idePercent));
                //alert('calculaIDE case acT_ide');
            break;
            
            case lb_ide_monto:
                var qtyTotal = $('#'+lb_quantity).val();
                var qtyAfecta = 0.00;
                var idePercent = 0.00;
                var ideQty = $('#'+lb_ide_monto).val();
                
                if($('#'+lb_cash).is(":visible"))
                {
                    var qtyCash = $('#'+lb_cash).val();
                    var qtyDeposit = $('#'+lb_deposit).val();
                    
                    qtyCash = (qtyCash == '') ? 0.00 : qtyCash.replace(/\,/g,'');
                    qtyDeposit = (qtyDeposit == '') ? 0.00 : qtyDeposit.replace(/\,/g,'');
                    
                    qtyCash = 1 * qtyCash;
                    qtyDeposit = 1 * qtyDeposit;
                    
                    if(qtyTotal <= 0 && qtyCash <= 0)
                        break;
                    
                    idePercent = ideQty * 100 / qtyCash;
                    qtyAfecta = qtyCash + qtyDeposit - ideQty;
                    qtyTotal = qtyCash + qtyDeposit;
                    
                    
                    $('#'+lb_cash).val(CommaFormatted(qtyCash));
                    $('#'+lb_deposit).val(CommaFormatted(qtyDeposit));
                }
                else
                {
                    
                    qtyTotal = (qtyTotal == '') ? 0.00 : qtyTotal.replace(/\,/g,'');
                    ideQty = (ideQty == '') ? 0.00 : ideQty.replace(/\,/g,'');
    
                    qtyTotal = 1 * qtyTotal;
                    ideQty = 1 * ideQty;
                    
                    if(qtyTotal <= 0)
                        break;
                    
                    idePercent = ideQty * 100 / qtyTotal;
                    qtyAfecta = qtyTotal - ideQty;
                
                }
                                
                $('#'+lb_quantity).val(CommaFormatted(qtyTotal));
                $('#'+lb_quantity_afecta).val(CommaFormatted(qtyAfecta));
                $('#'+lb_ide_monto).val(CommaFormatted(ideQty));
                $('#'+lb_ide).val(CommaFormatted(idePercent));
                
                //alert('calculaIDE case acT_ide_monto');
            break;
            
            case lb_quantity_afecta:
                //alert($("#acT_quantity_afecta").val());
                calculaImporteAfecta('SI');
                //alert($("#acT_quantity_afecta").val());
            
                var qtyTotal = $('#'+lb_quantity).val();
                var qtyAfecta = $('#'+lb_quantity_afecta).val();
                var idePercent = 0.00;
                var ideQty = 0.00;
                
                qtyTotal = (qtyTotal == '') ? 0.00 : qtyTotal.replace(/\,/g,'');
                qtyAfecta = (qtyAfecta == '') ? 0.00 : qtyAfecta.replace(/\,/g,'');
                
                if($('#'+lb_cash).is(":visible"))
                {
                    var qtyCash = 0.00;
                    var qtyDeposit = $('#'+lb_deposit).val();
                    
                    qtyDeposit = (qtyDeposit == '') ? 0.00 : qtyDeposit.replace(/\,/g,'');

                    qtyDeposit = 1 * qtyDeposit;
                    
                    ideQty = qtyTotal - qtyAfecta;
                    qtyCash = qtyTotal - qtyDeposit;
                    
                    idePercent = ideQty * 100 / qtyCash;
                    qtyAfecta = qtyCash + qtyDeposit - ideQty;
                    qtyTotal = qtyCash + qtyDeposit;
                    
                    $('#'+lb_cash).val(CommaFormatted(qtyCash));
                    $('#'+lb_deposit).val(CommaFormatted(qtyDeposit));
                }
                else
                {
                    qtyTotal = 1 * qtyTotal;
                    qtyAfecta = 1 * qtyAfecta;
    
    
                    ideQty = qtyTotal - qtyAfecta;
                    idePercent = ideQty * 100 / qtyTotal;
                }
                                                
                $('#'+lb_quantity).val(CommaFormatted(qtyTotal));
                $('#'+lb_quantity_afecta).val(CommaFormatted(qtyAfecta));
                $('#'+lb_ide_monto).val(CommaFormatted(ideQty));
                $('#'+lb_ide).val(CommaFormatted(idePercent));
                
                //alert('calculaIDE case acT_quantity_afecta');
            break;
            
            case lb_cash:
                var qtyTotal = $('#'+lb_quantity).val();
                var qtyAfecta = 0.00;
                var idePercent = $('#'+lb_ide).val();
                var ideQty = 0.00;
                var qtyCash = $('#'+lb_cash).val();
                var qtyDeposit = $('#'+lb_deposit).val();
                                
                qtyTotal = (qtyTotal == '') ? 0.00 : qtyTotal.replace(/\,/g,'');
                idePercent = (idePercent == '') ? 0.00 : idePercent.replace(/\,/g,'');
                qtyCash = (qtyCash == '') ? 0.00 : qtyCash.replace(/\,/g,'');
                qtyDeposit = (qtyDeposit == '') ? 0.00 : qtyDeposit.replace(/\,/g,'');
                                
                qtyTotal = 1 * qtyTotal;
                idePercent = 1 * idePercent;
                qtyCash = 1 * qtyCash;
                qtyDeposit = 1 * qtyDeposit;
                
                ideQty = qtyCash * idePercent / 100;
                qtyAfecta = qtyCash + qtyDeposit - ideQty;
                qtyTotal = qtyCash + qtyDeposit;
                                
                $('#'+lb_quantity).val(CommaFormatted(qtyTotal));
                $('#'+lb_quantity_afecta).val(CommaFormatted(qtyAfecta));
                $('#'+lb_ide_monto).val(CommaFormatted(ideQty));
                $('#'+lb_ide).val(CommaFormatted(idePercent));
                $('#'+lb_cash).val(CommaFormatted(qtyCash));
                $('#'+lb_deposit).val(CommaFormatted(qtyDeposit));
            break;
            
            case lb_deposit:
                var qtyTotal = $('#'+lb_quantity).val();
                var qtyAfecta = 0.00;
                var idePercent = $('#'+lb_ide).val();
                var ideQty = 0.00;
                var qtyCash = $('#'+lb_cash).val();
                var qtyDeposit = $('#'+lb_deposit).val();
                                
                qtyTotal = (qtyTotal == '') ? 0.00 : qtyTotal.replace(/\,/g,'');
                idePercent = (idePercent == '') ? 0.00 : idePercent.replace(/\,/g,'');
                qtyCash = (qtyCash == '') ? 0.00 : qtyCash.replace(/\,/g,'');
                qtyDeposit = (qtyDeposit == '') ? 0.00 : qtyDeposit.replace(/\,/g,'');
                                
                qtyTotal = 1 * qtyTotal;
                idePercent = 1 * idePercent;
                qtyCash = 1 * qtyCash;
                qtyDeposit = 1 * qtyDeposit;
                
                ideQty = qtyCash * idePercent / 100;
                qtyAfecta = qtyCash + qtyDeposit - ideQty;
                qtyTotal = qtyCash + qtyDeposit;
                                
                $('#'+lb_quantity).val(CommaFormatted(qtyTotal));
                $('#'+lb_quantity_afecta).val(CommaFormatted(qtyAfecta));
                $('#'+lb_ide_monto).val(CommaFormatted(ideQty));
                $('#'+lb_ide).val(CommaFormatted(idePercent));
                $('#'+lb_cash).val(CommaFormatted(qtyCash));
                $('#'+lb_deposit).val(CommaFormatted(qtyDeposit));
            break;
            
            default:
            break;
        }
        if($('#'+lb_ide).is(":visible"))
            calculaImporteAfecta('NO');
        else
            $('#'+lb_quantity_afecta).val($('#'+lb_quantity).val());
    }
    
    function calculaComisionTC(origen)
    {
        if(!origen)
            var origen = lb_quantity;
        
        if(!$('#'+lb_tarjeta_percent).is(":visible"))
            return;
            
        //calculaImporteAfecta('SI');
        
        var tasa_iva = 0.16;
                
        switch (origen)
        {
            case lb_quantity:
                var qtyTotal = $('#'+lb_quantity).val();
                var qtyAfecta = 0.00;
                var tarjPercent = $('#'+lb_tarjeta_percent).val();
                var tarjQty = 0.00;
                                
                qtyTotal = (qtyTotal == '') ? 0.00 : qtyTotal.replace(/\,/g,'');
                tarjPercent = (tarjPercent == '') ? 0.00 : tarjPercent.replace(/\,/g,'');
                                
                qtyTotal = 1 * qtyTotal;
                tarjPercent = 1 * tarjPercent;
                
                tarjQty = qtyTotal * tarjPercent / 100;
                qtyAfecta = qtyTotal - tarjQty;
                                
                $('#'+lb_quantity).val(CommaFormatted(qtyTotal));
                $('#'+lb_quantity_afecta).val(CommaFormatted(qtyAfecta));
                $('#'+lb_tarjeta_amount).val(CommaFormatted(tarjQty));
                $('#'+lb_tarjeta_percent).val(CommaFormatted(tarjPercent));
            break;
            
            case lb_tarjeta_percent:
                var qtyTotal = $('#'+lb_quantity).val();
                var qtyAfecta = 0.00;
                var tarjPercent = $('#'+lb_tarjeta_percent).val();
                var tarjQty = 0.00;
                                
                qtyTotal = (qtyTotal == '') ? 0.00 : qtyTotal.replace(/\,/g,'');
                tarjPercent = (tarjPercent == '') ? 0.00 : tarjPercent.replace(/\,/g,'');
                                
                qtyTotal = 1 * qtyTotal;
                tarjPercent = 1 * tarjPercent;
                
                tarjQty = qtyTotal * tarjPercent / 100;
                qtyAfecta = qtyTotal - tarjQty;
                                
                $('#'+lb_quantity).val(CommaFormatted(qtyTotal));
                $('#'+lb_quantity_afecta).val(CommaFormatted(qtyAfecta));
                $('#'+lb_tarjeta_amount).val(CommaFormatted(tarjQty));
                $('#'+lb_tarjeta_percent).val(CommaFormatted(tarjPercent));
            break;
            
            case lb_tarjeta_amount:
                var qtyTotal = $('#'+lb_quantity).val();
                var qtyAfecta = 0.00;
                var tarjPercent = 0.00;
                var tarjQty = $('#'+lb_tarjeta_amount).val();
                
                qtyTotal = (qtyTotal == '') ? 0.00 : qtyTotal.replace(/\,/g,'');
                tarjQty = (tarjQty == '') ? 0.00 : tarjQty.replace(/\,/g,'');
                
                qtyTotal = 1 * qtyTotal;
                tarjQty = 1 * tarjQty;
                    
                if(qtyTotal <= 0)
                    return;
                    
                tarjPercent = tarjQty * 100 / qtyTotal;
                qtyAfecta = qtyTotal - tarjQty;
                
                                
                $('#'+lb_quantity).val(CommaFormatted(qtyTotal));
                $('#'+lb_quantity_afecta).val(CommaFormatted(qtyAfecta));
                $('#'+lb_tarjeta_amount).val(CommaFormatted(tarjQty));
                $('#'+lb_tarjeta_percent).val(CommaFormatted(tarjPercent));
            break;
            
            case lb_quantity_afecta:
                
                calculaImporteAfecta('SI');
                
                var qtyTotal = $('#'+lb_quantity).val();
                var qtyAfecta = $('#'+lb_quantity_afecta).val();
                var tarjPercent = 0.00;
                var tarjQty = 0.00;
                                
                qtyTotal = (qtyTotal == '') ? 0.00 : qtyTotal.replace(/\,/g,'');
                qtyAfecta = (qtyAfecta == '') ? 0.00 : qtyAfecta.replace(/\,/g,'');

                qtyTotal = 1 * qtyTotal;
                qtyAfecta = 1 * qtyAfecta;
                
                tarjQty = qtyTotal - qtyAfecta;
                tarjPercent = tarjQty * 100 / qtyTotal;
                                
                $('#'+lb_quantity).val(CommaFormatted(qtyTotal));
                $('#'+lb_quantity_afecta).val(CommaFormatted(qtyAfecta));
                $('#'+lb_tarjeta_amount).val(CommaFormatted(tarjQty));
                $('#'+lb_tarjeta_percent).val(CommaFormatted(tarjPercent));
            break;
            
            default:
            break;
        }
        if($('#'+lb_tarjeta_percent).is(":visible"))
            calculaImporteAfecta('NO');
    }
    
    function calculaImporteAfecta(mo)
    {
        //alert('calculaImporteAfecta begin');
        if(!mo)
            var mo = 'NO';
        
        var qtyAfecta = $('#'+lb_quantity_afecta).val();
        var tdc = $("#"+lb_tipo_cambio).val();
        
        qtyAfecta = (qtyAfecta == '') ? 0.00 : qtyAfecta.replace(/\,/g,'');
        tdc = (tdc == '') ? 0.00 : tdc.replace(/\,/g,'');
        
        qtyAfecta = 1 * qtyAfecta;
        tdc = 1 * tdc;
        
                
        if(mo == 'NO')
        {
            var qtyTotal = $('#'+lb_quantity).val();
            var qtyAfecta = 0.00;
            var tarjPercent = $('#'+lb_tarjeta_percent).val();
            var tarjQty = $('#'+lb_tarjeta_amount).val();
            var idePercent = $('#'+lb_ide).val();
            var ideQty = $('#'+lb_ide_monto).val();
            var qtyCash = $('#'+lb_cash).val();
            var qtyDeposit = $('#'+lb_deposit).val();
            
            qtyTotal = (qtyTotal == '') ? 0.00 : qtyTotal.replace(/\,/g,'');
            tarjPercent = (tarjPercent == '') ? 0.00 : tarjPercent.replace(/\,/g,'');
            tarjQty = (tarjQty == '') ? 0.00 : tarjQty.replace(/\,/g,'');
            idePercent = (idePercent == '') ? 0.00 : idePercent.replace(/\,/g,'');
            ideQty = (ideQty == '') ? 0.00 : ideQty.replace(/\,/g,'');
            qtyCash = (qtyCash == '') ? 0.00 : qtyCash.replace(/\,/g,'');
            qtyDeposit = (qtyDeposit == '') ? 0.00 : qtyDeposit.replace(/\,/g,'');
            
            qtyTotal = 1 * qtyTotal;
            tarjPercent = 1 * tarjPercent;
            tarjQty = 1 * tarjQty;
            idePercent = 1 * idePercent;
            ideQty = 1 * ideQty;
            qtyCash = 1 * qtyCash;
            qtyDeposit = 1 * qtyDeposit;
            
            qtyAfecta = qtyTotal - tarjQty - ideQty;
            
            
            if(en_moneda != '1' && paga_moneda != en_moneda)
            {
                tdc = 1 / tdc;
            }
            if(_app == 'vale')
                qtyAfecta = qtyAfecta * 1.00;
            else
                qtyAfecta = qtyAfecta * tdc;
        }
        else
        {
            if(en_moneda != '1' && paga_moneda != en_moneda)
            {
                tdc = 1 / tdc;
            }
            qtyAfecta = qtyAfecta / tdc;
        }

        //alert('calculaImporteAfecta end');
        $('#'+lb_quantity_afecta).val(CommaFormatted(qtyAfecta));
    }
    
    function inicializaDialogoAcuenta()
    {
        $('#acT_quantity').val('0.00');
        $("#acT_monto").val('0.00');
        $('#acT_ide').val('0.00');
        $("#acT_ide_monto").val('0.00');
        $('#acT_referencia').val('');
        $('#acT_comentario').val('');
        $('#acT_quantity_afecta').val('0.00');
        $('#acT_deposit').val('0.00');
        $('#acT_cash').val('0.00');
        $('#acT_tarjeta_amount').val('0.00');
        $('#acT_tarjeta_percent').val('0.00');
        $("#acT_quantity_afecta").val('0.00');
        $("#acT_metodo_pago").val('1');
        banco_mov_tipo_do('acT_metodo_pago','acT_ide','acT_cuenta_bancaria');
        $('#acT_cuenta_bancaria').val('0');
        $("#acT_moneda").val(en_moneda);
        moneda('acT_moneda','acT_tipo_cambio');
    }