# iaCase - The Database-to-Web-App Machine

```
    +-----------------+
    |   YOUR DATABASE |  <-- You have tables here
    |   +-----------+ |
    |   | customers | |
    |   | orders    | |
    |   | products  | |
    |   +-----------+ |
    +-----------------+
            |
            | iaCase reads your tables
            v
    +-----------------+
    |    iaCase.php   |  <-- The magic happens here
    |    "Create"     |
    +-----------------+
            |
            | Generates PHP files automatically
            v
    +-----------------+
    |  YOUR WEB APP   |  <-- Boom! CRUD interface ready
    |  +-----------+  |
    |  | List Grid |  |  <-- Sort, filter, paginate
    |  | Add Form  |  |  <-- Insert new records
    |  | Edit Form |  |  <-- Update records
    |  | Delete    |  |  <-- Remove records
    |  +-----------+  |
    +-----------------+
```

## What is iaCase?

iaCase is a **Rapid Application Development (RAD) framework** for PHP and MySQL.

**The Problem:** You have a database with 50 tables. You need a web interface to manage all that data. Writing forms, validation, grids, and CRUD logic for each table is boring and takes forever.

**The Solution:** Point iaCase at your database. Click "Create". Get a complete web application with forms, data grids, validation, and all CRUD operations. Done.

## How It Works (The Simple Version)

```
1. You have a MySQL database with tables
2. You open ia_case.php in your browser
3. You select your database
4. You click "Create"
5. iaCase reads all your table structures
6. iaCase generates PHP files for each table
7. You now have a working web app!
```

## Requirements

- **PHP 5.x or 7.x** - The server-side language
- **MySQL/MariaDB** - Your database
- **Apache with mod_rewrite** - The web server
- **A web browser** - Netscape Navigator 4.0 should work fine (just kidding... maybe)

## Quick Start

### Step 1: Configure Database

Edit `inc/config.php`:

```php
$gIAsql['host'] = 'localhost';
$gIAsql['user'] = 'root';
$gIAsql['pwd']  = 'your_password';
$gIAsql['dbname'] = 'quantix';  // Default database

// Optional: Configure generated apps path (defaults to '../quantix/')
$gIApath['GeneratedAppPath'] = '../quantix/';  // Customize if needed
```

### Step 2: Generate Your Application

1. Open `http://yourserver/ia_case/ia_case.php`
2. Select your database from the dropdown
3. ✨ **Magic happens!** The **Create path** and **Hojas path** fields auto-fill based on your database name!
4. Click **"Create"**

**Auto-Path Feature:** When you select a database (e.g., `quantix`), the paths automatically become:
- Create path: `/lamp/www/quantix/`
- Hojas path: `/lamp/www/quantix/backoffice/`

No manual typing needed! The convention is simple: **database name = folder name**. You can still manually edit the paths if you need custom locations.

### Step 3: Use Your New App

Open `http://yourserver/quantixTest/backoffice/your_table.php`

You'll see:
- A **data grid** with all your records (powered by jqGrid)
- **Add** button to insert new records
- **Edit** button to modify records
- **Delete** button to remove records
- **Export** to download as CSV
- **Search** to filter data

### Step 4: Deploy to Production (Optional)

Use the built-in **Transfer Files** utility to copy your test app to production:

1. Open `http://yourserver/ia_case/transfer_files.php`
2. Set **Origin**: `/lamp/www/quantixTest/` (your test environment)
3. Set **Destination**: `/lamp/www/quantix/` (your production environment)
4. Click **Preview** to see what will be copied (no files are touched yet)
5. Click **Copy** to perform the actual deployment

The utility automatically excludes development files like `.git`, `.idea`, `node_modules`, etc.

## The Architecture (For Curious Minds)

```
+------------------+     +-------------------+     +------------------+
|   Browser        | --> |   PHP Page        | --> |   MySQL DB       |
|   (User clicks)  |     |   (iacase class)  |     |   (Your data)    |
+------------------+     +-------------------+     +------------------+
        ^                        |
        |                        v
        |                +-------------------+
        +----------------|   HTML + jQuery   |
                         |   + jqGrid        |
                         +-------------------+
```

### Key Files Explained

| File | What It Does |
|------|--------------|
| `ia_case.php` | The generator - creates your app from database |
| `transfer_files.php` | Copy utility - deploy apps between environments |
| `inc/config.php` | Database connection and path settings |
| `inc/iacase.php` | The brain - handles all CRUD operations |
| `inc/appRelateBase.php` | Knows about table relationships |
| `inc/ia_utilerias.php` | Helper functions for SQL and escaping |
| `inc/iaJQGrid.php` | Makes the fancy data grids work |

### Generated Files Explained

When you generate an app for table `reservas_cloudbeds`:

```
/quantixTest/
  /app/
    appRelate.php           <-- Central config (tables, relationships)
    app_reservas_cloudbeds.php  <-- The class that handles this table
  /backoffice/
    reservas_cloudbeds.php  <-- The web page you open in browser
```

## The URL Parameter System

iaCase uses the `h` parameter to know what to do:

| URL | What Happens |
|-----|--------------|
| `table.php` | Show the data grid |
| `table.php?h=a` | Show "Add New Record" form |
| `table.php?h=e&id=123` | Show "Edit Record #123" form |
| `table.php?h=r&id=123` | Show "View Record #123" (read-only) |
| `table.php?h=b&id=123` | Show "Delete Confirmation" |
| `table.php?h=d&id=123` | Actually delete record #123 |

### Transfer Files Utility

The `transfer_files.php` utility uses `h` for actions:

| URL | What Happens |
|-----|--------------|
| `transfer_files.php` | Show the transfer form |
| `transfer_files.php?h=preview` | Preview files to be copied (no changes made) |
| `transfer_files.php?h=copy` | Execute the file copy operation |

**Features:**
- **Preview Mode**: See exactly what files will be copied before committing
- **Session Persistence**: Your paths are remembered between page loads
- **Smart Exclusions**: Automatically skips `.git`, `.idea`, `.vscode`, `node_modules`, `__pycache__`, `.DS_Store`
- **Path Validation**: Enforces `/lamp/www/` prefix, blocks directory traversal attacks
- **Detailed Statistics**: Shows files copied, directories created, folders skipped, and any errors
- **Overwrite Mode**: Existing files in destination are replaced (be careful!)

**Common Use Cases:**
- Deploy from test (`/lamp/www/quantixTest/`) to production (`/lamp/www/quantix/`)
- Create backups before major changes
- Sync customizations between similar applications
- Migrate apps to new directory structures

## Customizing Your Generated App

The generated `app_[tablename].php` files are meant to be edited!

### Change Field Order

```php
public function campos_final() {
    $orden = array('name', 'email', 'phone', 'address', 'city');
    $this->campos_reorder($orden);
}
```

**Important:** iaCase now **preserves your custom field order** when regenerating! 🎉

When you add/remove database columns and regenerate (click "Create" in `ia_case.php`):
- ✅ Your custom field order from `$orden` is **preserved**
- ✅ New database fields are **automatically inserted** at logical positions
- ✅ Deleted database fields are **automatically removed** from `$orden`
- ✅ You can safely rearrange fields without fear of losing changes

**Example:**
```php
// 1. You customize the order
$orden = array('property', 'name', 'email', 'phone_number');

// 2. Later, you add 'propiedad_id' column to DB (between 'property' and 'name')

// 3. You regenerate by clicking "Create" in ia_case.php

// 4. iaCase intelligently produces:
$orden = array('property', 'propiedad_id', 'name', 'email', 'phone_number');
//                         ^^^^^^^^^^^^ New field inserted at the right spot!
```

This means **regeneration is safe** - customize away!

### Make a Field Required

```php
$this->campos['email']['required'] = true;
```

### Hide a Field

```php
$this->campos['internal_notes']['modo'] = 'hidden';
```

### Add Custom Validation

```php
function insert_validate() {
    if (empty($this->values['email'])) {
        $this->msg_err .= "<li>Email is required!</li>";
        return false;
    }
    return true;
}
```

### Run Code After Insert

```php
function insert_post_save() {
    // Send welcome email, update statistics, whatever you need
    mail($this->values['email'], 'Welcome!', 'Thanks for signing up.');
    return true;
}
```

## The Technology Stack

```
+------------------------+
|     Frontend           |
+------------------------+
| jQuery 1.7             |  <-- DOM manipulation, AJAX
| jqGrid 4.x             |  <-- Data grids with sort/filter/page
| jQuery UI              |  <-- Dialogs, datepickers, themes
| jQuery Validate        |  <-- Client-side form validation
+------------------------+
|     Backend            |
+------------------------+
| PHP 5.x/7.x            |  <-- Server-side logic
| MySQL/MariaDB          |  <-- Database
| Apache + mod_rewrite   |  <-- Web server
+------------------------+
```

## Common Patterns

### Foreign Keys Become Dropdowns

If your table has `customer_id` and there's a `customer` table, iaCase automatically creates a dropdown select with all customers.

### Timestamps Are Automatic

Fields named `alta_db`, `ultimo_cambio` (or similar) are automatically set on insert/update.

### Audit Fields

Common audit fields like `alta_por` (created_by) and `ultimo_cambio_por` (modified_by) are automatically filled with the logged-in user.

## Troubleshooting

### "Table doesn't exist" errors

These appear when iaCase finds a field like `customer_id` but can't find a `customer` table. This is just a warning - the app still works, but that field won't have a dropdown.

### Forms not saving

Check browser console for JavaScript errors. Make sure jQuery and jqGrid are loading correctly.

### Blank page

Enable PHP error display in `inc/config.php`:
```php
@error_reporting(E_ALL);
@ini_set('display_errors', 1);
```

## A Note on Legacy Code

This framework was built around 2012-2016. It uses patterns that were common back then:
- Global variables (`$gIAsql`, `$gAppRelate`)
- Procedural mixed with OOP
- No namespaces
- No Composer

It works. It's been running production apps for years. Don't judge it by 2024 standards - judge it by how fast you can build a working app with it.

## License

This is proprietary software. Contact the author for licensing information.

---

*"Give me a database and I shall give you a web app."* - iaCase, probably

