<?php
namespace Iac\inc\sql;

// @version 1.1
// @TODO doc
// @TODO hacer algo para coordinar inserts en varias tablas?
// min php  5.2.0

class IacSQLMultipleInsert {
    protected $db;
    protected $insertIntoClause;
    protected $values = [];
    protected $valuesNum = 0;
    protected $insertsOk = 0;
    protected $insertsErrors = 0;
    protected $onDuplicateClause;
    protected $currentLength;
    protected $baseLength;
    protected $maxLength;
    protected $sqlBuilder;
    protected $insertLast = '';
    protected $insertLastOk = true;
    protected $simulate = false; //Modificado por VCA
    protected $allValues = []; //Modificado por VCA

    public function __construct($db, $insertIntoClause, $onDuplicateClause = '', $maxLength = 5000, $simulate = false) {
        $this->db = $db;
        $this->insertIntoClause = $insertIntoClause;
        $this->onDuplicateClause = $onDuplicateClause;
        $this->currentLength = $this->baseLength = strlen($insertIntoClause) + strlen($onDuplicateClause) + 9;
        $this->maxLength = $maxLength;
        $this->simulate = $simulate;
        $this->sqlBuilder = new IacSqlBuilder();
    }

    public function valuesArray($values, $fieldNameDontQuote=array()) {
        return $this->valuesString( $this->sqlBuilder->insertValues($values, $fieldNameDontQuote) );
    }

    public function valuesString($valueString) {
        $ok = null;
        $len = strlen($valueString);
        if($this->currentLength + $len >= $this->maxLength) {
            $ok = $this->insertNow();
        }
        $this->currentLength += $len + 1;
        $this->values[] = $valueString;
        $this->valuesNum++;
        return $ok;
    }

    public function insertNow() {
        if(empty($this->values)) {
            $this->currentLength = $this->baseLength;
            $this->values = [];
            return true;
        }
//        dd_($this->values);
        $this->insertLast = $this->insertIntoClause . ' VALUES ' . implode(', ', $this->values) . ' ' . $this->onDuplicateClause;

        //Modificado por VCA para que sólo regrese un array de INSERTS
        if($this->simulate)
        {
            $this->allValues[]=$this->insertLast;
            $this->insertLastOk = true;
        }
        else
            $this->insertLastOk = $this->db->query($this->insertLast);

        if($this->insertLastOk) {
            $this->insertsOk++;
        } else {
            $this->insertsErrors++;
        }
        $this->currentLength = $this->baseLength;
        $this->values = [];
        return $this->insertLastOk;
    }

    // get info ________________________________________________________________________________________________________________
        public function get_valuesClauseNum() {return $this->valuesNum;}

        public function get_valuesCurrentNum() {return count($this->values);}

        public function get_insertsOkNum() {return $this->insertsOk;}

        public function get_insertsErrorsNum() {return $this->insertsErrors;}

        public function get_insertLast() {return $this->insertLast;}

        public function get_insertLastOk() {return $this->insertLastOk;}

        public function get_currentLength() {return $this->currentLength;}

        public function get_insertIntoLength() {return $this->baseLength;}

        public function get_simulate() {return $this->simulate;}

        public function set_simulate($simulate) {$this->simulate = $simulate; return $this->simulate;}

        public function get_allValues() {return $this->allValues;}

}
