<?php
/**
 * IacStringer
 * Helper string functions
 *
 * @package sql
 * @author Informatica Asociada
 * @copyright 2015
 * @version 1.0.0
 */
namespace Iac\inc\sql;


/**
 * IacStringer
 * String functions
 *
 * @package sql
 * @author Informatica Asociada
 * @copyright 2015
 * @version 1.0.0
 */
trait IacStringer {

    /**
     * iacStringer::strim()
     * Trims and removes double space, tabs leaving single spaces
     *
     *
     * @param string $s
     * @return string
     */
    public function strim($s) {
        if($s === null || $s === false)
            return '';
        return preg_replace('/\s+/', ' ',  trim($s) );
    }

    /**
     * iacStringer::strit()
     *
     *
     * @param string $str
     * @param integer $maxLength
     * @param bool $maxLengthInCharacters
     * @return string
     */
    public function strit($str, $maxLength=0, $maxLengthInCharacters=true) {
        if($str === null) {
            return 'null';
        }
        if($maxLength) {
            if($maxLengthInCharacters) {
                $str = mb_substr($str , 0, $maxLength);  // operates on characters
            } else {
                $str = mb_strcut($str , 0, $maxLength); // operates on bytes
            }
        }
        return "'".str_replace( array("\\",chr(8),chr(0),chr(26),chr(27)), array("\\\\",'','','',''),str_replace("'","''", $str))."'";
    }

    /**
     * iacStringer::stritc()
     *
     *
     * @param string $str
     * @param integer $maxLength
     * @param bool $maxLengthInCharacters
     * @return string
     */
    public function stritc($str, $maxLength=0, $maxLengthInCharacters=true) {
        if($str === null) {
            return 'null,';
        }
        if($maxLength)
            if($maxLengthInCharacters)
                $str = mb_substr($str , 0, $maxLength); // operates on characters
            else
                $str = mb_strcut($str , 0, $maxLength); // operates on bytes
        return "'".str_replace( array("\\",chr(8),chr(0),chr(26),chr(27)), array("\\\\",'','','',''),str_replace("'","''", $str))."',";
    }

    /**
     * exportTrimed()
     * Returns var_export($obj) as a one liner, no CR/LF
     *
     * @param mixed $obj
     * @return string returns var_export($obj) as a one liner, no CR/LF
     */
    public function exportTrimed($obj) {
        if($obj === null)
            return "null";
        if($obj === '')
            return '""';
        if(is_numeric($obj))
            return $obj;
        return $this->strim(str_replace(array("\r","\n"),"", var_export($obj,true) ));
    }

    /**
     * sqlNormalized()
     *
     * @param string $sql
     * @return string
     */
    public function sqlNormalized($sql) {
        $sqlLimit = preg_replace(
            "/LIMIT\\s*(\\d+?\\s*\\,\\s*\\d+?|\\d+?)/mUu",'LIMIT ?', str_replace(
                    array("''", " =", "= ", "> ", " >","< ", " <"),
                    array("",    "=", "=",  ">",   ">","<",   "<"),
                    $this->strim($sql)
                )
        );
        return preg_replace("/([=\\>\\<,\\(])\\s*(\\'.*\\'|\\-?\\d+?[\\.\\d]*?)/mUu",'${1}?',$sqlLimit);
    }

    /**
     * constant2name()
     *
     * @param string $group
     * @param mixed $value string or number
     * @param string $tag
     * @return string
     */
    public function constant2name($group,$value,$tag='ERR') {
        static $constats;
        if(!isset($constants)) {
            $constants = get_defined_constants(true);
        }
        if(!isset($constants[$group])) {
            return "Unknown ($value)";
        }
        foreach($constants[$group] as $c=>$n) {
            if( (empty($tag) || stripos($c,$tag)!==FALSE) &&  $n===$value) {
                return "$c ($value)";
            }
        }
        return "Unknown ($value)";
    }

}