/**
 * Modified alphanumeric jquery plugin for other languages
 * fixed regexp, and corrected events
 * 04.12.09
 */
(function($){
	$.fn.alphanumeric = function(p) { 
		p = $.extend({
			exp: ""
		  }, p);	
		return this.each(function(){
            var sets = function (obj, ev){
                var val = $(obj).val();
                var re = new RegExp(p.exp);
                var testVal = val.replace(re, '');
                $(obj).val(testVal);
                if (ev != undefined){
                    var charCode = null;
                    if (!ev.charCode) charCode = String.fromCharCode(ev.which);
                        else charCode = String.fromCharCode(ev.charCode);
                    var testChar = charCode.replace(re, '');
                    if (testChar == '') ev.preventDefault();
                }
            }
            sets(this);
            $(this).keypress(function(e){ sets(this, e); });
            $(this).click(function(e){ sets(this, e); });
            $(this).change(function(e){ sets(this, e); });
        });
	};

	$.fn.numeric = function(p) {
		var allow = /[^0-9\.\s,]+/g;
		p = $.extend({
			exp: allow
		  }, p);	
		return this.each (function(){
            $(this).alphanumeric(p);
        });	
	};
	
	$.fn.alpha = function(p) {
		var allow = /[0-9\.\s,]+/g;
		p = $.extend({
			exp: allow
		  }, p);
		return this.each (function(){
            $(this).alphanumeric(p);
        }
		);
	};
})(jQuery);
