
remove style
    $filtered = preg_replace('#style="[^"]*"#i', '', $text); 

email attachment with php email
    /*
    The class
    */
    <?php
    
    class AttachmentEmail {
    	private $from = 'yours@email.com';
    	private $from_name = 'Your Name';
    	private $reply_to = 'yours@email.com';
    	private $to = '';
    	private $subject = '';
    	private $message = '';
    	private $attachment = '';
    	private $attachment_filename = '';
    
    	public function __construct($to, $subject, $message, $attachment = '', $attachment_filename = '') {
    		$this -> to = $to;
    		$this -> subject = $subject;
    		$this -> message = $message;
    		$this -> attachment = $attachment;
    		$this -> attachment_filename = $attachment_filename;
    	}
    
    	public function mail() {
    		if (!empty($this -> attachment)) {
    			$filename = empty($this -> attachment_filename) ? basename($this -> attachment) : $this -> attachment_filename ;
    			$path = dirname($this -> attachment);
    			$mailto = $this -> to;
    			$from_mail = $this -> from;
    			$from_name = $this -> from_name;
    			$replyto = $this -> reply_to;
    			$subject = $this -> subject;
    			$message = $this -> message;
    
    			$file = $path.'/'.$filename;
    			$file_size = filesize($file);
    			$handle = fopen($file, "r");
    			$content = fread($handle, $file_size);
    			fclose($handle);
    			$content = chunk_split(base64_encode($content));
    			$uid = md5(uniqid(time()));
    			$name = basename($file);
    			$header = "From: ".$from_name." <".$from_mail.">\r\n";
    			$header .= "Reply-To: ".$replyto."\r\n";
    			$header .= "MIME-Version: 1.0\r\n";
    			$header .= "Content-Type: multipart/mixed; boundary=\"".$uid."\"\r\n\r\n";
    			$header .= "This is a multi-part message in MIME format.\r\n";
    			$header .= "--".$uid."\r\n";
    			$header .= "Content-type:text/plain; charset=iso-8859-1\r\n";
    			$header .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
    			$header .= $message."\r\n\r\n";
    			$header .= "--".$uid."\r\n";
    			$header .= "Content-Type: application/octet-stream; name=\"".$filename."\"\r\n"; // use diff. tyoes here
    			$header .= "Content-Transfer-Encoding: base64\r\n";
    			$header .= "Content-Disposition: attachment; filename=\"".$filename."\"\r\n\r\n";
    			$header .= $content."\r\n\r\n";
    			$header .= "--".$uid."--";
    
    			if (mail($mailto, $subject, "", $header)) {
    				return true;
    			} else {
    				return false;
    			}
    		} else {
    			$header = "From: ".($this -> from_name)." <".($this -> from).">\r\n";
    			$header .= "Reply-To: ".($this -> reply_to)."\r\n";
    
    			if (mail($this -> to, $this -> subject, $this -> message, $header)) {
    				return true;
    			} else {
    				return false;
    			}
    
    		}
    	}
    }
    ?>

HTML Parser - Grabs The Link URLs + Link Texts From A Web Page And Put Them Into An Array

    /*
    Practical example 
    */
    $sendmail = new AttachmentEmail('johnDoe@gmail.com', 'Testing mail() class', 'Your message here ', '/home/images/img.jpg');
    $sendmail -> mail();
    ?>


    <?php
    function parse_links($document) {
    
      # Zero or more whitespace characters
      $S0 = '\s*';
    
      # One or more whitespace characters
      $S1 = '\s+';
    
      # Anchor tag start
      $anch1 = '<a' . $S1;
    
      # href= pattern
      $href1 = 'href' . $S0 . '=' . $S0;
    
      # quoted strings, with selection
      $q1 = "'[^']'";
      $q2 = '"[^"]*"';
      $q = "($q1|$q2)";
    
      # full link pattern
      $link_RE = "$anch1$href1$q$S0>\s*(.*?)</a>";
    
    
      //global $q, $href1, $link_RE;
      preg_match_all("#$link_RE#i", $document, $matches);
      return $matches; // returns an array
    
    } // end function parse_links()
    
    //
    // DEMO OF HOW TO USE THE FUNCTION
    
    // grab a webpage
    $str = implode('',file('http://del.icio.us'));
    
    // call the parse_links function
    $linkarray=parse_links($str);
    
    // loop through the link array, outputting the URL + Link Text
    for ($i = 0; $i < sizeof($linkarray[0]); $i++)
        echo ($linkarray[2][$i] .$linkarray[1][$i] . "
    ");
    
    ?>
