<?php
require_once '../config.php';
require_once '../lib/DatabaseHelper.php';
require_once '../lib/ErrorHandler.php';

header('Content-Type: application/json');

try {
    $db = DatabaseHelper::getInstance();
    $conn = $db->connect();
    
    $result = $conn->query("SHOW DATABASES");
    if (!$result) {
        throw new Exception($conn->error);
    }
    
    $databases = [];
    $excluded = ['information_schema', 'mysql', 'performance_schema', 'sys'];
    
    while ($row = $result->fetch_array()) {
        if (!in_array($row[0], $excluded)) {
            $databases[] = $row[0];
        }
    }
    
    echo json_encode(['status' => 'ok', 'databases' => $databases]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
