<?php
/**
 * getImportSchema.php - API endpoint to fetch schema preview after file upload
 * 
 * @param string $tableName
 * @param string $database
 * @return array Schema details with column types, constraints, etc.
 */
require_once __DIR__ . '/../lib/TableOperations.php';
require_once __DIR__ . '/../lib/DatabaseHelper.php';

class SchemaPreviewer {
    public static function getSchemaPreview($tableName, $database = 'default') {
        $schema = TableOperations::getTableInfo($database, $tableName);
        $columns = DatabaseHelper::getColumns($tableName, $database);
        
        return [
            'tableName' => $tableName,
            'database' => $database,
            'schema' => $schema,
            'columns' => $columns,
            'previewUrl' => sprintf(
                'https://dev-app.filemonprime.net/importer/schema-preview.php?table=%s&db=%s',
                urlencode($tableName),
                urlencode($database)
            )
        ];
    }
}

// Example usage:
// Example usage:
