<?php
/**
 * API: Get Progress Update
 * Returns current progress for polling
 */

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../lib/ErrorHandler.php';
require_once __DIR__ . '/../lib/ProgressTracker.php';

header('Content-Type: application/json; charset=UTF-8');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

$key = $_GET['key'] ?? '';

if (empty($key)) {
    echo json_encode(['status' => 'error', 'message' => 'No progress key provided']);
    exit;
}

$progress = ProgressTracker::get($key);

if ($progress === null) {
    echo json_encode(['status' => 'not_found', 'message' => 'Progress not found']);
    exit;
}

// Add elapsed time estimate
if ($progress['status'] === 'in_progress' && isset($progress['started_at'])) {
    $elapsed = time() - $progress['started_at'];
    $progress['elapsed_seconds'] = $elapsed;
    
    // Estimate remaining time
    if ($progress['percent'] > 0 && $elapsed > 0) {
        $totalEstimated = ($elapsed / $progress['percent']) * 100;
        $progress['estimated_remaining'] = max(0, $totalEstimated - $elapsed);
    }
}

echo json_encode([
    'status' => 'ok',
    'progress' => $progress
]);
