<?php
/**
 * API: Get Previous Table Names
 * Returns list of table names from import history, sorted by recency
 */

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../lib/ErrorHandler.php';
require_once __DIR__ . '/../lib/ImportLogger.php';

header('Content-Type: application/json; charset=UTF-8');

try {
    $search = $_GET['search'] ?? '';
    $limit = min((int)($_GET['limit'] ?? 20), 50);
    
    // Get table names from ImportLogger
    $tableNames = ImportLogger::getRecentTableNames($search, $limit);
    
    echo json_encode([
        'status' => 'ok',
        'table_names' => $tableNames,
        'count' => count($tableNames)
    ]);
    
} catch (Exception $e) {
    ErrorHandler::logError('getTableNames API error: ' . $e->getMessage());
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
