<?php
include_once(__DIR__ . "/../config.php");
include_once(__DIR__ . "/../lib/DatabaseHelper.php");

header('Content-Type: application/json');

try {
    if (!isset($_GET['db']) || !isset($_GET['table'])) {
        throw new Exception('Database and table names are required');
    }

    $dbName = $_GET['db'];
    $tableName = $_GET['table'];
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $limit = 50;
    $offset = ($page - 1) * $limit;

    if ($page < 1) $page = 1;

    $db = DatabaseHelper::getInstance();
    $conn = $db->connect();
    
    // Validate and escape identifiers
    $safeDbName = $db->escapeIdentifier($dbName);
    $safeTableName = $db->escapeIdentifier($tableName);
    
    // Strip backticks for select_db
    $rawDbName = str_replace('`', '', $safeDbName);
    
    if (!$conn->select_db($rawDbName)) {
        throw new Exception("Could not select database");
    }
    
    // Get total count
    $countResult = $conn->query("SELECT COUNT(*) as c FROM $safeTableName");
    if (!$countResult) {
        throw new Exception($conn->error);
    }
    $totalRows = $countResult->fetch_assoc()['c'];
    
    // Get Data
    $sql = "SELECT * FROM $safeTableName LIMIT $limit OFFSET $offset";
    $result = $conn->query($sql);
    
    if (!$result) {
        throw new Exception($conn->error);
    }
    
    $rows = [];
    while ($row = $result->fetch_assoc()) {
        $rows[] = $row;
    }
    
    echo json_encode([
        'status' => 'ok',
        'rows' => $rows,
        'total' => (int)$totalRows,
        'page' => $page,
        'pages' => ceil($totalRows / $limit)
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
