<?php
include_once(__DIR__ . "/../config.php");
require_once 'MockCRUDEngine.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$db = $input['db'] ?? '';
$table = $input['table'] ?? '';
$id = $input['id'] ?? '';

if (!$db || !$table || !$id) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    exit;
}

try {
    $rows = MockCRUDEngine::deleteRow($db, $table, $id);
    echo json_encode(['status' => 'ok', 'rows' => $rows]);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
