<?php
include_once(__DIR__ . "/../config.php");
include_once(__DIR__ . "/../lib/DatabaseHelper.php");
include_once(__DIR__ . "/../lib/FormBuilder.php");
include_once(__DIR__ . "/../lib/Form.php");

// Get table and ID parameters
$table = $_GET['t'] ?? '';
$id = $_GET['id'] ?? '';
if (empty($table) || empty($id)) {
    die('No table or ID specified');
}

// Get database parameter 
$db = $_GET['db'] ?? '';
if (empty($db)) {
    die('No database specified');
}

// Validate database name
if (!preg_match('/^[a-zA-Z0-9_]+$/', $db)) {
    die('Invalid database name');
}

// Sanitize database name
$db = preg_replace('/[^a-zA-Z0-9_]/', '', $db);

// Check if modal parameter is set
$isModal = isset($_GET['modal']) && $_GET['modal'] == 1;

// Get table metadata and columns
$metadata = DatabaseHelper::getColumns($table, $db);
$columns = DatabaseHelper::getColumns($table, $db);

// Get existing record
$record = DatabaseHelper::getRow($table, $id, $db);
if (!$record) {
    die('Record not found');
}

// If modal, include modal wrapper
if ($isModal) {
    include 'ui/modal.php';
} else {
    // Standard page layout
    ?>
    <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit <?= htmlspecialchars(ucfirst($table)) ?> Record</title>
    <link rel="stylesheet" href="/importer/lib/forms-cyberpunk.css">
    <style>
        body {
            background-color: #0a0a0a;
            color: #00ff00;
            font-family: 'Courier New', monospace;
            margin: 0;
            padding: 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: #111;
            padding: 20px;
            border: 1px solid #00ff00;
            border-radius: 4px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #00ff00;
        }
        
        .back-button {
            background-color: #0066cc;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            margin-bottom: 20px;
            font-family: 'Courier New', monospace;
        }
        
        .back-button:hover {
            background-color: #0055aa;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Edit <?= htmlspecialchars(ucfirst($table)) ?> Record</h1>
            <button class="back-button" onclick="window.location.href='index.php?t=<?= urlencode($table) ?>'">
                ← Back to List
            </button>
        </div>
    <?php
}

// Load the generated form
$device = $_GET['device'] ?? 'desktop';
$formFile = FormBuilder::generate($table, $columns, $device);
$form = new Form($formFile);
$form->bind($record);
echo $form->render();
?>
</div>
</body>
</html>
