# RAG Index for PHP Importer Application

**Version:** 1.0.0

## Index Structure

```
docs/rag/
├── codebase/
│   ├── lib/
│   │   ├── DatabaseHelper.md
│   │   ├── SchemaDetector.md
│   │   ├── ImportLogger.md
│   │   ├── ErrorHandler.md
│   │   ├── DataValidator.md
│   │   ├── DataCleaner.md
│   │   ├── TableOperations.md
│   │   └── SchemaConventions.md
│   ├── api/
│   │   ├── getDatabases.md
│   │   ├── getTables.md
│   │   ├── getTableRows.md
│   │   ├── getTableNames.md
│   │   ├── getImportSchema.md
│   │   ├── getLastImportSchema.md
│   │   ├── getProgress.md
│   │   └── tableOperations.md
│   └── root/
│       ├── config.md
│       ├── arrival.md
│       └── insert.md
├── database/
│   ├── conventions.md
│   └── import_logger.md
└── README.md
```

## Usage

To query this index for LLM context:

```php
require_once 'lib/RagQuery.php';

$context = RagQuery::getContext("How do I add a new column to the import_logs table?");
```

## Query Examples

### Codebase Questions
- "What does the DatabaseHelper class do?"
- "How do I add a new column type to SchemaDetector?"
- "Explain the import logging flow"

### Database Questions
- "What tables are in the importer database?"
- "What is the primary key for the propietarios table?"
- "Show me the import_logs schema"

### API Questions
- "How do I get a list of tables?"
- "What parameters does getTableRows accept?"
- "What does the tableOperations endpoint do?"

### Conventions Questions
- "What are the standard audit fields?"
- "How are primary keys named?"
- "What is the character set?"

