# Class: Form

**File:** `Form.php`


## Description

Form - The Dynamic Wrapper
Wraps generated HTML forms to allow binding data and setting attributes

## Methods

### Public::bind()

/**
Form - The Dynamic Wrapper
Wraps generated HTML forms to allow binding data and setting attributes
/
class Form {
    private string $htmlContent;
    private string $formPath;

```php
/**
 * Form - The Dynamic Wrapper
 * Wraps generated HTML forms to allow binding data and setting attributes
 */
class Form {
    private string $htmlContent;
    private string $formPath;
    
    public function __construct(string $formPath) {
        if (!file_exists($formPath)) {
            throw new Exception("Form file not found: {$formPath}");
        }
        $this->formPath = $formPath;
        $this->htmlContent = file_get_contents($formPath);
    }
    
    /**
     * Bind data to form fields
     * @param array $data Associative array of field => value pairs
     * @return void
     */
    public function bind(
```

### Public::setMode()

/**
Set form mode (insert/edit)
@param string $mode Either 'insert' or 'edit'
@return void
/

```php
/**
     * Set form mode (insert/edit)
     * @param string $mode Either 'insert' or 'edit'
     * @return void
     */
    public function setMode(
```

### Public::setAction()

/**
Set form action URL
@param string $action The action URL
@return void
/

```php
/**
     * Set form action URL
     * @param string $action The action URL
     * @return void
     */
    public function setAction(
```

### Public::render()

/**
Render the final HTML form
@return string
/

```php
/**
     * Render the final HTML form
     * @return string
     */
    public function render(
```

### Public::getHtml()

/**
Get the raw HTML content
@return string
/

```php
/**
     * Get the raw HTML content
     * @return string
     */
    public function getHtml(
```

