# Class: FormBuilder

**File:** `FormBuilder.php`


## Description

Class FormBuilder
* The main engine for PhoenixForms (Gate 7).
It generates complete form files based on database table metadata.

## Constants

- `TEMPLATE_BASE_PATH`
- `OUTPUT_PATH`

## Methods

### Public::__construct()

/**
Class FormBuilder
* The main engine for PhoenixForms (Gate 7).
It generates complete form files based on database table metadata.
/
class FormBuilder
{
    private string $tableName;
    private array $columns;
    private string $device;
    private string $templatePath;
    private FormTemplate $templateEngine;

```php
/**
 * Class FormBuilder
 *
 * The main engine for PhoenixForms (Gate 7).
 * It generates complete form files based on database table metadata.
 */
class FormBuilder
{
    private string $tableName;
    private array $columns;
    private string $device;
    private string $templatePath;
    private FormTemplate $templateEngine;

    private const TEMPLATE_BASE_PATH = '/importer/forms/templates/';
    private const OUTPUT_PATH = '/importer/forms/generated/';

    /**
     * @param string $tableName The name of the database table.
     * @param array $columns Metadata for the table columns (from DatabaseHelper).
     * @param string $device The target device ('mobile', 'tablet', 'desktop').
     */
    public function __construct(
```

### Public::build()

/**
Static factory to generate a form.
* @param string $tableName
@param array $columns
@param string $device
@return string The path to the generated file.
@throws Exception
/
    public static function generate(string $tableName, array $columns, string $device): string
    {
        $builder = new self($tableName, $columns, $device);
        return $builder->build();
    }

```php
/**
     * Static factory to generate a form.
     *
     * @param string $tableName
     * @param array $columns
     * @param string $device
     * @return string The path to the generated file.
     * @throws Exception
     */
    public static function generate(string $tableName, array $columns, string $device): string
    {
        $builder = new self($tableName, $columns, $device);
        return $builder->build();
    }

    /**
     * Builds the form and writes it to a file.
     * @return string The path to the generated file.
     * @throws Exception
     */
    public function build(
```

