# Class: FormTemplate

**File:** `FormTemplate.php`


## Description

Class FormTemplate
* A simple and fast template wrapper for PhoenixForms.
It loads .tpl files, replaces placeholders, and renders the output.

## Methods

### Public::loadTemplate()

/**
Class FormTemplate
* A simple and fast template wrapper for PhoenixForms.
It loads .tpl files, replaces placeholders, and renders the output.
/
class FormTemplate
{
    private string $templateContent = '';

```php
/**
 * Class FormTemplate
 *
 * A simple and fast template wrapper for PhoenixForms.
 * It loads .tpl files, replaces placeholders, and renders the output.
 */
class FormTemplate
{
    private string $templateContent = '';

    /**
     * Loads a template file from the specified path.
     *
     * @param string $path Full path to the .tpl file.
     * @return self
     * @throws Exception if the template file is not found or readable.
     */
    public function loadTemplate(
```

### Public::replace()

/**
Replaces placeholders in the template.
Placeholders are in the format {{KEY}}.
* @param string $key The placeholder key (without brackets).
@param string $value The value to substitute.
@return self
/

```php
/**
     * Replaces placeholders in the template.
     * Placeholders are in the format {{KEY}}.
     *
     * @param string $key The placeholder key (without brackets).
     * @param string $value The value to substitute.
     * @return self
     */
    public function replace(
```

### Public::render()

/**
Renders the final template content.
@return string
/

```php
/**
     * Renders the final template content.
     * @return string
     */
    public function render(
```

