# Database Schema Conventions

## Primary Key Naming

Dynamic, table-specific naming convention:

- Pattern: `{singular_table}_id`
- Example: `propietarios` table -> `propietario_id` primary key

## Standard Audit Fields (Spanish Canonical)

| Field | Type | Constraint | Description |
|-------|------|------------|-------------|
| `alta_db` | TIMESTAMP | DEFAULT CURRENT_TIMESTAMP | Timestamp of record insertion |
| `alta_por` | VARCHAR(32) | DEFAULT 'system' | User who inserted the record |
| `ultimo_cambio` | TIMESTAMP | NULL DEFAULT NULL | Timestamp of last modification |
| `ultimo_cambio_por` | VARCHAR(32) | NULL | User who made last change |

## Table Naming

- Use plural form: `propietarios`, `departments`, `alumnos_becados`

## Character Set

- `utf8mb4` with `utf8mb4_unicode_ci` collation

## Storage Engine

- `InnoDB` for transaction support

## Singular/Plular Mapping

| Plural | Singular |
|--------|----------|
| propietarios | propietario |
| departments | department |
| alumnos_becados | alumno_becado |
| eleyeme_cfdi_emitidos | eleyeme_cfdi_emitido |
