<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{FORM_TITLE}}</title>
    <link rel="stylesheet" href="/importer/lib/forms{{THEME}}.css">
    <style>
        body {
            background: radial-gradient(circle at top, #020d18 0%, #000000 70%);
            font-family: 'Consolas', 'Monaco', monospace;
            color: #e0f7ff;
            margin: 0;
            padding: 2rem;
            min-height: 100vh;
        }
        .panel {
            background: rgba(0,0,0,0.35);
            border: 1px solid #00eaff55;
            box-shadow: 0 0 20px #00eaff44;
            margin: 20px auto;
            padding: 25px;
            border-radius: 12px;
            width: 95%;
            max-width: 1400px;
            animation: fadein 0.6s ease;
        }
        @keyframes fadein {
            from { opacity:0; transform: translateY(20px); }
            to { opacity:1; transform: translateY(0); }
        }
        .phoenix-form {
            background: rgba(0,0,0,0.35);
            border: 1px solid #00eaff55;
            box-shadow: 0 0 20px #00eaff44;
            border-radius: 12px;
            padding: 2rem;
            max-width: 900px;
            margin: 0 auto;
            animation: fadein 0.6s ease;
        }
        .phoenix-form h1 {
            text-shadow: 0 0 12px #00eaff;
            margin: 0 0 2rem 0;
            color: #e0f7ff;
            text-align: center;
            font-weight: 300;
            letter-spacing: 1px;
        }
        .phoenix-field label {
            color: #00ffaa;
            margin-bottom: 8px;
            font-size: 16px;
        }
        .phoenix-input {
            width: 100%;
            background: #000;
            color: #00eaff;
            border: 1px solid #00eaff55;
            padding: 12px;
            border-radius: 4px;
            font-family: 'Consolas', monospace;
            font-size: 18px;
            transition: all 0.2s ease-in-out;
        }
        .phoenix-input:focus {
            outline: none;
            border-color: #00eaff;
            box-shadow: 0 0 10px #00eaff44;
        }
        .phoenix-save, .phoenix-cancel {
            background: #00eaff;
            color: #000;
            padding: 12px 24px;
            border-radius: 4px;
            border: none;
            cursor: pointer;
            font-weight: bold;
            box-shadow: 0 0 10px #00eaff88;
            transition: all 0.2s ease;
            font-family: 'Consolas', monospace;
            font-size: 16px;
        }
        .phoenix-save:hover {
            transform: scale(1.05);
            box-shadow: 0 0 15px #00eaff;
        }
        .phoenix-cancel {
            background: #ff3366;
            color: #fff;
            box-shadow: 0 0 10px #ff336688;
        }
        .phoenix-cancel:hover {
            box-shadow: 0 0 15px #ff3366;
        }
    </style>
</head>
<body>
    <div class="panel">
        <form id="form-{{TABLE}}" class="phoenix-form {{DEVICE_CLASS}}" data-table="{{TABLE}}">
            <h1>{{FORM_TITLE}}</h1>
            <div class="fields-grid">
            {{FIELDS}}
            </div>
            {{ACTIONS}}
        </form>
    </div>
    <script src="/importer/lib/forms.js"></script>
</body>
</html>
