-- ============================================
-- 🌌 Exodus Migration Script
-- ============================================
-- Generated: 2026-01-02 21:06:59
-- Database: importer_db
-- Platform: linux
-- PHP Version: {PHP_VERSION}
-- ============================================
--
-- SAFE TO RE-RUN: This script checks for existing
-- tables and columns before making changes.
--
-- Each column is added individually, so partial
-- migrations can be resumed without errors.
--
-- ============================================

-- Ensure database exists (create if missing)
CREATE DATABASE IF NOT EXISTS `importer_db`
    DEFAULT CHARACTER SET utf8mb4
    COLLATE utf8mb4_unicode_ci;

USE `importer_db`;


-- ============================================
-- Table: agoda_transaction
-- Columns: 29
-- ============================================

-- Create table structure (if missing)
CREATE TABLE IF NOT EXISTS `agoda_transaction` (
    `placeholder_id` INT AUTO_INCREMENT PRIMARY KEY COMMENT 'Temporary placeholder'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add columns one by one (safe to re-run)

-- Column 1: agoda_transaction_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'agoda_transaction_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `agoda_transaction_id` varchar(32) NOT NULL',
    'SELECT "Column agoda_transaction_id already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 2: bookingidexternal_reference_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'bookingidexternal_reference_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `bookingidexternal_reference_id` varchar(100) NOT NULL',
    'SELECT "Column bookingidexternal_reference_id already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 3: booking_status
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'booking_status'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `booking_status` varchar(50) NOT NULL',
    'SELECT "Column booking_status already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 4: staydatefrom
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'staydatefrom'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `staydatefrom` date NOT NULL',
    'SELECT "Column staydatefrom already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 5: staydateto
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'staydateto'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `staydateto` date NOT NULL',
    'SELECT "Column staydateto already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 6: bookeddate
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'bookeddate'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `bookeddate` date NOT NULL',
    'SELECT "Column bookeddate already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 7: customer_name
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'customer_name'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `customer_name` varchar(50) NOT NULL',
    'SELECT "Column customer_name already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 8: customer_nationality
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'customer_nationality'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `customer_nationality` varchar(50) NOT NULL',
    'SELECT "Column customer_nationality already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 9: roomtype
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'roomtype'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `roomtype` varchar(50) NOT NULL',
    'SELECT "Column roomtype already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 10: special_request
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'special_request'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `special_request` varchar(255) NULL',
    'SELECT "Column special_request already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 11: no_of_night
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'no_of_night'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `no_of_night` int NOT NULL',
    'SELECT "Column no_of_night already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 12: no_of_adult
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'no_of_adult'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `no_of_adult` int NOT NULL',
    'SELECT "Column no_of_adult already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 13: no_of_children
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'no_of_children'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `no_of_children` int NOT NULL',
    'SELECT "Column no_of_children already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 14: no_of_extra_bed
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'no_of_extra_bed'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `no_of_extra_bed` int NOT NULL',
    'SELECT "Column no_of_extra_bed already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 15: channel
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'channel'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `channel` varchar(50) NOT NULL',
    'SELECT "Column channel already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 16: rateplan
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'rateplan'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `rateplan` varchar(50) NOT NULL',
    'SELECT "Column rateplan already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 17: promotiontype
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'promotiontype'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `promotiontype` varchar(100) NOT NULL',
    'SELECT "Column promotiontype already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 18: cancellationpolicycode
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'cancellationpolicycode'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `cancellationpolicycode` varchar(50) NOT NULL',
    'SELECT "Column cancellationpolicycode already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 19: cancellationpolicydescription
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'cancellationpolicydescription'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `cancellationpolicydescription` varchar(500) NOT NULL',
    'SELECT "Column cancellationpolicydescription already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 20: acknowledged
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'acknowledged'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `acknowledged` varchar(50) NOT NULL',
    'SELECT "Column acknowledged already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 21: total_inclusive_rate
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'total_inclusive_rate'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `total_inclusive_rate` decimal(10,4) NOT NULL',
    'SELECT "Column total_inclusive_rate already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 22: currency
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'currency'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `currency` varchar(50) NOT NULL',
    'SELECT "Column currency already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 23: paymentmodel
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'paymentmodel'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `paymentmodel` varchar(50) NOT NULL',
    'SELECT "Column paymentmodel already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 24: referencesellinclusive
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'referencesellinclusive'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `referencesellinclusive` varchar(50) NOT NULL',
    'SELECT "Column referencesellinclusive already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 25: commission
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'commission'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `commission` varchar(50) NOT NULL',
    'SELECT "Column commission already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 26: alta_db
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'alta_db'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `alta_db` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
    'SELECT "Column alta_db already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 27: alta_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'alta_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `alta_por` varchar(32) NULL DEFAULT 'system'',
    'SELECT "Column alta_por already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 28: ultimo_cambio
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'ultimo_cambio'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `ultimo_cambio` timestamp NULL',
    'SELECT "Column ultimo_cambio already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 29: ultimo_cambio_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'ultimo_cambio_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `agoda_transaction` ADD COLUMN `ultimo_cambio_por` varchar(32) NULL',
    'SELECT "Column ultimo_cambio_por already exists in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Remove placeholder column (if exists)
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'agoda_transaction'
        AND COLUMN_NAME = 'placeholder_id'
);

SET @sql = IF(@col_exists > 0,
    'ALTER TABLE `agoda_transaction` DROP COLUMN `placeholder_id`',
    'SELECT "Column placeholder_id does not exist in agoda_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- ============================================
-- Table: booking_transaction
-- Columns: 35
-- ============================================

-- Create table structure (if missing)
CREATE TABLE IF NOT EXISTS `booking_transaction` (
    `placeholder_id` INT AUTO_INCREMENT PRIMARY KEY COMMENT 'Temporary placeholder'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add columns one by one (safe to re-run)

-- Column 1: booking_transaction_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'booking_transaction_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `booking_transaction_id` varchar(32) NOT NULL',
    'SELECT "Column booking_transaction_id already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 2: type_transaction_type
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'type_transaction_type'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `type_transaction_type` varchar(50) NOT NULL',
    'SELECT "Column type_transaction_type already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 3: statement_descriptor
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'statement_descriptor'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `statement_descriptor` varchar(50) NOT NULL',
    'SELECT "Column statement_descriptor already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 4: reference_number
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'reference_number'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `reference_number` varchar(20) NOT NULL',
    'SELECT "Column reference_number already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 5: check_in_date
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'check_in_date'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `check_in_date` date NOT NULL',
    'SELECT "Column check_in_date already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 6: check_out_date
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'check_out_date'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `check_out_date` date NOT NULL',
    'SELECT "Column check_out_date already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 7: issue_date
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'issue_date'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `issue_date` date NOT NULL',
    'SELECT "Column issue_date already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 8: reservation_status
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'reservation_status'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `reservation_status` varchar(50) NOT NULL',
    'SELECT "Column reservation_status already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 9: rooms
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'rooms'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `rooms` int NOT NULL',
    'SELECT "Column rooms already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 10: room_nights
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'room_nights'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `room_nights` int NOT NULL',
    'SELECT "Column room_nights already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 11: property_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'property_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `property_id` varchar(20) NOT NULL',
    'SELECT "Column property_id already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 12: property_name
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'property_name'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `property_name` varchar(100) NOT NULL',
    'SELECT "Column property_name already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 13: legal_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'legal_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `legal_id` varchar(20) NOT NULL',
    'SELECT "Column legal_id already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 14: legal_name
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'legal_name'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `legal_name` varchar(50) NOT NULL',
    'SELECT "Column legal_name already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 15: country
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'country'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `country` varchar(50) NOT NULL',
    'SELECT "Column country already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 16: payout_type
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'payout_type'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `payout_type` varchar(50) NOT NULL',
    'SELECT "Column payout_type already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 17: gross_amount
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'gross_amount'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `gross_amount` decimal(10,2) NOT NULL',
    'SELECT "Column gross_amount already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 18: commission
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'commission'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `commission` decimal(10,2) NOT NULL',
    'SELECT "Column commission already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 19: commission_percentage
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'commission_percentage'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `commission_percentage` decimal(10,2) NOT NULL',
    'SELECT "Column commission_percentage already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 20: payments_by_booking_com_fee
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'payments_by_booking_com_fee'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `payments_by_booking_com_fee` decimal(10,2) NOT NULL',
    'SELECT "Column payments_by_booking_com_fee already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 21: payments_by_booking_com_fee_percentage
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'payments_by_booking_com_fee_percentage'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `payments_by_booking_com_fee_percentage` decimal(10,2) NOT NULL',
    'SELECT "Column payments_by_booking_com_fee_percentage already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 22: tax_vat
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'tax_vat'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `tax_vat` decimal(10,2) NOT NULL',
    'SELECT "Column tax_vat already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 23: transaction_amount
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'transaction_amount'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `transaction_amount` decimal(10,2) NOT NULL',
    'SELECT "Column transaction_amount already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 24: transaction_currency
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'transaction_currency'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `transaction_currency` varchar(50) NOT NULL',
    'SELECT "Column transaction_currency already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 25: exchange_rate
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'exchange_rate'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `exchange_rate` decimal(10,4) NOT NULL',
    'SELECT "Column exchange_rate already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 26: payable_amount
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'payable_amount'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `payable_amount` decimal(10,2) NOT NULL',
    'SELECT "Column payable_amount already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 27: payout_amount
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'payout_amount'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `payout_amount` decimal(10,2) NOT NULL',
    'SELECT "Column payout_amount already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 28: payout_currency
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'payout_currency'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `payout_currency` varchar(50) NOT NULL',
    'SELECT "Column payout_currency already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 29: payout_date
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'payout_date'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `payout_date` date NOT NULL',
    'SELECT "Column payout_date already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 30: payout_frequency
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'payout_frequency'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `payout_frequency` varchar(50) NOT NULL',
    'SELECT "Column payout_frequency already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 31: bank_account
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'bank_account'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `bank_account` varchar(50) NOT NULL',
    'SELECT "Column bank_account already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 32: alta_db
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'alta_db'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `alta_db` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
    'SELECT "Column alta_db already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 33: alta_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'alta_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `alta_por` varchar(32) NULL DEFAULT 'system'',
    'SELECT "Column alta_por already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 34: ultimo_cambio
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'ultimo_cambio'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `ultimo_cambio` timestamp NULL',
    'SELECT "Column ultimo_cambio already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 35: ultimo_cambio_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'ultimo_cambio_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `booking_transaction` ADD COLUMN `ultimo_cambio_por` varchar(32) NULL',
    'SELECT "Column ultimo_cambio_por already exists in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Remove placeholder column (if exists)
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'booking_transaction'
        AND COLUMN_NAME = 'placeholder_id'
);

SET @sql = IF(@col_exists > 0,
    'ALTER TABLE `booking_transaction` DROP COLUMN `placeholder_id`',
    'SELECT "Column placeholder_id does not exist in booking_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- ============================================
-- Table: casitamx_transaction
-- Columns: 25
-- ============================================

-- Create table structure (if missing)
CREATE TABLE IF NOT EXISTS `casitamx_transaction` (
    `placeholder_id` INT AUTO_INCREMENT PRIMARY KEY COMMENT 'Temporary placeholder'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add columns one by one (safe to re-run)

-- Column 1: casitamx_transaction_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'casitamx_transaction_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `casitamx_transaction_id` varchar(32) NOT NULL',
    'SELECT "Column casitamx_transaction_id already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 2: guest
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'guest'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `guest` varchar(100) NOT NULL',
    'SELECT "Column guest already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 3: date_reserved
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'date_reserved'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `date_reserved` date NOT NULL',
    'SELECT "Column date_reserved already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 4: email
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'email'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `email` varchar(50) NULL',
    'SELECT "Column email already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 5: phone
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'phone'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `phone` varchar(50) NULL',
    'SELECT "Column phone already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 6: guests
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'guests'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `guests` int NOT NULL',
    'SELECT "Column guests already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 7: hostify
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'hostify'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `hostify` varchar(50) NOT NULL',
    'SELECT "Column hostify already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 8: total_payment_host_will_receive
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'total_payment_host_will_receive'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `total_payment_host_will_receive` decimal(10,2) NOT NULL',
    'SELECT "Column total_payment_host_will_receive already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 9: sent_to_host
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'sent_to_host'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `sent_to_host` decimal(10,2) NULL',
    'SELECT "Column sent_to_host already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 10: check_in
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'check_in'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `check_in` date NOT NULL',
    'SELECT "Column check_in already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 11: check_out
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'check_out'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `check_out` date NOT NULL',
    'SELECT "Column check_out already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 12: property
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'property'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `property` varchar(100) NOT NULL',
    'SELECT "Column property already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 13: need_to_refund
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'need_to_refund'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `need_to_refund` varchar(50) NULL',
    'SELECT "Column need_to_refund already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 14: host_rate
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'host_rate'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `host_rate` decimal(10,2) NOT NULL',
    'SELECT "Column host_rate already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 15: host_fee
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'host_fee'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `host_fee` decimal(10,2) NULL',
    'SELECT "Column host_fee already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 16: interchange
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'interchange'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `interchange` decimal(10,4) NULL',
    'SELECT "Column interchange already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 17: mxn_convert
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'mxn_convert'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `mxn_convert` decimal(10,2) NOT NULL',
    'SELECT "Column mxn_convert already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 18: payment_date
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'payment_date'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `payment_date` date NULL',
    'SELECT "Column payment_date already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 19: location
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'location'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `location` varchar(50) NULL',
    'SELECT "Column location already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 20: operator
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'operator'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `operator` varchar(50) NOT NULL',
    'SELECT "Column operator already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 21: nights
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'nights'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `nights` int NOT NULL',
    'SELECT "Column nights already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 22: alta_db
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'alta_db'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `alta_db` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
    'SELECT "Column alta_db already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 23: alta_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'alta_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `alta_por` varchar(32) NULL DEFAULT 'system'',
    'SELECT "Column alta_por already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 24: ultimo_cambio
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'ultimo_cambio'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `ultimo_cambio` timestamp NULL',
    'SELECT "Column ultimo_cambio already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 25: ultimo_cambio_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'ultimo_cambio_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `casitamx_transaction` ADD COLUMN `ultimo_cambio_por` varchar(32) NULL',
    'SELECT "Column ultimo_cambio_por already exists in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Remove placeholder column (if exists)
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'casitamx_transaction'
        AND COLUMN_NAME = 'placeholder_id'
);

SET @sql = IF(@col_exists > 0,
    'ALTER TABLE `casitamx_transaction` DROP COLUMN `placeholder_id`',
    'SELECT "Column placeholder_id does not exist in casitamx_transaction" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- ============================================
-- Table: cloudbed_reserva
-- Columns: 39
-- ============================================

-- Create table structure (if missing)
CREATE TABLE IF NOT EXISTS `cloudbed_reserva` (
    `placeholder_id` INT AUTO_INCREMENT PRIMARY KEY COMMENT 'Temporary placeholder'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add columns one by one (safe to re-run)

-- Column 1: cloudbed_reserva_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'cloudbed_reserva_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `cloudbed_reserva_id` varchar(32) NOT NULL',
    'SELECT "Column cloudbed_reserva_id already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 2: property
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'property'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `property` varchar(50) NOT NULL',
    'SELECT "Column property already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 3: name
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'name'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `name` varchar(100) NOT NULL',
    'SELECT "Column name already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 4: email
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'email'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `email` varchar(50) NOT NULL',
    'SELECT "Column email already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 5: phone_number
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'phone_number'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `phone_number` varchar(50) NULL',
    'SELECT "Column phone_number already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 6: gender
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'gender'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `gender` varchar(50) NOT NULL',
    'SELECT "Column gender already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 7: reservation_number
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'reservation_number'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `reservation_number` varchar(50) NOT NULL',
    'SELECT "Column reservation_number already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 8: third_party_confirmation_number
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'third_party_confirmation_number'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `third_party_confirmation_number` int NULL',
    'SELECT "Column third_party_confirmation_number already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 9: type_of_document
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'type_of_document'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `type_of_document` varchar(50) NOT NULL',
    'SELECT "Column type_of_document already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 10: document_issuing_country
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'document_issuing_country'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `document_issuing_country` varchar(50) NULL',
    'SELECT "Column document_issuing_country already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 11: street_address
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'street_address'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `street_address` varchar(50) NULL',
    'SELECT "Column street_address already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 12: apt_suite_floor_etc
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'apt_suite_floor_etc'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `apt_suite_floor_etc` varchar(50) NULL',
    'SELECT "Column apt_suite_floor_etc already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 13: city
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'city'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `city` varchar(50) NULL',
    'SELECT "Column city already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 14: state
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'state'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `state` varchar(50) NULL',
    'SELECT "Column state already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 15: postal_zip_code
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'postal_zip_code'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `postal_zip_code` varchar(50) NULL',
    'SELECT "Column postal_zip_code already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 16: adults
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'adults'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `adults` int NOT NULL',
    'SELECT "Column adults already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 17: children
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'children'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `children` int NOT NULL',
    'SELECT "Column children already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 18: room_number
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'room_number'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `room_number` varchar(100) NOT NULL',
    'SELECT "Column room_number already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 19: accommodation_total
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'accommodation_total'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `accommodation_total` decimal(10,2) NOT NULL',
    'SELECT "Column accommodation_total already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 20: amount_paid
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'amount_paid'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `amount_paid` decimal(10,2) NOT NULL',
    'SELECT "Column amount_paid already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 21: check_in_date
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'check_in_date'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `check_in_date` date NOT NULL',
    'SELECT "Column check_in_date already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 22: check_out_date
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'check_out_date'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `check_out_date` date NOT NULL',
    'SELECT "Column check_out_date already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 23: nights
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'nights'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `nights` int NOT NULL',
    'SELECT "Column nights already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 24: room_type
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'room_type'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `room_type` varchar(255) NOT NULL',
    'SELECT "Column room_type already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 25: grand_total
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'grand_total'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `grand_total` decimal(10,2) NOT NULL',
    'SELECT "Column grand_total already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 26: deposit
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'deposit'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `deposit` decimal(10,2) NOT NULL',
    'SELECT "Column deposit already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 27: balance_due
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'balance_due'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `balance_due` decimal(10,2) NOT NULL',
    'SELECT "Column balance_due already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 28: reservation_date
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'reservation_date'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `reservation_date` date NOT NULL',
    'SELECT "Column reservation_date already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 29: source
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'source'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `source` varchar(100) NOT NULL',
    'SELECT "Column source already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 30: status
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'status'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `status` varchar(50) NOT NULL',
    'SELECT "Column status already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 31: country
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'country'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `country` varchar(50) NOT NULL',
    'SELECT "Column country already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 32: cancelation_date
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'cancelation_date'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `cancelation_date` date NULL',
    'SELECT "Column cancelation_date already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 33: estimated_arrival_time
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'estimated_arrival_time'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `estimated_arrival_time` varchar(50) NOT NULL',
    'SELECT "Column estimated_arrival_time already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 34: origin
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'origin'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `origin` varchar(50) NULL',
    'SELECT "Column origin already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 35: cancelation_fee
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'cancelation_fee'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `cancelation_fee` decimal(10,2) NULL',
    'SELECT "Column cancelation_fee already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 36: alta_db
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'alta_db'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `alta_db` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
    'SELECT "Column alta_db already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 37: alta_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'alta_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `alta_por` varchar(32) NULL DEFAULT 'system'',
    'SELECT "Column alta_por already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 38: ultimo_cambio
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'ultimo_cambio'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `ultimo_cambio` timestamp NULL',
    'SELECT "Column ultimo_cambio already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 39: ultimo_cambio_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'ultimo_cambio_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `cloudbed_reserva` ADD COLUMN `ultimo_cambio_por` varchar(32) NULL',
    'SELECT "Column ultimo_cambio_por already exists in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Remove placeholder column (if exists)
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'cloudbed_reserva'
        AND COLUMN_NAME = 'placeholder_id'
);

SET @sql = IF(@col_exists > 0,
    'ALTER TABLE `cloudbed_reserva` DROP COLUMN `placeholder_id`',
    'SELECT "Column placeholder_id does not exist in cloudbed_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- ============================================
-- Table: hostify_reserva
-- Columns: 14
-- ============================================

-- Create table structure (if missing)
CREATE TABLE IF NOT EXISTS `hostify_reserva` (
    `placeholder_id` INT AUTO_INCREMENT PRIMARY KEY COMMENT 'Temporary placeholder'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add columns one by one (safe to re-run)

-- Column 1: hostify_reserva_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'hostify_reserva_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `hostify_reserva_id` varchar(32) NOT NULL',
    'SELECT "Column hostify_reserva_id already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 2: confirmation_code
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'confirmation_code'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `confirmation_code` varchar(50) NULL',
    'SELECT "Column confirmation_code already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 3: guest_name
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'guest_name'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `guest_name` varchar(50) NOT NULL',
    'SELECT "Column guest_name already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 4: check_in
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'check_in'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `check_in` date NOT NULL',
    'SELECT "Column check_in already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 5: check_out
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'check_out'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `check_out` date NOT NULL',
    'SELECT "Column check_out already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 6: channel
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'channel'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `channel` varchar(50) NOT NULL',
    'SELECT "Column channel already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 7: anuncio
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'anuncio'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `anuncio` varchar(100) NOT NULL',
    'SELECT "Column anuncio already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 8: total_price
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'total_price'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `total_price` decimal(10,2) NULL',
    'SELECT "Column total_price already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 9: nights
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'nights'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `nights` int NOT NULL',
    'SELECT "Column nights already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 10: currency
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'currency'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `currency` varchar(50) NOT NULL',
    'SELECT "Column currency already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 11: alta_db
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'alta_db'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `alta_db` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
    'SELECT "Column alta_db already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 12: alta_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'alta_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `alta_por` varchar(32) NULL DEFAULT 'system'',
    'SELECT "Column alta_por already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 13: ultimo_cambio
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'ultimo_cambio'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `ultimo_cambio` timestamp NULL',
    'SELECT "Column ultimo_cambio already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 14: ultimo_cambio_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'ultimo_cambio_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `hostify_reserva` ADD COLUMN `ultimo_cambio_por` varchar(32) NULL',
    'SELECT "Column ultimo_cambio_por already exists in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Remove placeholder column (if exists)
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'hostify_reserva'
        AND COLUMN_NAME = 'placeholder_id'
);

SET @sql = IF(@col_exists > 0,
    'ALTER TABLE `hostify_reserva` DROP COLUMN `placeholder_id`',
    'SELECT "Column placeholder_id does not exist in hostify_reserva" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- ============================================
-- Table: import_logger_meta
-- Columns: 3
-- ============================================

-- Create table structure (if missing)
CREATE TABLE IF NOT EXISTS `import_logger_meta` (
    `placeholder_id` INT AUTO_INCREMENT PRIMARY KEY COMMENT 'Temporary placeholder'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add columns one by one (safe to re-run)

-- Column 1: meta_key
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logger_meta'
        AND COLUMN_NAME = 'meta_key'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logger_meta` ADD COLUMN `meta_key` varchar(64) NOT NULL',
    'SELECT "Column meta_key already exists in import_logger_meta" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 2: meta_value
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logger_meta'
        AND COLUMN_NAME = 'meta_value'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logger_meta` ADD COLUMN `meta_value` text NULL',
    'SELECT "Column meta_value already exists in import_logger_meta" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 3: ultima_actualizacion
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logger_meta'
        AND COLUMN_NAME = 'ultima_actualizacion'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logger_meta` ADD COLUMN `ultima_actualizacion` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
    'SELECT "Column ultima_actualizacion already exists in import_logger_meta" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Remove placeholder column (if exists)
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logger_meta'
        AND COLUMN_NAME = 'placeholder_id'
);

SET @sql = IF(@col_exists > 0,
    'ALTER TABLE `import_logger_meta` DROP COLUMN `placeholder_id`',
    'SELECT "Column placeholder_id does not exist in import_logger_meta" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- ============================================
-- Table: import_logs
-- Columns: 22
-- ============================================

-- Create table structure (if missing)
CREATE TABLE IF NOT EXISTS `import_logs` (
    `placeholder_id` INT AUTO_INCREMENT PRIMARY KEY COMMENT 'Temporary placeholder'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add columns one by one (safe to re-run)

-- Column 1: import_log_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'import_log_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `import_log_id` varchar(32) NOT NULL',
    'SELECT "Column import_log_id already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 2: database_name
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'database_name'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `database_name` varchar(64) NOT NULL',
    'SELECT "Column database_name already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 3: table_name
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'table_name'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `table_name` varchar(64) NOT NULL',
    'SELECT "Column table_name already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 4: file_name
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'file_name'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `file_name` varchar(255) NULL',
    'SELECT "Column file_name already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 5: file_type
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'file_type'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `file_type` enum('XLSX','CSV') NOT NULL',
    'SELECT "Column file_type already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 6: file_size
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'file_size'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `file_size` int NULL',
    'SELECT "Column file_size already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 7: file_path
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'file_path'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `file_path` varchar(500) NULL',
    'SELECT "Column file_path already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 8: operation_status
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'operation_status'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `operation_status` enum('pending','success','error','partial') NOT NULL DEFAULT 'pending'',
    'SELECT "Column operation_status already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 9: create_table_status
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'create_table_status'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `create_table_status` enum('pending','created','already_exists','error') NOT NULL DEFAULT 'pending'',
    'SELECT "Column create_table_status already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 10: create_table_sql
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'create_table_sql'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `create_table_sql` text NULL',
    'SELECT "Column create_table_sql already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 11: create_table_error
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'create_table_error'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `create_table_error` text NULL',
    'SELECT "Column create_table_error already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 12: rows_processed
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'rows_processed'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `rows_processed` int NULL DEFAULT '0'',
    'SELECT "Column rows_processed already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 13: rows_inserted
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'rows_inserted'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `rows_inserted` int NULL DEFAULT '0'',
    'SELECT "Column rows_inserted already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 14: rows_failed
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'rows_failed'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `rows_failed` int NULL DEFAULT '0'',
    'SELECT "Column rows_failed already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 15: error_details
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'error_details'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `error_details` json NULL',
    'SELECT "Column error_details already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 16: csv_delimiter
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'csv_delimiter'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `csv_delimiter` varchar(10) NULL',
    'SELECT "Column csv_delimiter already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 17: csv_encoding
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'csv_encoding'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `csv_encoding` varchar(20) NULL',
    'SELECT "Column csv_encoding already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 18: csv_normalized_rows
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'csv_normalized_rows'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `csv_normalized_rows` int NULL DEFAULT '0'',
    'SELECT "Column csv_normalized_rows already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 19: alta_db
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'alta_db'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `alta_db` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
    'SELECT "Column alta_db already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 20: alta_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'alta_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `alta_por` varchar(32) NULL DEFAULT 'system'',
    'SELECT "Column alta_por already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 21: ultimo_cambio
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'ultimo_cambio'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `ultimo_cambio` timestamp NULL ON UPDATE CURRENT_TIMESTAMP',
    'SELECT "Column ultimo_cambio already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 22: ultimo_cambio_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'ultimo_cambio_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_logs` ADD COLUMN `ultimo_cambio_por` varchar(32) NULL',
    'SELECT "Column ultimo_cambio_por already exists in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Remove placeholder column (if exists)
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_logs'
        AND COLUMN_NAME = 'placeholder_id'
);

SET @sql = IF(@col_exists > 0,
    'ALTER TABLE `import_logs` DROP COLUMN `placeholder_id`',
    'SELECT "Column placeholder_id does not exist in import_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- ============================================
-- Table: import_schema_logs
-- Columns: 14
-- ============================================

-- Create table structure (if missing)
CREATE TABLE IF NOT EXISTS `import_schema_logs` (
    `placeholder_id` INT AUTO_INCREMENT PRIMARY KEY COMMENT 'Temporary placeholder'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add columns one by one (safe to re-run)

-- Column 1: import_schema_log_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'import_schema_log_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `import_schema_log_id` varchar(32) NOT NULL',
    'SELECT "Column import_schema_log_id already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 2: import_log_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'import_log_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `import_log_id` varchar(32) NOT NULL',
    'SELECT "Column import_log_id already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 3: column_name
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'column_name'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `column_name` varchar(64) NOT NULL',
    'SELECT "Column column_name already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 4: column_order
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'column_order'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `column_order` int NOT NULL',
    'SELECT "Column column_order already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 5: data_type
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'data_type'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `data_type` varchar(50) NOT NULL',
    'SELECT "Column data_type already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 6: length_values
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'length_values'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `length_values` varchar(255) NULL',
    'SELECT "Column length_values already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 7: default_value
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'default_value'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `default_value` varchar(255) NULL',
    'SELECT "Column default_value already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 8: is_nullable
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'is_nullable'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `is_nullable` tinyint(1) NULL DEFAULT '1'',
    'SELECT "Column is_nullable already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 9: is_indexed
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'is_indexed'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `is_indexed` tinyint(1) NULL DEFAULT '0'',
    'SELECT "Column is_indexed already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 10: column_comment
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'column_comment'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `column_comment` text NULL',
    'SELECT "Column column_comment already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 11: was_auto_detected
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'was_auto_detected'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `was_auto_detected` tinyint(1) NULL DEFAULT '1'',
    'SELECT "Column was_auto_detected already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 12: original_column_name
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'original_column_name'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `original_column_name` varchar(64) NULL',
    'SELECT "Column original_column_name already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 13: alta_db
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'alta_db'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `alta_db` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
    'SELECT "Column alta_db already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 14: alta_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'alta_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `import_schema_logs` ADD COLUMN `alta_por` varchar(32) NULL DEFAULT 'system'',
    'SELECT "Column alta_por already exists in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Remove placeholder column (if exists)
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'import_schema_logs'
        AND COLUMN_NAME = 'placeholder_id'
);

SET @sql = IF(@col_exists > 0,
    'ALTER TABLE `import_schema_logs` DROP COLUMN `placeholder_id`',
    'SELECT "Column placeholder_id does not exist in import_schema_logs" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- ============================================
-- Table: propiedad
-- Columns: 8
-- ============================================

-- Create table structure (if missing)
CREATE TABLE IF NOT EXISTS `propiedad` (
    `placeholder_id` INT AUTO_INCREMENT PRIMARY KEY COMMENT 'Temporary placeholder'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add columns one by one (safe to re-run)

-- Column 1: propiedad_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propiedad'
        AND COLUMN_NAME = 'propiedad_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propiedad` ADD COLUMN `propiedad_id` varchar(32) NOT NULL',
    'SELECT "Column propiedad_id already exists in propiedad" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 2: num_deptos
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propiedad'
        AND COLUMN_NAME = 'num_deptos'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propiedad` ADD COLUMN `num_deptos` int NOT NULL',
    'SELECT "Column num_deptos already exists in propiedad" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 3: nombre_propiedad
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propiedad'
        AND COLUMN_NAME = 'nombre_propiedad'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propiedad` ADD COLUMN `nombre_propiedad` varchar(50) NOT NULL',
    'SELECT "Column nombre_propiedad already exists in propiedad" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 4: direccion
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propiedad'
        AND COLUMN_NAME = 'direccion'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propiedad` ADD COLUMN `direccion` varchar(100) NULL',
    'SELECT "Column direccion already exists in propiedad" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 5: alta_db
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propiedad'
        AND COLUMN_NAME = 'alta_db'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propiedad` ADD COLUMN `alta_db` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
    'SELECT "Column alta_db already exists in propiedad" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 6: alta_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propiedad'
        AND COLUMN_NAME = 'alta_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propiedad` ADD COLUMN `alta_por` varchar(32) NULL DEFAULT 'system'',
    'SELECT "Column alta_por already exists in propiedad" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 7: ultimo_cambio
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propiedad'
        AND COLUMN_NAME = 'ultimo_cambio'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propiedad` ADD COLUMN `ultimo_cambio` timestamp NULL',
    'SELECT "Column ultimo_cambio already exists in propiedad" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 8: ultimo_cambio_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propiedad'
        AND COLUMN_NAME = 'ultimo_cambio_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propiedad` ADD COLUMN `ultimo_cambio_por` varchar(32) NULL',
    'SELECT "Column ultimo_cambio_por already exists in propiedad" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Remove placeholder column (if exists)
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propiedad'
        AND COLUMN_NAME = 'placeholder_id'
);

SET @sql = IF(@col_exists > 0,
    'ALTER TABLE `propiedad` DROP COLUMN `placeholder_id`',
    'SELECT "Column placeholder_id does not exist in propiedad" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- ============================================
-- Table: propietario
-- Columns: 12
-- ============================================

-- Create table structure (if missing)
CREATE TABLE IF NOT EXISTS `propietario` (
    `placeholder_id` INT AUTO_INCREMENT PRIMARY KEY COMMENT 'Temporary placeholder'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add columns one by one (safe to re-run)

-- Column 1: propietario_id
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'propietario_id'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `propietario_id` varchar(32) NOT NULL',
    'SELECT "Column propietario_id already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 2: departamento
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'departamento'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `departamento` varchar(100) NOT NULL',
    'SELECT "Column departamento already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 3: propietario
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'propietario'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `propietario` varchar(100) NULL',
    'SELECT "Column propietario already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 4: responsable
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'responsable'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `responsable` varchar(100) NOT NULL',
    'SELECT "Column responsable already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 5: es_dueno
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'es_dueno'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `es_dueno` enum('Si','No') NOT NULL',
    'SELECT "Column es_dueno already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 6: inversionista
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'inversionista'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `inversionista` varchar(100) NULL',
    'SELECT "Column inversionista already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 7: despacho
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'despacho'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `despacho` varchar(100) NULL',
    'SELECT "Column despacho already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 8: correo
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'correo'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `correo` varchar(100) NULL',
    'SELECT "Column correo already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 9: alta_db
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'alta_db'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `alta_db` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
    'SELECT "Column alta_db already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 10: alta_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'alta_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `alta_por` varchar(32) NULL DEFAULT 'system'',
    'SELECT "Column alta_por already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 11: ultimo_cambio
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'ultimo_cambio'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `ultimo_cambio` timestamp NULL',
    'SELECT "Column ultimo_cambio already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Column 12: ultimo_cambio_por
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'ultimo_cambio_por'
);

SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `propietario` ADD COLUMN `ultimo_cambio_por` varchar(32) NULL',
    'SELECT "Column ultimo_cambio_por already exists in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Remove placeholder column (if exists)
SET @col_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'propietario'
        AND COLUMN_NAME = 'placeholder_id'
);

SET @sql = IF(@col_exists > 0,
    'ALTER TABLE `propietario` DROP COLUMN `placeholder_id`',
    'SELECT "Column placeholder_id does not exist in propietario" AS message'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- ============================================
-- Migration Complete
-- Finished: 2026-01-02 21:06:59
-- ============================================

SELECT 'Migration completed successfully' AS status;
