# ✨ **Cyberpunk Data Importer & Neon Data OS**
*(excerpt – full file unchanged except for the added section below)*

...

## 📦 New Feature – Column Removal (`remove` flag)

When reviewing the **Schema Builder** (Gate 3) you can now mark any column for removal before the import proceeds.

### How it works
1. In the schema table a **“Skip”** checkbox appears as the first column.  
2. Checking this box sets a boolean `remove` flag on the column definition.  
3. The backend (`insert.php`) filters out any columns where `remove` is `true` **before**:
   * Table creation / `DROP TABLE` logic  
   * `ALTER TABLE` for missing columns  
   * Row insertion  
4. If **all** columns are removed the import automatically switches to *skip‑table‑recreation* mode, inserting only into an existing table (if any) and logging a warning.

### UI notes
- The **Skip** column is highlighted in the schema table header.  
- Hovering over a checkbox shows a tooltip: *“Remove this column from the import”*.  
- When a column is marked for removal it disappears from the SQL preview and will not be part of the final table.

### Impact
- Allows you to quickly exclude unwanted columns without editing the source file.  
- Guarantees that the rest of the import workflow (progress tracking, logging, audit fields) remains unchanged.  
- Works seamlessly with the existing **Skip Table Recreation** option for incremental imports.

### Example
| Skip | Column Name | Data Type | Length | Nullable | Indexed | Comment |
|------|-------------|-----------|--------|----------|---------|---------|
| ☑️   | `unused_col`| VARCHAR   | 100    | true     | false   | (will be omitted) |
|      | `keep_me`   | INT       |        | false    | true    | (will be imported) |

The test suite `tests/test_insert_remove_column.php` validates this behavior by:
- Creating a temporary database,
- Sending a schema with a column flagged `remove => true`,
- Confirming the column is absent from the created table,
- Verifying the remaining data is inserted correctly.

---

*(The rest of the original README content follows unchanged.)*
