# Test Plan for The Ledger Whisperer (tabler.php)

## Test File
- Path: `/lamp/www/importer/uploads/01 ENERO 24 ESTADO DE CUENTA SANTANDER ELEYEME ASOCIADOS.pdf`
- Size: 434KB
- Expected bank: Santander (Spanish bank statement)

## Test Scenarios

### CLI Interface Tests

| # | Test Case | Command | Expected Result |
|---|-----------|----------|-----------------|
| 1 | Help display | `php tabler.php --help` | Show help message |
| 2 | Version display | `php tabler.php --version` | Show version info |
| 3 | Basic conversion | `php tabler.php input.pdf output.txt` | Generate TSV with 5 columns |
| 4 | With audit | `php tabler.php input.pdf output.txt --audit=audit.json` | Generate audit.json |
| 5 | With debug | `php tabler.php input.pdf output.txt --debug` | Generate debug overlays |
| 6 | Language override | `php tabler.php input.pdf output.txt --lang=en` | Use English headers |

### Expected Output Format

```
Día    Concepto / Referencia    cargo    Abono    Saldo
01-01-2024    Payment to Merchant | REF123    1,234.56    0.00    5,678.90
01-01-2024    Deposit | CHECKPOINT    0.00    500.00    6,178.90
```

### Validation Rules

| # | Rule | Description |
|---|------|-------------|
| 1 | Header row | First line must be exact header |
| 2 | Column count | Every row must have exactly 5 TAB-separated fields |
| 3 | Date format | DD-MM-YYYY (two digits each) |
| 4 | Money format | 1,234.56 or 0.00 |
| 5 | Ledger math | balance[i] = balance[i-1] + credit - debit |

### Test Data Assertions

| # | Assertion | Check |
|---|-----------|-------|
| 1 | Row count | > 0 rows extracted |
| 2 | Header present | "Día" in first column |
| 3 | Balance progression | Monotonically increasing or consistent |
| 4 | No empty rows | Filter non-transaction regions |

### Performance Benchmarks

| Stage | Expected Time |
|-------|---------------|
| Ingest | < 1s |
| Linear Crawl | < 5s (text) or < 30s (OCR) |
| Zoom-Out | < 2s |
| Row Assembly | < 1s |
| Reconciliation | < 1s |
| Export | < 1s |
| **Total** | **< 10s (text) or < 40s (OCR)** |

### Error Handling Tests

| # | Error Condition | Expected Behavior |
|---|------------------|-------------------|
| 1 | Missing input file | Error message |
| 2 | Invalid PDF | Error message |
| 3 | Unreadable output path | Error message |
| 4 | Reconciliation failure | Warning in audit, export continues |

### PII Redaction Tests

| # | Pattern | Should Be Redacted |
|---|----------|--------------------|
| 1 | CLABE (12-34-5678-9012) | [CLABE REDACTED] |
| 2 | RFC (AA12345678) | [RFC REDACTED] |
| 3 | Account (9-17 digits) | [ACCOUNT# REDACTED] |
| 4 | IBAN | [IBAN REDACTED] |

## Test Execution

```bash
# Run CLI test
cd /lamp/www/importer
php tabler.php "uploads/01 ENERO 24 ESTADO DE CUENTA SANTANDER ELEYEME ASOCIADOS.pdf" /tmp/test_output.txt --audit=/tmp/test_audit.json

# Verify output
head -5 /tmp/test_output.txt
cat /tmp/test_audit.json
```

## Acceptance Criteria

- [ ] CLI runs without errors
- [ ] Output has 5 columns
- [ ] Header row is correct
- [ ] All dates normalized to DD-MM-YYYY
- [ ] All money formatted as 1,234.56
- [ ] Ledger reconciles (or failure flagged)
- [ ] Audit generated with PII redacted