<?php
/**
 * Configuration File - The Foundation
 * Database credentials, upload settings, and system configuration
 */

// Set up include paths for reliable file loading across different execution contexts
set_include_path(
    "/lamp/www/importer"
    . PATH_SEPARATOR . "/lamp/www/importer/api"
    . PATH_SEPARATOR . "/lamp/www/importer/lib"
    . PATH_SEPARATOR . get_include_path()
);

// Database Configuration (Linux/Windows compatible)
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', 'M@chiavell1');
define('DB_NAME', 'importer_db'); // Default database name
define('DB_PORT', 3306);

// Auto-detect OS and set appropriate socket path
// Linux loves sockets, Windows uses TCP/IP =)
if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
    // Windows - use TCP/IP connection (no socket)
    define('DB_SOCKET', null);
} else {
    // Linux/Unix - use socket for faster local connections
    define('DB_SOCKET', '/lamp/mysql/mysql.sock');
}

define('DB_CHARSET', 'utf8mb4');
define('DB_COLLATION', 'utf8mb4_unicode_ci');

// Upload Configuration
define('UPLOAD_DIR', __DIR__ . '/tmp/');
define('MAX_FILE_SIZE', 50 * 1024 * 1024); // 50MB (matches upload_max_filesize)
define('ALLOWED_EXTENSIONS', ['xlsx', 'csv']);

// Large File Processing Configuration
// For files with many rows, use chunk-based processing to avoid memory exhaustion
define('MAX_ROWS_IN_MEMORY', 1000); // Load up to this many rows at once
define('CHUNK_SIZE', 100); // Process rows in chunks of this size
define('SCHEMA_SAMPLE_SIZE', 500); // Sample this many rows for schema detection on large files

// Standard Table Fields - Spanish Canonical Schema (Added to every created table)
// NOTE: Primary key is now DYNAMIC and table-specific (e.g., 'propietario_id' for 'propietarios' table)
// Use SchemaConventions::getPrimaryKeyName($tableName) to get the primary key field name
// Use SchemaConventions::getStandardFields($tableName) to get these fields programmatically
define('STANDARD_FIELDS', [
    'alta_db' => [
        'type' => 'TIMESTAMP',
        'constraint' => 'DEFAULT CURRENT_TIMESTAMP',
        'comment' => 'Timestamp del momento de inserción del registro'
    ],
    'alta_por' => [
        'type' => 'VARCHAR(32)',
        'constraint' => "DEFAULT 'system'",
        'comment' => 'Usuario que insertó el registro'
    ],
    'ultimo_cambio' => [
        'type' => 'TIMESTAMP',
        'constraint' => 'NULL DEFAULT NULL',
        'comment' => 'Timestamp del último cambio al registro'
    ],
    'ultimo_cambio_por' => [
        'type' => 'VARCHAR(32)',
        'constraint' => 'NULL DEFAULT NULL',
        'comment' => 'Usuario que hizo el último cambio'
    ]
]);

// Error Reporting
define('DEBUG_MODE', true);
if (DEBUG_MODE) {
    ini_set('display_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    error_reporting(0);
}

// Encoding Settings
mb_internal_encoding('UTF-8');
mb_http_output('UTF-8');
ini_set('default_charset', 'UTF-8');

// Ensure tmp directory exists
if (!is_dir(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}

// Ensure logs directory exists
if (!is_dir(__DIR__ . '/logs')) {
    mkdir(__DIR__ . '/logs', 0755, true);
}
