<?php
include_once(__DIR__ . "/../../config.php");
include_once(__DIR__ . "/../../lib/DatabaseHelper.php");

header('Content-Type: application/json');

// Get table and ID parameters
$table = $_GET['t'] ?? '';
$id = $_GET['id'] ?? null;

if (empty($table)) {
    echo json_encode(["status" => "error", "message" => "No table specified"]);
    exit;
}

// Get POST data
$data = $_POST;

try {
    if ($id) {
        // UPDATE existing record
        DatabaseHelper::updateRow($table, $id, $data);
    } else {
        // INSERT new record
        DatabaseHelper::insertRow($table, $data);
    }
    
    echo json_encode(["status" => "ok", "message" => "Record saved successfully"]);
    
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>
