<?php
// Modal wrapper template for CRUD forms
// This file provides the modal structure that can be included in CRUD pages
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CRUD Modal</title>
    <style>
        .neon-modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(5px);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s ease;
        }
        
        .neon-modal.open {
            opacity: 1;
            visibility: visible;
        }
        
        .modal-content {
            background: rgba(0, 10, 20, 0.95);
            border: 1px solid #00eaff55;
            box-shadow: 0 0 30px #00eaff44;
            border-radius: 12px;
            padding: 20px;
            max-width: 90vw;
            max-height: 90vh;
            overflow-y: auto;
            animation: modalFadeIn 0.3s ease;
            width: 90%;
            max-width: 800px;
        }
        
        @keyframes modalFadeIn {
            from { opacity: 0; transform: scale(0.9); }
            to { opacity: 1; transform: scale(1); }
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #00eaff33;
        }
        
        .modal-title {
            color: #00eaff;
            text-shadow: 0 0 8px #00eaff;
            margin: 0;
        }
        
        .modal-close {
            background: none;
            border: none;
            color: #ff3366;
            cursor: pointer;
            font-size: 24px;
            padding: 0;
            margin-left: 20px;
        }
        
        .modal-close:hover {
            color: #ff6699;
        }
    </style>
</head>
<body>
    <div class="neon-modal" id="crudModal">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title">CRUD Modal</h2>
                <button class="modal-close" onclick="document.getElementById('crudModal').classList.remove('open')">&times;</button>
            </div>
            <div id="modalFormContent">
                <?php
                if (isset($form_content)) {
                    echo $form_content;
                } else {
                    echo '<p>No form content loaded.</p>';
                }
                ?>
            </div>
        </div>
    </div>
    
    <script>
        function openCRUDModal(url) {
            fetch(url).then(r=>r.text()).then(html=>{
                document.querySelector('#crudModal').innerHTML = html;
                document.querySelector('#crudModal').classList.add('open');
            });
        }
        
        function closeModal() {
            document.getElementById('crudModal').classList.remove('open');
        }
    </script>
</body>
</html>
