<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<title>Gate 0: The Threshold</title>
<style>
    /* Reuse core styles */
    * { box-sizing: border-box; }

    body {
        background: radial-gradient(circle at top, #020d18 0%, #000000 70%);
        font-family: 'Consolas', 'Monaco', monospace;
        color: #e0f7ff;
        margin: 0;
        padding: 0;
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }

    h1 {
        text-shadow: 0 0 12px #00eaff;
        font-weight: bold;
        margin-bottom: 10px;
        margin-top: 0;
        color: #e0f7ff;
        text-align: center;
        font-size: 2.5em;
    }
    
    .subtitle {
        color: #00ffaa;
        text-align: center;
        margin-bottom: 50px;
        font-size: 1.2em;
        text-shadow: 0 0 8px #00ffaa;
    }

    .gateway-container {
        display: flex;
        gap: 40px;
        max-width: 1200px;
        width: 90%;
        justify-content: center;
        flex-wrap: wrap;
        animation: fadein 0.8s ease;
    }

    .gate-card {
        background: rgba(0, 10, 20, 0.6);
        border: 2px solid #00eaff33;
        padding: 40px;
        border-radius: 16px;
        width: 450px;
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
        text-decoration: none;
    }

    .gate-card:hover {
        border-color: #00eaff;
        box-shadow: 0 0 40px #00eaff44;
        transform: translateY(-10px);
        background: rgba(0, 20, 30, 0.8);
    }

    .gate-icon {
        font-size: 4em;
        margin-bottom: 20px;
        text-shadow: 0 0 20px #00eaff;
    }

    .gate-title {
        font-size: 1.8em;
        color: #00eaff;
        margin-bottom: 15px;
        font-weight: bold;
        text-shadow: 0 0 10px #00eaff;
    }

    .gate-desc {
        color: #8899aa;
        line-height: 1.6;
        margin-bottom: 30px;
        font-size: 1.1em;
    }

    .gate-btn {
        background: transparent;
        color: #00eaff;
        border: 2px solid #00eaff;
        padding: 12px 30px;
        font-size: 16px;
        border-radius: 8px;
        font-weight: bold;
        transition: all 0.2s ease;
        font-family: 'Consolas', monospace;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .gate-card:hover .gate-btn {
        background: #00eaff;
        color: #000;
        box-shadow: 0 0 20px #00eaff;
    }

    @keyframes fadein {
        from { opacity:0; transform: translateY(20px); }
        to { opacity:1; transform: translateY(0); }
    }
    
    @media (max-width: 800px) {
        .gateway-container {
            flex-direction: column;
            align-items: center;
        }
        .gate-card {
            width: 100%;
        }
    }
</style>
</head>
<body>

    <h1>✦ Gate 0: The Threshold</h1>
    <div class="subtitle">Choose a chamber to enter.</div>

    <div class="gateway-container">
        <!-- Gate 1 -->
        <a href="arrival.php" class="gate-card">
            <div class="gate-icon">📄</div>
            <div class="gate-title">Gate 1: The Arrival</div>
            <div class="gate-desc">
                Prepare your data for transformation.<br>
                Upload → Parse → Preview → Shape.
            </div>
            <div class="gate-btn">Enter Arrival</div>
        </a>

        <!-- Gate 5 -->
        <a href="dashboard.php" class="gate-card">
            <div class="gate-icon">🌌</div>
            <div class="gate-title">Gate 5: The Observatory</div>
            <div class="gate-desc">
                Survey the structure of your data kingdom.<br>
                Explore → Inspect → Navigate → Observe.
            </div>
            <div class="gate-btn">Enter Observatory</div>
        </a>

        <!-- Gate 6 -->
        <a href="table_operations.php" class="gate-card">
            <div class="gate-icon">🔄</div>
            <div class="gate-title">Gate 6: The Replicator</div>
            <div class="gate-desc">
                Copy, move, and manage tables across databases.<br>
                Clone → Migrate → Replicate → Transform.
            </div>
            <div class="gate-btn">Enter Replicator</div>
        </a>

        <!-- Gate 7 -->
        <a href="dashboard.php" class="gate-card">
            <div class="gate-icon">📜</div>
            <div class="gate-title">Gate 7: Phoenix Form Builder</div>
            <div class="gate-desc">
                Generate clean, device-specific forms (mobile, tablet, desktop) from your database schema.
                Perfect for Lupita-friendly UX and developer-perfect structure.
            </div>
            <div class="gate-btn">Enter Form Builder</div>
        </a>

        <!-- Gate X: The Exodus -->
        <a href="exodus.php" class="gate-card">
            <div class="gate-icon">🌌</div>
            <div class="gate-title">Gate X: The Exodus</div>
            <div class="gate-desc">
                Cross-platform migration system. Backup, migrate, and restore your entire project.<br>
                Linux ↔ Windows • Safe migrations • One-click deployment.
            </div>
            <div class="gate-btn">Enter Exodus</div>
        </a>
    </div>

</body>
</html>
