<?php
session_start();
header('Content-Type: application/json');

$destinationDir = $_POST['destination'] ?? '';
$filesToCopy = json_decode($_POST['files'] ?? '[]', true);

// Validate destination path
$baseDir = '/lamp/www';
$realDestPath = realpath($destinationDir);

if ($realDestPath === false || strpos($realDestPath, realpath($baseDir)) !== 0) {
    echo json_encode(['error' => 'Invalid destination path']);
    exit;
}

if (!is_dir($realDestPath)) {
    echo json_encode(['error' => 'Destination directory does not exist']);
    exit;
}

if (!is_writable($realDestPath)) {
    echo json_encode(['error' => 'Destination directory is not writable']);
    exit;
}

if (empty($filesToCopy) || !is_array($filesToCopy)) {
    echo json_encode(['error' => 'No files specified for copying']);
    exit;
}

// Get the persistent temp directory for this session
$persistentTempDir = sys_get_temp_dir() . '/tabler_ui_persistent_' . session_id();
if (!is_dir($persistentTempDir)) {
    echo json_encode(['error' => 'Source directory does not exist. Please convert files first.']);
    exit;
}

$success = [];
$failed = [];

foreach ($filesToCopy as $fileName) {
    // Validate filename (no path traversal)
    if (strpos($fileName, '/') !== false || strpos($fileName, '\\') !== false) {
        $failed[] = ['file' => $fileName, 'reason' => 'Invalid filename'];
        continue;
    }

    $sourceFile = $persistentTempDir . '/' . $fileName;
    $destFile = $realDestPath . '/' . $fileName;

    if (!file_exists($sourceFile)) {
        $failed[] = ['file' => $fileName, 'reason' => 'Source file not found'];
        continue;
    }

    if (!is_file($sourceFile)) {
        $failed[] = ['file' => $fileName, 'reason' => 'Not a file'];
        continue;
    }

    if (copy($sourceFile, $destFile)) {
        $success[] = $fileName;
    } else {
        $failed[] = ['file' => $fileName, 'reason' => 'Copy operation failed'];
    }
}

if (count($failed) > 0) {
    echo json_encode([
        'error' => 'Some files failed to copy',
        'success' => $success,
        'failed' => $failed
    ]);
} else {
    echo json_encode([
        'success' => 'All files copied successfully',
        'copied' => $success,
        'count' => count($success)
    ]);
}
?>