<?php
include_once(__DIR__ . "/../config.php");
include_once(__DIR__ . "/../lib/DatabaseHelper.php");

header('Content-Type: application/json');

try {
    if (!isset($_GET['db'])) {
        throw new Exception('Database name is required');
    }

    $dbName = $_GET['db'];
    
    // Validate db name
    if (!preg_match('/^[a-zA-Z0-9_]+$/', $dbName)) {
        throw new Exception('Invalid database name');
    }

    $db = DatabaseHelper::getInstance();
    $conn = $db->connect();
    
    // Select database
    if (!$conn->select_db($dbName)) {
        throw new Exception("Could not select database: " . $conn->error);
    }
    
    // Get table status (includes row count, size, etc.)
    $result = $conn->query("SHOW TABLE STATUS");
    if (!$result) {
        throw new Exception($conn->error);
    }
    
    $tables = [];
    while ($row = $result->fetch_assoc()) {
        $tables[] = [
            'name' => $row['Name'],
            'rows' => (int)($row['Rows'] ?? 0),
            'data_length' => (int)($row['Data_length'] ?? $row['Data_Length'] ?? 0),
            'index_length' => (int)($row['Index_length'] ?? $row['Index_Length'] ?? 0),
            'created' => $row['Create_time'] ?? null,
            'updated' => $row['Update_time'] ?? null,
            'engine' => $row['Engine'],
            'collation' => $row['Collation'],
            'comment' => $row['Comment']
        ];
    }
    
    echo json_encode(['status' => 'ok', 'tables' => $tables]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
