<?php
// api/list_directories.php

header('Content-Type: application/json');

$path = $_GET['path'] ?? '/lamp/www';
$baseDir = '/lamp/www';

// Validate path to prevent directory traversal
$realPath = realpath($path);
if ($realPath === false || strpos($realPath, realpath($baseDir)) !== 0) {
    echo json_encode(['error' => 'Invalid path']);
    exit;
}

if (!is_dir($realPath)) {
    echo json_encode(['error' => 'Path is not a directory']);
    exit;
}

// Get parent directory info
$parent = null;
if ($realPath !== realpath($baseDir)) {
    $parentPath = dirname($realPath);
    if (strpos($parentPath, realpath($baseDir)) === 0) {
        $parent = $parentPath;
    }
}

$entries = scandir($realPath);
$directories = [];

foreach ($entries as $entry) {
    if ($entry === '.' || $entry === '..') continue;
    $fullPath = $realPath . '/' . $entry;
    if (is_dir($fullPath)) {
        $directories[] = [
            'name' => $entry,
            'path' => $fullPath
        ];
    }
}

// Sort directories alphabetically
usort($directories, function($a, $b) {
    return strcasecmp($a['name'], $b['name']);
});

echo json_encode([
    'current_path' => $realPath,
    'parent' => $parent,
    'directories' => $directories
]);
?>