<?php
include_once(__DIR__ . "/../config.php");
require_once 'MockCRUDEngine.php';
header('Content-Type: application/json');

$db = $_GET['db'] ?? '';
$table = $_GET['table'] ?? '';

if (!$db || !$table) {
    echo json_encode(['status' => 'error', 'message' => 'Missing db or table']);
    exit;
}

try {
    $rows = MockCRUDEngine::loadMock($db, $table);
    echo json_encode(['status' => 'ok', 'rows' => $rows]);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
