<?php
include_once(__DIR__ . "/../../config.php");
include_once(__DIR__ . "/../../lib/DatabaseHelper.php");

header('Content-Type: application/json');

try {
    if (!isset($_GET['table'])) {
        throw new Exception('Table name is required');
    }

    $table = $_GET['table'];
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 50;
    $offset = ($page - 1) * $limit;
    
    // Validate table name
    if (!preg_match('/^[a-zA-Z0-9_]+$/', $table)) {
        throw new Exception('Invalid table name');
    }
    
    if ($page < 1) $page = 1;
    if ($limit < 1 || $limit > 1000) $limit = 50;

    $rows = DatabaseHelper::getRows($table, $limit, $offset);
    
    // Get total count for pagination info
    $db = DatabaseHelper::getInstance();
    $conn = $db->connect();
    $dbName = DB_NAME;
    
    if (!$conn->select_db($dbName)) {
        throw new Exception("Could not select database: " . $conn->error);
    }
    
    $safeTableName = $db->escapeIdentifier($table);
    $countResult = $conn->query("SELECT COUNT(*) as c FROM {$safeTableName}");
    $totalRows = $countResult ? $countResult->fetch_assoc()['c'] : 0;

    echo json_encode([
        'status' => 'ok',
        'table' => $table,
        'rows' => $rows,
        'total' => (int)$totalRows,
        'page' => $page,
        'pages' => ceil($totalRows / $limit)
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
