<?php
include_once(__DIR__ . "/../../config.php");
include_once(__DIR__ . "/../../lib/DatabaseHelper.php");

header('Content-Type: application/json');

try {
    if (!isset($_GET['table'])) {
        throw new Exception('Table name is required');
    }

    $table = $_GET['table'];
    
    // Validate table name
    if (!preg_match('/^[a-zA-Z0-9_]+$/', $table)) {
        throw new Exception('Invalid table name');
    }

    $columns = DatabaseHelper::getColumns($table);
    
    echo json_encode([
        'status' => 'ok',
        'table' => $table,
        'columns' => $columns
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
