// Modal functionality for CRUD operations
function openCRUDModal(url) {
    fetch(url)
        .then(r => r.text())
        .then(html => {
            document.querySelector('#crudModal').innerHTML = html;
            document.querySelector('#crudModal').classList.add('open');
        })
        .catch(err => {
            console.error('Modal loading error:', err);
        });
}

function closeModal() {
    const modal = document.getElementById('crudModal');
    if (modal) {
        modal.classList.remove('open');
    }
}

// Close modal when clicking outside content
document.addEventListener('click', function(event) {
    const modal = document.getElementById('crudModal');
    if (modal && modal.classList.contains('open')) {
        if (event.target === modal) {
            closeModal();
        }
    }
});

// Close modal with Escape key
document.addEventListener('keydown', function(event) {
    if (event.key === 'Escape') {
        closeModal();
    }
});
