<?php
// Modal wrapper for CRUD forms
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CRUD Modal</title>
    <link rel="stylesheet" href="../../lib/forms-cyberpunk.css">
    <style>
        body {
            background-color: #0a0a0a;
            color: #00ff00;
            font-family: 'Courier New', monospace;
            margin: 0;
            padding: 20px;
        }
        
        .neon-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
            z-index: 1000;
            justify-content: center;
            align-items: center;
        }
        
        .neon-modal.open {
            display: flex;
        }
        
        .modal-content {
            background-color: #111;
            border: 1px solid #00ff00;
            border-radius: 4px;
            padding: 20px;
            max-width: 800px;
            width: 90%;
            max-height: 90vh;
            overflow-y: auto;
            box-shadow: 0 0 20px #00ff00;
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #00ff00;
        }
        
        .close-modal {
            background-color: #cc0000;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
            font-family: 'Courier New', monospace;
        }
        
        .close-modal:hover {
            background-color: #aa0000;
        }
        
        .form-container {
            background-color: transparent;
            border: none;
            padding: 0;
        }
        
        .form-container form {
            margin: 0;
        }
        
        .form-container .form-group {
            margin-bottom: 15px;
        }
        
        .form-container label {
            display: block;
            margin-bottom: 5px;
            color: #00ff00;
        }
        
        .form-container input[type="text"],
        .form-container input[type="email"],
        .form-container input[type="password"],
        .form-container input[type="number"],
        .form-container textarea,
        .form-container select {
            background-color: #222;
            border: 1px solid #00ff00;
            color: #00ff00;
            padding: 8px;
            width: 100%;
            border-radius: 4px;
        }
        
        .form-container button[type="submit"] {
            background-color: #00cc00;
            color: black;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-family: 'Courier New', monospace;
            font-weight: bold;
        }
        
        .form-container button[type="submit"]:hover {
            background-color: #00aa00;
        }
    </style>
</head>
<body>
    <div id="crudModal" class="neon-modal">
        <div class="modal-content">
            <?php
            // This file will include the form content from insert.php or edit.php
            if (isset($form_file)) {
                include $form_file;
            } else {
                // Default fallback - include the current file path
                $currentPath = $_SERVER['REQUEST_URI'];
                if (strpos($currentPath, '?') !== false) {
                    parse_str(parse_url($currentPath, PHP_URL_QUERY), $params);
                    if (isset($params['t'])) {
                        $table = $params['t'];
                        $formFile = "../forms/generated/{$table}_form.php";
                        if (file_exists($formFile)) {
                            include $formFile;
                            echo '<div class="form-container">';
                            echo $form->render();
                            echo '</div>';
                        }
                    }
                }
            }
            ?>
        </div>
    </div>
    
    <script>
        function openCRUDModal(url) {
            fetch(url).then(r=>r.text()).then(html=>{
                document.querySelector('#crudModal').innerHTML = html;
                document.querySelector('#crudModal').classList.add('open');
            });
        }
        
        function closeModal() {
            document.querySelector('#crudModal').classList.remove('open');
        }
        
        // Close modal when clicking outside content
        document.querySelector('#crudModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeModal();
            }
        });
        
        // Close modal with Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeModal();
            }
        });
    </script>
</body>
</html>
