# Class: ChunkReadFilter

**File:** `ChunkReader.php`


## Description

ChunkReader - Memory-Efficient Excel Reader
Reads large XLSX files in chunks to avoid memory exhaustion

## Methods

### Public::setRows()

/**
ChunkReader - Memory-Efficient Excel Reader
Reads large XLSX files in chunks to avoid memory exhaustion
/

```php
/**
 * ChunkReader - Memory-Efficient Excel Reader
 * Reads large XLSX files in chunks to avoid memory exhaustion
 */

// Ensure PhpSpreadsheet is loaded
if (!class_exists('PhpOffice\PhpSpreadsheet\IOFactory')) {
    require_once dirname(__DIR__) . '/vendor/autoload.php';
}

use PhpOffice\PhpSpreadsheet\Reader\IReadFilter;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;

/**
 * Read filter to load only specific row ranges
 * This prevents loading the entire file into memory
 */
class ChunkReadFilter implements IReadFilter {
    private $startRow = 0;
    private $endRow = 0;

    /**
     * Set the row range to read
     */
    public function setRows(
```

### Public::readCell()

/**
Should this cell be read?
/

```php
/**
     * Should this cell be read?
     */
    public function readCell(
```

