# Import Logger Schema

## Table: import_logs

Tracks every import operation with full schema capture.

| Column | Type | Description |
|--------|------|-------------|
| `import_log_id` | VARCHAR(32) | UUID primary key |
| `database_name` | VARCHAR(64) | Target database name |
| `table_name` | VARCHAR(64) | Target table name |
| `file_name` | VARCHAR(255) | Original uploaded filename |
| `file_type` | ENUM('XLSX','CSV') | File type |
| `file_size` | INT | File size in bytes |
| `operation_status` | ENUM | 'pending', 'success', 'error', 'partial' |
| `rows_processed` | INT | Total rows processed |
| `rows_inserted` | INT | Successfully inserted rows |
| `rows_failed` | INT | Failed row count |
| `alta_db` | TIMESTAMP | Import timestamp |
| `alta_por` | VARCHAR(32) | User who performed import |

## Table: import_schema_logs

Stores column definitions for each import.

| Column | Type | Description |
|--------|------|-------------|
| `import_schema_log_id` | VARCHAR(32) | UUID primary key |
| `import_log_id` | VARCHAR(32) | FK to import_logs |
| `column_name` | VARCHAR(64) | Column name |
| `column_order` | INT | Position in table (1-based) |
| `data_type` | VARCHAR(50) | MySQL data type |
| `length_values` | VARCHAR(255) | Length/precision |
| `is_nullable` | BOOLEAN | NULL constraint |
| `is_indexed` | BOOLEAN | Whether column has an index |
| `column_comment` | TEXT | Column description |
