# Plan: Split Gate 1 into Excel and PDF

## Current Structure

Gate 1 is currently a single card that links to `arrival.php`:

```html
<!-- Gate 1 -->
<a href="arrival.php" class="gate-card">
    <div class="gate-icon">📄</div>
    <div class="gate-title">Gate 1: The Arrival</div>
    <div class="gate-desc">
        Prepare your data for transformation.<br>
        Upload → Parse → Preview → Shape.
    </div>
    <div class="gate-btn">Enter Arrival</div>
</a>
```

## Proposed New Structure

Split Gate 1 into two separate cards:

```html
<!-- Gate 1: Excel -->
<a href="arrival.php?type=xls" class="gate-card">
    <div class="gate-icon">��</div>
    <div class="gate-title">Gate 1: Enter Arrival Excel</div>
    <div class="gate-desc">
        Import XLS/XLSX files.<br>
        Upload → Parse → Preview → Shape.
    </div>
    <div class="gate-btn">Enter Arrival Excel</div>
</a>

<!-- Gate 1: PDF -->
<a href="#" class="gate-card" id="btn-pdf-arrival">
    <div class="gate-icon">��</div>
    <div class="gate-title">Gate 1: Enter Arrival PDF</div>
    <div class="gate-desc">
        Import PDF files.<br>
        Upload → Parse → Preview → Shape.
    </div>
    <div class="gate-btn">Enter Arrival PDF</div>
</a>
```

## Implementation Steps

### Step 1: Modify index.php
- Replace the single Gate 1 card with two cards
- Keep the Excel card linking to `arrival.php?type=xls`
- Add the PDF card with `href="#"` and `id="btn-pdf-arrival"`

### Step 2: Add JavaScript handler (inline or external)
- Add click handler for `#btn-pdf-arrival`
- For now, just show an alert: `alert('PDF import coming soon')`

### Step 3: (Future) Connect PDF button to actual functionality
- This is out of scope for now
- The button will simply do nothing or show a "coming soon" message

## CSS Considerations

The existing `.gateway-container` uses `flex-wrap: wrap` which will automatically handle the layout of multiple cards.

## File Changes Summary

| File | Change |
|------|--------|
| `index.php` | Replace Gate 1 card with two cards (Excel + PDF) |
| `index.php` | Add JavaScript handler for PDF button |