<?php
$dateFields = ['staydatefrom', 'staydateto', 'bookeddate', 'updated_at', 'created_at', 'check_in', 'fecha', 'birth_date', 'date_created'];
$notDateFields = ['update', 'validate', 'candidate', 'rateplan', 'commission'];

echo "Testing DATE pattern matching:\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";

echo "Should MATCH (expected DATE):\n";
foreach ($dateFields as $field) {
    // Check direct matches first
    $directMatch = preg_match('/check.*in|check.*out|fecha|created_at$|updated_at$/i', $field);

    // Check for 'date' with exclusions
    $dateMatch = preg_match('/date/i', $field);
    $isExcluded = preg_match('/^update$|^validate$|^candidate$/i', $field);
    $dateMatchFinal = $dateMatch && !$isExcluded;

    $finalMatch = $directMatch || $dateMatchFinal;
    echo "  " . ($finalMatch ? '✅' : '❌') . " $field\n";
}

echo "\nShould NOT MATCH (expected other types):\n";
foreach ($notDateFields as $field) {
    // Check direct matches first
    $directMatch = preg_match('/check.*in|check.*out|fecha|created_at$|updated_at$/i', $field);

    // Check for 'date' with exclusions
    $dateMatch = preg_match('/date/i', $field);
    $isExcluded = preg_match('/^update$|^validate$|^candidate$/i', $field);
    $dateMatchFinal = $dateMatch && !$isExcluded;

    $finalMatch = $directMatch || $dateMatchFinal;
    echo "  " . (!$finalMatch ? '✅' : '❌') . " $field\n";
}
