<?php
/**
 * test_rag_system.php - Test script for the RAG system
 * 
 * This script demonstrates how to use the RAG system to query documentation.
 * 
 * Usage:
 *   php tests/test_rag_system.php
 */

require_once __DIR__ . '/../lib/RagQuery.php';

echo "RAG System Test\n";
echo str_repeat('=', 60) . "\n\n";

// Show version info
$version = RagQuery::getVersion();
echo "Version: " . $version['version'] . "\n";
echo "Index Directory: " . $version['index_dir'] . "\n\n";

// Test queries
$testQueries = [
    "What does the DatabaseHelper class do?",
    "How do I add a new column to the import_logs table?",
    "What are the standard audit fields?",
    "How do I get a list of tables?",
    "What parameters does getTableRows accept?",
    "What is the character set?",
    "Explain the import logging flow",
];

foreach ($testQueries as $idx => $query) {
    echo "Test " . ($idx + 1) . ": " . $query . "\n";
    echo str_repeat('-', 60) . "\n";
    
    $context = RagQuery::getContext($query);
    echo $context;
    
    echo "\n" . str_repeat('=', 60) . "\n\n";
}

// Test specific methods
echo "Test: Get DatabaseHelper class documentation\n";
echo str_repeat('-', 60) . "\n";
echo RagQuery::getClassDoc('DatabaseHelper') . "\n";

echo "\nTest: Get API documentation for getTables\n";
echo str_repeat('-', 60) . "\n";
echo RagQuery::getApiDoc('getTables') . "\n";

echo "\nTest: Get database conventions\n";
echo str_repeat('-', 60) . "\n";
echo RagQuery::getDatabaseConventions() . "\n";

echo "\nTest: Get import logger schema\n";
echo str_repeat('-', 60) . "\n";
echo RagQuery::getImportLoggerSchema() . "\n";

echo "\n" . str_repeat('=', 60) . "\n";
echo "All tests completed.\n";