<?php
/**
 * API Endpoint: generate_form.php
 *
 * This endpoint triggers the Phoenix Form Builder (Gate 7).
 * It takes a database, table, and device type, then generates
 * the corresponding form file.
 */

declare(strict_types=1);

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../lib/ErrorHandler.php';
require_once __DIR__ . '/../lib/DatabaseHelper.php';
require_once __DIR__ . '/../lib/FormBuilder.php';

try {
    // Validate input
    $dbName = $_GET['db'] ?? null;
    $tableName = $_GET['table'] ?? null;
    $device = $_GET['device'] ?? 'desktop';

    if (!$dbName || !$tableName) {
        ErrorHandler::jsonError('Database and table name are required.', 'MISSING_PARAMS', 400);
    }

    // Get table metadata
    $db = DatabaseHelper::getInstance();
    $conn = $db->connect();
    $conn->select_db($dbName);

    $safeTable = $db->escapeIdentifier($tableName);
    $result = $conn->query("DESCRIBE $safeTable");
    $columns = [];
    while ($row = $result->fetch_assoc()) {
        $columns[] = ['name' => $row['Field'], 'type' => $row['Type'], 'nullable' => $row['Null']];
    }

    // Generate the form
    $filePath = FormBuilder::generate($tableName, $columns, $device);
    $webPath = str_replace($_SERVER['DOCUMENT_ROOT'], '', $filePath);

    ErrorHandler::jsonSuccess(['message' => 'Form generated successfully.', 'path' => $webPath]);

} catch (Exception $e) {
    ErrorHandler::handleException($e);
}
