<?php
include_once(__DIR__ . "/../../config.php");
include_once(__DIR__ . "/../../lib/DatabaseHelper.php");

header('Content-Type: application/json');

// Get table and ID parameters
$table = $_GET['t'] ?? '';
$id = $_GET['id'] ?? '';

if (empty($table) || empty($id)) {
    echo json_encode(["status" => "error", "message" => "No table or ID specified"]);
    exit;
}

try {
    DatabaseHelper::deleteRow($table, $id);
    echo json_encode(["status" => "ok", "message" => "Record deleted successfully"]);
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>
