<?php
include_once(__DIR__ . "/../config.php");
include_once(__DIR__ . "/../lib/DatabaseHelper.php");
include_once(__DIR__ . "/../lib/FormBuilder.php");

// Get table and ID parameters
$table = $_GET['t'] ?? '';
$id = $_GET['id'] ?? '';
if (empty($table) || empty($id)) {
    die('No table or ID specified');
}

// Get existing record for confirmation
$record = DatabaseHelper::getRow($table, $id);
if (!$record) {
    die('Record not found');
}

// If delete confirmation is requested
if (isset($_POST['confirm_delete']) && $_POST['confirm_delete'] == 'yes') {
    // Perform deletion
    DatabaseHelper::deleteRow($table, $id);
    
    // Return JSON response for AJAX calls
    if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
        header('Content-Type: application/json');
        echo json_encode(["status" => "ok", "message" => "Record deleted successfully"]);
        exit;
    }
    
    // Redirect back to list view
    header("Location: index.php?t={$table}");
    exit;
}

// If modal parameter is set, include modal wrapper
if (isset($_GET['modal']) && $_GET['modal'] == 1) {
    include 'ui/modal.php';
} else {
    // Standard page layout
    ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete <?= htmlspecialchars(ucfirst($table)) ?> Record</title>
    <link rel="stylesheet" href="../lib/forms-cyberpunk.css">
    <style>
        body {
            background-color: #0a0a0a;
            color: #00ff00;
            font-family: 'Courier New', monospace;
            margin: 0;
            padding: 20px;
        }
        
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #111;
            padding: 20px;
            border: 1px solid #00ff00;
            border-radius: 4px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #00ff00;
        }
        
        .record-details {
            background-color: #222;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
            border: 1px solid #00cc00;
        }
        
        .back-button {
            background-color: #0066cc;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            margin-bottom: 20px;
            font-family: 'Courier New', monospace;
        }
        
        .back-button:hover {
            background-color: #0055aa;
        }
        
        .delete-button {
            background-color: #cc0000;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-family: 'Courier New', monospace;
            font-weight: bold;
        }
        
        .delete-button:hover {
            background-color: #aa0000;
        }
        
        .cancel-button {
            background-color: #666;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-family: 'Courier New', monospace;
        }
        
        .cancel-button:hover {
            background-color: #555;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Delete <?= htmlspecialchars(ucfirst($table)) ?> Record</h1>
            <button class="back-button" onclick="window.location.href='index.php?t=<?= urlencode($table) ?>'">
                ← Back to List
            </button>
        </div>
        
        <div class="record-details">
            <h3>Confirm Deletion</h3>
            <p>You are about to delete the following record:</p>
            <?php foreach ($record as $key => $value): ?>
                <p><strong><?= htmlspecialchars($key) ?>:</strong> <?= htmlspecialchars($value) ?></p>
            <?php endforeach; ?>
        </div>
        
        <form method="POST" action="">
            <input type="hidden" name="confirm_delete" value="yes">
            <button type="submit" class="delete-button">🗑️ Yes, Delete This Record</button>
            <button type="button" class="cancel-button" onclick="window.location.href='index.php?t=<?= urlencode($table) ?>'">❌ Cancel</button>
        </form>
    </div>
</body>
</html>
    <?php
}
?>
