<?php
/**
 * Test script to verify the import logging fix works correctly
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/lib/DatabaseHelper.php';

// Check recent import logs
$db = DatabaseHelper::getInstance();
$conn = $db->getConnection();

echo "<h2>Recent Import Logs (Last 5)</h2>\n";
echo "<table border='1' style='border-collapse: collapse; width: 100%;'>\n";
echo "<tr><th>Import ID</th><th>Database</th><th>Table</th><th>File Name</th><th>Status</th><th>Date</th></tr>\n";

$result = $conn->query("SELECT import_id, database_name, table_name, file_name, status, fecha_importacion 
                        FROM import_logs 
                        ORDER BY fecha_importacion DESC 
                        LIMIT 5");

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>{$row['import_id']}</td>";
        echo "<td>{$row['database_name']}</td>";
        echo "<td>{$row['table_name']}</td>";
        echo "<td>{$row['file_name']}</td>";
        echo "<td>{$row['status']}</td>";
        echo "<td>{$row['fecha_importacion']}</td>";
        echo "</tr>\n";
    }
} else {
    echo "<tr><td colspan='6'>No import logs found</td></tr>\n";
}

echo "</table>\n";

echo "<hr>\n";
echo "<h2>Instructions</h2>\n";
echo "<p>1. Go to <a href='index.php'>index.php</a> and perform an import</p>\n";
echo "<p>2. Select database: <strong>importer_db</strong></p>\n";
echo "<p>3. Upload file: <strong>test_data.csv</strong> (or any other file)</p>\n";
echo "<p>4. Complete the import</p>\n";
echo "<p>5. Refresh this page to see the new log entry</p>\n";
echo "<p>6. The database_name should now be properly set to 'importer_db' and status should be 'completed'</p>\n";
?>
