create
    definer = root@localhost procedure UpdateNumerosBodegas(IN bodegaId varchar(32))
BEGIN
    -- Variables para almacenar valores
    DECLARE maximo_numero_movimiento INT;
    DECLARE minimo_numero_movimiento INT;
    DECLARE total_movimiento INT;

    DECLARE maximo_numero_devolucion INT;
    DECLARE minimo_numero_devolucion INT;
    DECLARE total_devolucion INT;

    DECLARE maximo_numero_ajuste INT;
    DECLARE minimo_numero_ajuste INT;
    DECLARE total_ajuste INT;

    DECLARE maximo_numero_traslado INT;
    DECLARE minimo_numero_traslado INT;
    DECLARE total_traslado INT;

    DECLARE maximo_numero_borrado INT;
    DECLARE minimo_numero_borrado INT;
    DECLARE total_borrado INT;

    DECLARE maximo_numero_cancelacion INT;
    DECLARE minimo_numero_cancelacion INT;
    DECLARE total_cancelacion INT;

    -- Obtener números de entrada y salida
    DECLARE max_num_entrada INT;
    DECLARE min_num_entrada INT;
    DECLARE total_entrada INT;

    DECLARE max_num_salida INT;
    DECLARE min_num_salida INT;
    DECLARE total_salida INT;

    DECLARE maximo_numero_inc INT;
    DECLARE minimo_numero_inc INT;
    DECLARE total_inconsistencia INT;

    DECLARE maximo_numero_dm INT;
    DECLARE minimo_numero_dm INT;
    DECLARE total_dm INT;

    DECLARE maximo_numero_pn INT;
    DECLARE minimo_numero_pn INT;
    DECLARE total_pn INT;

    DECLARE max_num INT;
    DECLARE min_num INT;

    SELECT MAX(numero_real), MIN(numero_real)
    INTO max_num, min_num
    FROM nota_bodega
    WHERE bodega_id = bodegaId;

    -- Obtener valores de Entrada
    SELECT MAX(numero_real), MIN(numero_real), COUNT(*)
    INTO max_num_entrada, min_num_entrada, total_entrada
    FROM nota_bodega
    WHERE bodega_id = bodegaId AND entrada_salida = 'Entrada' AND tipo NOT IN ('Cancelacion', 'Correccion', 'Borrado');

    -- Obtener valores de Salida
    SELECT MAX(numero_real), MIN(numero_real), COUNT(*)
    INTO max_num_salida, min_num_salida, total_salida
    FROM nota_bodega
    WHERE bodega_id = bodegaId AND entrada_salida = 'Salida' AND tipo NOT IN ('Cancelacion', 'Correccion', 'Borrado');

    -- Obtener valores de Movimiento
    SELECT MAX(numero_real), MIN(numero_real), COUNT(*)
    INTO maximo_numero_movimiento, minimo_numero_movimiento, total_movimiento
    FROM nota_bodega
    WHERE bodega_id = bodegaId AND tipo = 'Movimiento';

    -- Obtener valores de Devolucion
    SELECT MAX(numero_real), MIN(numero_real), COUNT(*)
    INTO maximo_numero_devolucion, minimo_numero_devolucion, total_devolucion
    FROM nota_bodega
    WHERE bodega_id = bodegaId AND tipo = 'Devolucion';

    -- Obtener valores de Correccion
    SELECT MAX(numero_real), MIN(numero_real), COUNT(*)
    INTO maximo_numero_ajuste, minimo_numero_ajuste, total_ajuste
    FROM nota_bodega
    WHERE bodega_id = bodegaId AND tipo = 'Correccion';

    -- Obtener valores de Traslado
    SELECT MAX(numero_real), MIN(numero_real), COUNT(*)
    INTO maximo_numero_traslado, minimo_numero_traslado, total_traslado
    FROM nota_bodega
    WHERE bodega_id = bodegaId AND tipo = 'Traslado';

    -- Obtener valores de Borrado
    SELECT MAX(numero_real), MIN(numero_real), COUNT(*)
    INTO maximo_numero_borrado, minimo_numero_borrado, total_borrado
    FROM nota_bodega
    WHERE bodega_id = bodegaId AND tipo = 'Borrado';

    -- Obtener valores de Cancelacion
    SELECT MAX(numero_real), MIN(numero_real), COUNT(*)
    INTO maximo_numero_cancelacion, minimo_numero_cancelacion, total_cancelacion
    FROM nota_bodega
    WHERE bodega_id = bodegaId AND tipo = 'Cancelacion';

    SELECT MAX(numero_real) as max_num, MIN(numero_real) as min_num, COUNT(*)
    INTO maximo_numero_inc, minimo_numero_inc, total_inconsistencia
    FROM nota_bodega
    WHERE bodega_id = bodegaId AND cuenta_inconsistencias > 0;

    SELECT MAX(numero_real) as max_num, MIN(numero_real) as min_num, COUNT(*)
    INTO maximo_numero_dm, minimo_numero_dm, total_dm
    FROM nota_bodega
    WHERE bodega_id = bodegaId AND destino_match <> 'Si';

    SELECT MAX(numero_real) as max_num, MIN(numero_real) as min_num, COUNT(*)
    INTO maximo_numero_pn, minimo_numero_pn, total_pn
    FROM nota_bodega
    WHERE tipo_nota = 'PIÑA' AND bodega_id = bodegaId;

    -- Sumar total de tipos deseados
    SET @total_sum = total_entrada + total_salida + total_ajuste + total_borrado + total_cancelacion;
    -- Actualizar la tabla numeros_bodegas
    INSERT INTO numeros_bodegas (bodega_id, maximo_numero_all,max_num,  min_num, minimo_numero_all, maximo_numero_movimiento, minimo_numero_movimiento, nv_movimiento,
                                 maximo_numero_devolucion, minimo_numero_devolucion, nv_devolucion,
                                 maximo_numero_ajuste, minimo_numero_ajuste, nv_ajuste,
                                 maximo_numero_traslado, minimo_numero_traslado, nv_traslado,
                                 maximo_numero_cancelacion_borrado, minimo_numero_cancelacion_borrado, nv_cancelacion_borrado,
                                 nv_all, maximo_numero_entrada, minimo_numero_entrada, nv_entrada, maximo_numero_salida, minimo_numero_salida, nv_salida,
                                 maximo_numero_inconsistencia, minimo_numero_inconsistencia, nv_inconsistencia,
                                 maximo_numero_destino_match_fail, minimo_numero_destino_match_fail, nv_destino_match_fail,
                                 maximo_numero_pina, minimo_numero_pina, nv_pina
                                 )
    VALUES (bodegaId, max_num, max_num, min_num, min_num, maximo_numero_movimiento, minimo_numero_movimiento, total_movimiento,
            maximo_numero_devolucion, minimo_numero_devolucion, total_devolucion,
            maximo_numero_ajuste, minimo_numero_ajuste, total_ajuste,
            maximo_numero_traslado, minimo_numero_traslado, total_traslado,
            GREATEST(maximo_numero_borrado, maximo_numero_cancelacion),
            LEAST(minimo_numero_borrado, minimo_numero_cancelacion),
            total_borrado + total_cancelacion,
            @total_sum,
            max_num_entrada,
            min_num_entrada,
            total_entrada,
            max_num_salida,
            min_num_salida,
            total_salida,
            maximo_numero_inc,
            minimo_numero_inc,
            total_inconsistencia,
            maximo_numero_dm,
            minimo_numero_dm,
            total_dm,
            maximo_numero_pn,
            minimo_numero_pn,
            total_pn)
    ON DUPLICATE KEY UPDATE
                         maximo_numero_all = VALUES(maximo_numero_all),
                         max_num = VALUES(max_num),
                         nv_all = VALUES(nv_all),
                         min_num = VALUES(min_num),
                         minimo_numero_all = VALUES(minimo_numero_all),
                         maximo_numero_movimiento = VALUES(maximo_numero_movimiento),
                         minimo_numero_movimiento = VALUES(minimo_numero_movimiento),
                         nv_movimiento = VALUES(nv_movimiento),
                         maximo_numero_devolucion = VALUES(maximo_numero_devolucion),
                         minimo_numero_devolucion = VALUES(minimo_numero_devolucion),
                         nv_devolucion = VALUES(nv_devolucion),
                         maximo_numero_ajuste = VALUES(maximo_numero_ajuste),
                         minimo_numero_ajuste = VALUES(minimo_numero_ajuste),
                         nv_ajuste = VALUES(nv_ajuste),
                         maximo_numero_traslado = VALUES(maximo_numero_traslado),
                         minimo_numero_traslado = VALUES(minimo_numero_traslado),
                         nv_traslado = VALUES(nv_traslado),
                         maximo_numero_cancelacion_borrado = VALUES(maximo_numero_cancelacion_borrado),
                         minimo_numero_cancelacion_borrado = VALUES(minimo_numero_cancelacion_borrado),
                         nv_cancelacion_borrado = VALUES(nv_cancelacion_borrado),
                         nv_all = VALUES(nv_all),
                         maximo_numero_entrada = VALUES(maximo_numero_entrada),
                         minimo_numero_entrada = VALUES(minimo_numero_entrada),
                         nv_entrada = VALUES(nv_entrada),
                         maximo_numero_salida = VALUES(maximo_numero_salida),
                         minimo_numero_salida = VALUES(minimo_numero_salida),
                         nv_salida = VALUES(nv_salida),
                         maximo_numero_inconsistencia = VALUES(maximo_numero_inconsistencia),
                         minimo_numero_inconsistencia = VALUES(minimo_numero_inconsistencia),
                         nv_inconsistencia = VALUES(nv_inconsistencia),
                         maximo_numero_destino_match_fail = VALUES(maximo_numero_destino_match_fail),
                         minimo_numero_destino_match_fail = VALUES(minimo_numero_destino_match_fail),
                         nv_destino_match_fail = VALUES(nv_destino_match_fail),
                         maximo_numero_pina = VALUES(maximo_numero_pina),
                         minimo_numero_pina = VALUES(minimo_numero_pina),
                         nv_pina = VALUES(nv_pina);

END;

