create
    definer = root@localhost procedure actualiza_a_cuentas_live() comment 'Actualiza la tabla a_cuentas_live'
BEGIN
    CREATE TABLE IF NOT EXISTS a_cuentas_live LIKE a_cuentas_schema;

    TRUNCATE TABLE a_cuentas_live;

    INSERT INTO a_cuentas_live (
        (SELECT cp.cheque_pago_id AS doc_pago_id,
                cp.cheque_id AS doc_id,
                cp.fecha,
                cp.activo,
                cp.origen,
                ch.numero AS doc_numero,
                ch.cliente_id,
                cli.nombre AS doc_cliente,
                ch.quantity AS doc_quantity,
                cp.quantity,
                cp.tipo_cambio,
                cp.quantity_ctat,
                cp.quantity_total,
                cp.moneda_id,
                cp.saldo AS doc_saldo,
                cp.alta_por,
                cp.cuentaT_id,
                cp.metodo_pago_id,
                cp.deposit_total,
                cp.banco_cuenta_mov_link_id,
                cp.deposit_fecha,
                cp.banco_cuenta_id,
                '' AS fecha_borrado,
                cp.comentario,
                cp.ide_amount,
                cp.ide_percent,
                cp.factura,
                cp.tipo_cash_nota,
                cp.cash_nota_num,
                cp.cliente,
                cp.numero,
                cp.alta_db,
                ch.cuentaT_deliveredto_id,
                ch.paid,
                ch.moneda_id AS doc_moneda,
                cp.cobra_iva,
                cp.iva_incluido,
                cp.numero_referencia,
                cp.cash_num_cobro_iva,
                cp.empresa_id,
                cp.cliente_rfc,
                cp.ultimo_cambio,
                cp.ultimo_cambio_por,
                cp.referencia,
                cp.factura_numero,
                cp.ivacobradox100,
                cp.ivacobradototal,
                cp.tarjeta_amount,
                cp.tarjeta_percent,
                cp.comision_amount,
                cp.comision_percent,
                cp.puede_borrar,
                cp.vs_pago_key,
                cp.vs_doc_key,
                cp.vs_doc,
                cp.cuenta_t_mov_id,
                ch.tienda_id,
                ch.total_payments,
                ch.origen_cuentat_id
         FROM cheque_pago AS cp
                  LEFT JOIN cheque ch ON ch.cheque_id=cp.cheque_id
                  LEFT JOIN cliente cli ON ch.cliente_id=cli.cliente_id
         WHERE cp.fecha >= '2010-01-01'
         ORDER BY  cp.fecha DESC,
                   doc_numero ASC,
                   CAST(cp.numero AS UNSIGNED) DESC)

        UNION ALL

        (SELECT cp.pagare_pago_id AS doc_pago_id,
                cp.pagare_id AS doc_id,
                cp.fecha,
                cp.activo,
                cp.origen,
                ch.numero AS doc_numero,
                ch.cliente_id,
                cli.nombre AS doc_cliente,
                ch.quantity AS doc_quantity,
                cp.quantity,
                cp.tipo_cambio,
                cp.quantity_ctat,
                cp.quantity_total,
                cp.moneda_id,
                cp.saldo AS doc_saldo,
                cp.alta_por,
                cp.cuentaT_id,
                cp.metodo_pago_id,
                cp.deposit_total,
                cp.banco_cuenta_mov_link_id,
                cp.deposit_fecha,
                cp.banco_cuenta_id,
                '' AS fecha_borrado,
                cp.comentario,
                cp.ide_amount,
                cp.ide_percent,
                cp.factura,
                cp.tipo_cash_nota,
                cp.cash_nota_num,
                cp.cliente,
                cp.numero,
                cp.alta_db,
                ch.cuentaT_deliveredto_id,
                ch.paid,
                ch.moneda_id AS doc_moneda,
                cp.cobra_iva,
                cp.iva_incluido,
                cp.numero_referencia,
                cp.cash_num_cobro_iva,
                cp.empresa_id,
                cp.cliente_rfc,
                cp.ultimo_cambio,
                cp.ultimo_cambio_por,
                cp.referencia,
                cp.factura_numero,
                cp.ivacobradox100,
                cp.ivacobradototal,
                cp.tarjeta_amount,
                cp.tarjeta_percent,
                cp.comision_amount,
                cp.comision_percent,
                cp.puede_borrar,
                cp.vs_pago_key,
                cp.vs_doc_key,
                cp.vs_doc,
                cp.cuenta_t_mov_id,
                ch.tienda_id,
                ch.total_payments,
                ch.origen_cuentat_id
         FROM pagare_pago AS cp
                  LEFT JOIN pagare ch ON ch.pagare_id=cp.pagare_id
                  LEFT JOIN cliente cli ON ch.cliente_id=cli.cliente_id
         WHERE  cp.fecha >= '2010-01-01'
         ORDER BY  cp.fecha DESC,
                   doc_numero ASC,
                   CAST(cp.numero AS UNSIGNED) DESC)


        UNION ALL

        (SELECT cp.vale_id AS doc_pago_id,
                cp.vale_id AS doc_id,
                cp.fecha,
                if((cp.cancelado = 1),'No','Si') AS activo,
                cp.origen,
                cp.vale_number AS doc_numero,
                cp.cliente_id,
                IF(cp.cliente_id IS NULL,
                   cp.cliente,
                   cli.nombre) AS doc_cliente,
                cp.quantity AS doc_quantity,
                0.00 AS quantity,
                cp.tipo_cambio,
                cp.quantity_recibido AS quantity_ctat,
                cp.quantity_total,
                cp.recibido_moneda_id AS moneda_id,
                ABS(cp.quantity - cp.total_payments) AS doc_saldo,
                cp.alta_por,
                cp.cuentaT_id,
                cp.metodo_pago_id,
                cp.deposit_total,
                cp.banco_cuenta_mov_link_id,
                cp.deposit_fecha,
                cp.banco_cuenta_id,
                '' AS fecha_borrado,
                cp.comentario,
                cp.ide_amount,
                cp.ide_percent,
                cp.factura,
                cp.tipo_cash_nota,
                cp.cash_nota_num,
                cp.cliente,
                '1' AS numero,
                cp.alta_db,
                cp.dinero_en_cuentaT_id AS cuentaT_deliveredto_id,
                cp.paid,
                cp.moneda_id AS doc_moneda,
                cp.cobra_iva,
                cp.iva_incluido,
                cp.numero_referencia,
                cp.cash_num_cobro_iva,
                cp.empresa_id,
                cp.cliente_rfc,
                cp.ultimo_cambio,
                cp.ultimo_cambio_por,
                cp.referencia,
                cp.factura_numero,
                cp.ivacobradox100,
                cp.ivacobradototal,
                cp.tarjeta_amount,
                cp.tarjeta_percent,
                cp.comision_percent,
                cp.comision_amount,
                'NO' AS puede_borrar,
                '' AS vs_pago_key,
                '' AS vs_doc_key,
                '' AS vs_doc,
                cp.cuenta_t_mov_id,
                cp.tienda_id,
                cp.total_payments,
                NULL AS origen_cuentat_id
         FROM vale as cp
                  LEFT JOIN cliente cli ON cp.cliente_id = cli.cliente_id
         WHERE  cp.fecha >= '2010-01-01'
         ORDER BY  cp.fecha DESC,
                   doc_numero ASC,
                   CAST(cp.vale_number AS UNSIGNED) DESC)


        UNION ALL

        (SELECT cp.cheque_pago_log_id AS doc_pago_id,
                cp.cheque_id AS doc_id,
                cp.fecha,
                'No' as activo,
                'CHEQUE' as origen,
                ch.numero AS doc_numero,
                ch.cliente_id,
                cli.nombre AS doc_cliente,
                ch.quantity AS doc_quantity,
                cp.quantity,
                cp.tipo_cambio,
                '' as quantity_ctat,
                cp.quantity_total,
                cp.moneda_id,
                cp.saldo AS doc_saldo,
                cp.alta_por,
                cp.cuentaT_id,
                cp.metodo_pago_id,
                cp.deposit_total,
                cp.banco_cuenta_mov_link_id,
                cp.deposit_fecha,
                cp.banco_cuenta_id,
                cp.fecha_borrado,
                cp.comentario,
                cp.ide_amount,
                cp.ide_percent,
                '' as factura,
                '' as tipo_cash_nota,
                '' as cash_nota_num,
                '' as cliente,
                cp.numero,
                cp.alta_db,
                ch.cuentaT_deliveredto_id,
                ch.paid,
                ch.moneda_id AS doc_moneda,
                '' as cobra_iva,
                '' as iva_incluido,
                '' as numero_referencia,
                '' as cash_num_cobro_iva,
                '' as empresa_id,
                '' as cliente_rfc,
                cp.ultimo_cambio,
                cp.ultimo_cambio_por,
                cp.referencia,
                '' as factura_numero,
                '' as ivacobradox100,
                '' as ivacobradototal,
                cp.tarjeta_amount,
                cp.tarjeta_percent,
                '' as comision_amount,
                '' as comision_percent,
                '' as puede_borrar,
                '' as vs_pago_key,
                '' as vs_doc_key,
                '' as vs_doc,
                cp.cuenta_t_mov_id,
                ch.tienda_id,
                ch.total_payments,
                ch.origen_cuentat_id FROM cheque_pago_log AS cp
                                              LEFT JOIN cheque ch ON ch.cheque_id=cp.cheque_id
                                              LEFT JOIN cliente cli ON ch.cliente_id=cli.cliente_id
         WHERE  cp.alta_db >= '2010-01-01'
         ORDER BY  cp.fecha DESC,
                   doc_numero ASC,
                   CAST(cp.numero AS UNSIGNED) DESC)

        UNION ALL
        (SELECT cp.pagare_pago_log_id AS doc_pago_id,
                cp.pagare_id AS doc_id,
                cp.fecha,
                'No' as activo,
                'pagare' as origen,
                ch.numero AS doc_numero,
                ch.cliente_id,
                cli.nombre AS doc_cliente,
                ch.quantity AS doc_quantity,
                cp.quantity,
                cp.tipo_cambio,
                '' as quantity_ctat,
                cp.quantity_total,
                cp.moneda_id,
                cp.saldo AS doc_saldo,
                cp.alta_por,
                cp.cuentaT_id,
                cp.metodo_pago_id,
                cp.deposit_total,
                cp.banco_cuenta_mov_link_id,
                cp.deposit_fecha,
                cp.banco_cuenta_id,
                cp.fecha_borrado,
                cp.comentario,
                cp.ide_amount,
                cp.ide_percent,
                '' as factura,
                '' as tipo_cash_nota,
                '' as cash_nota_num,
                '' as cliente,
                cp.numero,
                cp.alta_db,
                ch.cuentaT_deliveredto_id,
                ch.paid,
                ch.moneda_id AS doc_moneda,
                '' as cobra_iva,
                '' as iva_incluido,
                '' as numero_referencia,
                '' as cash_num_cobro_iva,
                '' as empresa_id,
                '' as cliente_rfc,
                cp.ultimo_cambio,
                cp.ultimo_cambio_por,
                cp.referencia,
                '' as factura_numero,
                '' as ivacobradox100,
                '' as ivacobradototal,
                cp.tarjeta_amount,
                cp.tarjeta_percent,
                '' as comision_amount,
                '' as comision_percent,
                '' as puede_borrar,
                '' as vs_pago_key,
                '' as vs_doc_key,
                '' as vs_doc,
                cp.cuenta_t_mov_id,
                ch.tienda_id,
                ch.total_payments,
                ch.origen_cuentat_id FROM pagare_pago_log AS cp
                                              LEFT JOIN pagare ch ON ch.pagare_id=cp.pagare_id
                                              LEFT JOIN cliente cli ON ch.cliente_id=cli.cliente_id
         WHERE cp.fecha >= '2010-01-01'
         ORDER BY cp.fecha DESC,
                  doc_numero ASC,
                  CAST(cp.numero AS UNSIGNED) DESC )
        UNION ALL
        (SELECT cp.vale_pago_id AS doc_pago_id,
                cp.vale_id AS doc_id,
                cp.fecha,
                cp.activo,
                'valepago' as origen,
                ch.vale_number AS doc_numero,
                ch.cliente_id,
                IF(ch.cliente_id IS NULL,
                   ch.cliente,
                   cli.nombre) AS doc_cliente,
                ch.quantity AS doc_quantity,
                cp.quantity,
                cp.tipo_cambio,
                cp.quantity_ctat,
                cp.quantity_total,
                cp.moneda_id,
                cp.saldo AS doc_saldo,
                cp.alta_por,
                cp.cuentaT_id,
                cp.metodo_pago_id,
                cp.deposit_total,
                cp.banco_cuenta_mov_link_id,
                cp.deposit_fecha,
                cp.banco_cuenta_id,
                '' AS fecha_borrado,
                cp.comentario,
                cp.ide_amount,
                cp.ide_percent,
                cp.factura,
                cp.tipo_cash_nota,
                cp.cash_nota_num,
                cp.cliente,
                cp.numero,
                cp.alta_db,
                ch.dinero_en_cuentaT_id as cuentaT_deliveredto_id,
                ch.paid,
                ch.moneda_id AS doc_moneda,
                cp.cobra_iva,
                cp.iva_incluido,
                cp.numero_referencia,
                cp.cash_num_cobro_iva,
                cp.empresa_id,
                cp.cliente_rfc,
                cp.ultimo_cambio,
                cp.ultimo_cambio_por,
                cp.referencia,
                cp.factura_numero,
                cp.ivacobradox100,
                cp.ivacobradototal,
                cp.tarjeta_amount,
                cp.tarjeta_percent,
                cp.comision_amount,
                cp.comision_percent,
                cp.puede_borrar,
                cp.vs_pago_key,
                cp.vs_doc_key,
                cp.vs_doc,
                cp.cuenta_t_mov_id,
                ch.tienda_id,
                ch.total_payments,
                ch.cuentaT_id as origen_cuentat_id
         FROM vale_pago AS cp
                  LEFT JOIN vale ch ON ch.vale_id=cp.vale_id
                  LEFT JOIN cliente cli ON ch.cliente_id=cli.cliente_id
         WHERE  cp.fecha >= '2010-01-01'
         ORDER BY  cp.fecha DESC,
                   doc_numero ASC,
                   CAST(cp.numero AS UNSIGNED) DESC)

        UNION ALL
        (SELECT cp.vale_pago_log_id AS doc_pago_id,
                cp.vale_id AS doc_id,
                cp.fecha,
                'No' as activo,
                'valepago' as origen,
                ch.vale_number AS doc_numero,
                ch.cliente_id,
                IF(ch.cliente_id IS NULL,
                   ch.cliente,
                   cli.nombre) AS doc_cliente,
                ch.quantity AS doc_quantity,
                cp.quantity,
                cp.tipo_cambio,
                '' as quantity_ctat,
                cp.quantity_total,
                cp.moneda_id,
                cp.saldo AS doc_saldo,
                cp.alta_por,
                cp.cuentaT_id,
                cp.metodo_pago_id,
                cp.deposit_total,
                cp.banco_cuenta_mov_link_id,
                cp.deposit_fecha,
                cp.banco_cuenta_id,
                '' as fecha_borrado,
                cp.comentario,
                cp.ide_amount,
                cp.ide_percent,
                '' as factura,
                '' as tipo_cash_nota,
                '' as cash_nota_num,
                '' as cliente,
                cp.numero,
                cp.alta_db,
                ch.dinero_en_cuentaT_id,
                ch.paid,
                ch.moneda_id AS doc_moneda,
                '' as cobra_iva,
                '' as iva_incluido,
                '' as numero_referencia,
                '' as cash_num_cobro_iva,
                '' as empresa_id,
                '' as cliente_rfc,
                cp.ultimo_cambio,
                cp.ultimo_cambio_por,
                cp.referencia,
                '' as factura_numero,
                '' as ivacobradox100,
                '' as ivacobradototal,
                cp.tarjeta_amount,
                cp.tarjeta_percent,
                '' as comision_amount,
                '' as comision_percent,
                '' as puede_borrar,
                '' as vs_pago_key,
                '' as vs_doc_key,
                '' as vs_doc,
                cp.cuenta_t_mov_id,
                ch.tienda_id,
                ch.total_payments,
                NULL AS origen_cuentat_id
         FROM vale_pago_log AS cp
                  LEFT JOIN vale ch ON ch.vale_id=cp.vale_id
                  LEFT JOIN cliente cli ON ch.cliente_id=cli.cliente_id
         WHERE  cp.fecha >= '2010-01-01'
         ORDER BY  cp.fecha DESC,
                   doc_numero ASC,
                   CAST(cp.numero AS UNSIGNED) DESC) ORDER BY  fecha DESC, doc_numero ASC)

        UNION ALL
        (SELECT cmp.compra_pago_id AS doc_pago_id,
        cmp.compra_id AS doc_id,
        cmp.fecha,
        cmp.activo,
        cmp.origen,
        cm.numero AS doc_numero,
        cm.cliente_id,
        cli.nombre AS doc_cliente,
        cm.quantity AS doc_quantity,
        cmp.quantity,
        cmp.tipo_cambio,
        cmp.quantity_ctat,
        cmp.quantity_total,
        cmp.moneda_id,
        cmp.saldo AS doc_saldo,
        cmp.alta_por,
        cmp.cuentaT_id,
        cmp.metodo_pago_id,
        cmp.deposit_total,
        cmp.banco_cuenta_mov_link_id,
        cmp.deposit_fecha,
        cmp.banco_cuenta_id,
        '' AS fecha_borrado,
        cmp.comentario,
        cmp.ide_amount,
        cmp.ide_percent,
        cmp.factura,
        cmp.tipo_cash_nota,
        cmp.cash_nota_num,
        cmp.cliente,
        cmp.numero,
        cmp.alta_db,
        cm.cuentaT_deliveredto_id,
        cm.paid,
        cm.moneda_id AS doc_moneda,
        cmp.cobra_iva,
        cmp.iva_incluido,
        cmp.numero_referencia,
        cmp.cash_num_cobro_iva,
        cmp.empresa_id,
        cmp.cliente_rfc,
        cmp.ultimo_cambio,
        cmp.ultimo_cambio_por,
        cmp.referencia,
        cmp.factura_numero,
        cmp.ivacobradox100,
        cmp.ivacobradototal,
        cmp.tarjeta_amount,
        cmp.tarjeta_percent,
        cmp.comision_amount,
        cmp.comision_percent,
        cmp.puede_borrar,
        cmp.vs_pago_key,
        cmp.vs_doc_key,
        cmp.vs_doc,
        cmp.cuenta_t_mov_id,
        cm.tienda_id,
        cm.total_payments,
        cm.origen_cuentat_id
        FROM compra_pago AS cmp
        LEFT JOIN compra cm ON cm.compra_id=cmp.compra_id
        LEFT JOIN cliente cli ON cm.cliente_id=cli.cliente_id
        WHERE cmp.fecha >= '2010-01-01'
        ORDER BY  cmp.fecha DESC,
        doc_numero ASC,
        CAST(cmp.numero AS UNSIGNED) DESC)

        UNION ALL
    (SELECT cmpl.compra_pago_log_id AS doc_pago_id,
     cmpl.compra_id AS doc_id,
     cmpl.fecha,
     'No' as activo,
     'compra' as origen,
     cm.numero AS doc_numero,
     cm.cliente_id,
     cli.nombre AS doc_cliente,
     cm.quantity AS doc_quantity,
     cmpl.quantity,
     cmpl.tipo_cambio,
     '' as quantity_ctat,
     cmpl.quantity_total,
     cmpl.moneda_id,
     cmpl.saldo AS doc_saldo,
     cmpl.alta_por,
     cmpl.cuentaT_id,
     cmpl.metodo_pago_id,
     cmpl.deposit_total,
     cmpl.banco_cuenta_mov_link_id,
     cmpl.deposit_fecha,
     cmpl.banco_cuenta_id,
     cmpl.fecha_borrado,
     cmpl.comentario,
     cmpl.ide_amount,
     cmpl.ide_percent,
     '' as factura,
     '' as tipo_cash_nota,
     '' as cash_nota_num,
     '' as cliente,
     cmpl.numero,
     cmpl.alta_db,
     cm.cuentaT_deliveredto_id,
     cm.paid,
     cm.moneda_id AS doc_moneda,
     '' as cobra_iva,
     '' as iva_incluido,
     '' as numero_referencia,
     '' as cash_num_cobro_iva,
     '' as empresa_id,
     '' as cliente_rfc,
     cmpl.ultimo_cambio,
     cmpl.ultimo_cambio_por,
     cmpl.referencia,
     '' as factura_numero,
     '' as ivacobradox100,
     '' as ivacobradototal,
     cmpl.tarjeta_amount,
     cmpl.tarjeta_percent,
     '' as comision_amount,
     '' as comision_percent,
     '' as puede_borrar,
     '' as vs_pago_key,
     '' as vs_doc_key,
     '' as vs_doc,
     cmpl.cuenta_t_mov_id,
     cm.tienda_id,
     cm.total_payments,
     cm.origen_cuentat_id
     FROM compra_pago_log AS cmpl
     LEFT JOIN compra cm ON cm.compra_id=cmpl.compra_id
     LEFT JOIN cliente cli ON cm.cliente_id=cli.cliente_id
     WHERE  cmpl.alta_db >= '2010-01-01'
     ORDER BY  cmpl.fecha DESC,
     doc_numero ASC,
     CAST(cmpl.numero AS UNSIGNED) DESC)

        UNION ALL
    (SELECT cp.vale_uso_id AS doc_pago_id,
     cp.vale_id AS doc_id,
     cp.fecha,
     'Si' as activo,
     'valeuso' as origen,
     ch.vale_number AS doc_numero,
     ch.cliente_id,
     IF(ch.cliente_id IS NULL, ch.cliente, cli.nombre) AS doc_cliente,
        ch.quantity AS doc_quantity,
        cp.quantity,
        cp.tipo_cambio,
        cp.quantity_total as quantity_ctat,
        cp.quantity_total,
        cp.moneda_id,
        cp.saldo AS doc_saldo,
        cp.alta_por,
        ch.cuentaT_id,
        cp.metodo_pago_id,
        cp.deposit_total,
        cp.banco_cuenta_mov_link_id,
        '0000-00-00' as deposit_fecha,
        cp.banco_cuenta_id,
        '' AS fecha_borrado,
        cp.comentario,
        cp.ide_amount,
        cp.ide_percent,
        '' as factura,
        '' as tipo_cash_nota,
        '' as cash_nota_num,
        '' as cliente,
        cp.numero,
        cp.alta_db,
        ch.dinero_en_cuentaT_id as cuentaT_deliveredto_id,
        ch.paid,
        ch.moneda_id AS doc_moneda,
        '' as cobra_iva,
        '' as iva_incluido,
        '' as numero_referencia,
        '' as cash_num_cobro_iva,
        '' as empresa_id,
        '' as cliente_rfc,
        cp.ultimo_cambio,
        cp.ultimo_cambio_por,
        '' as referencia,
        '' as factura_numero,
        '' as ivacobradox100,
        '' as ivacobradototal,
        cp.tarjeta_amount,
        cp.tarjeta_percent,
        '' as comision_amount,
        '' as comision_percent,
        '' as puede_borrar,
        cp.vs_pago_key,
        cp.vs_doc_key,
        cp.vs_doc,
        cp.cuenta_t_mov_id,
        ch.tienda_id,
        ch.total_payments,
        ch.cuentaT_id as origen_cuentat_id
        FROM vale_uso cp
        LEFT JOIN vale ch ON ch.vale_id = cp.vale_id
        LEFT JOIN cliente cli ON ch.cliente_id=cli.cliente_id
        WHERE cp.metodo_pago_id = 1 AND cp.fecha >= '2010-01-01'
        ORDER BY  cp.fecha DESC, doc_numero ASC, CAST(cp.numero AS UNSIGNED) DESC
        )

        UNION ALL
    (SELECT cp.vale_uso_log_id AS doc_pago_id,
     cp.vale_id AS doc_id,
     cp.fecha,
     'No' as activo,
     'valeuso' as origen,
     ch.vale_number AS doc_numero,
     ch.cliente_id,
     IF(ch.cliente_id IS NULL, ch.cliente, cli.nombre) AS doc_cliente,
        ch.quantity AS doc_quantity,
        cp.quantity,
        cp.tipo_cambio,
        cp.quantity_total as quantity_ctat,
        cp.quantity_total,
        cp.moneda_id,
        cp.saldo AS doc_saldo,
        cp.alta_por,
        ch.cuentaT_id,
        cp.metodo_pago_id,
        cp.deposit_total,
        cp.banco_cuenta_mov_link_id,
        '0000-00-00' as deposit_fecha,
        cp.banco_cuenta_id,
        cp.fecha_borrado,
        cp.comentario,
        cp.ide_amount,
        cp.ide_percent,
        '' as factura,
        '' as tipo_cash_nota,
        '' as cash_nota_num,
        '' as cliente,
        cp.numero,
        cp.alta_db,
        ch.dinero_en_cuentaT_id as cuentaT_deliveredto_id,
        ch.paid,
        ch.moneda_id AS doc_moneda,
        '' as cobra_iva,
        '' as iva_incluido,
        '' as numero_referencia,
        '' as cash_num_cobro_iva,
        '' as empresa_id,
        '' as cliente_rfc,
        cp.ultimo_cambio,
        cp.ultimo_cambio_por,
        '' as referencia,
        '' as factura_numero,
        '' as ivacobradox100,
        '' as ivacobradototal,
        cp.tarjeta_amount,
        cp.tarjeta_percent,
        '' as comision_amount,
        '' as comision_percent,
        '' as puede_borrar,
        cp.vs_pago_key,
        cp.vs_doc_key,
        cp.vs_doc,
        cp.cuenta_t_mov_id,
        ch.tienda_id,
        ch.total_payments,
        ch.cuentaT_id as origen_cuentat_id
        FROM vale_uso_log cp
        LEFT JOIN vale ch ON ch.vale_id = cp.vale_id
        LEFT JOIN cliente cli ON ch.cliente_id=cli.cliente_id
        WHERE cp.metodo_pago_id = 1 AND cp.fecha >= '2010-01-01'
        ORDER BY  cp.fecha DESC, doc_numero ASC, CAST(cp.numero AS UNSIGNED) DESC
        );
END;

