create
    definer = root@localhost procedure actualiza_banco_cuenta_saldos(IN my_banco_cuenta_id smallint)
BEGIN
    INSERT INTO banco_cuenta_saldos(banco_cuenta_id, saldo_actual, sbc, deposit_cash, deposit_total, withdrawal_total, Ultimo_Movimiento, Ultimo_cash, Ultimo_deposit, Ultimo_withdrawal, ultima_conciliacion, orden, nombre)
	(
		SELECT
			bcm.banco_cuenta_id,
			SUM(bcm.cash + bcm.deposit - bcm.withdrawal) as saldo_actual,
			SUM(IF(bcm.link_vale='SBC',bcm.cash + bcm.deposit,0)) as sbc,
			SUM(bcm.cash+bcm.deposit) as deposit_cash,
			SUM(bcm.cash + bcm.deposit) as deposit_total,
			SUM(bcm.withdrawal) as withdrawal_total,
			MAX(fecha) as Ultimo_Movimiento,
			MAX(IF(bcm.cash+bcm.deposit>0,fecha,NULL)) as Ultimo_cash,
			MAX(IF(bcm.cash+bcm.deposit>0,fecha,NULL)) as Ultimo_deposit,
			MAX(IF(bcm.withdrawal>0,fecha,NULL)) as Ultimo_withdrawal,
			bc.ultima_conciliacion,
			bc.orden,
			bc.nombre
		FROM banco_cuenta_mov bcm JOIN banco_cuenta bc ON bcm.banco_cuenta_id = bc.banco_cuenta_id WHERE bc.banco_cuenta_id = my_banco_cuenta_id AND bc.vale = 'Active'
	)
	ON DUPLICATE KEY UPDATE
		saldo_actual=VALUES(saldo_actual),
		sbc=VALUES(sbc),
		deposit_cash=VALUES(deposit_cash),
		deposit_total=VALUES(deposit_total),
		withdrawal_total=VALUES(withdrawal_total),
		Ultimo_Movimiento=VALUES(Ultimo_Movimiento),
		Ultimo_cash=VALUES(Ultimo_cash),
		Ultimo_deposit=VALUES(Ultimo_deposit),
		Ultimo_withdrawal=VALUES(Ultimo_withdrawal),
		ultima_conciliacion=VALUES(ultima_conciliacion),
		orden=VALUES(orden),
		nombre=VALUES(nombre);

END;

